/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.dao.SysActEntrustMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.model.SysActEntrust;
import com.jxdinfo.hussar.workflow.engine.bpm.processentrust.service.SysActEntrustService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysActEntrustServiceImpl
extends ServiceImpl<SysActEntrustMapper, SysActEntrust>
implements SysActEntrustService {
    @Resource
    SysActEntrustMapper sysActEntrustMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private IAssigneeChooseService assigneeChooseService;
    @Autowired
    private ModelService modelService;

    public ApiResponse<IPage<SysActEntrust>> list(Page<SysActEntrust> pages, String userId, String processKey) {
        if (ToolUtil.isEmpty((Object)userId)) {
            throw new PublicClientException("\u7528\u6237ID\u4e3a\u7a7a");
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.like(ToolUtil.isNotEmpty((Object)processKey), SysActEntrust::getProcessKey, (Object)processKey);
        ew.eq(SysActEntrust::getMandator, (Object)userId);
        List list = ((Page)this.page((IPage)pages, (Wrapper)ew)).getRecords();
        ArrayList<String> userIds = new ArrayList<String>();
        ArrayList<String> processKeys = new ArrayList<String>();
        for (SysActEntrust sysActEntrust : list) {
            userIds.add(sysActEntrust.getMandatary());
            processKeys.add(sysActEntrust.getProcessKey());
        }
        Map userNameMap = this.assigneeChooseService.getUserListByUserId(userIds, BaseSecurityUtil.getUser().getTenantId());
        Map modelNameMap = this.modelService.selectModelNames(processKeys);
        for (SysActEntrust sysActEntrust : list) {
            sysActEntrust.setProcessName((String)modelNameMap.get(sysActEntrust.getProcessKey()));
            sysActEntrust.setMandataryName((String)userNameMap.get(sysActEntrust.getMandatary()));
        }
        pages.setRecords(list);
        return ApiResponse.success(pages);
    }

    public ApiResponse<?> add(String processKey, String mandator, String mandatary, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust = new SysActEntrust(processKey, mandator, mandatary, state, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)ew.eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).eq(SysActEntrust::getProcessKey, (Object)sysActEntrust.getProcessKey());
        List list = this.sysActEntrustMapper.selectList((Wrapper)ew);
        if (list.size() >= 1) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getExistMandatary());
        }
        this.sysActEntrustMapper.insert(sysActEntrust);
        return ApiResponse.success((String)this.bpmConstantProperties.getSuccessSave());
    }

    public ApiResponse<?> addBatch(String processKey, String mandator, String mandatary, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust = null;
        ArrayList<SysActEntrust> tt = new ArrayList<SysActEntrust>();
        String[] ids = null;
        ids = processKey.split(",");
        List list = null;
        int isRight = 0;
        for (int i = 0; i < ids.length; ++i) {
            String id = String.valueOf(ids[i]);
            sysActEntrust = new SysActEntrust(id, mandator, mandatary, state, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
            LambdaQueryWrapper ew = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)ew.eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).eq(SysActEntrust::getProcessKey, (Object)sysActEntrust.getProcessKey());
            list = this.sysActEntrustMapper.selectList((Wrapper)ew);
            if (list.size() >= 1) continue;
            sysActEntrust = new SysActEntrust(id, mandator, mandatary, state, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
            tt.add(sysActEntrust);
            ++isRight;
        }
        if (isRight == 0) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getExistMandatary());
        }
        this.saveBatch(tt, ids.length);
        return ApiResponse.success((String)this.bpmConstantProperties.getSuccessSave());
    }

    public ApiResponse<Tip> saveEntrust(List<String> processKey, String mandator, String mandatary, String state, String startTime, String endTime) {
        SysActEntrust sysActEntrust = null;
        ArrayList<SysActEntrust> tt = new ArrayList<SysActEntrust>();
        List list = null;
        int isRight = 0;
        for (int i = 0; i < processKey.size(); ++i) {
            sysActEntrust = new SysActEntrust(processKey.get(i), mandator, mandatary, state, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
            LambdaQueryWrapper ew = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)ew.eq(SysActEntrust::getMandator, (Object)sysActEntrust.getMandator())).eq(SysActEntrust::getProcessKey, (Object)sysActEntrust.getProcessKey());
            list = this.sysActEntrustMapper.selectList((Wrapper)ew);
            if (list.size() >= 1) continue;
            sysActEntrust = new SysActEntrust(processKey.get(i), mandator, mandatary, state, Timestamp.valueOf(startTime), Timestamp.valueOf(endTime));
            tt.add(sysActEntrust);
            ++isRight;
        }
        if (isRight == 0) {
            throw new PublicClientException(this.bpmConstantProperties.getExistMandatary());
        }
        this.saveBatch(tt);
        return ApiResponse.success((String)this.bpmConstantProperties.getSuccessSave());
    }

    public Map<String, String> queryByUsers(List<String> users, String processKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        Date currentTime = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date date = null;
        try {
            date = formatter.parse(formatter.format(currentTime));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)ew.in(SysActEntrust::getMandator, users)).eq(ToolUtil.isNotEmpty((Object)processKey), SysActEntrust::getProcessKey, (Object)processKey)).eq(SysActEntrust::getState, (Object)"1")).le(SysActEntrust::getStartTime, (Object)date)).ge(SysActEntrust::getEndTime, (Object)date);
        List list = this.list((Wrapper)ew);
        if (ToolUtil.isNotEmpty((Object)list)) {
            for (SysActEntrust t : list) {
                map.put(t.getMandator(), t.getMandatary());
            }
        }
        return map;
    }

    public void updateState(String tEntrustId, String state) {
        this.sysActEntrustMapper.updateState(tEntrustId, state);
    }

    public SysActEntrust selectById(String id, String tenantId) {
        SysActEntrust sysActEntrust = (SysActEntrust)this.sysActEntrustMapper.selectById((Serializable)((Object)id));
        ArrayList<String> userName = new ArrayList<String>();
        userName.add(sysActEntrust.getMandatary());
        sysActEntrust.setMandataryName(this.assigneeChooseService.getUserNames(userName, tenantId));
        ArrayList<String> processKeys = new ArrayList<String>();
        processKeys.add(sysActEntrust.getProcessKey());
        Map modelNameMap = this.modelService.selectModelNames(processKeys);
        sysActEntrust.setProcessName((String)modelNameMap.get(sysActEntrust.getProcessKey()));
        return sysActEntrust;
    }
}

