/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskBpm;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.VariablesBpm;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskServiceImpl
implements IFlowTaskService {
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ITenantConfigService iTenantConfigService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;

    public ApiResponse<IPage<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dbType = this.druidProperties.getUrl().split(":")[1];
        flowTaskQueryModel.setDbType(dbType);
        List<FlowTask> todoList = this.flowTaskMapper.todoList(pages, flowTaskQueryModel);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> processInsIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            taskIds.add(flowTask.getTaskId());
            processInsIds.add(flowTask.getProcessInsId());
        }
        List<Object> allVariables = new ArrayList();
        if (todoList.size() > 0) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.size() == 0) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, processInsIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = todoList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskId(flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setUserId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setSendUser(flowTask.getSendUser());
            taskManagerQueryVo.setFormAddress((Map)JSON.parse((String)flowTask.getFormKey()));
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb((String)taskManagerQueryVo.getFormAddress().get("web"));
                taskManagerQueryVo.setMobile((String)taskManagerQueryVo.getFormAddress().get("mobile"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            taskManagerQueryVo.setTaskVariables(flowTask.getTaskVariableMap());
            if (flowTask.getTaskVariableMap() != null) {
                taskManagerQueryVo.setMessage((String)flowTask.getTaskVariableMap().get("todoConfiguration"));
                taskManagerQueryVo.setTaskSourceFlag((String)flowTask.getTaskVariableMap().get("taskSourceFlag"));
            }
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            resultData.add(taskManagerQueryVo);
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        Iterator<Object> iterator2 = resultData.iterator();
        while (iterator2.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setSendUserName(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator2.next()).getSendUser()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getSendUser()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    public BpmResponseResult todoListBpm(String userId, String processDefinitionKey, String message, String sendUserId, String startTime, String endTime, Integer page, Integer limit, String type, String tenantId) {
        Page pages = new Page((long)page.intValue(), (long)limit.intValue());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("todoConfiguration", message);
        map.put("sendUserId", sendUserId);
        map.put("processDefinitionKey", processDefinitionKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        String dbType = this.druidProperties.getUrl().split(":")[1];
        map.put("dbType", dbType);
        List<FlowTaskBpm> todoList = this.flowTaskMapper.todoListBpm(pages, map);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> instIds = new ArrayList<String>();
        for (FlowTaskBpm flowTask : todoList) {
            taskIds.add(flowTask.getTaskId());
            instIds.add(flowTask.getProcessInstId());
        }
        List<Object> allVariables = new ArrayList();
        if (todoList.size() > 0) {
            allVariables = this.flowTaskMapper.getAllToDoVariablesBpm(taskIds, instIds);
        }
        HashMap<String, ArrayList<VariablesBpm>> taskVariablesMap = new HashMap<String, ArrayList<VariablesBpm>>();
        HashMap<String, ArrayList<VariablesBpm>> processVariablesMap = new HashMap<String, ArrayList<VariablesBpm>>();
        for (VariablesBpm variablesBpm : allVariables) {
            List<Object> list;
            if (variablesBpm.getTaskId() == null) {
                list = (ArrayList<VariablesBpm>)processVariablesMap.get(variablesBpm.getProcessInstanceId());
                if (list == null) {
                    list = new ArrayList<VariablesBpm>();
                }
                list.add(variablesBpm);
                processVariablesMap.put(variablesBpm.getProcessInstanceId(), (ArrayList<VariablesBpm>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variablesBpm.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variablesBpm);
            taskVariablesMap.put(variablesBpm.getTaskId(), (ArrayList<VariablesBpm>)list);
        }
        Iterator<Object> iterator = todoList.iterator();
        while (iterator.hasNext()) {
            FlowTaskBpm flowTaskBpm;
            flowTaskBpm.setTaskVariables(taskVariablesMap.get((flowTaskBpm = (FlowTaskBpm)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTaskBpm.getTaskId()));
            flowTaskBpm.setProcessVariables(processVariablesMap.get(flowTaskBpm.getProcessInstId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTaskBpm.getProcessInstId()));
        }
        ArrayList<Map> resultData = new ArrayList<Map>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTaskBpm flowTask : todoList) {
            Map result = (Map)JSON.parseObject((String)JSON.toJSONString((Object)flowTask), Map.class);
            if (ToolUtil.isNotEmpty(result.get("formKey"))) {
                result.putAll((Map)JSON.parse((String)String.valueOf(result.get("formKey"))));
            }
            result.put("taskVariables", flowTask.getTaskVariableMap());
            result.put("variables", flowTask.getProcessVariableMap());
            result.put("message", ((Map)result.get("taskVariables")).get("todoConfiguration"));
            userIds.add(String.valueOf(result.get("sendUser")));
            result.put("taskSourceFlag", flowTask.getTaskVariableMap().get("taskSourceFlag"));
            result.put("createTime", result.get("startTime") == null ? "" : format.format(result.get("startTime")));
            result.put("processStartTime", result.get("processStartTime") == null ? "" : format.format(result.get("processStartTime")));
            result.put("processInsId", result.get("processInstId"));
            result.remove("startTime");
            result.remove("processVariables");
            result.remove("todoConfiguartion");
            result.remove("processInstId");
            result.remove("processVariableMap");
            result.remove("taskVariableMap");
            resultData.add(result);
        }
        Map map2 = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        Iterator<Object> iterator2 = resultData.iterator();
        while (iterator2.hasNext()) {
            Map result;
            result.put("sendUserName", map2.get((result = (Map)iterator2.next()).get("sendUser")) == null ? "" : map2.get(result.get("sendUser")));
        }
        HashMap<String, Serializable> data = new HashMap<String, Serializable>();
        data.put("data", resultData);
        data.put("count", Long.valueOf(pages.getTotal()));
        JSONArray jsonArray = new JSONArray();
        jsonArray.add(data);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public ApiResponse<IPage<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            if (this.lcdpBpmProperties.isStartAlone()) {
                TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
                securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), tenantConfig.getProjectAddress(), tenantId);
            } else {
                securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), null, tenantId);
            }
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        String dbType = this.druidProperties.getUrl().split(":")[1];
        flowTaskQueryModel.setDbType(dbType);
        List<FlowTask> doneList = this.flowTaskMapper.doneList(pages, flowTaskQueryModel);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> processInsIds = new ArrayList<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(flowTask.getTaskId());
            processInsIds.add(flowTask.getProcessInsId());
        }
        List<Object> allVariables = new ArrayList();
        if (doneList.size() > 0) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.size() == 0) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllVariables(taskIds, processInsIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, tenantId));
        return ApiResponse.success((Object)page);
    }

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists, String tenantId) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        Map propertiesMap = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (ToolUtil.isNotEmpty(taskVariables.get("sendUser"))) {
                    userIds.add(String.valueOf(taskVariables.get("sendUser")));
                }
                userIds.add(flowTask.getUserId());
                ids.add(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
            }
            propertiesMap = this.iSysActExtendPropertiesService.queryList(ids);
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        }
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setTaskVariables(taskVariables);
                taskManagerQueryVo.setTaskSourceFlag((String)taskVariables.get("taskSourceFlag"));
                String scope = String.valueOf(taskVariables.get("taskSourceFlag"));
                if (ToolUtil.isNotEmpty((Object)flowTask.getProcessEndTime())) {
                    scope = "\u5df2\u5b8c\u6210";
                } else if ("reject".equals(scope)) {
                    scope = "\u5df2\u9a73\u56de";
                } else if ("complete".equals(scope)) {
                    scope = "\u5df2\u5ba1\u6279";
                } else if (scope.contains("revoke")) {
                    scope = "\u5df2\u64a4\u56de";
                }
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser((String)taskVariables.get("sendUser"));
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(taskVariables.get("sendUser")));
                String message = ToolUtil.isNotEmpty((Object)flowTask.getTodoConfiguration()) ? flowTask.getTodoConfiguration() : (taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString());
                taskManagerQueryVo.setMessage(message);
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = (String)propertiesMap.get(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (ToolUtil.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }
}

