/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateUser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateUser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.model.TimeOutModel;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.Expression;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventType;
import org.activiti.engine.delegate.event.impl.ActivitiEventBuilder;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.AbstractBpmnActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.calendar.BusinessCalendar;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.el.ExpressionManager;
import org.activiti.engine.impl.el.JuelExpression;
import org.activiti.engine.impl.el.ParsingElContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.javax.el.ValueExpression;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.apache.commons.lang3.StringUtils;

public class ExtendParallelMultiInstanceBehavior
extends ParallelMultiInstanceBehavior {
    private static final String VARIABLE_NAME = "multiInstanceAssignee";
    public static final String CC_USER_MESSAGE = "ccUserMessage";
    private ISysActCcTaskService iSysActCcTaskService = (ISysActCcTaskService)SpringContextHolder.getApplicationContext().getBean(ISysActCcTaskService.class);
    private RepositoryService repositoryService = (RepositoryService)SpringContextHolder.getApplicationContext().getBean(RepositoryService.class);
    private ActivityRedisTimerService activityRedisTimer = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private ICandidateUserService candidateUserService = (ICandidateUserService)SpringContextHolder.getApplicationContext().getBean(ICandidateUserService.class);
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getApplicationContext().getBean(TaskEngineMapper.class);
    private HistoryService historyService = (HistoryService)SpringContextHolder.getApplicationContext().getBean(HistoryService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);

    public ExtendParallelMultiInstanceBehavior(ActivityImpl activity, AbstractBpmnActivityBehavior originalActivityBehavior) {
        super(activity, originalActivityBehavior);
    }

    protected void createInstances(ActivityExecution execution) throws Exception {
        Collection users;
        FlowElement element;
        List timeOutElement;
        boolean flag = "callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"));
        BpmnModel bm = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        if (!flag && ToolUtil.isNotEmpty((Object)(timeOutElement = (List)(element = ((Process)bm.getProcesses().get(0)).getFlowElement(execution.getActivity().getId())).getExtensionElements().get("TimeOutStrategy"))) && ToolUtil.isNotEmpty((Object)((ExtensionElement)timeOutElement.get(0)).getAttributes())) {
            execution.setVariable("TimeOutStrategy", (Object)((ExtensionAttribute)((List)((ExtensionElement)timeOutElement.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue());
        }
        int nrOfInstances = (users = this.getUser(bm, execution, flag)) == null ? 0 : users.size();
        HashMap map = flag ? new HashMap() : AnalyticalModelUtil.getCcUser(bm, execution, execution.getTenantId());
        this.setLoopVariable(execution, "nrOfInstances", nrOfInstances);
        this.setLoopVariable(execution, "nrOfCompletedInstances", 0);
        this.setLoopVariable(execution, "nrOfActiveInstances", nrOfInstances);
        ArrayList<ActivityExecution> concurrentExecutions = new ArrayList<ActivityExecution>();
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            ActivityExecution concurrentExecution = execution.createExecution();
            concurrentExecution.setActive(true);
            concurrentExecution.setConcurrent(true);
            concurrentExecution.setScope(false);
            if (this.isExtraScopeNeeded()) {
                ActivityExecution extraScopedExecution = concurrentExecution.createExecution();
                extraScopedExecution.setActive(true);
                extraScopedExecution.setConcurrent(false);
                extraScopedExecution.setScope(true);
                concurrentExecution = extraScopedExecution;
            }
            concurrentExecutions.add(concurrentExecution);
            this.logLoopDetails(concurrentExecution, "initialized", loopCounter, 0, nrOfInstances, nrOfInstances);
        }
        TaskEntity skipTaskEntity = null;
        for (int loopCounter = 0; loopCounter < nrOfInstances; ++loopCounter) {
            TaskEntity taskEntity;
            ActivityExecution concurrentExecution = (ActivityExecution)concurrentExecutions.get(loopCounter);
            if (!concurrentExecution.isActive() || concurrentExecution.isEnded() || !concurrentExecution.getParent().isActive() || concurrentExecution.getParent().isEnded()) continue;
            this.setLoopVariable(concurrentExecution, this.getCollectionElementIndexVariable(), loopCounter);
            if (!flag && loopCounter == 0) {
                concurrentExecution.setVariable(CC_USER_MESSAGE, map);
            }
            if ((taskEntity = this.executeBpmOriginalBehavior(concurrentExecution, loopCounter, users, flag)) == null) continue;
            skipTaskEntity = taskEntity;
        }
        if (!flag) {
            execution.removeVariable("TimeOutStrategy");
        }
        if (!concurrentExecutions.isEmpty()) {
            ExecutionEntity executionEntity = (ExecutionEntity)execution;
            executionEntity.setActive(false);
        }
        if (skipTaskEntity != null) {
            skipTaskEntity.setVariableLocal("sendUser", (Object)skipTaskEntity.getAssignee());
            skipTaskEntity.setVariableLocal("taskSourceFlag", (Object)"skip");
            skipTaskEntity.complete(null, false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected TaskEntity executeBpmOriginalBehavior(ActivityExecution execution, int loopCounter, Collection collection, boolean flag) throws Exception {
        Object value = null;
        if (collection != null && collection.size() > 0) {
            Iterator it = collection.iterator();
            for (int index = 0; index <= loopCounter; ++index) {
                value = it.next();
            }
            this.setLoopVariable(execution, VARIABLE_NAME, value);
        }
        if (loopCounter == 0) {
            if (!flag) return this.insertTask(execution, Objects.requireNonNull(value).toString(), true);
            this.innerActivityBehavior.execute(execution);
            return null;
        } else {
            if (!flag) return this.insertTask(execution, Objects.requireNonNull(value).toString(), false);
            execution.executeActivity((PvmActivity)this.activity);
        }
        return null;
    }

    private void ccTask(Task task, Set<String> users, String userId, ActivityExecution execution) {
        ArrayList<SysActCcTask> list = new ArrayList<SysActCcTask>();
        ProcessInstance processInstance = (ProcessInstance)execution.getProcessInstance();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        if (processInstance != null) {
            for (String user : users) {
                SysActCcTask sysActCcTask = new SysActCcTask();
                sysActCcTask.setProcessInsId(task.getProcessInstanceId());
                sysActCcTask.setProcName(((ExecutionEntity)processInstance).getProcessDefinition().getName());
                sysActCcTask.setTaskId(task.getId());
                sysActCcTask.setTaskName(task.getName());
                sysActCcTask.setReceiveUser(user);
                sysActCcTask.setSendUser(userId);
                sysActCcTask.setSendTime(ts);
                sysActCcTask.setFormKey(task.getFormKey());
                sysActCcTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActCcTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActCcTask.setBusinessId(execution.getProcessBusinessKey());
                Map map = ((TaskEntity)task).getVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActCcTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActCcTask);
            }
        }
        if (list.size() > 0) {
            this.iSysActCcTaskService.saveBatch(list);
        }
    }

    private JSONArray getRightActivity(JSONArray allCallActivityInfos, ActivityExecution execution) {
        JSONArray callActivityInfos = new JSONArray();
        for (Object allCallActivityInfo : allCallActivityInfos) {
            JSONObject object = (JSONObject)allCallActivityInfo;
            if (!ToolUtil.isEmpty((Object)object.get((Object)"taskDefinitionKey")) && !((ExecutionEntity)execution).getActivityId().equals(object.get((Object)"taskDefinitionKey"))) continue;
            callActivityInfos.add((Object)object);
        }
        return callActivityInfos;
    }

    protected DbSqlSession getDbSqlSession() {
        return this.getSession(DbSqlSession.class);
    }

    protected <T> T getSession(Class<T> sessionClass) {
        return (T)Context.getCommandContext().getSession(sessionClass);
    }

    private TaskEntity insertTask(ActivityExecution execution, String userId, boolean flag) {
        Object ccUserMessage;
        HashMap<String, Object> map;
        Object formKey;
        Object category;
        Object priority;
        Object dueDate;
        TaskEntity task = TaskEntity.createAndInsert((ActivityExecution)execution);
        task.setExecution((DelegateExecution)execution);
        TaskDefinition taskDefinition = (TaskDefinition)execution.getActivity().getProperty("taskDefinition");
        Expression activeNameExpression = null;
        Expression activeDescriptionExpression = null;
        Expression activeDueDateExpression = null;
        Expression activePriorityExpression = null;
        Expression activeCategoryExpression = null;
        Expression activeFormKeyExpression = null;
        Expression activeSkipExpression = null;
        Expression activeAssigneeExpression = null;
        Expression activeOwnerExpression = null;
        Set<Expression> activeCandidateUserExpressions = null;
        Set<Expression> activeCandidateGroupExpressions = null;
        if (Context.getProcessEngineConfiguration().isEnableProcessDefinitionInfoCache()) {
            ObjectNode taskElementProperties = Context.getBpmnOverrideElementProperties((String)execution.getActivity().getId(), (String)execution.getProcessDefinitionId());
            activeNameExpression = this.getActiveValue(taskDefinition.getNameExpression(), "userTaskName", taskElementProperties);
            taskDefinition.setNameExpression(activeNameExpression);
            activeDescriptionExpression = this.getActiveValue(taskDefinition.getDescriptionExpression(), "userTaskDescription", taskElementProperties);
            taskDefinition.setDescriptionExpression(activeDescriptionExpression);
            activeDueDateExpression = this.getActiveValue(taskDefinition.getDueDateExpression(), "userTaskDueDate", taskElementProperties);
            taskDefinition.setDueDateExpression(activeDueDateExpression);
            activePriorityExpression = this.getActiveValue(taskDefinition.getPriorityExpression(), "userTaskPriority", taskElementProperties);
            taskDefinition.setPriorityExpression(activePriorityExpression);
            activeCategoryExpression = this.getActiveValue(taskDefinition.getCategoryExpression(), "userTaskCategory", taskElementProperties);
            taskDefinition.setCategoryExpression(activeCategoryExpression);
            activeFormKeyExpression = this.getActiveValue(taskDefinition.getFormKeyExpression(), "userTaskFormKey", taskElementProperties);
            taskDefinition.setFormKeyExpression(activeFormKeyExpression);
            activeSkipExpression = this.getActiveValue(taskDefinition.getSkipExpression(), "taskSkipExpression", taskElementProperties);
            taskDefinition.setSkipExpression(activeSkipExpression);
            activeAssigneeExpression = this.getActiveValue(taskDefinition.getAssigneeExpression(), "userTaskAssignee", taskElementProperties);
            taskDefinition.setAssigneeExpression(activeAssigneeExpression);
            activeOwnerExpression = this.getActiveValue(taskDefinition.getOwnerExpression(), "userTaskOwner", taskElementProperties);
            taskDefinition.setOwnerExpression(activeOwnerExpression);
            activeCandidateUserExpressions = this.getActiveValueSet(taskDefinition.getCandidateUserIdExpressions(), "userTaskCandidateUsers", taskElementProperties);
            taskDefinition.setCandidateUserIdExpressions(activeCandidateUserExpressions);
            activeCandidateGroupExpressions = this.getActiveValueSet(taskDefinition.getCandidateGroupIdExpressions(), "userTaskCandidateGroups", taskElementProperties);
            taskDefinition.setCandidateGroupIdExpressions(activeCandidateGroupExpressions);
        } else {
            activeNameExpression = taskDefinition.getNameExpression();
            activeDescriptionExpression = taskDefinition.getDescriptionExpression();
            activeDueDateExpression = taskDefinition.getDueDateExpression();
            activePriorityExpression = taskDefinition.getPriorityExpression();
            activeCategoryExpression = taskDefinition.getCategoryExpression();
            activeFormKeyExpression = taskDefinition.getFormKeyExpression();
            activeSkipExpression = taskDefinition.getSkipExpression();
        }
        task.setTaskDefinition(taskDefinition);
        if (activeNameExpression != null) {
            String name = null;
            try {
                name = (String)activeNameExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                name = activeNameExpression.getExpressionText();
                LOGGER.warn("property not found in task name expression {}", (Object)e.getMessage());
            }
            task.setName(name);
        }
        if (activeDescriptionExpression != null) {
            String description = null;
            try {
                description = (String)activeDescriptionExpression.getValue((VariableScope)execution);
            }
            catch (ActivitiException e) {
                description = activeDescriptionExpression.getExpressionText();
                LOGGER.warn("property not found in task description expression {}", (Object)e.getMessage());
            }
            task.setDescription(description);
        }
        if (activeDueDateExpression != null && (dueDate = activeDueDateExpression.getValue((VariableScope)execution)) != null) {
            if (dueDate instanceof Date) {
                task.setDueDate((Date)dueDate);
            } else if (dueDate instanceof String) {
                BusinessCalendar businessCalendar = Context.getProcessEngineConfiguration().getBusinessCalendarManager().getBusinessCalendar(taskDefinition.getBusinessCalendarNameExpression().getValue((VariableScope)execution).toString());
                task.setDueDate(businessCalendar.resolveDuedate((String)dueDate));
            } else {
                throw new ActivitiIllegalArgumentException("Due date expression does not resolve to a Date or Date string: " + activeDueDateExpression.getExpressionText());
            }
        }
        if (activePriorityExpression != null && (priority = activePriorityExpression.getValue((VariableScope)execution)) != null) {
            if (priority instanceof String) {
                try {
                    task.setPriority(Integer.parseInt((String)priority));
                }
                catch (NumberFormatException e) {
                    throw new ActivitiIllegalArgumentException("Priority does not resolve to a number: " + priority, (Throwable)e);
                }
            } else if (priority instanceof Number) {
                task.setPriority(((Number)priority).intValue());
            } else {
                throw new ActivitiIllegalArgumentException("Priority expression does not resolve to a number: " + activePriorityExpression.getExpressionText());
            }
        }
        if (activeCategoryExpression != null && (category = activeCategoryExpression.getValue((VariableScope)execution)) != null) {
            if (category instanceof String) {
                task.setCategory((String)category);
            } else {
                throw new ActivitiIllegalArgumentException("Category expression does not resolve to a string: " + activeCategoryExpression.getExpressionText());
            }
        }
        if (activeFormKeyExpression != null && (formKey = activeFormKeyExpression.getValue((VariableScope)execution)) != null) {
            if (formKey instanceof String) {
                task.setFormKey((String)formKey);
            } else {
                throw new ActivitiIllegalArgumentException("FormKey expression does not resolve to a string: " + activeFormKeyExpression.getExpressionText());
            }
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinition.getId());
        Map extensionElementsNode = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey()).getExtensionElements();
        boolean skip = false;
        if (extensionElementsNode.get("skiprepetition") != null) {
            String skipTypeValue = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("skiprepetition")).get(0)).getAttributes().get("skiprepetition")).get(0)).getValue();
            List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().unfinished().desc()).listPage(0, 1);
            if (hisTaskList != null && hisTaskList.size() > 0) {
                List<String> skipList;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
                map = historicTaskInstance.getTaskLocalVariables();
                if (map != null && map.size() > 0) {
                    boolean bl = flag = map.get("is_normal_commit") == null || (Boolean)map.get("is_normal_commit") != false;
                }
                if (flag && (skipList = Arrays.asList(skipTypeValue.split(","))).contains("2") && ToolUtil.isNotEmpty((Object)hisTaskList)) {
                    String lastAssign = historicTaskInstance.getAssignee();
                    if (userId != null && userId.contains(lastAssign)) {
                        task.setAssignee(lastAssign);
                        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
                            this.activityRedisTimer.delTimeOutModel(task.getId());
                        }
                        skip = true;
                    }
                }
            }
        }
        String delayToAssign = "";
        if (extensionElementsNode.get("delayToAssign") != null) {
            delayToAssign = ((ExtensionAttribute)((List)((ExtensionElement)((List)extensionElementsNode.get("delayToAssign")).get(0)).getAttributes().get("delayToAssign")).get(0)).getValue();
        }
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            if (!"true".equals(delayToAssign)) {
                task.setAssignee(userId, true, false);
            } else {
                String taskId = task.getId();
                CandidateUser tmp = new CandidateUser();
                tmp.setTaskId(taskId);
                tmp.setAssignee(userId);
                this.candidateUserService.save((Object)tmp);
            }
        }
        task.fireEvent("create");
        this.setVariables(task, execution.getVariables());
        if (Context.getProcessEngineConfiguration().getEventDispatcher().isEnabled()) {
            Context.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((ActivitiEvent)ActivitiEventBuilder.createEntityEvent((ActivitiEventType)ActivitiEventType.TASK_CREATED, (Object)task));
        }
        if (ToolUtil.isNotEmpty((Object)(ccUserMessage = execution.getVariable(CC_USER_MESSAGE)))) {
            String sendUserId;
            Map map2 = (Map)ccUserMessage;
            Set ccUsers = (Set)map2.get("ccUser");
            if (!ToolUtil.isOneEmpty((Object[])new Object[]{ccUsers, sendUserId = (String)map2.get("ccSendUser")})) {
                this.ccTask((Task)task, ccUsers, sendUserId, execution);
            }
            execution.removeVariable(CC_USER_MESSAGE);
        }
        if (!skip && ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)execution.getVariable("TimeOutStrategy"))) {
            TimeOutModel timeOutModel = new TimeOutModel();
            timeOutModel.setId(task.getId());
            timeOutModel.setCreateTime(task.getCreateTime());
            timeOutModel.setDueTime(task.getDueDate());
            timeOutModel.setAssignee(task.getAssignee());
            timeOutModel.setTimeOutType((String)execution.getVariable("TimeOutStrategy"));
            timeOutModel.setTenantId(execution.getTenantId());
            if (timeOutModel.getTimeOutType().startsWith("http") || "urging".equals(timeOutModel.getTimeOutType())) {
                map = new HashMap<String, Object>();
                map.put("name", task.getName());
                map.put("processInsId", task.getProcessInstanceId());
                map.put("processDefinitionId", task.getProcessDefinitionId());
                map.put("taskDefinitionKey", task.getTaskDefinitionKey());
                map.put("formKey", task.getFormKey());
                map.put("businessId", execution.getProcessBusinessKey());
                map.put("processName", ((ExecutionEntity)execution).getProcessDefinition().getName());
                map.put("todoConfiguration", task.getVariable("todoConfiguration"));
                map.put("sendUser", task.getVariable("sendUser"));
                timeOutModel.setMap(JSON.toJSONString(map));
            }
            this.activityRedisTimer.addTimeOutModel(timeOutModel);
        }
        if (flag) {
            this.insertActHiActinst(execution, userId, task);
        }
        task.fireEvent("start");
        if (skip) {
            return task;
        }
        return null;
    }

    private void setVariables(TaskEntity task, Map<String, Object> variables) {
        Map<String, String> map = AnalyticalModelUtil.getToDoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.size() == 0) {
            return;
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        newVariables.putAll(processMap);
        newVariables.putAll(taskMap);
        String todo = newVariables.size() > 0 ? AnalyticalModelUtil.getTodo(newVariables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        task.setVariableLocal("todoConfiguration", (Object)todo);
    }

    public void leave(ActivityExecution execution) {
        if (TaskEngineServiceImpl.CALL_REJECT_LIST.contains(execution.getProcessInstanceId() + ((ExecutionEntity)execution).getActivityId())) {
            return;
        }
        int nrOfInstances = this.getLoopVariable(execution, "nrOfInstances");
        if (nrOfInstances == 0) {
            super.leave(execution);
        } else {
            ExecutionEntity executionEntity;
            int loopCounter = this.getLoopVariable(execution, this.getCollectionElementIndexVariable());
            int nrOfCompletedInstances = this.getLoopVariable(execution, "nrOfCompletedInstances") + 1;
            int nrOfActiveInstances = this.getLoopVariable(execution, "nrOfActiveInstances") - 1;
            ActivityExecution newExecution = execution;
            if (this.isExtraScopeNeeded()) {
                executionEntity = (ExecutionEntity)execution;
                newExecution = execution.getParent();
                executionEntity.remove();
            }
            if (newExecution.getParent() != null) {
                this.setLoopVariable(newExecution.getParent(), "nrOfCompletedInstances", nrOfCompletedInstances);
                this.setLoopVariable(newExecution.getParent(), "nrOfActiveInstances", nrOfActiveInstances);
            }
            this.logLoopDetails(newExecution, "instance completed", loopCounter, nrOfCompletedInstances, nrOfActiveInstances, nrOfInstances);
            executionEntity = (ExecutionEntity)newExecution;
            if (executionEntity.getParent() != null) {
                executionEntity.inactivate();
                executionEntity.getParent().forceUpdate();
                List joinedExecutions = executionEntity.findInactiveConcurrentExecutions(newExecution.getActivity());
                if (joinedExecutions.size() >= nrOfInstances || this.completionConditionSatisfied(newExecution)) {
                    execution.removeVariable("reject_appoint_assignee");
                    ArrayList<ExecutionEntity> executionsToRemove = new ArrayList<ExecutionEntity>();
                    for (ActivityExecution childExecution : executionEntity.getParent().getExecutions()) {
                        if (!childExecution.isActive()) continue;
                        executionsToRemove.add((ExecutionEntity)childExecution);
                    }
                    StringBuilder taskIds = new StringBuilder();
                    for (ExecutionEntity executionEntity2 : executionsToRemove) {
                        if (!ToolUtil.isNotEmpty((Object)executionEntity2.getTasks()) || !ToolUtil.isNotEmpty((Object)((TaskEntity)executionEntity2.getTasks().get(0)).getDueDate())) continue;
                        taskIds.append(",").append(((TaskEntity)executionEntity2.getTasks().get(0)).getId());
                    }
                    if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                        this.activityRedisTimer.delTimeOutModel(taskIds.toString().substring(1));
                    }
                    Iterator var9 = executionsToRemove.iterator();
                    StringBuilder updateTaskIds = new StringBuilder();
                    for (ExecutionEntity executionToRemove : executionsToRemove) {
                        if (!ToolUtil.isNotEmpty((Object)executionToRemove.getTasks())) continue;
                        updateTaskIds.append(",'").append(((TaskEntity)executionToRemove.getTasks().get(0)).getId()).append("'");
                    }
                    if (updateTaskIds.length() > 1) {
                        this.taskEngineMapper.removeMultiHistoryTask(updateTaskIds.substring(1));
                        this.dataPushService.deleteMultiTask(new ArrayList<String>(Arrays.asList(updateTaskIds.toString().substring(1).replace("'", "").split(","))));
                    }
                    while (var9.hasNext()) {
                        ExecutionEntity executionEntity3 = (ExecutionEntity)var9.next();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Execution {} still active, but multi-instance is completed. Removing this execution.", (Object)executionEntity3);
                        }
                        executionEntity3.inactivate();
                        executionEntity3.deleteCascade("multi-instance completed");
                    }
                    executionEntity.takeAll(executionEntity.getActivity().getOutgoingTransitions(), joinedExecutions);
                }
            } else {
                super.leave((ActivityExecution)executionEntity);
            }
        }
    }

    protected boolean completionConditionSatisfied(ActivityExecution execution) {
        ExpressionFactoryImpl expressionFactory = new ExpressionFactoryImpl();
        Object multiType = execution.getVariable("multi_type");
        if (ToolUtil.isNotEmpty((Object)multiType)) {
            String condition = "";
            if ("0".equals(multiType.toString())) {
                condition = "${nrOfCompletedInstances/nrOfInstances >=" + Double.parseDouble(String.valueOf(execution.getVariable("multi_finish_condition"))) / 100.0 + "}";
            }
            if ("1".equals(multiType.toString())) {
                condition = "${nrOfCompletedInstances == " + Integer.parseInt(String.valueOf(execution.getVariable("multi_finish_condition"))) + " }";
            }
            ValueExpression valueExpression = expressionFactory.createValueExpression((ELContext)new ParsingElContext(), condition, Object.class);
            this.completionConditionExpression = new JuelExpression(valueExpression, condition);
        }
        if (this.completionConditionExpression != null) {
            Object value = this.completionConditionExpression.getValue((VariableScope)execution);
            if (!(value instanceof Boolean)) {
                throw new ActivitiIllegalArgumentException("completionCondition '" + this.completionConditionExpression.getExpressionText() + "' does not evaluate to a boolean value");
            }
            Boolean booleanValue = (Boolean)value;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Completion condition of multi-instance satisfied: {}", (Object)booleanValue);
            }
            return booleanValue;
        }
        return false;
    }

    private void insertActHiActinst(ActivityExecution execution, String userId, TaskEntity task) {
        IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
        String processDefinitionId = execution.getProcessDefinitionId();
        String processInsId = execution.getProcessInstanceId();
        String executionId = execution.getId();
        HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
        historicActivityInstance.setId(idGenerator.getNextId());
        historicActivityInstance.setProcessDefinitionId(processDefinitionId);
        historicActivityInstance.setProcessInstanceId(processInsId);
        historicActivityInstance.setExecutionId(executionId);
        historicActivityInstance.setActivityId(execution.getActivity().getId());
        historicActivityInstance.setActivityName((String)execution.getActivity().getProperty("name"));
        historicActivityInstance.setActivityType((String)execution.getActivity().getProperty("type"));
        historicActivityInstance.setStartTime(Context.getProcessEngineConfiguration().getClock().getCurrentTime());
        historicActivityInstance.setAssignee(userId);
        historicActivityInstance.setTaskId(task.getId());
        if (execution.getTenantId() != null) {
            historicActivityInstance.setTenantId(execution.getTenantId());
        }
        this.getDbSqlSession().insert((PersistentObject)historicActivityInstance);
    }

    protected Expression getActiveValue(Expression originalValue, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValueNode;
        Object activeValue = originalValue;
        if (taskElementProperties != null && (overrideValueNode = taskElementProperties.get(propertyName)) != null) {
            activeValue = overrideValueNode.isNull() ? null : Context.getProcessEngineConfiguration().getExpressionManager().createExpression(overrideValueNode.asText());
        }
        return activeValue;
    }

    protected Set<Expression> getActiveValueSet(Set<Expression> originalValues, String propertyName, ObjectNode taskElementProperties) {
        JsonNode overrideValuesNode;
        Set<Expression> activeValues = originalValues;
        if (taskElementProperties != null && (overrideValuesNode = taskElementProperties.get(propertyName)) != null) {
            if (overrideValuesNode.isNull() || !overrideValuesNode.isArray() || overrideValuesNode.size() == 0) {
                activeValues = null;
            } else {
                ExpressionManager expressionManager = Context.getProcessEngineConfiguration().getExpressionManager();
                activeValues = new HashSet<Expression>();
                for (JsonNode valueNode : overrideValuesNode) {
                    activeValues.add(expressionManager.createExpression(valueNode.asText()));
                }
            }
        }
        return activeValues;
    }

    protected Collection getUser(BpmnModel bm, ActivityExecution execution, boolean flag) {
        AbstractCollection collection = new ArrayList();
        if (flag) {
            JSONArray allCallActivityInfos;
            JSONArray callActivityInfos = null;
            JSONArray jSONArray = allCallActivityInfos = execution.getVariable("call_activity_info") == null ? null : (JSONArray)execution.getVariable("call_activity_info");
            if (ToolUtil.isNotEmpty((Object)allCallActivityInfos)) {
                callActivityInfos = this.getRightActivity(allCallActivityInfos, execution);
            }
            if (ToolUtil.isNotEmpty(callActivityInfos)) {
                for (Object object : callActivityInfos) {
                    collection.add("");
                }
                return collection;
            }
            CallActivity callActivity = (CallActivity)((Process)bm.getProcesses().get(0)).getFlowElement(((ExecutionEntity)execution).getActivityId());
            String processDefinitionJson = callActivity.getCalledElement();
            List<Object> list = new ArrayList();
            if (ToolUtil.isNotEmpty((Object)processDefinitionJson)) {
                list = Arrays.asList(processDefinitionJson.split(","));
            }
            for (int i = 0; i < list.size(); ++i) {
                collection.add("");
            }
            return collection;
        }
        collection = AnalyticalModelUtil.getCandidateUser(bm, execution, false, execution.getTenantId());
        return collection;
    }

    protected int resolveNrOfInstances(ActivityExecution execution) {
        boolean flag = "callActivity".equals(execution.getActivity().getProperty("type")) && "parallel".equals(execution.getActivity().getProperty("multiInstance"));
        BpmnModel bm = this.repositoryService.getBpmnModel(execution.getProcessDefinitionId());
        Collection users = this.getUser(bm, execution, flag);
        return users == null ? 0 : users.size();
    }
}

