/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstancePercentUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.extend.ExtendParallelMultiInstanceBehavior;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.engine.runtime.Execution;

public class MultiInstanceDelAssigneeCmd
implements Command<Void> {
    protected String executionId;
    protected String taskId;
    private List<String> assignees;
    private TaskEngineMapper taskEngineMapper = (TaskEngineMapper)SpringContextHolder.getApplicationContext().getBean(TaskEngineMapper.class);
    private BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getApplicationContext().getBean(BpmConstantProperties.class);
    private ActivityRedisTimerService activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getApplicationContext().getBean(ActivityRedisTimerService.class);
    private DataPushService dataPushService = (DataPushService)SpringContextHolder.getApplicationContext().getBean(DataPushService.class);

    public MultiInstanceDelAssigneeCmd(String executionId, String taskId, List<String> assignees) {
        this.executionId = executionId;
        this.taskId = taskId;
        this.assignees = assignees;
    }

    public Void execute(CommandContext commandContext) {
        ActivityBehavior activityBehavior;
        ProcessEngineConfigurationImpl pec = commandContext.getProcessEngineConfiguration();
        RuntimeService runtimeService = pec.getRuntimeService();
        Execution execution = (Execution)runtimeService.createExecutionQuery().executionId(this.executionId).singleResult();
        ExecutionEntity ee = (ExecutionEntity)execution;
        int nrOfInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfInstances");
        int num = 1;
        if (nrOfInstances == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getTheOnlyAssigneeInMulti(), Boolean.valueOf(false));
        }
        if (this.assignees != null && this.assignees.size() > 0) {
            List executionEntities = ee.getParent().getExecutions();
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<ExecutionEntity> entities = new ArrayList<ExecutionEntity>();
            for (ExecutionEntity entity : executionEntities) {
                if (!ToolUtil.isNotEmpty((Object)entity.getTasks()) || !this.assignees.contains(((TaskEntity)entity.getTasks().get(0)).getAssignee())) continue;
                stringBuilder.append(",'").append(((TaskEntity)entity.getTasks().get(0)).getId()).append("'");
                entities.add(entity);
            }
            num = entities.size();
            if (nrOfInstances == num) {
                throw new PublicClientException(this.bpmConstantProperties.getTheOnlyAssigneeInMulti(), Boolean.valueOf(false));
            }
            if (num == 0) {
                return null;
            }
            String taskIds = stringBuilder.toString().substring(1);
            this.taskEngineMapper.removeMultiHistoryTask(taskIds);
            this.dataPushService.deleteMultiTask(new ArrayList<String>(Arrays.asList(taskIds.replace("'", "").split(","))));
            if (((TaskEntity)((ExecutionEntity)entities.get(0)).getTasks().get(0)).getDueDate() != null) {
                this.activityRedisTimerService.delTimeOutModel(taskIds.replace("'", ""));
            }
            ee = (ExecutionEntity)entities.get(0);
            for (ExecutionEntity entity : entities) {
                entity.remove();
                Context.getCommandContext().getHistoryManager().recordActivityEnd(entity);
                commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByProcInstance(entity.getId());
            }
        } else {
            this.taskEngineMapper.removeMultiHistoryTask("'" + this.taskId + "'");
            this.dataPushService.deleteMultiTask(new ArrayList<String>(Collections.singletonList(this.taskId)));
            ee.remove();
            Context.getCommandContext().getHistoryManager().recordActivityEnd(ee);
            commandContext.getIdentityLinkEntityManager().deleteIdentityLinksByProcInstance(this.executionId);
        }
        int nrOfCompletedInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfCompletedInstances");
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfInstances", nrOfInstances - num);
        MultiInstancePercentUtils.setLoopVariable(ee, "nrOfCompletedInstances", nrOfCompletedInstances - 1);
        if (num > 1) {
            int nrOfActiveInstances = MultiInstancePercentUtils.getLoopVariable(ee, "nrOfActiveInstances");
            MultiInstancePercentUtils.setLoopVariable(ee, "nrOfActiveInstances", nrOfActiveInstances - num + 1);
        }
        if ((activityBehavior = ee.getActivity().getActivityBehavior()) instanceof ExtendParallelMultiInstanceBehavior) {
            ((ExtendParallelMultiInstanceBehavior)activityBehavior).leave((ActivityExecution)ee);
        }
        return null;
    }
}

