/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.util;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;

public class EntrustAssigneeCmd
implements Command<Void> {
    protected String taskId;
    protected String userId;
    protected String mandatary;
    protected boolean isAdd;
    protected boolean isSame;

    public EntrustAssigneeCmd(String taskId, String userId, String mandatary, boolean isAdd, boolean isSame) {
        this.taskId = taskId;
        this.userId = userId;
        this.mandatary = mandatary;
        this.isAdd = isAdd;
        this.isSame = isSame;
    }

    public Void execute(CommandContext commandContext) {
        TaskEntity taskEntity = Context.getCommandContext().getTaskEntityManager().findTaskById(this.taskId);
        if (taskEntity.getAssignee() != null) {
            taskEntity.setAssignee(this.mandatary);
        } else {
            if (this.isSame) {
                taskEntity.deleteCandidateUser(this.userId);
                return null;
            }
            Set identityLinks = taskEntity.getCandidates();
            if (ToolUtil.isNotEmpty((Object)this.userId)) {
                taskEntity.deleteCandidateUser(this.userId);
                taskEntity.addCandidateUsers(Arrays.asList(this.mandatary.split(",")));
            } else {
                ArrayList<String> users = new ArrayList<String>(Arrays.asList(this.mandatary.split(",")));
                for (IdentityLink identityLink : identityLinks) {
                    if (this.isAdd) {
                        users.remove(identityLink.getUserId());
                        continue;
                    }
                    taskEntity.deleteCandidateUser(identityLink.getUserId());
                }
                if (users.size() > 0) {
                    taskEntity.addCandidateUsers(users);
                }
            }
        }
        return null;
    }
}

