/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.model.SysActCcTask;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.InstanceEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.IInstanceEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl.TaskEngineServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.tenant.service.ISysUserService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.IdentityService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Comment;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InstanceEngineServiceImpl
implements IInstanceEngineService {
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Resource
    private ITaskEngineService taskEngineService;
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private IdentityService identityService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService iSysActUrgeTaskService;
    @Autowired
    private ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private DataPushService dataPushService;
    @Resource
    private InstanceEngineMapper instanceEngineMapper;
    private static final Map<String, String> TASK_SOURCE_FLAG = new HashMap<String, String>();
    private static final String FINISH_STATE = "finish";
    private static final String NOW_STATE = "complete";
    @Autowired
    private ISysUserService sysUserService;

    public BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, String tenantId, Map<String, Object> variables) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        boolean flag = this.validateAuthority(userId, processDefinitionId, tenantId, businessId, variables);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("tenantId", tenantId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, String tenantId, Map<String, Object> variables) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
        boolean flag = this.validateAuthority(userId, processDefinitionId, tenantId, businessId, variables);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNoAuthorityStartProcess(), null);
        }
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "processCreateStart");
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("tenantId", tenantId);
        map.put("businessId", businessId);
        CommonCodeUtil.triggerEventHandleClass(map);
        newVariables.put("startUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult validationStartProcess(String processKey, String userId, String businessId, String tenantId, Map<String, Object> variables) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
        this.identityService.setAuthenticatedUserId(userId);
        HashMap<String, Object> newVariables = new HashMap<String, Object>(this.installVariables(processDefinitionId, variables));
        newVariables.put("sendUser", userId);
        ProcessInstance processInstance = this.runtimeService.startProcessInstanceById(processDefinitionId, businessId, newVariables);
        JSONArray json = this.installJson(processInstance.getProcessInstanceId(), userId, newVariables);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult checkProcessInstByBusinessId(String businessId) {
        List instance = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).listPage(0, 1);
        if (instance != null && instance.size() > 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONObject object = new JSONObject();
        if (tasks != null && tasks.size() > 0) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                object.put("processKey", (Object)task.getProcessDefinitionId().split(":")[0]);
                object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                object.put("businessId", (Object)businessId);
                object.put("taskId", (Object)task.getId());
                return ApiResponse.success((Object)object);
            }
            return ApiResponse.fail((String)this.bpmConstantProperties.getBusinessAlreadyStartProcess());
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (ToolUtil.isNotEmpty((Object)historicProcessInstance)) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getBusinessAlreadyStartProcess());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult validateDeleteByBusinessId(String businessId) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        JSONArray jsonArray = new JSONArray();
        if (tasks != null && tasks.size() > 0) {
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((Task)tasks.get(0)).getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().activityType("userTask").asc()).listPage(0, 1);
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)historicActivityInstances.get(0);
            for (Task task : tasks) {
                if (!task.getTaskDefinitionKey().equals(historicActivityInstance.getActivityId())) continue;
                jsonArray.add((Object)"1");
                return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
            }
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (ToolUtil.isNotEmpty((Object)historicProcessInstance)) {
            jsonArray.add((Object)"2");
            return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getBusinessAlreadyStartProcess(), (JSONArray)jsonArray);
        }
        jsonArray.add((Object)"0");
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private boolean validateAuthority(String userId, String processDefinitionId, String tenantId, String businessId, Map<String, Object> variables) {
        List users;
        String sql = AnalyticalModelUtil.queryFirstNodeAssigneeConfig(userId, tenantId, processDefinitionId, businessId, variables);
        if (ToolUtil.isEmpty((Object)sql)) {
            return true;
        }
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        boolean flag = (users = this.iAssigneeChooseService.getCandidateUser(sql, tenantId, (Integer)variables.get("security_level"))) != null && users.size() > 0 ? users.contains(userId) : true;
        return flag;
    }

    public Map<String, Object> installVariables(String processDefinitionId, Map<String, Object> variables) {
        String todo;
        if (ToolUtil.isEmpty((Object)processDefinitionId)) {
            return variables;
        }
        Map<String, String> map = AnalyticalModelUtil.getToDoConfiguration(processDefinitionId, null);
        if (map.size() == 0) {
            return variables;
        }
        if (variables != null && variables.size() > 0) {
            try {
                todo = AnalyticalModelUtil.getTodo(variables, map.get("todoConfiguration"));
            }
            catch (Exception e) {
                todo = map.get("todoConfiguration");
            }
        } else {
            HashMap<String, Object> newVariables = new HashMap<String, Object>(3);
            newVariables.put("todoConfiguration", map.get("todoConfiguration"));
            return newVariables;
        }
        variables.put("todoConfiguration", todo);
        return variables;
    }

    private JSONArray installJson(String processInsId, String userId, Map<String, Object> variables) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).active().list();
        for (Task task : tasks) {
            JSONObject object = new JSONObject();
            List<String> users = this.getAssigneeByTaskId(task.getId());
            if (users.size() == 0) {
                this.taskService.setAssignee(task.getId(), userId);
            }
            this.taskService.setVariableLocal(task.getId(), "sendUser", (Object)userId);
            this.taskService.setVariableLocal(task.getId(), "complete_type", (Object)NOW_STATE);
            object.put("processInsId", (Object)processInsId);
            object.put("taskId", (Object)task.getId());
            object.put("userId", new HashSet<String>(this.getAssigneeByTaskId(task.getId())));
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
            object.put("taskDefinitionName", (Object)task.getName());
            object.put("formKey", (Object)task.getFormKey());
            json.add((Object)object);
        }
        return json;
    }

    private void setVariables(Task task, Map<String, Object> variables) {
        Map<String, String> map = AnalyticalModelUtil.getToDoConfiguration(task.getProcessDefinitionId(), task.getTaskDefinitionKey());
        if (map.size() == 0) {
            return;
        }
        HashMap<String, Object> newVariables = new HashMap<String, Object>();
        if (variables != null) {
            newVariables.putAll(variables);
        }
        Map processMap = task.getProcessVariables();
        Map taskMap = task.getTaskLocalVariables();
        newVariables.putAll(processMap);
        newVariables.putAll(taskMap);
        String todo = newVariables.size() > 0 ? AnalyticalModelUtil.getTodo(newVariables, map.get("todoConfiguration")) : map.get("todoConfiguration");
        this.taskService.setVariableLocal(task.getId(), "todoConfiguration", (Object)todo);
    }

    public BpmResponseResult suspendProcessInstanceById(String processInsId) {
        this.runtimeService.suspendProcessInstanceById(processInsId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "suspendEnd");
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        map.put("processInsId", processInsId);
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activateProcessInstanceById(String processInsId) {
        this.runtimeService.activateProcessInstanceById(processInsId);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "activateEnd");
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        map.put("processInsId", processInsId);
        map.put("processDefinitionId", processInstance.getProcessDefinitionId());
        map.put("processDefinitionName", processInstance.getProcessDefinitionName());
        map.put("businessId", processInstance.getBusinessKey());
        map.put("starter", processInstance.getStartUserId());
        map.put("startTime", processInstance.getStartTime());
        CommonCodeUtil.triggerEventHandleClass(map);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        StringBuilder taskIds = new StringBuilder();
        for (Task task : tasks) {
            if (!ToolUtil.isNotEmpty((Object)task.getDueDate())) continue;
            taskIds.append(",").append(task.getId());
        }
        if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
            this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
        }
        this.runtimeService.deleteProcessInstance(processInsId, reason);
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = new DataPush();
            dataPush.setBusinessKey(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()).getBusinessKey());
            dataPush.setProcessInsId(processInsId);
            this.dataPushService.deleteDataPush(dataPush);
        }
        LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
        urgeQueryWrapper.eq(SysActUrgeTask::getProcessInsId, (Object)processInsId);
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        this.historyService.deleteHistoricProcessInstance(processInsId);
        LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
        ccQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)processInsId);
        this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
        LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
        urgeQueryWrapper.eq(SysActUrgeTask::getProcessInsId, (Object)processInsId);
        this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessId(String businessId) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null) {
            if (historicProcessInstance.getEndTime() != null) {
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            } else {
                List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(historicProcessInstance.getId())).list();
                StringBuilder taskIds = new StringBuilder();
                for (Task task : tasks) {
                    if (!ToolUtil.isNotEmpty((Object)task.getDueDate())) continue;
                    taskIds.append(",").append(task.getId());
                }
                if (ToolUtil.isNotEmpty((Object)taskIds.toString())) {
                    this.activityRedisTimerService.delTimeOutModel(taskIds.toString().substring(1));
                }
                this.runtimeService.deleteProcessInstance(historicProcessInstance.getId(), "");
                this.historyService.deleteHistoricProcessInstance(historicProcessInstance.getId());
            }
            LambdaQueryWrapper ccQueryWrapper = new LambdaQueryWrapper();
            ccQueryWrapper.eq(SysActCcTask::getProcessInsId, (Object)historicProcessInstance.getId());
            this.iSysActCcTaskService.remove((Wrapper)ccQueryWrapper);
            LambdaQueryWrapper urgeQueryWrapper = new LambdaQueryWrapper();
            urgeQueryWrapper.eq(SysActUrgeTask::getProcessInsId, (Object)historicProcessInstance.getId());
            this.iSysActUrgeTaskService.remove((Wrapper)urgeQueryWrapper);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult deleteProcessInstanceByBusinessIdList(String businessId, boolean isValidate) {
        try {
            if (ToolUtil.isNotEmpty((Object)businessId)) {
                List<String> procIdList;
                List<String> businessIdList = Arrays.asList(businessId.split(","));
                if (isValidate) {
                    for (String s : businessIdList) {
                        BpmResponseResult validateResult;
                        if (s.isEmpty() || (validateResult = this.validateDeleteByBusinessId(s)).getResult().get(0) != null && "1".equals(validateResult.getResult().get(0).toString())) continue;
                        return InstallResult.getResult((String)"0", (String)validateResult.getMsg(), null);
                    }
                }
                if (!(procIdList = this.instanceEngineMapper.selectProcIdByBusinessIdList(businessIdList)).isEmpty()) {
                    this.instanceEngineMapper.deleteByProcIdList(procIdList, this.druidProperties.getUrl().split(":")[1]);
                }
            }
        }
        catch (Exception e) {
            return InstallResult.getResult((String)"0", (String)"error", null);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        JSONObject object = new JSONObject();
        JSONArray json = new JSONArray();
        Long count = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).processDefinitionKey(processKey).finished().count();
        List insts = this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).processDefinitionKey(processKey).finished().listPage((page - 1) * rows, rows);
        object.put("data", (Object)insts);
        object.put("count", (Object)count);
        json.add((Object)object);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        JSONArray json = new JSONArray();
        boolean isEnded = true;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance != null) {
            throw new PublicClientException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff01");
        }
        if (!processInstance.isEnded()) {
            isEnded = false;
        }
        json.add((Object)isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessInstanceCompleteStateByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        boolean isEnded = true;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
        if (processInstance != null) {
            throw new PublicClientException("\u6d41\u7a0b\u5b9e\u4f8b\u4e0d\u5b58\u5728\uff01");
        }
        if (!processInstance.isEnded()) {
            isEnded = false;
        }
        json.add((Object)isEnded);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getProcessTrace(String processInsId, String tenantId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray jsonArray = new JSONArray();
        HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(processInstance.getProcessDefinitionId());
        List activitiList = processDefinition.getActivities();
        List hisList = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("userTask").orderByHistoricActivityInstanceStartTime().desc()).finished().list();
        List<Object> userList = new ArrayList();
        if (hisList != null && hisList.size() > 0) {
            userList = hisList.stream().map(HistoricActivityInstance::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        for (ActivityImpl activity : activitiList) {
            JSONObject object = new JSONObject();
            object.put("width", (Object)activity.getWidth());
            object.put("height", (Object)activity.getHeight());
            object.put("x", (Object)activity.getX());
            object.put("y", (Object)activity.getY());
            object.put("id", (Object)activity.getId());
            List taskList = null;
            if (tasks != null && tasks.size() > 0) {
                taskList = tasks.stream().filter(t -> t.getTaskDefinitionKey().equals(activity.getId())).collect(Collectors.toList());
            }
            if (taskList != null && taskList.size() > 0) {
                List<String> user = this.getAssigneeByTaskId(((Task)taskList.get(0)).getId());
                if (user.size() > 0) {
                    String assignee = this.iAssigneeChooseService.getUserNames(user, tenantId);
                    object.put("assignee", (Object)assignee);
                } else {
                    object.put("assignee", (Object)this.bpmConstantProperties.getNullAssignee());
                }
                object.put("state", (Object)NOW_STATE);
            } else {
                object.put("state", (Object)FINISH_STATE);
                List hisActivitList = null;
                if (hisList != null && hisList.size() > 0) {
                    hisActivitList = hisList.stream().filter(hai -> hai.getActivityId().equals(activity.getId())).collect(Collectors.toList());
                }
                if (hisActivitList == null || hisActivitList.size() <= 0) continue;
                hisActivitList.sort(Comparator.comparing(HistoricActivityInstance::getStartTime));
                JSONArray json = new JSONArray();
                for (HistoricActivityInstance historicActivityInstance : hisActivitList) {
                    List comments;
                    JSONObject o = new JSONObject();
                    String user = "";
                    if (historicActivityInstance.getAssignee() != null) {
                        user = (String)finalUsersMap.get(historicActivityInstance.getAssignee());
                    }
                    if ((comments = this.taskService.getTaskComments(historicActivityInstance.getTaskId(), NOW_STATE)) != null && comments.size() > 0) {
                        o.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                    } else {
                        o.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                    }
                    o.put("assignee", (Object)user);
                    o.put("endTime", (Object)historicActivityInstance.getEndTime());
                    o.put("startTime", (Object)historicActivityInstance.getStartTime());
                    json.add((Object)o);
                }
                object.put("completeInfo", (Object)json);
            }
            jsonArray.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult getAllProcessTrace(String processInsId, String tenantId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).list();
        return this.getResult(hisTaskList, tenantId, true);
    }

    public BpmResponseResult queryCallActivityTask(String businessId, String processInsId, int type, String tenantId) {
        HistoricProcessInstance historicProcessInstance;
        if (ToolUtil.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List<Object> processInsIds = new ArrayList();
        if (type == 0) {
            if (ToolUtil.isEmpty((Object)processInsId)) {
                historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
                if (historicProcessInstance == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
                }
                processInsId = historicProcessInstance.getId();
            }
            if ((processInsIds = this.taskEngineMapper.getCallActivityInstId(processInsId)).size() == 0) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
        } else {
            historicProcessInstance = ToolUtil.isEmpty((Object)processInsId) ? (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult() : (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            if (historicProcessInstance == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
            }
            if (ToolUtil.isEmpty((Object)historicProcessInstance.getSuperProcessInstanceId())) {
                return InstallResult.getResult((String)"1", (String)"success", null);
            }
            processInsIds.add(historicProcessInstance.getSuperProcessInstanceId());
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(processInsIds)).list();
        return this.getResult(historicTaskInstances, tenantId, true);
    }

    public BpmResponseResult getAllProcessTraceByBusinessId(String businessId, String tenantId, int page, int size) {
        if (businessId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        Long count = ((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).count();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().asc()).listPage((page - 1) * size, size);
        BpmResponseResult bpmResponseResult = this.getResult(hisTaskList, tenantId, true);
        bpmResponseResult.setMsg(String.valueOf(count));
        return bpmResponseResult;
    }

    private BpmResponseResult getResult(List<HistoricTaskInstance> hisTaskList, String tenantId, boolean flag) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        if (this.lcdpBpmProperties.isOrderByTime()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            hisTaskList.sort((o1, o2) -> {
                if (!o1.getStartTime().equals(o2.getStartTime()) && !simpleDateFormat.format(o1.getStartTime()).equals(simpleDateFormat.format(o2.getStartTime()))) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
                if (ToolUtil.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                if (o1.getEndTime() == null && o2.getEndTime() != null) {
                    return o2.getEndTime().compareTo(new Date(0L));
                }
                if (o1.getStartTime() != null && o2.getEndTime() == null) {
                    return new Date(0L).compareTo(o1.getEndTime());
                }
                if (o1.getEndTime().equals(o2.getEndTime())) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                return o1.getStartTime().compareTo(o2.getStartTime());
            });
        } else {
            hisTaskList.sort((o1, o2) -> {
                if (ToolUtil.isAllEmpty((Object[])new Object[]{o1.getEndTime(), o2.getEndTime()})) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                if (o1.getEndTime() == null && o2.getEndTime() != null) {
                    return new Date(0L).compareTo(o2.getEndTime());
                }
                if (o1.getEndTime() != null && o2.getEndTime() == null) {
                    return o1.getEndTime().compareTo(new Date(0L));
                }
                if (o1.getEndTime().equals(o2.getEndTime())) {
                    return o1.getTaskDefinitionKey().compareTo(o2.getTaskDefinitionKey());
                }
                return o1.getEndTime().compareTo(o2.getEndTime());
            });
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            ArrayList<String> hisTaskIds = new ArrayList<String>();
            for (HistoricTaskInstance hisTask : hisTaskList) {
                if (hisTask.getEndTime() == null) continue;
                hisTaskIds.add(hisTask.getId());
            }
            List<Object> commentsMap = new ArrayList();
            if (ToolUtil.isNotEmpty(hisTaskIds)) {
                commentsMap = this.taskEngineMapper.getTaskComments(hisTaskIds);
            }
            HashMap taskComment = new HashMap();
            for (Map map : commentsMap) {
                taskComment.put(String.valueOf(map.get("id")), map.get("comments"));
            }
            List<Object> allVariables = new ArrayList();
            if (ToolUtil.isNotEmpty(hisTaskIds)) {
                allVariables = this.flowTaskMapper.getAllVariables(hisTaskIds, null);
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Variables variables : allVariables) {
                if (!"taskSourceFlag".equals(variables.getName())) continue;
                hashMap.put(variables.getTaskId(), variables.getTextValue());
            }
            for (HistoricTaskInstance hsi : hisTaskList) {
                String comment;
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                String nullCommont = "";
                if (flag) {
                    nullCommont = this.bpmConstantProperties.getNullComment();
                }
                object.put("comments", (Object)((comment = (String)taskComment.get(hsi.getId())) == null ? nullCommont : comment));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && users.size() > 0) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users, tenantId);
                        if (ToolUtil.isNotEmpty((Object)assignee)) {
                            object.put("assignee", (Object)assignee);
                        } else {
                            object.put("assignee", (Object)this.bpmConstantProperties.getNullComplete());
                        }
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processKey", (Object)hsi.getProcessDefinitionId().split(":")[0]);
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)hashMap.get(hsi.getId());
                if ("reject_revoke".equals(taskSourceFlag)) {
                    taskSourceFlag = "revoke";
                }
                object.put("taskSourceFlag", (Object)(taskSourceFlag == null ? "" : TASK_SOURCE_FLAG.get(taskSourceFlag)));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getAllProcessTraceByMicroApp(String processInsId, String tenantId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        for (HistoricTaskInstance hsi : nullList) {
            hisTaskList.add(hsi);
        }
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && comments.size() > 0) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (ToolUtil.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                if (hsi.getEndTime() != null) {
                    object.put("assignee", (Object)user);
                    object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                } else {
                    object.put("endTime", (Object)"");
                    List<String> users = this.getAssigneeByTaskId(hsi.getId());
                    if (user != null && users.size() > 0) {
                        String assignee = this.iAssigneeChooseService.getUserNames(users, tenantId);
                        object.put("assignee", (Object)assignee);
                    }
                    object.put("comments", (Object)"");
                }
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    variables.put("taskSourceFlag", "revoke");
                }
                object.put("variables", (Object)variables);
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult getDoneProcessTrace(String businessId, String tenantId) {
        JSONArray json = new JSONArray();
        List<Object> userList = new ArrayList();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceBusinessKey(businessId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).asc()).list();
        ArrayList<HistoricTaskInstance> nullList = new ArrayList<HistoricTaskInstance>();
        for (HistoricTaskInstance historicTaskInstance : hisTaskList) {
            if (historicTaskInstance.getEndTime() != null) continue;
            nullList.add(historicTaskInstance);
        }
        hisTaskList.removeAll(nullList);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            userList = hisTaskList.stream().map(TaskInfo::getAssignee).filter(Objects::nonNull).collect(Collectors.toList());
        }
        Map finalUsersMap = this.iAssigneeChooseService.getUserListByUserId(userList, tenantId);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            for (HistoricTaskInstance hsi : hisTaskList) {
                JSONObject object = new JSONObject();
                String user = hsi.getAssignee() != null ? (finalUsersMap.get(hsi.getAssignee()) == null ? this.bpmConstantProperties.getNullComplete() : (String)finalUsersMap.get(hsi.getAssignee())) : this.bpmConstantProperties.getNullComplete();
                List comments = this.taskService.getTaskComments(hsi.getId(), NOW_STATE);
                if (comments != null && comments.size() > 0) {
                    object.put("comments", (Object)(((Comment)comments.get(0)).getFullMessage() == null ? this.bpmConstantProperties.getNullComment() : ((Comment)comments.get(0)).getFullMessage()));
                } else {
                    object.put("comments", (Object)this.bpmConstantProperties.getNullComment());
                }
                Map variables = hsi.getTaskLocalVariables();
                if (ToolUtil.isEmpty(variables.get("taskSourceFlag"))) {
                    variables.put("taskSourceFlag", "");
                }
                hsi.getTaskLocalVariables();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                object.put("startTime", (Object)sdf.format(hsi.getStartTime()));
                object.put("assignee", (Object)user);
                object.put("endTime", (Object)sdf.format(hsi.getEndTime()));
                object.put("time", (Object)(hsi.getEndTime().getTime() - hsi.getStartTime().getTime()));
                object.put("activityName", (Object)hsi.getName());
                object.put("activityId", (Object)hsi.getId());
                object.put("taskId", (Object)hsi.getId());
                object.put("taskDefinitionKey", (Object)hsi.getTaskDefinitionKey());
                object.put("processDefinitionId", (Object)hsi.getProcessDefinitionId());
                object.put("processInsId", (Object)hsi.getProcessInstanceId());
                String taskSourceFlag = (String)variables.get("taskSourceFlag");
                if ("reject_revoke".equals(taskSourceFlag)) {
                    variables.put("taskSourceFlag", "revoke");
                }
                object.put("variables", (Object)variables);
                object.put("taskSourceFlag", (Object)TASK_SOURCE_FLAG.get(variables.get("taskSourceFlag")));
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(processInstance.getProcessDefinitionId()).singleResult();
        ProcessDefinitionModel processDefinitionModel = new ProcessDefinitionModel();
        processDefinitionModel.setKey(processDefinition.getKey());
        processDefinitionModel.setDescription(processDefinition.getDescription());
        processDefinitionModel.setVersion(String.valueOf(processDefinition.getVersion()));
        processDefinitionModel.setResourceName(processDefinition.getResourceName());
        processDefinitionModel.setDeploymentId(processDefinition.getDeploymentId());
        processDefinitionModel.setDiagramResourceName(processDefinition.getDiagramResourceName());
        processDefinitionModel.setHasStartFormKey(String.valueOf(processDefinition.hasStartFormKey()));
        processDefinitionModel.setHasGraphicalNotation(String.valueOf(processDefinition.hasGraphicalNotation()));
        processDefinitionModel.setIsSuspended(String.valueOf(processDefinition.isSuspended()));
        processDefinitionModel.setTenantId(processDefinition.getTenantId());
        processDefinitionModel.setProcessName(processDefinition.getName());
        processDefinitionModel.setId(processDefinition.getId());
        json.add((Object)processDefinitionModel);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult endProcess(String taskId, String userId, String reason) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIdNull(), null);
        }
        Task task = this.taskEngineService.getTask(taskId, "0");
        this.endCallProcess(task.getProcessInstanceId(), userId, reason);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void endCallProcess(String instanceId, String userId, String reason) {
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instanceId).unfinished().list();
        if (list.size() > 0) {
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                TaskEngineServiceImpl.CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, reason);
                TaskEngineServiceImpl.CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getEndNodeNotFound(), Boolean.valueOf(false));
            }
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, historicActivityInstance.getExecutionId(), destinationActivity, "endProcess", reason, new HashMap<String, Object>(), currentActivity));
        }
    }

    private List<String> getAssigneeByTaskId(String taskId) {
        ArrayList<String> users = new ArrayList<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    public List<Map<String, String>> getCallNodeType(String processInsId) {
        return this.taskEngineMapper.getCallNodeType(processInsId);
    }

    public BpmResponseResult queryCompletecomment(String businessId, String processInsId, String tenantId) {
        BpmResponseResult bpmResponseResult = new BpmResponseResult();
        if (ToolUtil.isEmpty((Object)processInsId)) {
            HistoricProcessInstance instance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult();
            if (instance != null) {
                processInsId = instance.getId();
            } else {
                return bpmResponseResult;
            }
        }
        if (processInsId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).orderByHistoricTaskInstanceEndTime().includeProcessVariables()).includeTaskLocalVariables()).finished().asc()).list();
        return this.getResult(hisTaskList, tenantId, false);
    }

    static {
        TASK_SOURCE_FLAG.put(NOW_STATE, "\u529e\u7406");
        TASK_SOURCE_FLAG.put("revoke", "\u64a4\u56de");
        TASK_SOURCE_FLAG.put("skip", "\u8df3\u8fc7");
        TASK_SOURCE_FLAG.put("reject", "\u9a73\u56de");
        TASK_SOURCE_FLAG.put("freejump", "\u81ea\u7531\u8df3\u8f6c");
        TASK_SOURCE_FLAG.put("endProcess", "\u7ec8\u7ed3\u6d41\u7a0b");
    }
}

