/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.dao.AssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.visitor.AssigneeVisitorBeanUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.workflow.engine.core.util.HussarBpmSM4Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AssigneeChooseServiceImpl
implements IAssigneeChooseService {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Resource
    AssigneeChooseMapper assigneeChooseMapper;
    @Resource
    private ITenantConfigService iTenantConfigService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    private static Logger LOGGER = LoggerFactory.getLogger(AssigneeChooseServiceImpl.class);
    private static final Pattern REGEX = Pattern.compile("\\@\\{([^@]|[^}]\\@)*\\}\\@");
    private static final String USER_TREE_URL = "/assignee/user";
    private static final String DEPT_TREE_URL = "/assignee/dept";
    private static final String ROLE_TREE_URL = "/assignee/role";
    private static final String USER_DETAIL_URL = "/assignee/userDetail";
    private static final String USER_DEPT_DETAIL_URL = "/assignee/userDeptDetail";
    private static final String CANDIDATE_USER_URL = "/assignee/getCandidateUser";
    private static final String REAL_CANDIDATE_URL = "/assignee/getRealCondition";
    private static final String SECUTITY_LEVEL = "/assignee/getSecurityLevel";
    private static final String IS_MULTI_TENANT = "1";
    private static final String DEFAULT_PARENTID = "11";

    public List<BpmTreeModel> userTree(String id, String tenantId, boolean isInterface, boolean isGetTenantUser) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userTree(newId, null);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            return new ArrayList<BpmTreeModel>();
        }
        if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
            try {
                return this.assigneeChooseMapper.userTree(newId, null);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", newId);
        map.put("tenantId", HussarBpmSM4Util.encrypt((String)tenantId, (String)"admin#$%^kopoiuy"));
        return this.getRequestResult(tenantConfig.getProjectAddress() + USER_TREE_URL, isInterface, map);
    }

    public List<BpmTreeModel> deptTree(String id, String tenantId, boolean isInterface) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.deptTree(newId, null);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            return new ArrayList<BpmTreeModel>();
        }
        if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
            try {
                return this.assigneeChooseMapper.deptTree(newId, null);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", newId);
        map.put("tenantId", HussarBpmSM4Util.encrypt((String)tenantId, (String)"admin#$%^kopoiuy"));
        return this.getRequestResult(tenantConfig.getProjectAddress() + DEPT_TREE_URL, isInterface, map);
    }

    public List<BpmTreeModel> roleTree(String tenantId, boolean isInterface) {
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.roleTree();
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            return new ArrayList<BpmTreeModel>();
        }
        if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
            try {
                return this.assigneeChooseMapper.roleTree();
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantId", HussarBpmSM4Util.encrypt((String)tenantId, (String)"admin#$%^kopoiuy"));
        return this.getRequestResult(tenantConfig.getProjectAddress() + ROLE_TREE_URL, isInterface, map);
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, String tenantId, boolean isInterface) {
        if (ToolUtil.isEmpty(userIds)) {
            return null;
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userDetail(userIds);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTenantConfigNotExist(), Boolean.valueOf(false));
        }
        if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
            try {
                return this.assigneeChooseMapper.userDetail(userIds);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userIds", String.join((CharSequence)",", userIds));
        map.put("tenantId", HussarBpmSM4Util.encrypt((String)tenantId, (String)"admin#$%^kopoiuy"));
        return this.getRequestResult(tenantConfig.getProjectAddress() + USER_DETAIL_URL, isInterface, map);
    }

    private List<BpmTreeModel> userDeptDetail(String userId, String tenantId, boolean isInterface) {
        if (ToolUtil.isEmpty((Object)userId)) {
            return null;
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            try {
                return this.assigneeChooseMapper.userDeptDetail(userId);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTenantConfigNotExist(), Boolean.valueOf(false));
        }
        if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
            try {
                return this.assigneeChooseMapper.userDeptDetail(userId);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("tenantId", HussarBpmSM4Util.encrypt((String)tenantId, (String)"admin#$%^kopoiuy"));
        return this.getRequestResult(tenantConfig.getProjectAddress() + USER_DEPT_DETAIL_URL, isInterface, map);
    }

    public String getUserNames(List<String> userIds, String tenantId) {
        StringBuilder result = new StringBuilder();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId, false);
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                result.append(bpmTreeModel.getLabel()).append(",");
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.toString();
    }

    public List<Map<String, String>> getUserListByUserIdWithSelect(List<String> userList, String tenantId) {
        List<BpmTreeModel> list = this.userDetail(userList, tenantId, true);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                HashMap<String, String> mapSelect = new HashMap<String, String>(2);
                mapSelect.put("id", bpmTreeModel.getId());
                mapSelect.put("name", bpmTreeModel.getLabel());
                resultList.add(mapSelect);
            }
        }
        return resultList;
    }

    public Map<String, String> getUserListByUserId(List<String> userIds, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<BpmTreeModel> list = this.userDetail(userIds, tenantId, false);
        if (list != null && list.size() > 0) {
            for (BpmTreeModel bpmTreeModel : list) {
                map.put(bpmTreeModel.getId(), bpmTreeModel.getLabel());
            }
        }
        return map;
    }

    public List<String> getCandidateUser(String condition, String tenantId, Integer securityLevel) {
        if (!this.lcdpBpmProperties.isUseSecurityLevel()) {
            securityLevel = null;
        }
        if (!this.lcdpBpmProperties.isStartAlone()) {
            if (condition.contains("@{")) {
                condition = this.getRealCondition(condition);
            }
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT DISTINCT O.ORGAN_ID AS userId ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append("  LEFT JOIN HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ").append("  WHERE O.TYPE = 'user'  ");
                sb.append(condition);
                return this.assigneeChooseMapper.getCandidateUsers(sb.toString(), securityLevel);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTenantConfigNotExist(), Boolean.valueOf(false));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", HussarBpmSM4Util.encrypt((String)condition, (String)"admin#$%^kopoiuy"));
        map.put("tenantId", HussarBpmSM4Util.encrypt((String)tenantId, (String)"admin#$%^kopoiuy"));
        map.put("securityLevel", securityLevel);
        if (IS_MULTI_TENANT.equals(tenantConfig.getIsMultiTenant())) {
            if (condition.contains("@{")) {
                condition = HttpRequestUtil.getRequestResult((String)(tenantConfig.getProjectAddress() + REAL_CANDIDATE_URL), map);
            }
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(" SELECT DISTINCT O.ORGAN_ID AS userId ").append(" FROM HUSSAR_BPM_ORGAN_VIEW O ").append("  LEFT JOIN HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ").append("  WHERE O.TYPE = 'user'  ");
                sb.append(condition);
                return this.assigneeChooseMapper.getCandidateUsers(sb.toString(), securityLevel);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(2);
            }
        }
        try {
            String result = HttpRequestUtil.getRequestResult((String)(tenantConfig.getProjectAddress() + CANDIDATE_USER_URL), map);
            return JSONArray.parseArray((String)result, String.class);
        }
        catch (GodAxeRequestException e) {
            if (1 == e.getRequestErrorType()) {
                throw new GodAxeRequestException(3);
            }
            throw e;
        }
    }

    private List<BpmTreeModel> getRequestResult(String url, boolean isInterface, Map<String, Object> map) {
        try {
            String result = HttpRequestUtil.getRequestResult((String)url, map);
            return JSONArray.parseArray((String)result, BpmTreeModel.class);
        }
        catch (GodAxeRequestException e) {
            if (isInterface) {
                if (1 == e.getRequestErrorType()) {
                    throw new GodAxeRequestException(3);
                }
                throw e;
            }
            LOGGER.error(this.bpmConstantProperties.getHttpRequestError());
            return new ArrayList<BpmTreeModel>();
        }
        catch (Exception e) {
            if (isInterface) {
                throw new GodAxeRequestException(3);
            }
            LOGGER.error(this.bpmConstantProperties.getHttpRequestError());
            return new ArrayList<BpmTreeModel>();
        }
    }

    public String getRealCondition(String condition) {
        String realCondition = condition;
        if (realCondition.contains("@{")) {
            Matcher matcher = REGEX.matcher(realCondition);
            while (matcher.find()) {
                String message = matcher.group().substring(1, matcher.group().length() - 1);
                CharSequence[] messages = message.split(":");
                for (int j = 0; j < messages.length; ++j) {
                    String str = messages[j];
                    if (j != messages.length - 1) {
                        if (str.lastIndexOf("','") == str.indexOf("','")) continue;
                        str = str.replace("','", ",");
                        int num = str.lastIndexOf(",");
                        messages[j] = str.substring(0, num) + "','" + str.substring(num + 1);
                        continue;
                    }
                    messages[j] = str.replace("','", ",");
                }
                message = String.join((CharSequence)":", messages);
                List<String> userList = this.functionUser((Map)JSONArray.parse((String)message));
                StringBuilder users = new StringBuilder();
                String functionUsers = "";
                if (userList != null && userList.size() > 0) {
                    for (String user : userList) {
                        users.append(user).append("','");
                    }
                    functionUsers = users.toString().substring(0, users.toString().length() - 3);
                } else {
                    functionUsers = "";
                }
                realCondition = realCondition.replace(matcher.group(), functionUsers);
            }
            return realCondition;
        }
        return realCondition;
    }

    public List<String> functionUser(Map<String, Object> message) {
        AssigneeVisitor hussarBpmVariablesVisitor;
        String beanId = new ArrayList<String>(message.keySet()).get(0);
        try {
            if (beanId == null) {
                return new ArrayList<String>();
            }
            hussarBpmVariablesVisitor = AssigneeVisitorBeanUtil.getVisitorBean(beanId);
        }
        catch (NoSuchBeanDefinitionException e) {
            return new ArrayList<String>();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
        return hussarBpmVariablesVisitor.visit((Map)message.get(beanId));
    }

    public String getSameLevelDeptIdByUserId(String userId, String tenantId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT t.STRU_ID struid ").append(" FROM SYS_STRU t  where t.PARENT_ID=( ").append("   SELECT stru.PARENT_ID FROM SYS_STRU stru WHERE stru.STRU_ID=( ").append("  SELECT su.DEPARTMENT_ID FROM SYS_USERS su   ");
        if (ToolUtil.isNotEmpty((Object)userId)) {
            sb.append(" WHERE su.USER_ID = '" + userId + "'");
        }
        sb.append(" )) AND (t.STRU_TYPE='1' or t.STRU_TYPE='2')");
        List<String> deptId = this.queryForJdbcTemplate(sb, tenantId);
        StringBuilder deptIdBuilder = new StringBuilder();
        String deptIds = "";
        if (deptId != null && deptId.size() > 0) {
            for (String deptid : deptId) {
                deptIdBuilder.append(deptid).append(",");
            }
            deptIds = deptIdBuilder.toString().substring(0, deptIdBuilder.toString().length() - 1);
        }
        return deptIds;
    }

    public String getParentDeptIdByUserId(String userId, String tenantId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT stru.PARENT_ID ").append(" FROM SYS_STRU stru WHERE stru.STRU_ID=( ").append("   SELECT su.DEPARTMENT_ID ").append("  FROM SYS_USERS su   ");
        if (ToolUtil.isNotEmpty((Object)userId)) {
            sb.append(" WHERE su.USER_ID = '" + userId + "'");
        }
        sb.append(" )");
        List<String> deptIds = this.queryForJdbcTemplate(sb, tenantId);
        String deptId = "";
        if (deptIds != null && deptIds.size() > 0) {
            deptId = deptIds.get(0);
        }
        return deptId;
    }

    public String getDeptIdByUserId(String userId, String tenantId) {
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT SU.DEPARTMENT_ID ").append(" FROM SYS_USERS SU  ");
        if (ToolUtil.isNotEmpty((Object)userId)) {
            sb.append(" WHERE SU.USER_ID = '" + userId + "'");
        }
        List<String> deptIds = this.queryForJdbcTemplate(sb, tenantId);
        String deptId = "";
        if (deptIds != null && deptIds.size() > 0) {
            deptId = deptIds.get(0);
        }
        return deptId;
    }

    public Integer getSecurityLevel(String userId, String url, String tenantId) {
        if (!this.lcdpBpmProperties.isStartAlone()) {
            return this.assigneeChooseMapper.getSecurityLevel(userId);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userId", userId);
        map.put("tenantId", HussarBpmSM4Util.encrypt((String)tenantId, (String)"admin#$%^kopoiuy"));
        String result = HttpRequestUtil.getRequestResult((String)(url + SECUTITY_LEVEL), map);
        return Integer.valueOf(result);
    }

    private List<String> queryForJdbcTemplate(StringBuilder sb, String tenantId) {
        if (!this.lcdpBpmProperties.isStartAlone()) {
            return this.assigneeChooseMapper.getCandidateUsers(sb.toString(), null);
        }
        TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTenantConfigNotExist(), Boolean.valueOf(false));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("condition", HussarBpmSM4Util.encrypt((String)sb.toString(), (String)"admin#$%^kopoiuy"));
        map.put("tenantId", HussarBpmSM4Util.encrypt((String)tenantId, (String)"admin#$%^kopoiuy"));
        map.put("isConditionFullSql", true);
        try {
            String result = HttpRequestUtil.getRequestResult((String)(tenantConfig.getProjectAddress() + CANDIDATE_USER_URL), map);
            return JSONArray.parseArray((String)result, String.class);
        }
        catch (GodAxeRequestException e) {
            if (1 == e.getRequestErrorType()) {
                throw new GodAxeRequestException(3);
            }
            throw e;
        }
    }

    public String getStarterDept(String userId, String tenantId) {
        if (ToolUtil.isEmpty((Object)userId)) {
            return null;
        }
        List<BpmTreeModel> list = this.userDeptDetail(userId, tenantId, true);
        StringBuilder stringBuilder = new StringBuilder();
        for (BpmTreeModel bpmTreeModel : list) {
            if (bpmTreeModel.getParentId() == null) continue;
            stringBuilder.append(",").append(bpmTreeModel.getParentId());
        }
        String result = stringBuilder.toString();
        if (result.length() > 0) {
            result = result.substring(1);
        }
        return result;
    }
}

