/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.activiti.engine.HistoryService;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiEntityEventImpl;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.IdentityLink;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class TaskCreateListener
implements ActivitiEventListener {
    @Resource
    private DataPushService dataPushService;
    @Lazy
    @Resource
    private HistoryService historyService;
    private static Logger logger = LogManager.getLogger(TaskCreateListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        TaskEntity taskEntity = (TaskEntity)((ActivitiEntityEventImpl)activitiEvent).getEntity();
        String userId = (String)taskEntity.getVariable("startUser");
        if (ToolUtil.isNotEmpty((Object)userId)) {
            taskEntity.removeVariable("startUser");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "taskCreateEnd");
        map.put("taskId", taskEntity.getId());
        map.put("taskName", taskEntity.getName());
        map.put("businessId", taskEntity.getProcessInstance().getBusinessKey());
        map.put("processInsId", taskEntity.getProcessInstanceId());
        map.put("processDefinitionId", taskEntity.getProcessDefinitionId());
        map.put("processKey", taskEntity.getProcessDefinitionId().split(":")[0]);
        map.put("taskDefinitionKey", taskEntity.getTaskDefinitionKey());
        map.put("tenantId", taskEntity.getTenantId());
        map.put("formKey", taskEntity.getFormKey());
        userId = ToolUtil.isEmpty((Object)this.getAssigneeByTaskId(taskEntity)) ? userId : this.getAssigneeByTaskId(taskEntity);
        map.put("userId", userId);
        map.put("sendUser", taskEntity.getVariable("sendUser"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("startDate", simpleDateFormat.format(taskEntity.getCreateTime()));
        map.put("endDate", null);
        map.put("url", taskEntity.getFormKey());
        map.put("description", taskEntity.getVariable("todoConfiguration"));
        map.put("comment", null);
        map.put("processName", taskEntity.getProcessInstance().getProcessDefinition().getName());
        List identityLinkEntityList = taskEntity.getProcessInstance().getIdentityLinks();
        for (IdentityLinkEntity identityLinkEntity : identityLinkEntityList) {
            if (!"starter".equals(identityLinkEntity.getType())) continue;
            map.put("starter", identityLinkEntity.getUserId());
            break;
        }
        CommonCodeUtil.triggerEventHandleClass(map);
        if (ToolUtil.isNotEmpty((Object)userId)) {
            taskEntity.removeVariable("startUser");
        }
        this.addDataPush(taskEntity, userId, ToolUtil.isEmpty((Object)this.getAssigneeByTaskId(taskEntity)) ? userId : this.getAssigneeByTaskId(taskEntity));
    }

    private String getAssigneeByTaskId(TaskEntity taskEntity) {
        StringBuilder users = new StringBuilder();
        Set identityLinks = taskEntity.getCandidates();
        if (identityLinks != null && identityLinks.size() > 0) {
            for (IdentityLink identityLink : identityLinks) {
                users.append(",").append(identityLink.getUserId());
            }
        }
        if (taskEntity.getAssignee() != null) {
            users.append(",").append(taskEntity.getAssignee());
        }
        if (ToolUtil.isNotEmpty((Object)users.toString())) {
            return users.substring(1);
        }
        return "";
    }

    public boolean isFailOnException() {
        logger.error("\u4efb\u52a1\u521b\u5efa\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }

    private void addDataPush(TaskEntity task, String startUser, String userId) {
        if (this.dataPushService.isDataPush()) {
            String processInstanceId = task.getProcessInstanceId();
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            if (historicProcessInstance != null) {
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            } else {
                dataPush.setBusinessKey(task.getProcessInstance().getBusinessKey());
                dataPush.setStartUserId((String)task.getVariable("sendUser"));
            }
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(userId);
            dataPush.setSendUser((String)task.getVariable("sendUser"));
            dataPush.setStartDate(task.getCreateTime());
            dataPush.setEndDate(null);
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)task.getVariable("todoConfiguration"));
            dataPush.setComment(null);
            dataPush.setProcessName(task.getProcessInstance().getProcessDefinition().getName());
            dataPush.setProcessInsId(processInstanceId);
            this.dataPushService.addDataPush(dataPush);
        }
    }
}

