/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.exception;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.support.log.trace.annotation.Trace;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.BpmTenantException;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import javax.el.PropertyNotFoundException;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiIllegalArgumentException;
import org.activiti.engine.ActivitiObjectNotFoundException;
import org.activiti.engine.ActivitiTaskAlreadyClaimedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@Order(value=4)
@Trace
public class WorkflowGlobalExceptionHander {
    private static Logger LOGGER = LoggerFactory.getLogger(WorkflowGlobalExceptionHander.class);
    private static BpmConstantProperties bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);

    @ExceptionHandler(value={BpmTenantException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(BpmTenantException e) {
        return ApiResponse.fail((String)BpmEnum.ERROR_TENANT_INFORMATION.getMessage());
    }

    @ExceptionHandler(value={PropertyNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(PropertyNotFoundException e) {
        LOGGER.error(e.getMessage());
        return ApiResponse.fail((String)bpmConstantProperties.getPropertyNotFound());
    }

    @ExceptionHandler(value={ActivitiIllegalArgumentException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(ActivitiIllegalArgumentException e) {
        LOGGER.error(e.getMessage());
        if (e.getMessage().contains(" null")) {
            return ApiResponse.fail((String)bpmConstantProperties.getNotNullParamIsNull());
        }
        return ApiResponse.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={ActivitiTaskAlreadyClaimedException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(ActivitiTaskAlreadyClaimedException e) {
        LOGGER.error(e.getMessage());
        return ApiResponse.fail((String)bpmConstantProperties.getTaskAlreadyClaimed());
    }

    @ExceptionHandler(value={ActivitiException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(ActivitiException e) {
        LOGGER.error(e.getMessage());
        if (e.getMessage().startsWith("Cannot set suspensionState state 'suspended' for ProcessDefinitionEntity")) {
            return ApiResponse.fail((String)bpmConstantProperties.getSuspendedProcessDefinitionEntityError());
        }
        if (e.getMessage().startsWith("Cannot set suspensionState state 'active' for ProcessDefinitionEntity")) {
            return ApiResponse.fail((String)bpmConstantProperties.getActiveProcessDefinitionEntityError());
        }
        if (e.getMessage().startsWith("Cannot set suspensionState state 'suspended' for ProcessInstance")) {
            return ApiResponse.fail((String)bpmConstantProperties.getSuspendedProcessProcessInstanceError());
        }
        if (e.getMessage().startsWith("Cannot set suspensionState state 'active' for ProcessInstance")) {
            return ApiResponse.fail((String)bpmConstantProperties.getActiveProcessProcessInstanceError());
        }
        if (e.getMessage().startsWith("Process instance is still running, cannot delete historic process instance")) {
            return ApiResponse.fail((String)bpmConstantProperties.getProcessInstanceIsNotEnd());
        }
        if ("Cannot claim a suspended task".equals(e.getMessage())) {
            return ApiResponse.fail((String)bpmConstantProperties.getTaskIsSuspended());
        }
        if (e.getMessage().startsWith("No outgoing sequence flow of")) {
            return ApiResponse.fail((String)bpmConstantProperties.getNoOutgoingSequence());
        }
        return ApiResponse.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={ActivitiObjectNotFoundException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(ActivitiObjectNotFoundException e) {
        LOGGER.error(e.getMessage());
        if (e.getMessage().startsWith("Cannot find task with id ")) {
            return ApiResponse.fail((String)bpmConstantProperties.getTaskNotFound());
        }
        if (e.getMessage().startsWith("Cannot find process definition for id ") || e.getMessage().startsWith("no deployed process definition found with id")) {
            return ApiResponse.fail((String)bpmConstantProperties.getModelNotFound());
        }
        if (e.getMessage().startsWith("Cannot find processInstance for id") || e.getMessage().startsWith("No process instance found for id") || e.getMessage().startsWith("No historic process instance found with id")) {
            return ApiResponse.fail((String)bpmConstantProperties.getProcessNotFound());
        }
        return ApiResponse.fail((String)e.getMessage());
    }

    @ExceptionHandler(value={GodAxeRequestException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    public ApiResponse<?> credentials(GodAxeRequestException e) {
        LOGGER.error(bpmConstantProperties.getHttpRequestError());
        switch (e.getRequestErrorType()) {
            case 0: {
                return ApiResponse.fail((String)bpmConstantProperties.getErrorProjectAddress());
            }
            case 1: {
                return ApiResponse.fail((String)bpmConstantProperties.getErrorGodaxeVisitor());
            }
            case 2: {
                return ApiResponse.fail((String)bpmConstantProperties.getErrorViewRequest());
            }
        }
        return ApiResponse.fail((String)bpmConstantProperties.getErrorRequest());
    }

    @ExceptionHandler(value={PublicClientException.class})
    @ResponseStatus(value=HttpStatus.OK)
    public ApiResponse<?> credentials(PublicClientException e) {
        return ApiResponse.fail((String)e.getReason());
    }
}

