/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.model.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.model.dao.SysActAssigneeMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.model.model.SysActAssignee;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.SysActAssigneeService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sysActAssigneeService")
public class SysActAssigneeServiceImpl
extends HussarServiceImpl<SysActAssigneeMapper, SysActAssignee>
implements SysActAssigneeService {
    @Resource
    SysActAssigneeMapper sysActAssigneeMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    public Map<String, String> getAssignee(String procDefKey, String taskDefKey, boolean isCcUser) {
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        List result = new ArrayList();
        if (isCcUser) {
            list.add(procDefKey + ":" + "defaultCcAssign" + ":" + taskDefKey);
            list.add(procDefKey + ":" + "conditionCcAssign" + ":" + taskDefKey);
            result = this.sysActAssigneeMapper.selectBatchIds(list);
        } else {
            list.add(procDefKey + ":" + "defaultAssign" + ":" + taskDefKey);
            list.add(procDefKey + ":" + "conditionAssign" + ":" + taskDefKey);
            result = this.sysActAssigneeMapper.selectBatchIds(list);
        }
        for (SysActAssignee modelAssignee : result) {
            map.put(modelAssignee.getContentType(), modelAssignee.getContent() == null ? "" : new String(modelAssignee.getContent(), StandardCharsets.UTF_8));
        }
        return map;
    }

    public void delAssignee(String modelId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.inSql(SysActAssignee::getProcDefKey, "SELECT PROCESS_KEY FROM BPM_ACT_PROCESS_FILE WHERE MODEL_ID ='" + modelId + "'");
        this.sysActAssigneeMapper.delete((Wrapper)queryWrapper);
    }

    public BpmResponseResult getAssigneeModel(String procDefKey, String taskDefKey) {
        JSONArray json = new JSONArray();
        if (!this.lcdpBpmProperties.isModifyConfigurationOnline()) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysActAssignee::getProcDefKey, (Object)procDefKey);
        ArrayList<String> list = new ArrayList<String>();
        list.add("assign_model");
        list.add("cc_assign_model");
        queryWrapper.in(SysActAssignee::getContentType, list);
        if (taskDefKey != null) {
            queryWrapper.eq(SysActAssignee::getTaskDefKey, (Object)taskDefKey);
        }
        List results = this.sysActAssigneeMapper.selectList((Wrapper)queryWrapper);
        for (SysActAssignee modelAssignee : results) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("type", (Object)modelAssignee.getContentType());
            jsonObject.put("taskDefKey", (Object)modelAssignee.getTaskDefKey());
            jsonObject.put("model", JSONObject.toJSON((Object)new String(modelAssignee.getContent(), StandardCharsets.UTF_8)));
            json.add((Object)jsonObject);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }
}

