/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.listener;

import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.service.ITenantConfigService;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.delegate.event.ActivitiEvent;
import org.activiti.engine.delegate.event.ActivitiEventListener;
import org.activiti.engine.delegate.event.impl.ActivitiProcessStartedEventImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class ProcessCreateListener
implements ActivitiEventListener {
    @Resource
    private ITenantConfigService iTenantConfigService;
    private static Logger logger = LogManager.getLogger(ProcessCreateListener.class);

    public void onEvent(ActivitiEvent activitiEvent) {
        ExecutionEntity entity = (ExecutionEntity)((ActivitiProcessStartedEventImpl)activitiEvent).getEntity();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("type", "processCreateEnd");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("createTime", simpleDateFormat.format(new Date()));
        map.put("tenantId", entity.getTenantId());
        map.put("businessId", entity.getBusinessKey());
        map.put("processInsId", entity.getProcessInstanceId());
        map.put("processDefinitionId", entity.getProcessDefinitionId());
        map.put("processDefinitionName", entity.getProcessDefinition().getName());
        List linkEntityList = entity.getIdentityLinks();
        if (linkEntityList.size() > 0) {
            map.put("starter", ((IdentityLinkEntity)linkEntityList.get(0)).getUserId());
        }
        CommonCodeUtil.triggerEventHandleClass(map);
    }

    public boolean isFailOnException() {
        logger.error("\u6d41\u7a0b\u542f\u52a8\u540e\u89e6\u53d1\u4e8b\u4ef6\u6267\u884c\u5931\u8d25");
        return false;
    }
}

