/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.definition.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.dao.ProcessDefinitionsMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.ProcessDefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.processfile.service.SysActProcessFileService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.repository.ProcessDefinition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessDefinitionsServiceImpl
implements ProcessDefinitionsService {
    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    ProcessEngine processEngine;
    @Resource
    ProcessDefinitionsMapper processDefinitionsMapper;
    @Autowired
    private SysActProcessFileService sysActProcessFileService;
    @Autowired
    RepositoryService repositoryService;

    public IPage<DefinitionModel> queryProcessDefinitionsList(String definitionName, Page<DefinitionModel> page) {
        List<DefinitionModel> instList = this.processDefinitionsMapper.getList(page, definitionName);
        page.setRecords(instList);
        return page;
    }

    public DefinitionModel getMainOrNew(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        throw new PublicClientException(this.bpmConstantProperties.getProcessKeyError(), Boolean.valueOf(false));
    }

    public ApiResponse<String> setMain(String processKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null) + this.processDefinitionsMapper.setMain(id);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        String deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        if ((num += this.processDefinitionsMapper.setModelMain(id)) != 0) {
            if (this.sysActProcessFileService.copyFiles(processKey, id, BaseSecurityUtil.getUser().getStringTenantId())) {
                return ApiResponse.success((String)BpmEnum.SET_SUCCESS.getMessage());
            }
            throw new PublicClientException(BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        throw new PublicClientException(BpmEnum.SET_FAIL.getMessage());
    }

    public void canModelDeleteWithVersion(String processKey) {
        List<DefinitionModel> list = this.processDefinitionsMapper.getMainOrNew(processKey);
        if (list.size() == 1) {
            throw new PublicClientException(this.bpmConstantProperties.getNotDeleteTheOnlyProcessDefinition(), Boolean.valueOf(false));
        }
    }

    public int setNotMain(String processKey) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, null);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        String deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        return num;
    }

    public ApiResponse<String> cancelMain(String processKey, String id) {
        int num = this.processDefinitionsMapper.setNotMain(processKey, id);
        DefinitionModel definitionModel = this.getMainOrNew(processKey);
        String name = definitionModel.getName();
        String deploymentId = definitionModel.getDeploymentId();
        this.processDefinitionsMapper.setNameAndDeploymentId(name, deploymentId, processKey);
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKey).latestVersion().singleResult();
        if (num != 0) {
            if (this.sysActProcessFileService.copyFiles(processKey, processDefinition.getId(), BaseSecurityUtil.getUser().getStringTenantId())) {
                return ApiResponse.success((String)BpmEnum.SUCCESS_UPDATE.getMessage());
            }
            throw new PublicClientException(BpmEnum.FILES_NOT_FOUND.getMessage());
        }
        throw new PublicClientException(BpmEnum.ERROR_UPDATE.getMessage());
    }

    public int updateProcessName(String id, String processName) {
        return this.processDefinitionsMapper.updateProcessName(id, processName);
    }

    public List<ProcessDefinitionModel> queryProcessDefListOfMainVersion(String processName) {
        List<ProcessDefinitionModel> list = this.processDefinitionsMapper.queryProcessDefListOfMainVersion(processName);
        ArrayList<ProcessDefinitionModel> newList = new ArrayList<ProcessDefinitionModel>();
        Boolean flag = false;
        for (ProcessDefinitionModel oldPro : list) {
            flag = false;
            for (ProcessDefinitionModel newPro : newList) {
                if (!ToolUtil.equals((Object)oldPro.getKey(), (Object)newPro.getKey())) continue;
                flag = true;
                break;
            }
            if (flag.booleanValue()) continue;
            newList.add(oldPro);
        }
        return newList;
    }

    public int setVersionTemporary(String id) {
        return this.processDefinitionsMapper.setVersionTemporary(id);
    }

    public void editTemporaryDefId(String defId, String processInsId, String version) {
        this.processDefinitionsMapper.updateActInst(defId, processInsId, version);
        this.processDefinitionsMapper.updateExecution(defId, processInsId, version);
        this.processDefinitionsMapper.updateProcDef(defId, processInsId, version);
        this.processDefinitionsMapper.updateTask(defId, processInsId, version);
        this.processDefinitionsMapper.updateTaskInst(defId, processInsId, version);
        this.processDefinitionsMapper.updateProcInst(defId, processInsId, version);
    }
}

