/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowevents.service.FlowEventsService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowEventsServiceImpl
implements FlowEventsService {
    private final TaskService taskService;
    private final ITaskEngineService taskEngineService;
    private final RuntimeService runtimeService;
    private final RepositoryService repositoryService;
    private final ISysActUrgeTaskService iSysActUrgeTaskService;
    private final IFlowTaskService flowTaskService;
    private final BpmConstantProperties bpmConstantProperties;
    @Autowired
    private DataPushService dataPushService;
    @Autowired
    private HistoryService historyService;

    public FlowEventsServiceImpl(TaskService taskService, ITaskEngineService ITaskEngineService2, RuntimeService runtimeService, RepositoryService repositoryService, ISysActUrgeTaskService iSysActUrgeTaskService, IFlowTaskService flowTaskService, BpmConstantProperties bpmConstantProperties) {
        this.taskService = taskService;
        this.taskEngineService = ITaskEngineService2;
        this.runtimeService = runtimeService;
        this.repositoryService = repositoryService;
        this.iSysActUrgeTaskService = iSysActUrgeTaskService;
        this.flowTaskService = flowTaskService;
        this.bpmConstantProperties = bpmConstantProperties;
    }

    public ApiResponse<IPage<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime, String tenantId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = ToolUtil.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = ToolUtil.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.todoList(pages, flowTaskQueryModel, tenantId);
    }

    public ApiResponse<IPage<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, String userId, String processKey, String definitionKey, List<String> processKeys, String message, String sendUserId, String startTime, String endTime, String tenantId) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        Date end = null;
        try {
            start = ToolUtil.isNotEmpty((Object)startTime) ? formatter.parse(startTime) : null;
            end = ToolUtil.isNotEmpty((Object)endTime) ? formatter.parse(endTime) : null;
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        flowTaskQueryModel.setProcessKeys(processKeys);
        flowTaskQueryModel.setTodoConfiguration(message);
        flowTaskQueryModel.setSendUserId(sendUserId);
        flowTaskQueryModel.setStartTime(start);
        flowTaskQueryModel.setEndTime(end);
        return this.flowTaskService.doneList(pages, flowTaskQueryModel, tenantId);
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    public JSONArray flowType() {
        List definitions = this.repositoryService.createProcessDefinitionQuery().latestVersion().active().list();
        JSONArray jsonArray = new JSONArray();
        if (definitions != null) {
            for (ProcessDefinition tmp : definitions) {
                HashMap<String, String> tmpMap = new HashMap<String, String>();
                tmpMap.put("id", tmp.getKey());
                tmpMap.put("name", tmp.getName());
                jsonArray.add(tmpMap);
            }
        }
        return jsonArray;
    }

    public ApiResponse<String> revokeTask(String historicTaskId, String userId) {
        BpmResponseResult check = this.taskEngineService.withdrawState(historicTaskId);
        if (check.getCode().equals("0")) {
            throw new PublicClientException(check.getMsg());
        }
        if (!((Boolean)check.getResult().get(0)).booleanValue()) {
            throw new PublicClientException("\u5f53\u524d\u8282\u70b9\u4e0d\u80fd\u64a4\u56de");
        }
        BpmResponseResult bpmResponseResult = this.taskEngineService.revokeTask(historicTaskId, userId, "", true, null);
        if (bpmResponseResult.getCode().equals("0")) {
            throw new PublicClientException(bpmResponseResult.getMsg());
        }
        return ApiResponse.success((String)bpmResponseResult.getMsg());
    }

    public ApiResponse<String> urgeTask(String processInsId, String userId) {
        Set<String> users;
        if (ToolUtil.isEmpty((Object)processInsId)) {
            throw new PublicClientException("\u6d41\u7a0b\u5b9e\u4f8bid\u4e3a\u7a7a");
        }
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (processInstance == null) {
            throw new PublicClientException("\u6d41\u7a0b\u5df2\u7ecf\u7ed3\u675f\uff0c\u65e0\u6cd5\u50ac\u529e");
        }
        if (processInstance.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended());
        }
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).includeProcessVariables()).processInstanceId(processInsId)).list();
        ArrayList<SysActUrgeTask> list = new ArrayList<SysActUrgeTask>();
        Date date = new Date();
        Timestamp ts = new Timestamp(date.getTime());
        for (Task task : tasks) {
            users = this.getAssigneeByTaskId(task.getId());
            if (users.size() <= 0) continue;
            for (String user : users) {
                SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
                sysActUrgeTask.setTaskId(task.getId());
                sysActUrgeTask.setProcessInsId(task.getProcessInstanceId());
                sysActUrgeTask.setProcName(processInstance.getProcessDefinitionName());
                sysActUrgeTask.setTaskName(task.getName());
                sysActUrgeTask.setSendUser(userId);
                sysActUrgeTask.setReceiveUser(user);
                sysActUrgeTask.setSendTime(ts);
                sysActUrgeTask.setFormKey(task.getFormKey());
                sysActUrgeTask.setTaskDefKey(task.getTaskDefinitionKey());
                sysActUrgeTask.setProcDefKey(processInstance.getProcessDefinitionKey());
                sysActUrgeTask.setBusinessId(processInstance.getBusinessKey());
                Map map = task.getTaskLocalVariables();
                if (ToolUtil.isNotEmpty((Object)map)) {
                    sysActUrgeTask.setToDoConfig((String)map.get("todoConfiguration"));
                }
                list.add(sysActUrgeTask);
            }
        }
        if (list.size() > 0) {
            this.iSysActUrgeTaskService.saveBatch(list);
            for (Task task : tasks) {
                users = this.getAssigneeByTaskId(task.getId());
                if (users.size() <= 0 || !this.dataPushService.isDataPush()) continue;
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
                DataPush dataPush = new DataPush();
                dataPush.setTaskId(task.getId());
                dataPush.setTaskDefinitionName(task.getName());
                dataPush.setUserId(String.join((CharSequence)",", users));
                dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
                dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
                dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
                dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
                HashMap map = new HashMap();
                map.putAll(task.getProcessVariables());
                map.putAll(task.getTaskLocalVariables());
                dataPush.setSendUser(userId);
                dataPush.setStartDate(task.getCreateTime());
                dataPush.setEndDate(new Date());
                dataPush.setUrl(task.getFormKey());
                dataPush.setDescription((String)map.get("todoConfiguration"));
                dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
                dataPush.setProcessInsId(task.getProcessInstanceId());
                dataPush.setTenantId(task.getTenantId());
                this.dataPushService.addUrgeTask(dataPush);
            }
        }
        return ApiResponse.success((String)"success");
    }
}

