/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6d41\u7a0b\u4efb\u52a1\u7ba1\u7406"})
@RequestMapping(value={"/task"})
public class TaskEngineController {
    private final ITaskEngineService taskEngineService;

    @Autowired
    public TaskEngineController(ITaskEngineService ITaskEngineService2) {
        this.taskEngineService = ITaskEngineService2;
    }

    @GetMapping(value={"/queryTask"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", notes="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query")})
    public ApiResponse<?> queryTask(String taskId, String tenantId) {
        return this.taskEngineService.queryTask(taskId, tenantId);
    }

    @GetMapping(value={"/queryAllToDoTaskList"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", notes="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processName", value="\u6d41\u7a0b\u540d", required=false, paramType="query"), @ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="startTime", value="\u6700\u65e9\u5f00\u59cb\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="endTime", value="\u6700\u665a\u7ed3\u675f\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="timeoutState", value="\u662f\u5426\u8d85\u65f6", required=false, paramType="query"), @ApiImplicitParam(name="suspensionState", value="\u662f\u5426\u6302\u8d77", required=false, paramType="query"), @ApiImplicitParam(name="todoConfiguration", value="\u5f85\u529e\u914d\u7f6e", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query")})
    public ApiResponse<?> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, String tenantId, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer size) {
        return this.taskEngineService.queryAllToDoTaskList(processName, processKey, startTime, endTime, timeoutState, suspensionState, todoConfiguration, tenantId, page, size);
    }

    @GetMapping(value={"/queryAllToDoTaskListByBusiness"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1", notes="\u67e5\u8be2\u6d41\u7a0b\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processName", value="\u6d41\u7a0b\u540d", required=false, paramType="query"), @ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="startTime", value="\u6700\u65e9\u5f00\u59cb\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="endTime", value="\u6700\u665a\u7ed3\u675f\u65f6\u95f4", required=false, paramType="query"), @ApiImplicitParam(name="timeoutState", value="\u662f\u5426\u8d85\u65f6", required=false, paramType="query"), @ApiImplicitParam(name="suspensionState", value="\u662f\u5426\u6302\u8d77", required=false, paramType="query"), @ApiImplicitParam(name="todoConfiguration", value="\u5f85\u529e\u914d\u7f6e", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="business", value="\u4e1a\u52a1\u4e3b\u952e\u5e8f\u5217", required=true, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="size", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query")})
    public ApiResponse<?> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, String tenantId, String business, Integer page, Integer size) {
        List businessList = (List)JSON.parseObject((String)business, List.class);
        return this.taskEngineService.queryAllToDoTaskListByBusiness(processName, processKey, startTime, endTime, timeoutState, suspensionState, todoConfiguration, businessList, tenantId, page, size);
    }

    @GetMapping(value={"/queryToDoTaskList"})
    @ApiOperation(value="\u67e5\u8be2\u5f85\u529e\u5217\u8868", notes="\u67e5\u8be2\u5f85\u529e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query"), @ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="definitionKey", value="\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query")})
    public ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        return this.taskEngineService.queryToDoTaskList(userId, processKey, definitionKey, tenantId);
    }

    @GetMapping(value={"/queryToDoTaskListByPage"})
    @ApiOperation(value="\u67e5\u8be2\u5f85\u529e\u5217\u8868", notes="\u67e5\u8be2\u5f85\u529e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query"), @ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="definitionKey", value="\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query")})
    public ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer rows, String tenantId) {
        return this.taskEngineService.queryToDoTaskList(userId, processKey, definitionKey, tenantId, page, rows);
    }

    @GetMapping(value={"/queryToDoTaskListByBusinessIds"})
    @ApiOperation(value="\u67e5\u8be2\u5f85\u529e\u5217\u8868", notes="\u67e5\u8be2\u5f85\u529e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query"), @ApiImplicitParam(name="businessIds", value="\u4e1a\u52a1\u4e3b\u952e\u5e8f\u5217", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query")})
    public ApiResponse<?> queryToDoTaskList(String userId, String businessIds, String tenantId) {
        List<Object> list = new ArrayList();
        if (ToolUtil.isNotEmpty((Object)businessIds)) {
            list = Arrays.asList(businessIds.split(","));
        }
        return this.taskEngineService.queryToDoTaskList(userId, list, tenantId);
    }

    @GetMapping(value={"/queryFinishedTaskList"})
    @ApiOperation(value="\u67e5\u8be2\u5df2\u529e\u5217\u8868", notes="\u67e5\u8be2\u5df2\u529e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query"), @ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="definitionKey", value="\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query")})
    public ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        return this.taskEngineService.queryFinishedTaskList(userId, processKey, definitionKey, tenantId);
    }

    @GetMapping(value={"/queryFinishedTaskListByPage"})
    @ApiOperation(value="\u67e5\u8be2\u5df2\u529e\u5217\u8868", notes="\u67e5\u8be2\u5df2\u529e\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query"), @ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="definitionKey", value="\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="page", value="\u5f53\u524d\u9875\u6570", required=false, paramType="query"), @ApiImplicitParam(name="rows", value="\u6bcf\u9875\u6761\u6570", required=false, paramType="query")})
    public ApiResponse<?> queryFinishedTaskListByDefinitionKey(String userId, String processKey, String definitionKey, String tenantId, @RequestParam(defaultValue="1") Integer page, @RequestParam(defaultValue="10") Integer rows) {
        return this.taskEngineService.queryFinishedTaskList(userId, processKey, definitionKey, tenantId, page, rows);
    }

    @GetMapping(value={"/queryUserTaskCount"})
    @ApiOperation(value="\u67e5\u8be2\u5404\u4e2a\u6d41\u7a0b\u5f85\u529e\u6570\u91cf", notes="\u67e5\u8be2\u5404\u4e2a\u6d41\u7a0b\u5f85\u529e\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query")})
    public ApiResponse<?> queryUserTaskCount(String userId) {
        return this.taskEngineService.queryUserTaskCount(userId);
    }

    @GetMapping(value={"/queryUserTaskCountByNode"})
    @ApiOperation(value="\u67e5\u8be2\u5404\u4e2a\u8282\u70b9\u5f85\u529e\u6570\u91cf", notes="\u67e5\u8be2\u5404\u4e2a\u8282\u70b9\u5f85\u529e\u6570\u91cf")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=false, paramType="query")})
    public ApiResponse<?> queryUserTaskCountByNode(String userId) {
        return this.taskEngineService.queryUserTaskCountByNode(userId);
    }

    @GetMapping(value={"/claimTask"})
    @ApiOperation(value="\u7b7e\u6536\u4efb\u52a1", notes="\u7b7e\u6536\u4efb\u52a1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query")})
    public ApiResponse<?> claimTask(String taskId, String userId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.claimTask(taskId, userId));
    }

    @GetMapping(value={"/unClaimTask"})
    @ApiOperation(value="\u53d6\u6d88\u7b7e\u6536", notes="\u53d6\u6d88\u7b7e\u6536")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    public ApiResponse<?> unClaimTask(String taskId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.unClaimTask(taskId));
    }

    @GetMapping(value={"/completeTask1"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u53c2\u4e0e\u8005id", required=true, paramType="query"), @ApiImplicitParam(name="map", value="\u76f8\u5173\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeTask(String taskId, String userId, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeTask(taskId, userId, variable));
    }

    @GetMapping(value={"/completeTask2"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u6d41\u7a0b\u540d", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u6d41\u7a0b\u6807\u8bc6", required=true, paramType="query"), @ApiImplicitParam(name="assigneeMap", value="\u6307\u5b9a\u53c2\u4e0e\u8005", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeTask(String taskId, String userId, String assigneeMap, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeTask(taskId, userId, assigneeVariable, variable));
    }

    @GetMapping(value={"/completeTask3"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, paramType="query"), @ApiImplicitParam(name="assigneeMap", value="\u6307\u5b9a\u53c2\u4e0e\u8005", required=false, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeTask(String taskId, String userId, String assigneeMap, String comment, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeTask(taskId, userId, assigneeVariable, comment, variable));
    }

    @GetMapping(value={"/completeTask4"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeTask4(String taskId, String userId, String comment, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeTask(taskId, userId, comment, variable));
    }

    @GetMapping(value={"/completeTask5"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="subProcesses", value="\u542f\u52a8\u7684\u5b50\u6d41\u7a0b", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeTask5(String taskId, String userId, String comment, String subProcesses, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeTask(taskId, userId, comment, subProcesses, variable));
    }

    @GetMapping(value={"/completeTask6"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, paramType="query"), @ApiImplicitParam(name="assigneeMap", value="\u6307\u5b9a\u53c2\u4e0e\u8005", required=false, paramType="query"), @ApiImplicitParam(name="users", value="\u6284\u9001\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeTask(String taskId, String userId, String assigneeMap, String users, String comment, String map) {
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        Set users1 = (Set)JSON.parseObject((String)users, Set.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeTask(taskId, userId, assigneeVariable, users1, comment, variable));
    }

    @GetMapping(value={"/completeTask7"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, paramType="query"), @ApiImplicitParam(name="assigneeMap", value="\u6307\u5b9a\u53c2\u4e0e\u8005", required=false, paramType="query"), @ApiImplicitParam(name="users", value="\u6284\u9001\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeTaskNoAuditAuthority(String taskId, String userId, String assigneeMap, String users, String comment, String map) {
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        Set users1 = (Set)JSON.parseObject((String)users, Set.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeTask(taskId, userId, assigneeVariable, users1, comment, variable, false));
    }

    @GetMapping(value={"/completeLeapTask"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="assigneeMap", value="\u6307\u5b9a\u4eba\u5458", required=false, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeLeapTask(String taskId, String userId, String assigneeMap, String comment, String map) {
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeLeapTask(taskId, userId, assigneeVariable, comment, variable));
    }

    @GetMapping(value={"/completeLeapTask1"})
    @ApiOperation(value="\u4efb\u52a1\u529e\u7406", notes="\u4efb\u52a1\u529e\u7406")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="assigneeMap", value="\u6307\u5b9a\u4eba\u5458", required=false, paramType="query"), @ApiImplicitParam(name="users", value="\u6284\u9001\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> completeLeapTask(String taskId, String userId, String assigneeMap, String users, String comment, String map) {
        Set user = (Set)JSON.parseObject((String)users, Set.class);
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        Map assigneeVariable = (Map)JSON.parseObject((String)assigneeMap, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.completeLeapTask(taskId, userId, assigneeVariable, user, comment, variable));
    }

    @GetMapping(value={"/rejectToLastTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de\u81f3\u4e0a\u4e00\u4e2a\u8282\u70b9", notes="\u4efb\u52a1\u9a73\u56de\u81f3\u4e0a\u4e00\u4e2a\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="assignees", value="\u53c2\u4e0e\u8005", required=false, paramType="query"), @ApiImplicitParam(name="isSubmit", value="\u662f\u5426\u9a73\u56de\u5230\u529e\u7406\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.rejectToLastTask(taskId, userId, comment, assignees, isSubmit, variable, null));
    }

    @GetMapping(value={"/rejectToFirstTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de\u81f3\u7b2c\u4e00\u4e2a\u8282\u70b9", notes="\u4efb\u52a1\u9a73\u56de\u81f3\u7b2c\u4e00\u4e2a\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=false, paramType="query"), @ApiImplicitParam(name="userId", value="\u5904\u7406\u4ebaid", required=false, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="assignees", value="\u9a73\u56de\u65f6\u6307\u5b9a\u7684\u4eba\u5458", required=false, paramType="query"), @ApiImplicitParam(name="isSubmit", value="\u662f\u5426\u9a73\u56de\u5230\u63d0\u4ea4\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.rejectToFirstTask(taskId, userId, comment, assignees, isSubmit, variable));
    }

    @GetMapping(value={"/rejectToAnyTask"})
    @ApiOperation(value="\u4efb\u52a1\u9a73\u56de\u81f3\u4efb\u610f\u8282\u70b9", notes="\u4efb\u52a1\u9a73\u56de\u81f3\u4efb\u610f\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u5904\u7406\u4ebaid", required=true, paramType="query"), @ApiImplicitParam(name="backActivityId", value="\u9a73\u56de\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="assignees", value="\u53c2\u4e0e\u8005", required=false, paramType="query"), @ApiImplicitParam(name="isSubmit", value="\u662f\u4e0d\u662f\u9a73\u56de\u5230\u63d0\u4ea4\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.rejectToAnyTask(taskId, userId, backActivityId, comment, assignees, isSubmit, variable));
    }

    @GetMapping(value={"/queryRejectNode"})
    @ApiOperation(value="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9", notes="\u67e5\u8be2\u53ef\u4ee5\u9a73\u56de\u7684\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public ApiResponse<?> queryRejectNode(String taskId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryRejectNode(taskId));
    }

    @GetMapping(value={"/delegateTask"})
    @ApiOperation(value="\u4efb\u52a1\u59d4\u6258", notes="\u4efb\u52a1\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true, paramType="query")})
    public ApiResponse<?> delegateTask(String taskId, String userId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.delegateTask(taskId, userId));
    }

    @GetMapping(value={"/entrustTask"})
    @ApiOperation(value="\u4efb\u52a1\u59d4\u6258", notes="\u4efb\u52a1\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u59d4\u6258\u4eba\u7528\u6237ID", required=true, paramType="query"), @ApiImplicitParam(name="mandatary", value="\u88ab\u59d4\u6258\u4eba\u7528\u6237ID", required=true, paramType="query")})
    public ApiResponse<?> entrustTask(String taskId, String userId, String mandatary) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.entrustTask(taskId, userId, mandatary));
    }

    @GetMapping(value={"/entrustTaskByTaskId"})
    @ApiOperation(value="\u4efb\u52a1\u59d4\u6258", notes="\u4efb\u52a1\u59d4\u6258")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="taskId", required=true, paramType="query"), @ApiImplicitParam(name="mandatary", value="mandatary", required=true, paramType="query")})
    public ApiResponse<?> entrustTask(String taskId, String mandatary) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.entrustTask(taskId, mandatary, 1));
    }

    @GetMapping(value={"/freeJump"})
    @ApiOperation(value="\u81ea\u7531\u8df3\u8f6c", notes="\u81ea\u7531\u8df3\u8f6c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="activitiId", value="\u6d3b\u52a8\u8282\u70b9id", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u529e\u7406\u4ebaid", required=true, paramType="query"), @ApiImplicitParam(name="assignees", value="\u6307\u5b9a\u4eba\u5458", required=false, paramType="query"), @ApiImplicitParam(name="isSubmit", value="\u662f\u4e0d\u662f\u8df3\u8f6c\u5230\u63d0\u4ea4\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.freeJump(taskId, activitiId, userId, assignees, isSubmit, comment, variable));
    }

    @GetMapping(value={"/multiInstanceAddAssignee"})
    @ApiOperation(value="\u4f1a\u7b7e\u8282\u70b9\u589e\u52a0\u529e\u7406\u4eba", notes="\u4f1a\u7b7e\u8282\u70b9\u589e\u52a0\u529e\u7406\u4eba")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=false, paramType="query"), @ApiImplicitParam(name="assigneeList", value="\u6dfb\u52a0\u4eba\u5458\u5e8f\u5217", required=false, paramType="query")})
    public ApiResponse<?> multiInstanceAddAssignee(String taskId, String assigneeList) {
        List list = (List)JSON.parseObject((String)assigneeList, List.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.multiInstanceAddAssignee(taskId, list));
    }

    @GetMapping(value={"/queryAssigneeByTaskId"})
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u67e5\u8be2\u5f53\u524d\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public ApiResponse<?> queryAssigneeByTaskId(String taskId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryAssigneeByTaskId(taskId));
    }

    @GetMapping(value={"/addAssignees"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u6216\u8005\u662f\u4efb\u52a1id\u7ed9\u4efb\u52a1\u6dfb\u52a0\u53c2\u4e0e\u8005", notes="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u6216\u8005\u662f\u4efb\u52a1id\u7ed9\u4efb\u52a1\u6dfb\u52a0\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false, paramType="query"), @ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=false, paramType="query"), @ApiImplicitParam(name="users", value="\u4eba\u5458 \u591a\u4e2a\u9017\u53f7\u9694\u5f00", required=true, paramType="query")})
    public ApiResponse<?> addAssignees(String taskId, String businessId, String users) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.addAssignees(taskId, businessId, users));
    }

    @GetMapping(value={"/queryProcessNodeByTaskId"})
    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u8282\u70b9", notes="\u67e5\u8be2\u6d41\u7a0b\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public ApiResponse<?> queryProcessNodeByTaskId(String taskId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryProcessNodeByTaskId(taskId));
    }

    @GetMapping(value={"/queryNextAssigneeByTaskIdAndNodeId"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1", required=true, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query"), @ApiImplicitParam(name="map", value="\u53d8\u91cf", required=false, paramType="query")})
    public ApiResponse<?> queryNextAssigneeByTaskIdAndNodeId(String taskId, String tenantId, String nodeId, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, variable));
    }

    @GetMapping(value={"/queryNextAssignee"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005", notes="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=false, paramType="query"), @ApiImplicitParam(name="tenantId", value="\u79df\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="nodeId", value="\u8282\u70b9id", required=true, paramType="query"), @ApiImplicitParam(name="map", value="\u53d8\u91cf", required=false, paramType="query")})
    public ApiResponse<?> queryNextAssigneeByTaskIdAndNodeId(String processKey, String taskId, String tenantId, String nodeId, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryNextAssigneeByTaskIdAndNodeId(processKey, taskId, nodeId, tenantId, variable));
    }

    @GetMapping(value={"/queryHistoryActByTaskId"})
    @ApiOperation(value="\u67e5\u8be2\u5386\u53f2\u8282\u70b9\u4fe1\u606f", notes="\u67e5\u8be2\u5386\u53f2\u8282\u70b9\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=true, paramType="query")})
    public ApiResponse<?> queryHistoryActByTaskId(String taskId) {
        return this.taskEngineService.queryHistoryActByTaskId(taskId, null);
    }

    @GetMapping(value={"/getProcessDefinitionIdAndNodeId"})
    @ApiOperation(value="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u6216\u8005taskId\u83b7\u53d6\u6d41\u7a0b\u7248\u672cID\u548c\u8282\u70b9id", notes="\u6839\u636e\u6d41\u7a0b\u6807\u8bc6\u6216\u8005taskId\u83b7\u53d6\u6d41\u7a0b\u7248\u672cID\u548c\u8282\u70b9id")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false, paramType="query")})
    public ApiResponse<?> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        return this.taskEngineService.getProcessDefinitionIdAndNodeId(processKey, taskId);
    }

    @GetMapping(value={"/queryTaskIdByBusinessId"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u67e5\u8be2\u4efb\u52a1ID", notes="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u67e5\u8be2\u4efb\u52a1ID")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query")})
    public ApiResponse<?> queryTaskIdByBusinessId(String businessId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryTaskIdByBusinessId(businessId));
    }

    @GetMapping(value={"/queryNextNodeByTaskId"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9", notes="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false, paramType="query"), @ApiImplicitParam(name="isGetRevokeNode", value="\u662f\u5426\u83b7\u53d6\u9a73\u56de\u8282\u70b9", required=false, paramType="query")})
    public ApiResponse<?> queryNextNode(String taskId, boolean isGetRevokeNode) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryNextNode(taskId, isGetRevokeNode));
    }

    @GetMapping(value={"/queryNextNode"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9", notes="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false, paramType="query"), @ApiImplicitParam(name="isGetRevokeNode", value="\u662f\u5426\u83b7\u53d6\u9a73\u56de\u8282\u70b9", required=false, paramType="query")})
    public ApiResponse<?> queryNextNode(String processKey, String taskId, boolean isGetRevokeNode) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryNextNode(processKey, taskId, isGetRevokeNode));
    }

    @GetMapping(value={"/queryNextNodeByCondition"})
    @ApiOperation(value="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9", notes="\u67e5\u8be2\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processKey", value="\u6d41\u7a0b\u6807\u8bc6", required=false, paramType="query"), @ApiImplicitParam(name="taskId", value="\u4efb\u52a1ID", required=false, paramType="query"), @ApiImplicitParam(name="lineCondition", value="\u7ebf\u6761\u4ef6", required=false, paramType="query")})
    public ApiResponse<?> queryNextNodeByCondition(String processKey, String taskId, Map<String, Object> lineCondition) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.queryNextNode(processKey, taskId, lineCondition));
    }

    @GetMapping(value={"/withdrawState"})
    @ApiOperation(value="\u67e5\u8be2\u80fd\u5426\u64a4\u56de", notes="\u67e5\u8be2\u80fd\u5426\u64a4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="historicTaskId", value="\u5386\u53f2\u4efb\u52a1ID", required=true, paramType="query")})
    public ApiResponse<?> withdrawState(String historicTaskId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.withdrawState(historicTaskId));
    }

    @GetMapping(value={"/revokeTask"})
    @ApiOperation(value="\u4efb\u52a1\u64a4\u56de", notes="\u4efb\u52a1\u64a4\u56de")
    @ApiImplicitParams(value={@ApiImplicitParam(name="historicTaskId", value="\u5386\u53f2\u4efb\u52a1ID", required=true, paramType="query"), @ApiImplicitParam(name="userId", value="\u4eba\u5458ID", required=true, paramType="query"), @ApiImplicitParam(name="comment", value="\u610f\u89c1", required=false, paramType="query"), @ApiImplicitParam(name="isSubmit", value="\u662f\u5426\u64a4\u56de\u5230\u63d0\u4ea4\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53c2\u6570", required=false, paramType="query")})
    public ApiResponse<?> revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.revokeTask(historicTaskId, userId, comment, isSubmit, variable));
    }

    @GetMapping(value={"/editTaskComment"})
    @ApiOperation(value="\u4fee\u6539\u529e\u7406\u610f\u89c1", notes="\u4fee\u6539\u529e\u7406\u610f\u89c1")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="comment", value="\u529e\u7406\u610f\u89c1", required=true, paramType="query")})
    public ApiResponse<?> editTaskComment(String taskId, String comment) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.editTaskComment(taskId, comment));
    }

    @GetMapping(value={"/multiInstanceDelAssignee"})
    @ApiOperation(value="\u4f1a\u7b7e\u8282\u70b9\u51cf\u5c11\u53c2\u4e0e\u8005", notes="\u4f1a\u7b7e\u8282\u70b9\u51cf\u5c11\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query"), @ApiImplicitParam(name="assignees", value="\u53c2\u4e0e\u8005id", required=true, paramType="query")})
    public ApiResponse<?> multiInstanceDelAssignee(String taskId, String assignees) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.multiInstanceDelAssignee(taskId, assignees));
    }

    @GetMapping(value={"/reStartProcess"})
    @ApiOperation(value="\u91cd\u542f\u6d41\u7a0b\u5230\u76ee\u6807\u8282\u70b9", notes="\u91cd\u542f\u6d41\u7a0b\u5230\u76ee\u6807\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=false, paramType="query"), @ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=false, paramType="query"), @ApiImplicitParam(name="taskDefinitionKey", value="\u76ee\u6807\u8282\u70b9id", required=false, paramType="query"), @ApiImplicitParam(name="userId", value="\u529e\u7406\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="assignee", value="\u53c2\u4e0e\u8005", required=false, paramType="query"), @ApiImplicitParam(name="isSubmit", value="\u662f\u5426\u91cd\u542f\u5230\u76ee\u6807\u8282\u70b9\u63d0\u4ea4\u4eba", required=false, paramType="query"), @ApiImplicitParam(name="map", value="\u53d8\u91cf", required=false, paramType="query")})
    public ApiResponse<?> reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, String map) {
        Map variable = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.reStartProcess(processInsId, businessId, taskDefinitionKey, userId, assignee, isSubmit, variable));
    }

    @GetMapping(value={"/updateUserSecurityLevel"})
    @ApiOperation(value="\u66f4\u65b0\u53d7\u5bc6\u7ea7\u53d8\u52a8\u5f71\u54cd\u7684\u6d41\u7a0b", notes="\u66f4\u65b0\u53d7\u5bc6\u7ea7\u53d8\u52a8\u5f71\u54cd\u7684\u6d41\u7a0b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true, paramType="query"), @ApiImplicitParam(name="level", value="\u5bc6\u7ea7", required=true, paramType="query")})
    public ApiResponse<?> updateUserSecurityLevel(String userId, Integer level) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.updateUserSecurityLevel(userId, level));
    }

    @GetMapping(value={"/updateStarter"})
    @ApiOperation(value="\u4fee\u6539\u6d41\u7a0b\u542f\u52a8\u8005", notes="\u4fee\u6539\u6d41\u7a0b\u542f\u52a8\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="processInsId", value="\u6d41\u7a0b\u5b9e\u4f8bid", required=false, paramType="query"), @ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=false, paramType="query"), @ApiImplicitParam(name="userId", value="\u542f\u52a8\u8005id", required=true, paramType="query")})
    public ApiResponse<?> updateStarter(String processInsId, String businessId, String userId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.updateStarter(processInsId, businessId, userId));
    }

    @GetMapping(value={"/activeTaskCandidates"})
    @ApiOperation(value="\u6dfb\u52a0\u8282\u70b9\u5019\u9009\u4eba\u4e3a\u53c2\u4e0e\u8005", notes="\u6dfb\u52a0\u8282\u70b9\u5019\u9009\u4eba\u4e3a\u53c2\u4e0e\u8005")
    @ApiImplicitParams(value={@ApiImplicitParam(name="taskId", value="\u4efb\u52a1id", required=true, paramType="query")})
    public ApiResponse<?> addCandidateUsers(String taskId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.activeTaskCandidates(taskId));
    }

    @GetMapping(value={"/getExecutionByBusinessId"})
    @ApiOperation(value="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u83b7\u5f97\u6267\u884cid", notes="\u6839\u636e\u4e1a\u52a1\u4e3b\u952e\u83b7\u5f97\u6267\u884cid")
    @ApiImplicitParams(value={@ApiImplicitParam(name="businessId", value="\u4e1a\u52a1\u4e3b\u952e", required=true, paramType="query")})
    public ApiResponse<?> getExecutionByBusinessId(String businessId) {
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.getExecutionByBusinessId(businessId));
    }

    @GetMapping(value={"/receiveTaskSignal"})
    @ApiOperation(value="\u63a5\u6536\u4efb\u52a1\u6267\u884c\u5230\u4e0b\u4e00\u8282\u70b9", notes="\u63a5\u6536\u4efb\u52a1\u6267\u884c\u5230\u4e0b\u4e00\u8282\u70b9")
    @ApiImplicitParams(value={@ApiImplicitParam(name="executionId", value="\u6267\u884c\u5b9e\u4f8bid", required=false, paramType="query")})
    public ApiResponse<?> receiveTaskSignal(String executionId, String map) {
        Map variableMap = (Map)JSON.parseObject((String)map, HashMap.class);
        return CommonCodeUtil.getApiResponse((BpmResponseResult)this.taskEngineService.receiveTaskSignal(executionId, variableMap));
    }
}

