/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.extend;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.IOParameter;
import org.activiti.editor.language.json.converter.BaseBpmnJsonConverter;
import org.activiti.editor.language.json.converter.BpmnJsonConverterUtil;
import org.activiti.editor.language.json.converter.CallActivityJsonConverter;
import org.apache.commons.lang3.StringUtils;

public class ExtendCallActivityJsonConverter
extends CallActivityJsonConverter {
    public static void fillTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap, Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        ExtendCallActivityJsonConverter.fillJsonTypes(convertersToBpmnMap);
        ExtendCallActivityJsonConverter.fillBpmnTypes(convertersToJsonMap);
    }

    public static void fillJsonTypes(Map<String, Class<? extends BaseBpmnJsonConverter>> convertersToBpmnMap) {
        convertersToBpmnMap.put("CallActivity", CallActivityJsonConverter.class);
    }

    public static void fillBpmnTypes(Map<Class<? extends BaseElement>, Class<? extends BaseBpmnJsonConverter>> convertersToJsonMap) {
        convertersToJsonMap.put(CallActivity.class, CallActivityJsonConverter.class);
    }

    protected String getStencilId(BaseElement baseElement) {
        return "CallActivity";
    }

    protected void convertElementToJson(ObjectNode propertiesNode, BaseElement baseElement) {
        List extendExecutionListenerElement;
        CallActivity callActivity = (CallActivity)baseElement;
        if (StringUtils.isNotEmpty((CharSequence)callActivity.getCalledElement())) {
            propertiesNode.put("callactivitycalledelement", callActivity.getCalledElement());
        }
        this.addJsonParameters("callactivityinparameters", "inParameters", callActivity.getInParameters(), propertiesNode);
        this.addJsonParameters("callactivityoutparameters", "outParameters", callActivity.getOutParameters(), propertiesNode);
        Map elementsListMap = callActivity.getExtensionElements();
        if (elementsListMap != null && (extendExecutionListenerElement = (List)elementsListMap.get("extendExecutionListener")) != null && extendExecutionListenerElement.size() > 0) {
            ArrayNode itemsNode = this.objectMapper.createArrayNode();
            for (ExtensionElement extensionElement : extendExecutionListenerElement) {
                ObjectNode propertyItemNode = this.objectMapper.createObjectNode();
                Map maps = extensionElement.getAttributes();
                if (ToolUtil.isNotEmpty((Object)maps)) {
                    for (Map.Entry map : maps.entrySet()) {
                        propertyItemNode.put((String)map.getKey(), ((ExtensionAttribute)((List)map.getValue()).get(0)).getValue());
                    }
                }
                itemsNode.add((JsonNode)propertyItemNode);
            }
            propertiesNode.put("extendExecutionListener", (JsonNode)itemsNode);
        }
    }

    private void addJsonParameters(String propertyName, String valueName, List<IOParameter> parameterList, ObjectNode propertiesNode) {
        ObjectNode parametersNode = this.objectMapper.createObjectNode();
        ArrayNode itemsNode = this.objectMapper.createArrayNode();
        for (IOParameter parameter : parameterList) {
            ObjectNode parameterItemNode = this.objectMapper.createObjectNode();
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSource())) {
                parameterItemNode.put("source", parameter.getSource());
            } else {
                parameterItemNode.putNull("source");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getTarget())) {
                parameterItemNode.put("target", parameter.getTarget());
            } else {
                parameterItemNode.putNull("target");
            }
            if (StringUtils.isNotEmpty((CharSequence)parameter.getSourceExpression())) {
                parameterItemNode.put("sourceExpression", parameter.getSourceExpression());
            } else {
                parameterItemNode.putNull("sourceExpression");
            }
            itemsNode.add((JsonNode)parameterItemNode);
        }
        parametersNode.put(valueName, (JsonNode)itemsNode);
        propertiesNode.put(propertyName, (JsonNode)parametersNode);
    }

    protected FlowElement convertJsonToElement(JsonNode elementNode, JsonNode modelNode, Map<String, JsonNode> shapeMap) {
        CallActivity callActivity = new CallActivity();
        if (StringUtils.isNotEmpty((CharSequence)this.getPropertyValueAsString("callactivitycalledelement", elementNode))) {
            callActivity.setCalledElement(this.getPropertyValueAsString("callactivitycalledelement", elementNode));
        }
        callActivity.getInParameters().addAll(this.convertToIOParameters("callactivityinparameters", "inParameters", elementNode));
        callActivity.getOutParameters().addAll(this.convertToIOParameters("callactivityoutparameters", "outParameters", elementNode));
        ArrayNode executionListener = (ArrayNode)this.getProperty("extendExecutionListener", elementNode);
        if (ToolUtil.isNotEmpty((Object)executionListener)) {
            for (JsonNode jsonNode : executionListener) {
                ExtensionElement extensionElement = new ExtensionElement();
                extensionElement.setName("extendExecutionListener");
                extensionElement.setNamespacePrefix("extend");
                extensionElement.setNamespace("http://activiti.org/bpmn");
                ExtensionAttribute eventAttribute = new ExtensionAttribute();
                eventAttribute.setName("event");
                eventAttribute.setValue(jsonNode.get("event").toString().replace("\"", ""));
                extensionElement.addAttribute(eventAttribute);
                ExtensionAttribute typeAttribute = new ExtensionAttribute();
                typeAttribute.setName("type");
                typeAttribute.setValue(jsonNode.get("type").toString().replace("\"", ""));
                extensionElement.addAttribute(typeAttribute);
                ExtensionAttribute urlAttribute = new ExtensionAttribute();
                urlAttribute.setName("url");
                urlAttribute.setValue(jsonNode.get("url").toString().replace("\"", ""));
                extensionElement.addAttribute(urlAttribute);
                callActivity.addExtensionElement(extensionElement);
            }
        }
        return callActivity;
    }

    private List<IOParameter> convertToIOParameters(String propertyName, String valueName, JsonNode elementNode) {
        JsonNode itemsArrayNode;
        ArrayList<IOParameter> ioParameters = new ArrayList<IOParameter>();
        JsonNode parametersNode = this.getProperty(propertyName, elementNode);
        if (parametersNode != null && (itemsArrayNode = (parametersNode = BpmnJsonConverterUtil.validateIfNodeIsTextual((JsonNode)parametersNode)).get(valueName)) != null) {
            Iterator var7 = itemsArrayNode.iterator();
            while (true) {
                if (!var7.hasNext()) {
                    return ioParameters;
                }
                JsonNode itemNode = (JsonNode)var7.next();
                JsonNode sourceNode = itemNode.get("source");
                JsonNode sourceExpressionNode = itemNode.get("sourceExpression");
                if ((sourceNode == null || !StringUtils.isNotEmpty((CharSequence)sourceNode.asText())) && (sourceExpressionNode == null || !StringUtils.isNotEmpty((CharSequence)sourceExpressionNode.asText()))) continue;
                IOParameter parameter = new IOParameter();
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("source", itemNode))) {
                    parameter.setSource(this.getValueAsString("source", itemNode));
                } else if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("sourceExpression", itemNode))) {
                    parameter.setSourceExpression(this.getValueAsString("sourceExpression", itemNode));
                }
                if (StringUtils.isNotEmpty((CharSequence)this.getValueAsString("target", itemNode))) {
                    parameter.setTarget(this.getValueAsString("target", itemNode));
                }
                ioParameters.add(parameter);
            }
        }
        return ioParameters;
    }
}

