/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateUser.model.CandidateUser;
import com.jxdinfo.hussar.workflow.engine.bpm.candidateUser.service.ICandidateUserService;
import com.jxdinfo.hussar.workflow.engine.bpm.cctask.service.ISysActCcTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.model.TaskComment;
import com.jxdinfo.hussar.workflow.engine.bpm.comment.service.TaskCommentService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.AnalyticalModelUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.CommonCodeUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.model.DefinitionModel;
import com.jxdinfo.hussar.workflow.engine.bpm.definition.service.ProcessDefinitionsService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dao.TaskEngineMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.service.ITaskEngineService;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.AddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.CommonJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.EntrustAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.InstallResult;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceAddAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceDelAssigneeCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.MultiInstanceJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ParallelJumpTaskCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.util.ReceiveTaskAddVariablesCmd;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.hisline.service.ISysActHiLineService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.model.SysActUrgeTask;
import com.jxdinfo.hussar.workflow.engine.bpm.urgetask.service.ISysActUrgeTaskService;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.model.DataPush;
import com.jxdinfo.hussar.workflow.engine.bsp.datapush.service.DataPushService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.dto.GetTaskManagerDto;
import com.jxdinfo.hussar.workflow.engine.bsp.taskmanager.service.TaskManagerService;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import com.jxdinfo.hussar.workflow.engine.constant.BpmEnum;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CallActivity;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.ExclusiveGateway;
import org.activiti.bpmn.model.ExtensionAttribute;
import org.activiti.bpmn.model.ExtensionElement;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Gateway;
import org.activiti.bpmn.model.InclusiveGateway;
import org.activiti.bpmn.model.ParallelGateway;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.ReceiveTask;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.bpmn.model.ServiceTask;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.bpmn.model.UserTask;
import org.activiti.engine.HistoryService;
import org.activiti.engine.ProcessEngine;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.bpmn.behavior.InclusiveGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelGatewayActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.juel.ExpressionFactoryImpl;
import org.activiti.engine.impl.juel.SimpleContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.ReadOnlyProcessDefinition;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.Execution;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.IdentityLink;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskEngineServiceImpl
implements ITaskEngineService {
    @Autowired
    private DruidProperties druidProperties;
    private static Logger LOGGER = LoggerFactory.getLogger(TaskEngineServiceImpl.class);
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    ISysActCcTaskService iSysActCcTaskService;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;
    @Autowired
    private ProcessDefinitionsService processDefinitionsService;
    @Autowired
    private TaskManagerService taskManagerService;
    @Resource
    private TaskEngineMapper taskEngineMapper;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    @Autowired
    private TaskCommentService taskCommentService;
    @Autowired
    private ActivityRedisTimerService activityRedisTimerService;
    @Autowired
    private ISysActUrgeTaskService sysActUrgeTaskService;
    @Resource
    private ICandidateUserService candidateUserService;
    @Autowired
    private ISysActHiLineService iSysActHiLineService;
    @Autowired
    private IFlowTaskService flowTaskService;
    @Autowired
    private DataPushService dataPushService;
    public static final List<String> CALL_REJECT_LIST = new ArrayList<String>();

    public Task getTask(String taskId, String state) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIdNull(), Boolean.valueOf(false));
        }
        TaskQuery taskQuery = (TaskQuery)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).includeTaskLocalVariables();
        if ("1".equals(state)) {
            taskQuery = (TaskQuery)taskQuery.includeTaskLocalVariables();
        } else if ("2".equals(state)) {
            taskQuery = (TaskQuery)((TaskQuery)taskQuery.includeTaskLocalVariables()).includeProcessVariables();
        }
        Task task = (Task)taskQuery.singleResult();
        if (task == null) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskNotFound(), Boolean.valueOf(false));
        }
        if (task.isSuspended()) {
            throw new PublicClientException(this.bpmConstantProperties.getTaskIsSuspended(), Boolean.valueOf(false));
        }
        return task;
    }

    public ApiResponse<?> queryTask(String taskId, String tenantId) {
        String message;
        String sendUser;
        if (taskId == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getNotNullParamIsNull());
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).includeTaskLocalVariables()).includeProcessVariables()).singleResult();
        if (historicTaskInstance == null) {
            return ApiResponse.fail((String)this.bpmConstantProperties.getTaskNotFound());
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(historicTaskInstance.getProcessInstanceId()).singleResult();
        Map variables = historicTaskInstance.getProcessVariables();
        Map taskVariables = historicTaskInstance.getTaskLocalVariables();
        map.put("taskId", historicTaskInstance.getId());
        map.put("name", historicTaskInstance.getName());
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(hpi.getStartUserId());
        String string = sendUser = taskVariables.get("sendUser") == null ? "" : taskVariables.get("sendUser").toString();
        if (ToolUtil.isNotEmpty((Object)sendUser)) {
            userIds.add(sendUser);
            map.put("sendUser", sendUser);
        }
        Map finalUsers = new HashMap();
        if (ToolUtil.isNotEmpty((Object)historicTaskInstance.getAssignee())) {
            userIds.add(historicTaskInstance.getAssignee());
            map.put("assigneeId", historicTaskInstance.getAssignee());
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            map.put("assigneeName", finalUsers.get(historicTaskInstance.getAssignee()));
        } else {
            Set<String> users = this.getAssigneeByTaskId(taskId);
            if (ToolUtil.isNotEmpty(users)) {
                userIds.addAll(users);
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilderName = new StringBuilder();
                for (String user : users) {
                    stringBuilder.append(",").append(user);
                    stringBuilderName.append(",").append((String)finalUsers.get(user));
                }
                map.put("assigneeId", stringBuilder.toString().substring(1));
                map.put("assigneeName", stringBuilderName.toString().substring(1));
            } else if (userIds.size() > 0) {
                finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
            }
        }
        if (ToolUtil.isNotEmpty((Object)sendUser)) {
            map.put("sendUserName", finalUsers.get(sendUser));
        }
        map.put("processStartUserId", hpi.getStartUserId());
        map.put("processStartUserName", finalUsers.get(hpi.getStartUserId()));
        map.put("processDefinitionId", historicTaskInstance.getProcessDefinitionId());
        map.put("processKey", hpi.getProcessDefinitionKey());
        map.put("processDefinitionName", hpi.getProcessDefinitionName());
        map.put("taskDefinitionKey", historicTaskInstance.getTaskDefinitionKey());
        map.put("processInsId", historicTaskInstance.getProcessInstanceId());
        map.put("claimTime", historicTaskInstance.getClaimTime());
        map.put("startTime", historicTaskInstance.getStartTime());
        map.put("endTime", historicTaskInstance.getEndTime());
        map.put("businessId", hpi.getBusinessKey());
        map.put("variables", variables);
        map.put("taskVariables", taskVariables);
        map.put("taskSourceFlag", taskVariables.get("taskSourceFlag"));
        String string2 = message = taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString();
        if (ToolUtil.isNotEmpty((Object)message)) {
            map.put("message", message);
        }
        map.put("formKey", historicTaskInstance.getFormKey());
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(historicTaskInstance.getProcessInstanceId() + historicTaskInstance.getTaskDefinitionKey());
        String formDetail = (String)this.iSysActExtendPropertiesService.queryList(ids).get(historicTaskInstance.getProcessDefinitionId() + historicTaskInstance.getTaskDefinitionKey());
        map.put("formDetailKey", formDetail);
        return ApiResponse.success(map);
    }

    public ApiResponse<?> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, String tenantId, Integer page, Integer size) {
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(startTime);
        taskManagerDto.setEndTime(endTime);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(suspensionState);
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setTenantId(tenantId);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<?> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, String tenantId, Integer page, Integer size) {
        GetTaskManagerDto taskManagerDto = new GetTaskManagerDto();
        taskManagerDto.setProcessName(processName);
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            List<String> processDefinitionKeies = Arrays.asList(processKey.split(","));
            taskManagerDto.setProcessKey(processDefinitionKeies);
        }
        taskManagerDto.setStartTime(startTime);
        taskManagerDto.setEndTime(endTime);
        taskManagerDto.setTimeoutState(timeoutState);
        taskManagerDto.setSuspensionState(suspensionState);
        taskManagerDto.setTodoConfiguration(todoConfiguration);
        taskManagerDto.setTenantId(tenantId);
        taskManagerDto.setBusinessList(!ToolUtil.isNotEmpty(businessList) ? businessList : null);
        Page pages = new Page(page == null ? 1L : (long)page.intValue(), size == null ? 10L : (long)size.intValue());
        List list = this.taskManagerService.getTask(pages, taskManagerDto);
        JSONObject object = new JSONObject();
        object.put("count", (Object)pages.getTotal());
        object.put("data", (Object)list);
        return ApiResponse.success((Object)object);
    }

    public ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.todoList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.todoList(new Page((long)page.intValue(), (long)rows.intValue()), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<?> queryToDoTaskList(String userId, List<String> businessIds, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel();
        flowTaskQueryModel.setUserId(userId);
        flowTaskQueryModel.setBusinessIds(businessIds);
        return this.flowTaskService.todoList(new Page(1L, 1000L), flowTaskQueryModel, null);
    }

    public ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.doneList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, String tenantId, Integer page, Integer rows) {
        FlowTaskQueryModel flowTaskQueryModel = new FlowTaskQueryModel(userId, processKey, definitionKey);
        return this.flowTaskService.doneList(new Page(1L, 1000L), flowTaskQueryModel, tenantId);
    }

    public ApiResponse<?> queryUserTaskCount(String userId) {
        return ApiResponse.success(this.taskEngineMapper.getUserTask(userId));
    }

    public ApiResponse<?> queryUserTaskCountByNode(String userId) {
        return ApiResponse.success(this.taskEngineMapper.getUserTaskByNode(userId));
    }

    public BpmResponseResult claimTask(String taskId, String userId) {
        this.taskService.claim(taskId, userId);
        this.claimDataPush(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 0);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult unClaimTask(String taskId) {
        this.taskService.unclaim(taskId);
        this.claimDataPush(taskId, null);
        this.activityRedisTimerService.updateTimeOutModel(taskId, null, null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInsId = task.getProcessInstanceId();
        this.complete(task, map, userId);
        this.completeDataPush(task, "", userId);
        return this.installReturnValue(userId, processInsId, task.getTaskDefinitionKey(), map);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInsId = task.getProcessInstanceId();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.complete(task, newMap, userId);
        this.completeDataPush(task, "", userId);
        return this.installReturnValue(userId, processInsId, task.getTaskDefinitionKey(), newMap);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInsId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.complete(task, newMap, userId);
        this.completeDataPush(task, comment, userId);
        return this.installReturnValue(userId, processInsId, task.getTaskDefinitionKey(), newMap);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInsId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && users.size() > 0) {
            newMap.put("cc_user", users);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.complete(task, newMap, userId);
        this.completeDataPush(task, comment, userId);
        return this.installReturnValue(userId, processInsId, task.getTaskDefinitionKey(), newMap);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInsId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        this.complete(task, map, userId);
        this.completeDataPush(task, comment, userId);
        return this.installReturnValue(userId, processInsId, task.getTaskDefinitionKey(), newMap);
    }

    public BpmResponseResult completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        String[] subs = subProcesses.split(",");
        JSONArray jsonArray = new JSONArray();
        for (String sub : subs) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("businessId", (Object)"");
            jsonObject.put("processKey", (Object)sub);
            jsonObject.put("userId", (Object)"");
            jsonArray.add((Object)jsonObject);
        }
        newMap.put("call_activity_info", jsonArray);
        String processInsId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        this.complete(task, newMap, userId);
        this.completeDataPush(task, comment, userId);
        return this.installReturnValue(userId, processInsId, task.getTaskDefinitionKey(), newMap);
    }

    public BpmResponseResult completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map, boolean isAuditAuthority) {
        Task task = this.getTask(taskId, "1");
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        String processInsId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && users.size() > 0) {
            newMap.put("cc_user", users);
        }
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        this.complete(task, newMap, userId);
        this.completeDataPush(task, comment, userId);
        return this.installReturnValue(userId, processInsId, task.getTaskDefinitionKey(), newMap);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        Map variables = task.getTaskLocalVariables();
        String rejectFrom = "";
        String mainRejectFrom = "";
        String rejectType = "";
        if (variables != null) {
            rejectFrom = variables.get("reject_from") == null ? "" : variables.get("reject_from").toString();
            mainRejectFrom = variables.get("main_reject_from") == null ? "" : variables.get("main_reject_from").toString();
            String string = rejectType = variables.get("complete_type") == null ? "" : variables.get("complete_type").toString();
        }
        if ("reject".equals(rejectType)) {
            if (ToolUtil.isNotEmpty((Object)rejectFrom)) {
                BpmnModel bm;
                this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
                String processDefinition = task.getProcessDefinitionId();
                ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
                ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(rejectFrom);
                String executionId = task.getExecutionId();
                String parentId = task.getExecutionId();
                ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
                if (rejectFrom != null && !this.canReject(bm = this.repositoryService.getBpmnModel(processDefinition), task.getTaskDefinitionKey(), rejectFrom, null, null, false) && !this.canReject(bm, task.getTaskDefinitionKey(), rejectFrom, null, null, true)) {
                    this.complete(task, newMap, userId);
                    return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
                }
                newMap.put("sendUser", userId);
                newMap.put("bpm_submit_source", task.getTaskDefinitionKey());
                this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, newMap, currentActivity));
            } else if (ToolUtil.isNotEmpty((Object)mainRejectFrom)) {
                BpmnModel bm;
                mainRejectFrom = "main_process_" + mainRejectFrom;
                Map<String, Object> result = this.backType(task, mainRejectFrom, false, userId, comment, "reject");
                int backType = (Integer)result.get("num");
                if (backType == 0) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidReject(), null);
                }
                if (backType == 4) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
                }
                String processInsId = (String)result.get("processInsId");
                String processDefinitionId = (String)result.get("processDefinitionId");
                String taskDefinitionKey = (String)result.get("taskDefinitionKey");
                if (mainRejectFrom != null && !this.canReject(bm = this.repositoryService.getBpmnModel(processDefinitionId), taskDefinitionKey, mainRejectFrom.substring("main_process_".length()), null, null, true) && !this.canReject(bm, taskDefinitionKey, mainRejectFrom.substring("main_process_".length()), null, null, false)) {
                    this.complete(task, newMap, userId);
                    return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
                }
                if (backType == 3) {
                    this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInstanceId, userId, null, null);
                    newMap.put("affectedTasks", result.get("affectedTasks"));
                }
                if (mainRejectFrom.startsWith("main_process_")) {
                    newMap.put("executionId", result.get("executionId"));
                    newMap.put("processInsId", processInsId);
                    newMap.put("processDefinitionId", processDefinitionId);
                    newMap.put("taskDefinitionKey", taskDefinitionKey);
                }
                this.rejectTask(userId, task, mainRejectFrom, comment, newMap, backType, "reject");
                this.rejectDataPush(task, comment, userId);
            }
        } else {
            this.complete(task, newMap, userId);
            this.completeDataPush(task, comment, userId);
        }
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    public BpmResponseResult completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        boolean flag = this.auditAuthority(userId, taskId);
        if (!flag) {
            return InstallResult.getResult((String)"0", (String)("\u5f53\u524d\u7528\u6237(" + userId + ")\u6ca1\u6709\u529e\u7406\u6743\u9650"), null);
        }
        if (task.getAssignee() == null) {
            this.taskService.claim(taskId, userId);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (users != null && users.size() > 0) {
            newMap.put("cc_user", users);
        }
        String processInstanceId = task.getProcessInstanceId();
        this.addComment(taskId, comment);
        if (ToolUtil.isNotEmpty(assigneeMap)) {
            newMap.put("appoint_assignee", assigneeMap);
        }
        Map variables = task.getTaskLocalVariables();
        String rejectFrom = "";
        String mainRejectFrom = "";
        String rejectType = "";
        if (variables != null) {
            rejectFrom = variables.get("reject_from") == null ? "" : variables.get("reject_from").toString();
            mainRejectFrom = variables.get("main_reject_from") == null ? "" : variables.get("main_reject_from").toString();
            String string = rejectType = variables.get("complete_type") == null ? "" : variables.get("complete_type").toString();
        }
        if ("reject".equals(rejectType)) {
            if (ToolUtil.isNotEmpty((Object)rejectFrom)) {
                BpmnModel bm;
                this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
                String processDefinition = task.getProcessDefinitionId();
                ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
                ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(rejectFrom);
                String executionId = task.getExecutionId();
                String parentId = task.getExecutionId();
                ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
                if (rejectFrom != null && !this.canReject(bm = this.repositoryService.getBpmnModel(processDefinition), task.getTaskDefinitionKey(), rejectFrom, null, null, false) && !this.canReject(bm, task.getTaskDefinitionKey(), rejectFrom, null, null, true)) {
                    this.complete(task, newMap, userId);
                    return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
                }
                newMap.put("bpm_submit_source", task.getTaskDefinitionKey());
                newMap.put("sendUser", userId);
                this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, newMap, currentActivity));
            } else if (ToolUtil.isNotEmpty((Object)mainRejectFrom)) {
                BpmnModel bm;
                mainRejectFrom = "main_process_" + mainRejectFrom;
                Map<String, Object> result = this.backType(task, mainRejectFrom, false, userId, comment, "reject");
                int backType = (Integer)result.get("num");
                if (backType == 0) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidReject(), null);
                }
                if (backType == 4) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
                }
                String processInsId = (String)result.get("processInsId");
                String processDefinitionId = (String)result.get("processDefinitionId");
                String taskDefinitionKey = (String)result.get("taskDefinitionKey");
                if (mainRejectFrom != null && !this.canReject(bm = this.repositoryService.getBpmnModel(processDefinitionId), taskDefinitionKey, mainRejectFrom.substring("main_process_".length()), null, null, false) && !this.canReject(bm, taskDefinitionKey, mainRejectFrom.substring("main_process_".length()), null, null, true)) {
                    this.complete(task, newMap, userId);
                    return this.installReturnValue(userId, processInsId, task.getTaskDefinitionKey(), newMap);
                }
                if (backType == 3) {
                    this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInsId, userId, null, null);
                    newMap.put("affectedTasks", result.get("affectedTasks"));
                }
                if (mainRejectFrom.startsWith("main_process_")) {
                    newMap.put("executionId", result.get("executionId"));
                    newMap.put("processInsId", processInsId);
                    newMap.put("processDefinitionId", processDefinitionId);
                    newMap.put("taskDefinitionKey", taskDefinitionKey);
                }
                this.rejectTask(userId, task, mainRejectFrom, comment, newMap, backType, "reject");
                this.rejectDataPush(task, comment, userId);
            }
        } else {
            this.complete(task, newMap, userId);
            this.completeDataPush(task, comment, userId);
        }
        return this.installReturnValue(userId, processInstanceId, task.getTaskDefinitionKey(), newMap);
    }

    private boolean auditAuthority(String userId, String taskId) {
        boolean flag = false;
        Set<String> users = this.getAssigneeByTaskId(taskId);
        if (users.contains(userId)) {
            flag = true;
        }
        return flag;
    }

    private void complete(Task task, Map<String, Object> map, String userId) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        newMap.put("sendUser", userId);
        if (map != null) {
            newMap.putAll(map);
        }
        newMap.put("bpm_submit_source", task.getTaskDefinitionKey());
        Map<String, Object> appointAssignee = new HashMap();
        if (newMap.get("appoint_assignee") != null) {
            appointAssignee = (Map)newMap.get("appoint_assignee");
        }
        if (ToolUtil.isEmpty(appointAssignee.get("static_appoint_assignee"))) {
            appointAssignee.put("static_appoint_assignee", null);
            newMap.put("appoint_assignee", appointAssignee);
        }
        String taskId = task.getId();
        this.taskService.setVariableLocal(taskId, "taskSourceFlag", (Object)"complete");
        if (task.getDelegationState() == null) {
            this.taskService.complete(taskId, newMap);
        } else {
            this.taskService.resolveTask(taskId, newMap);
            this.taskService.complete(taskId, newMap);
        }
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
    }

    private void addComment(String taskId, String comment) {
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(taskId, null, "complete", comment);
        }
    }

    private BpmResponseResult installReturnValue(String userId, String processInsId, String taskDefinitionKey, Map<String, Object> variables) {
        HistoricProcessInstance processInstance;
        boolean isContainReceive;
        JSONArray json = new JSONArray();
        List<String> callActivityInstIds = this.taskEngineMapper.getCallActivityInstId(processInsId);
        callActivityInstIds.add(processInsId);
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(callActivityInstIds)).includeTaskLocalVariables()).list();
        String superProcessInstanceId = null;
        List<Object> mainCallActivityInstIds = new ArrayList();
        boolean bl = isContainReceive = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("receiveTask").unfinished().list().size() != 0;
        if (isContainReceive) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("receiveTask").unfinished().list();
            for (Object hi : historicActivityInstances) {
                String executionId = hi.getExecutionId();
                this.processEngine.getManagementService().executeCommand((Command)new ReceiveTaskAddVariablesCmd(executionId, taskDefinitionKey, userId, false, null));
                JSONObject object = new JSONObject();
                object.put("processInsId", (Object)hi.getProcessInstanceId());
                object.put("executionId", (Object)hi.getExecutionId());
                object.put("type", (Object)"receiveTask");
                object.put("taskDefinitionKey", (Object)hi.getActivityName());
                object.put("taskDefinitionName", (Object)hi.getActivityId());
                json.add((Object)object);
            }
        }
        if (ToolUtil.isEmpty((Object)tasks) && !isContainReceive && ToolUtil.isNotEmpty((Object)(processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult()).getSuperProcessInstanceId())) {
            superProcessInstanceId = processInstance.getSuperProcessInstanceId();
            mainCallActivityInstIds = this.taskEngineMapper.getCallActivityInstId(superProcessInstanceId);
            mainCallActivityInstIds.add(superProcessInstanceId);
            tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(mainCallActivityInstIds)).includeTaskLocalVariables()).list();
            mainCallActivityInstIds.remove(superProcessInstanceId);
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(superProcessInstanceId).finished().activityType("callActivity").list();
            for (Object historicActivityInstance : list) {
                if (!historicActivityInstance.getCalledProcessInstanceId().equals(processInsId)) continue;
                taskDefinitionKey = historicActivityInstance.getActivityId();
                break;
            }
            boolean bl2 = isContainReceive = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(superProcessInstanceId).activityType("receiveTask").unfinished().list().size() != 0;
            if (isContainReceive) {
                List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(superProcessInstanceId).activityType("receiveTask").unfinished().list();
                for (HistoricActivityInstance hi : historicActivityInstances) {
                    String executionId = hi.getExecutionId();
                    this.processEngine.getManagementService().executeCommand((Command)new ReceiveTaskAddVariablesCmd(executionId, taskDefinitionKey, userId, false, null));
                    JSONObject object = new JSONObject();
                    object.put("processInsId", (Object)hi.getProcessInstanceId());
                    object.put("executionId", (Object)hi.getExecutionId());
                    object.put("type", (Object)"receiveTask");
                    object.put("taskDefinitionKey", (Object)hi.getActivityName());
                    object.put("taskDefinitionName", (Object)hi.getActivityId());
                    json.add((Object)object);
                }
            }
        }
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                String completeType;
                Set<String> users = this.getAssigneeByTaskId(t.getId());
                Map map = t.getTaskLocalVariables() == null ? new HashMap(16) : t.getTaskLocalVariables();
                String string = completeType = map.get("complete_type") == null ? "" : map.get("complete_type").toString();
                if (ToolUtil.isEmpty((Object)completeType)) {
                    this.taskService.setVariableLocal(t.getId(), "complete_type", (Object)"complete");
                    this.taskService.setVariableLocal(t.getId(), "sendUser", (Object)userId);
                    if (taskDefinitionKey == null) {
                        if (ToolUtil.isEmpty(users)) {
                            this.taskService.setAssignee(t.getId(), userId);
                        }
                    } else if (t.getProcessInstanceId().equals(processInsId)) {
                        this.taskService.setVariableLocal(t.getId(), "complete_from", (Object)taskDefinitionKey);
                        if (variables != null) {
                            this.taskService.setVariableLocal(t.getId(), "old_appoint_assignee", variables.get("appoint_assignee"));
                        }
                    } else if (callActivityInstIds.contains(t.getProcessInstanceId())) {
                        this.taskService.setVariable(t.getId(), "process_complete_type", (Object)"complete");
                        this.taskService.setVariableLocal(t.getId(), "call_complete_from", (Object)taskDefinitionKey);
                    } else if (mainCallActivityInstIds.contains(t.getProcessInstanceId())) {
                        this.taskService.setVariableLocal(t.getId(), "call_complete_from", (Object)taskDefinitionKey);
                    } else {
                        this.taskService.setVariableLocal(t.getId(), "complete_from", (Object)taskDefinitionKey);
                    }
                }
                JSONObject object = new JSONObject();
                object.put("processInsId", (Object)t.getProcessInstanceId());
                object.put("taskId", (Object)t.getId());
                object.put("userId", users);
                object.put("taskDefinitionKey", (Object)t.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)t.getName());
                object.put("formKey", (Object)t.getFormKey());
                json.add((Object)object);
            }
        } else if (!isContainReceive) {
            JSONObject object = new JSONObject();
            object.put("taskDefinitionName", BpmConstant.END_NAME);
            object.put("endTime", (Object)new Date());
            json.add((Object)object);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map, String rejectActivityId) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = this.getTask(taskId, "1");
        String backActivityId = this.getLastActivityId(task);
        if ("".equals(backActivityId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidReject(), null);
        }
        Map<String, Object> result = this.backType(task, backActivityId, false, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == 0) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidReject(), null);
        }
        if (backType == 4) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        String processInsId = (String)result.get("processInsId");
        String processDefinitionId = (String)result.get("processDefinitionId");
        String taskDefinitionKey = (String)result.get("taskDefinitionKey");
        if (backActivityId != null) {
            String nodeId;
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            String string = nodeId = backActivityId.startsWith("main_process_") ? backActivityId.substring("main_process_".length()) : backActivityId;
            if (!this.canReject(bm, taskDefinitionKey, nodeId, null, null, true) && !this.canReject(bm, taskDefinitionKey, nodeId, null, null, false)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
            }
        }
        if (ToolUtil.isEmpty((Object)rejectActivityId)) {
            rejectActivityId = task.getTaskDefinitionKey();
        }
        if (backActivityId != null && (backActivityId.equals(this.getFirstActivityId(processInsId, taskDefinitionKey)) || backActivityId.equals("main_process_" + this.getFirstActivityId(processInsId, taskDefinitionKey)))) {
            starterUserId = this.getTaskStarterUserId(processInsId);
            isFirst = true;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(processInsId, backActivityId);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        if (backType == 3) {
            this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInsId, userId, null, null);
            newMap.put("affectedTasks", result.get("affectedTasks"));
        }
        if (backActivityId.startsWith("main_process_")) {
            newMap.put("executionId", result.get("executionId"));
            newMap.put("processInsId", processInsId);
            newMap.put("processDefinitionId", processDefinitionId);
            newMap.put("taskDefinitionKey", taskDefinitionKey);
        }
        this.rejectTask(userId, task, backActivityId, comment, newMap, backType, "reject");
        BpmResponseResult bpmResponseResult = this.installRejectReturnValue(processInsId, isFirst, starterUserId, backActivityId, userId, taskDefinitionKey, "reject", (String)result.get("taskName"), task.getTaskDefinitionKey(), task.getName());
        JSONArray array = bpmResponseResult.getResult();
        boolean needReject = false;
        String rejectTaskId = "";
        if (ToolUtil.isNotEmpty((Object)array)) {
            for (int i = 0; i < array.size(); ++i) {
                JSONObject object = array.getJSONObject(i);
                if (!object.get((Object)"taskDefinitionKey").equals(backActivityId) || !ToolUtil.isEmpty((Object)object.get((Object)"userId")) || !object.get((Object)"processInsId").equals(processInsId)) continue;
                needReject = true;
                rejectTaskId = object.get((Object)"taskId") == null ? "" : object.get((Object)"taskId").toString();
                break;
            }
        }
        if (needReject) {
            return this.rejectToLastTask(rejectTaskId, userId, comment, assignees, isSubmit, newMap, rejectActivityId);
        }
        this.rejectDataPush(task, comment, userId);
        return bpmResponseResult;
    }

    public BpmResponseResult rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        String firstTaskId = this.getFirstActivityId(task.getProcessInstanceId(), task.getTaskDefinitionKey());
        String starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
        Map<String, Object> result = this.backType(task, "", true, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == 4) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        if (isSubmit) {
            newMap.put("reject_appoint_assignee", this.getTaskCommitUser((String)result.get("processInsId"), firstTaskId));
        }
        if (backType == 3) {
            newMap.put("affectedTasks", result.get("affectedTasks"));
        }
        this.rejectTask(userId, task, firstTaskId, comment, newMap, backType, "reject");
        this.rejectDataPush(task, comment, userId);
        return this.installRejectReturnValue(task.getProcessInstanceId(), true, starterUserId, firstTaskId, userId, task.getTaskDefinitionKey(), "reject", task.getName(), task.getTaskDefinitionKey(), task.getName());
    }

    public BpmResponseResult rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        boolean isFirst = false;
        String starterUserId = "";
        Task task = this.getTask(taskId, "1");
        Map<String, Object> result = this.backType(task, backActivityId, false, userId, comment, "reject");
        int backType = (Integer)result.get("num");
        if (backType == -1) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRejectToAnyCannotToAnotherBranch(), null);
        }
        if (backType == 4) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
        }
        String processInsId = (String)result.get("processInsId");
        String processDefinitionId = (String)result.get("processDefinitionId");
        String taskDefinitionKey = (String)result.get("taskDefinitionKey");
        if (backActivityId != null) {
            String nodeId;
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            String string = nodeId = backActivityId.startsWith("main_process_") ? backActivityId.substring("main_process_".length()) : backActivityId;
            if (!this.canReject(bm, taskDefinitionKey, nodeId, null, null, true) && !this.canReject(bm, taskDefinitionKey, nodeId, null, null, false)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRejectToTargetNode(), null);
            }
        }
        if (backActivityId != null && (backActivityId.equals(this.getFirstActivityId(processInsId, taskDefinitionKey)) || backActivityId.equals("main_process_" + this.getFirstActivityId(processInsId, taskDefinitionKey)))) {
            starterUserId = this.getTaskStarterUserId(processInsId);
            isFirst = true;
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(processInsId, backActivityId);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        if (backType == 3) {
            this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInsId, userId, null, null);
            newMap.put("affectedTasks", result.get("affectedTasks"));
        }
        if (backActivityId.startsWith("main_process_")) {
            newMap.put("executionId", result.get("executionId"));
            newMap.put("processInsId", processInsId);
            newMap.put("processDefinitionId", processDefinitionId);
            newMap.put("taskDefinitionKey", taskDefinitionKey);
        }
        this.rejectTask(userId, task, backActivityId, comment, newMap, backType, "reject");
        this.rejectDataPush(task, comment, userId);
        return this.installRejectReturnValue(processInsId, isFirst, starterUserId, backActivityId, userId, taskDefinitionKey, "reject", (String)result.get("taskName"), task.getTaskDefinitionKey(), task.getName());
    }

    public BpmResponseResult queryRejectNode(String taskId) {
        Task task = this.getTask(taskId, "1");
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm != null) {
            List hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list();
            List<String> hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).activityType("callActivity").finished().list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!ToolUtil.isNotEmpty((Object)historicActivityInstance.getEndTime())) continue;
                hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
            }
            JSONArray json = new JSONArray();
            Process process = bm.getMainProcess();
            FlowNode userTask = (FlowNode)process.getFlowElement(task.getTaskDefinitionKey());
            HashSet<String> ids = new HashSet<String>();
            ids.add(task.getTaskDefinitionKey());
            ArrayList<List<String>> lists = new ArrayList<List<String>>();
            if (userTask == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
            }
            this.getAllhisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
            List<String> finalList = this.getFinalList(lists);
            this.updateJsonResult(bm, json, finalList, false);
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            if (ToolUtil.isNotEmpty((Object)processInstance.getSuperProcessInstanceId()) && (hisList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId())).taskVariableValueNotEquals("taskSourceFlag", (Object)"skip")).orderByHistoricTaskInstanceEndTime().asc()).finished().list()).size() > 0) {
                bm = this.repositoryService.getBpmnModel(((HistoricTaskInstance)hisList.get(0)).getProcessDefinitionId());
                hisTaskDefinitionKey = hisList.stream().map(TaskInfo::getTaskDefinitionKey).collect(Collectors.toList());
                list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(((HistoricTaskInstance)hisList.get(0)).getProcessInstanceId()).activityType("callActivity").list();
                String taskDefinitionKey = "";
                for (HistoricActivityInstance historicActivityInstance : list) {
                    if (ToolUtil.isNotEmpty((Object)historicActivityInstance.getEndTime())) {
                        hisTaskDefinitionKey.add(historicActivityInstance.getActivityId());
                    }
                    if (!"".equals(taskDefinitionKey) || !processInstance.getId().equals(historicActivityInstance.getCalledProcessInstanceId())) continue;
                    taskDefinitionKey = historicActivityInstance.getActivityId();
                }
                hisTaskDefinitionKey = new ArrayList<String>(new HashSet<String>(hisTaskDefinitionKey));
                hisTaskDefinitionKey.remove(taskDefinitionKey);
                process = bm.getMainProcess();
                userTask = (FlowNode)process.getFlowElement(taskDefinitionKey);
                ids = new HashSet();
                ids.add(taskDefinitionKey);
                lists = new ArrayList();
                if (userTask == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getRunningNodeNotFound(), null);
                }
                this.getAllhisNodeList(bm, userTask.getIncomingFlows(), hisTaskDefinitionKey, new ArrayList<String>(ids), new ArrayList<String>(), lists);
                finalList = this.getFinalList(lists);
                this.updateJsonResult(bm, json, finalList, true);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    private void getAllhisNodeList(BpmnModel bm, List<SequenceFlow> incomingFlows, List<String> hisTaskDefinitionKey, List<String> goneNode, List<String> hisNode, List<List<String>> allHisNode) {
        Process process = (Process)bm.getProcesses().get(0);
        for (SequenceFlow sequenceFlow : incomingFlows) {
            FlowElement flowElement = process.getFlowElement(sequenceFlow.getSourceRef());
            ArrayList<String> goneNodeSave = new ArrayList<String>(goneNode);
            ArrayList<String> hisNodeSave = new ArrayList<String>(hisNode);
            if (flowElement instanceof StartEvent) {
                allHisNode.add(hisNodeSave);
            }
            if (goneNode.contains(flowElement.getId())) continue;
            goneNodeSave.add(flowElement.getId());
            if (hisTaskDefinitionKey.contains(flowElement.getId())) {
                hisNodeSave.add(flowElement.getId());
            }
            this.getAllhisNodeList(bm, ((FlowNode)flowElement).getIncomingFlows(), hisTaskDefinitionKey, goneNodeSave, hisNodeSave, allHisNode);
        }
    }

    private List<String> getFinalList(List<List<String>> lists) {
        if (lists.size() == 0) {
            return new ArrayList<String>();
        }
        List<String> finalList = lists.get(0);
        for (int i = 1; i < lists.size(); ++i) {
            List<String> list = lists.get(i);
            int index = 0;
            for (String id : list) {
                if (finalList.contains(id)) {
                    index = finalList.indexOf(id) + 1;
                    continue;
                }
                finalList.add(index, id);
                ++index;
            }
        }
        return finalList;
    }

    private void updateJsonResult(BpmnModel bm, JSONArray json, List<String> finalList, boolean isRejectMain) {
        Process process = (Process)bm.getProcesses().get(0);
        String preFix = isRejectMain ? "main_process_" : "";
        String namePreFix = isRejectMain ? "\u4e3b\u6d41\u7a0b" : "";
        for (String id : finalList) {
            FlowElement flowElement = process.getFlowElement(id);
            JSONObject object = new JSONObject();
            object.put("id", (Object)(preFix + flowElement.getId()));
            object.put("name", (Object)(namePreFix + flowElement.getName()));
            json.add((Object)object);
        }
    }

    private String getTaskCommitUser(String processInsId, String backActivityId) {
        List hisTaskList;
        StringBuilder assignee = new StringBuilder();
        if (backActivityId.startsWith("main_process_")) {
            backActivityId = backActivityId.substring("main_process_".length());
        }
        if ((hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).finished().includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).list()) != null && hisTaskList.size() > 0) {
            block0: for (int i = 0; i < hisTaskList.size(); ++i) {
                String taskSourceFlag = (String)((HistoricTaskInstance)hisTaskList.get(i)).getTaskLocalVariables().get("taskSourceFlag");
                if ("reject".equals(taskSourceFlag) || "revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) continue;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(i);
                Date start = historicTaskInstance.getStartTime();
                assignee.append(historicTaskInstance.getAssignee());
                for (int j = i; j < hisTaskList.size(); ++j) {
                    historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(j);
                    if (start.getTime() > historicTaskInstance.getEndTime().getTime()) break block0;
                    assignee.append(",").append(historicTaskInstance.getAssignee());
                }
                break;
            }
        }
        return assignee.toString();
    }

    private BpmResponseResult installRejectReturnValue(String processInsId, boolean isFirst, String starterUserId, String backActivityId, String userId, String taskDefinitionKey, String type, String name, String callTaskDefKey, String callTaskName) {
        if (backActivityId.startsWith("main_process_")) {
            backActivityId = backActivityId.substring("main_process_".length());
        }
        JSONArray json = new JSONArray();
        List<String> callActivityInstIds = this.taskEngineMapper.getCallActivityInstId(processInsId);
        callActivityInstIds.add(processInsId);
        List tasks = ((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(callActivityInstIds)).orderByTaskCreateTime()).asc()).list();
        Object completeFrom = null;
        Object callCompleteFrom = null;
        HashMap callCompleteFromMap = new HashMap();
        List hisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInsId)).taskDefinitionKey(backActivityId)).includeTaskLocalVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
        if (hisTaskList != null && hisTaskList.size() > 0) {
            HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTaskList.get(0);
            completeFrom = historicTaskInstance.getTaskLocalVariables().get("complete_from");
            callCompleteFrom = historicTaskInstance.getTaskLocalVariables().get("call_complete_from");
        }
        callActivityInstIds.remove(processInsId);
        if (callActivityInstIds.size() > 0) {
            List callHisTaskList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(callActivityInstIds)).taskVariableValueNotEquals("call_complete_from", null)).includeTaskLocalVariables()).finished().orderByHistoricTaskInstanceEndTime().desc()).list();
            for (HistoricTaskInstance historicTask : callHisTaskList) {
                if (callCompleteFromMap.get(historicTask.getProcessInstanceId()) != null) continue;
                callCompleteFromMap.put(historicTask.getProcessInstanceId(), historicTask.getTaskLocalVariables().get("call_complete_from"));
            }
        }
        if (tasks != null && tasks.size() > 0) {
            for (Task t : tasks) {
                Set<String> users = this.getAssigneeByTaskId(t.getId());
                if (t.getTaskDefinitionKey().equals(backActivityId) || !processInsId.equals(t.getProcessInstanceId())) {
                    if (isFirst && t.getAssignee() == null && StringUtils.isNotEmpty((CharSequence)starterUserId) && users.size() == 0) {
                        this.taskService.setAssignee(t.getId(), starterUserId);
                    }
                    this.taskService.setVariableLocal(t.getId(), "sendUser", (Object)userId);
                    if (processInsId.equals(t.getProcessInstanceId())) {
                        this.taskService.setVariableLocal(t.getId(), "reject_from", (Object)taskDefinitionKey);
                        if (completeFrom != null) {
                            this.taskService.setVariableLocal(t.getId(), "complete_from", completeFrom);
                        } else if (callCompleteFrom != null) {
                            this.taskService.setVariableLocal(t.getId(), "call_complete_from", callCompleteFrom);
                        }
                    } else {
                        this.taskService.setVariable(t.getId(), "process_complete_type", (Object)"reject");
                        this.taskService.setVariableLocal(t.getId(), "main_reject_from", (Object)taskDefinitionKey);
                        this.taskService.setVariableLocal(t.getId(), "call_complete_from", callCompleteFromMap.get(t.getProcessInstanceId()));
                    }
                    this.taskService.setVariableLocal(t.getId(), "complete_type", (Object)type);
                    this.taskService.setVariableLocal(t.getId(), "reject_name", (Object)name);
                }
                JSONObject object = new JSONObject();
                object.put("processInsId", (Object)t.getProcessInstanceId());
                object.put("taskId", (Object)t.getId());
                object.put("userId", users);
                object.put("taskDefinitionKey", (Object)t.getTaskDefinitionKey());
                object.put("taskDefinitionName", (Object)t.getName());
                object.put("formKey", (Object)t.getFormKey());
                json.add((Object)object);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    private void rejectTask(String userId, Task task, String backActivityId, String comment, Map<String, Object> map, int backType, String type) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        newMap.put("sendUser", userId);
        Map<String, Object> appointAssignee = new HashMap<String, Object>();
        if (newMap.get("appoint_assignee") != null) {
            appointAssignee = (Map)newMap.get("appoint_assignee");
        }
        appointAssignee.put("static_appoint_assignee", null);
        newMap.put("appoint_assignee", appointAssignee);
        if (backActivityId.startsWith("main_process_")) {
            String executionId = (String)newMap.get("executionId");
            newMap.remove("executionId");
            String processDefinitionId = (String)newMap.get("processDefinitionId");
            newMap.remove("processDefinitionId");
            String taskDefinitionKey = (String)newMap.get("taskDefinitionKey");
            newMap.remove("taskDefinitionKey");
            this.callReject(userId, executionId, processDefinitionId, taskDefinitionKey, backActivityId, type, comment, newMap);
            if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
                this.activityRedisTimerService.delTimeOutModel(task.getId());
            }
            return;
        }
        this.taskService.setVariableLocal(task.getId(), "taskSourceFlag", (Object)type);
        if (StringUtils.isNotEmpty((CharSequence)comment)) {
            this.taskService.addComment(task.getId(), null, "complete", comment);
        }
        HashMap<String, Boolean> variables = new HashMap<String, Boolean>();
        variables.put("is_normal_commit", false);
        this.taskService.setVariablesLocal(task.getId(), variables);
        switch (backType) {
            case 2: {
                this.multiInstanceReject(userId, task, backActivityId, newMap);
                break;
            }
            case 3: {
                this.parallelReject(userId, task, backActivityId, type, comment, newMap);
                break;
            }
            default: {
                this.commonReject(userId, task, backActivityId, newMap);
            }
        }
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            this.activityRedisTimerService.delTimeOutModel(task.getId());
        }
    }

    private void parallelReject(String userId, Task task, String backActivityId, String type, String comment, Map<String, Object> map) {
        if (ToolUtil.isNotEmpty((Object)userId) && ToolUtil.isEmpty((Object)task.getAssignee())) {
            this.claimTask(task.getId(), userId);
        }
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        if (ToolUtil.isEmpty((Object)currentActivity)) {
            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
        }
        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, destinationActivity, type, comment, map, currentActivity));
    }

    private void callReject(String userId, String executionId, String processDefinitionId, String taskDefinitionKey, String backActivityId, String type, String comment, Map<String, Object> map) {
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinitionId);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId.substring("main_process_".length()));
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(taskDefinitionKey);
        if (ToolUtil.isEmpty((Object)currentActivity)) {
            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
        }
        this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, executionId, destinationActivity, type, comment, map, currentActivity));
    }

    private void commonReject(String userId, Task task, String backActivityId, Map<String, Object> map) {
        if (StringUtils.isNotEmpty((CharSequence)userId)) {
            this.claimTask(task.getId(), userId);
        }
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        String parentId = task.getExecutionId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        if (ToolUtil.isEmpty((Object)currentActivity)) {
            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
        }
        this.processEngine.getManagementService().executeCommand((Command)new CommonJumpTaskCmd(executionId, parentId, destinationActivity, map, currentActivity));
    }

    private void multiInstanceReject(String userId, Task task, String backActivityId, Map<String, Object> map) {
        String processDefinition = task.getProcessDefinitionId();
        ReadOnlyProcessDefinition processDefinitionEntity = (ReadOnlyProcessDefinition)this.repositoryService.getProcessDefinition(processDefinition);
        ActivityImpl destinationActivity = (ActivityImpl)processDefinitionEntity.findActivity(backActivityId);
        String executionId = task.getExecutionId();
        List execution = this.runtimeService.createExecutionQuery().processInstanceId(task.getProcessInstanceId()).activityId(task.getTaskDefinitionKey()).listPage(0, 1);
        String parentId = ((Execution)execution.get(0)).getParentId();
        ActivityImpl currentActivity = (ActivityImpl)processDefinitionEntity.findActivity(task.getTaskDefinitionKey());
        if (ToolUtil.isEmpty((Object)currentActivity)) {
            throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceJumpTaskCmd(userId, executionId, parentId, destinationActivity, map, currentActivity, task.getId()));
    }

    private String getLastActivityId(Task task) {
        Map map;
        Map map2 = map = task.getTaskLocalVariables() == null ? new HashMap() : task.getTaskLocalVariables();
        if (map.get("complete_from") != null) {
            return map.get("complete_from").toString();
        }
        if (map.get("call_complete_from") != null) {
            return "main_process_" + map.get("call_complete_from");
        }
        return "";
    }

    private String getFirstActivityId(String processInsId, String taskDefinitionKey) {
        ApiResponse<?> allNodeInfo = this.queryHistoryActByTaskId(null, processInsId);
        JSONArray jsonArray = (JSONArray)((Map)allNodeInfo.getData()).get("data");
        JSONObject jsonObject = new JSONObject();
        if (jsonArray != null && jsonArray.size() > 0) {
            jsonObject = jsonArray.getJSONObject(jsonArray.size() - 1);
        }
        if (jsonArray != null && jsonArray.size() == 0) {
            return taskDefinitionKey;
        }
        return jsonObject.getString("nodeId") == null ? "" : jsonObject.getString("nodeId");
    }

    public BpmResponseResult delegateTask(String taskId, String userId) {
        this.taskService.delegateTask(taskId, userId);
        this.activityRedisTimerService.updateTimeOutModel(taskId, userId, null, 1);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, String userId, String mandatary) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{userId, taskId, mandatary})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        if (userId.equals(mandatary)) {
            return InstallResult.getResult((String)"1", (String)"success", null);
        }
        if (!this.auditAuthority(mandatary, taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userId, mandatary, false, false));
            this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, userId, 0);
            SysActUrgeTask sysActUrgeTask = new SysActUrgeTask();
            sysActUrgeTask.setReceiveUser(mandatary);
            this.sysActUrgeTaskService.update((Object)sysActUrgeTask, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId)).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
            Date date = new Date();
            this.entrustDataPush(task, userId, mandatary, null, task.getCreateTime(), date);
        } else {
            this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, userId, null, false, true));
            this.activityRedisTimerService.updateTimeOutModel(taskId, null, userId, 0);
            this.sysActUrgeTaskService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId)).eq(SysActUrgeTask::getReceiveUser, (Object)userId));
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult entrustTask(String taskId, String mandatary, int state) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{taskId, mandatary})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getEntrustFailParameterCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        if (state != 0 && mandatary.contains(",") && this.isMulti(task) == 2) {
            return InstallResult.getResult((String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), (String)String.valueOf(BpmEnum.ERROR_ENTRUST_ASSIGNEE.getCode()), null);
        }
        this.processEngine.getManagementService().executeCommand((Command)new EntrustAssigneeCmd(taskId, "", mandatary, state == 0, false));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
        if (list != null && list.size() != 0) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            String[] receiveUsers = mandatary.split(",");
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : receiveUsers) {
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(urgeTask.getTaskId());
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            if (state == 1) {
                this.sysActUrgeTaskService.remove((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
        }
        Date date = new Date();
        if (state == 1) {
            this.entrustDataPush(task, null, mandatary, null, task.getCreateTime(), date);
        } else {
            this.addUserDataPush(task, null, mandatary);
        }
        this.activityRedisTimerService.updateTimeOutModel(taskId, mandatary, null, state);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        Task task = this.getTask(taskId, "1");
        Map<String, Object> result = this.backType(task, activitiId, false, userId, comment, "freejump");
        int backType = (Integer)result.get("num");
        if (backType == -1) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getFreeJumpCannotToAnotherBranch(), null);
        }
        if (backType == 4) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotFreeJumpToTargetNode(), null);
        }
        String processInsId = (String)result.get("processInsId");
        String processDefinitionId = (String)result.get("processDefinitionId");
        String taskDefinitionKey = (String)result.get("taskDefinitionKey");
        if (activitiId != null) {
            String nodeId;
            BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
            String string = nodeId = activitiId.startsWith("main_process_") ? activitiId.substring("main_process_".length()) : activitiId;
            if (!this.canReject(bm, taskDefinitionKey, nodeId, null, null, true) && !this.canReject(bm, taskDefinitionKey, nodeId, null, null, false)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotFreeJumpToTargetNode(), null);
            }
        }
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map != null) {
            newMap.putAll(map);
        }
        if (isSubmit) {
            assignees = this.getTaskCommitUser(processInsId, activitiId);
        }
        if (ToolUtil.isNotEmpty((Object)assignees)) {
            newMap.put("reject_appoint_assignee", assignees);
        }
        if (backType == 3) {
            this.callActivitiReject((List)result.get("affectedTasks"), (Set)result.get("runningActivitiNodeIds"), processInsId, userId, null, null);
            newMap.put("affectedTasks", result.get("affectedTasks"));
        }
        if (activitiId.startsWith("main_process_")) {
            newMap.put("executionId", result.get("executionId"));
            newMap.put("processInsId", processInsId);
            newMap.put("processDefinitionId", processDefinitionId);
            newMap.put("taskDefinitionKey", taskDefinitionKey);
        }
        this.rejectTask(userId, task, activitiId, comment, newMap, backType, "freejump");
        this.freeJumpDataPush(task, comment, userId);
        return this.installReturnValue(userId, task.getProcessInstanceId(), task.getTaskDefinitionKey(), newMap);
    }

    public BpmResponseResult multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        if (assigneeList == null || assigneeList.size() < 1) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        int num = this.isMulti(task);
        if (num != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCantAddAssignee(), null);
        }
        String outTimeType = null;
        long dueTime = 0L;
        if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
            BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
            FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
            List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
            if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)timeOutStrategy)) {
                outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
            }
            dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
        }
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        variableMap.put("old_appoint_assignee", task.getTaskLocalVariables().get("old_appoint_assignee"));
        variableMap.put("complete_type", task.getTaskLocalVariables().get("complete_type"));
        Map newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), assigneeList, dueTime, outTimeType, variableMap));
        List list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId));
        if (list != null && list.size() != 0) {
            String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
            for (int i = list.size() - 1; i >= 0; --i) {
                if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                list.remove(i);
            }
            ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
            for (String receiveUser : assigneeList) {
                String newTaskId = (String)newTaskIdMap.get(receiveUser);
                for (SysActUrgeTask urgeTask : list) {
                    SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                    saveUrgeTask.setTaskId(newTaskId);
                    saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                    saveUrgeTask.setProcName(urgeTask.getProcName());
                    saveUrgeTask.setTaskName(urgeTask.getTaskName());
                    saveUrgeTask.setSendUser(urgeTask.getSendUser());
                    saveUrgeTask.setReceiveUser(receiveUser);
                    saveUrgeTask.setSendTime(urgeTask.getSendTime());
                    saveUrgeTask.setFormKey(urgeTask.getFormKey());
                    saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                    saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                    saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                    saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                    saveList.add(saveUrgeTask);
                }
            }
            this.sysActUrgeTaskService.saveBatch(saveList);
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult taskAddAssignee(String taskId, String assignees) {
        if (ToolUtil.isEmpty((Object)assignees)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        Task task = this.getTask(taskId, "1");
        int num = this.isMulti(task);
        if (num != 2) {
            this.entrustTask(taskId, assignees, 0);
        } else {
            List list;
            ArrayList<String> users = new ArrayList<String>(Arrays.asList(assignees.split(",")));
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(task.getTaskDefinitionKey())).list();
            for (Task runningTask : tasks) {
                if (!ToolUtil.isNotEmpty((Object)runningTask.getAssignee())) continue;
                users.remove(runningTask.getAssignee());
            }
            String outTimeType = null;
            long dueTime = 0L;
            if (ToolUtil.isNotEmpty((Object)task.getDueDate())) {
                BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
                FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(task.getTaskDefinitionKey());
                List timeOutStrategy = (List)element.getExtensionElements().get("TimeOutStrategy");
                if (ToolUtil.isNotEmpty((Object)task.getDueDate()) && ToolUtil.isNotEmpty((Object)timeOutStrategy)) {
                    outTimeType = ((ExtensionAttribute)((List)((ExtensionElement)timeOutStrategy.get(0)).getAttributes().get("TimeOutStrategy")).get(0)).getValue();
                }
                dueTime = task.getDueDate().getTime() - task.getCreateTime().getTime();
            }
            Map newTaskIdMap = null;
            if (ToolUtil.isNotEmpty(users)) {
                HashMap<String, Object> variableMap = new HashMap<String, Object>();
                variableMap.put("old_appoint_assignee", task.getTaskLocalVariables().get("old_appoint_assignee"));
                variableMap.put("complete_type", task.getTaskLocalVariables().get("complete_type"));
                newTaskIdMap = (Map)this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceAddAssigneeCmd(task.getExecutionId(), users, dueTime, outTimeType, variableMap));
            }
            if ((list = this.sysActUrgeTaskService.list((Wrapper)new LambdaQueryWrapper().eq(SysActUrgeTask::getTaskId, (Object)taskId))) != null && list.size() != 0) {
                String randomUser = ((SysActUrgeTask)list.get(0)).getReceiveUser();
                HashSet<String> set = new HashSet<String>();
                for (int i = list.size() - 1; i >= 0; --i) {
                    set.add(((SysActUrgeTask)list.get(i)).getReceiveUser());
                    if (((SysActUrgeTask)list.get(i)).getReceiveUser().equals(randomUser)) continue;
                    list.remove(i);
                }
                String[] receiveUsers = assignees.split(",");
                ArrayList<SysActUrgeTask> saveList = new ArrayList<SysActUrgeTask>();
                for (String receiveUser : receiveUsers) {
                    String newTaskId;
                    if (set.contains(receiveUser) || (newTaskId = (String)newTaskIdMap.get(receiveUser)) == null) continue;
                    for (SysActUrgeTask urgeTask : list) {
                        SysActUrgeTask saveUrgeTask = new SysActUrgeTask();
                        saveUrgeTask.setTaskId(newTaskId);
                        saveUrgeTask.setProcessInsId(urgeTask.getProcessInsId());
                        saveUrgeTask.setProcName(urgeTask.getProcName());
                        saveUrgeTask.setTaskName(urgeTask.getTaskName());
                        saveUrgeTask.setSendUser(urgeTask.getSendUser());
                        saveUrgeTask.setReceiveUser(receiveUser);
                        saveUrgeTask.setSendTime(urgeTask.getSendTime());
                        saveUrgeTask.setFormKey(urgeTask.getFormKey());
                        saveUrgeTask.setTaskDefKey(urgeTask.getTaskDefKey());
                        saveUrgeTask.setProcDefKey(urgeTask.getProcDefKey());
                        saveUrgeTask.setBusinessId(urgeTask.getBusinessId());
                        saveUrgeTask.setToDoConfig(urgeTask.getToDoConfig());
                        saveList.add(saveUrgeTask);
                    }
                }
                this.sysActUrgeTaskService.saveBatch(saveList);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult queryProcessNodeByTaskId(String taskId) {
        Task task = this.getTask(taskId, "0");
        JSONArray json = new JSONArray();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionId(task.getProcessDefinitionId()).singleResult();
        if (processDefinition == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
        }
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinition.getId());
        if (bpmnModel != null) {
            Collection flowElements = ((Process)bpmnModel.getProcesses().get(0)).getFlowElements();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof UserTask)) continue;
                JSONObject object = new JSONObject();
                object.put("id", (Object)flowElement.getId());
                object.put("name", (Object)flowElement.getName());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
    }

    public BpmResponseResult queryAssigneeByTaskId(String taskId) {
        JSONArray json = new JSONArray();
        Set<String> users = this.getAssigneeByTaskId(taskId);
        json.add(users);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult addAssignees(String taskId, String businessId, String users) {
        if (ToolUtil.isEmpty((Object)users)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getAppointAssigneesCanNotNull(), null);
        }
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(taskId, users));
            this.activityRedisTimerService.updateTimeOutModel(taskId, users, null, 0);
        } else {
            if (businessId == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
            if (tasks.size() == 0) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
            }
            for (Task task : tasks) {
                this.processEngine.getManagementService().executeCommand((Command)new AddAssigneeCmd(task.getId(), users));
                this.activityRedisTimerService.updateTimeOutModel(task.getId(), users, null, 0);
            }
        }
        return InstallResult.getResult((String)"1", (String)this.bpmConstantProperties.getAppointAssigneesSuccess(), null);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        Object level;
        String appointAssignees;
        Task task = this.getTask(taskId, "2");
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        map.put("bpm_submit_source", task.getTaskDefinitionKey());
        Object publicAppointAssignee = task.getProcessVariables().get("public_appoint_assignee");
        if (publicAppointAssignee != null && ToolUtil.isNotEmpty((Object)(appointAssignees = (String)((Map)publicAppointAssignee).get(nodeId)))) {
            HashSet<String> users = new HashSet<String>(Arrays.asList(appointAssignees.split(",")));
            JSONArray jsonArray = new JSONArray();
            if (users.size() > 0) {
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        if (ToolUtil.isNotEmpty((Object)task.getProcessVariables()) && (level = task.getProcessVariables().get("security_level")) != null) {
            map.put("security_level", level);
        }
        if (task == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (task.isSuspended()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        HashSet<String> users = AnalyticalModelUtil.getNextCandidateUser(task.getProcessInstanceId(), task.getProcessDefinitionId(), bm, nodeId, tenantId, map);
        if (users.size() > 0) {
            jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextAssigneeByTaskIdAndNodeId(String processKey, String taskId, String nodeId, String tenantId, Map<String, Object> map) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            return this.queryNextAssigneeByTaskIdAndNodeId(taskId, nodeId, tenantId, map);
        }
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            String processDefinitionId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
            if (bpmnModel == null) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
            }
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            StartEvent startEvent = new StartEvent();
            for (FlowElement flowElement : flowElements) {
                if (!(flowElement instanceof StartEvent)) continue;
                startEvent = (StartEvent)flowElement;
                break;
            }
            String taskDefinitionKey = null;
            List sequenceFlowList = startEvent.getOutgoingFlows();
            String targetRef = ((SequenceFlow)sequenceFlowList.get(0)).getTargetRef();
            FlowElement flowElement = process.getFlowElement(targetRef);
            if (flowElement instanceof UserTask) {
                taskDefinitionKey = flowElement.getId();
            }
            if (flowElement instanceof ExclusiveGateway) {
                taskDefinitionKey = null;
            }
            if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
            }
            if (map == null) {
                map = new HashMap<String, Object>();
            }
            map.put("bpm_submit_source", taskDefinitionKey);
            JSONArray jsonArray = new JSONArray();
            HashSet<String> users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bpmnModel, nodeId, tenantId, map);
            if (users.size() > 0) {
                jsonArray.addAll((Collection)this.iAssigneeChooseService.getUserListByUserIdWithSelect(new ArrayList<String>(users), tenantId));
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
    }

    public BpmResponseResult queryAllAssignee(String procDefinitionKey, String taskDefinitionKey) {
        Object users;
        JSONObject jsonObject;
        String tenantId = "";
        String processDefinitionId = this.processDefinitionsService.getMainOrNew(procDefinitionKey).getId();
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        HashSet<String> userIds = new HashSet<String>();
        JSONArray jsonArray = new JSONArray();
        if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask)) continue;
                jsonObject = new JSONObject();
                jsonObject.put("id", (Object)flowElement.getId());
                jsonObject.put("name", (Object)flowElement.getName());
                users = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), tenantId, new HashMap<String, Object>());
                userIds.addAll((Collection<String>)users);
                jsonObject.put("assignee", users);
                jsonArray.add((Object)jsonObject);
            }
        } else {
            boolean isContain = false;
            for (FlowElement flowElement : bm.getMainProcess().getFlowElements()) {
                if (!(flowElement instanceof UserTask) || !flowElement.getId().equals(taskDefinitionKey)) continue;
                isContain = true;
                JSONObject jsonObject2 = new JSONObject();
                jsonObject2.put("id", (Object)flowElement.getId());
                jsonObject2.put("name", (Object)flowElement.getName());
                HashSet<String> users2 = AnalyticalModelUtil.getNextCandidateUser(null, processDefinitionId, bm, flowElement.getId(), tenantId, new HashMap<String, Object>());
                userIds.addAll(users2);
                jsonObject2.put("assignee", users2);
                jsonArray.add((Object)jsonObject2);
            }
            if (!isContain) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNodeNotFound(), null);
            }
        }
        Map userMap = this.iAssigneeChooseService.getUserListByUserId(new ArrayList(userIds), tenantId);
        for (int i = 0; i < jsonArray.size(); ++i) {
            jsonObject = jsonArray.getJSONObject(i);
            users = jsonObject.getJSONArray("assignee");
            ArrayList user = new ArrayList();
            for (int j = 0; j < users.size(); ++j) {
                String userId = users.getString(j);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userId", userId);
                map.put("userName", (String)userMap.get(userId));
                user.add(map);
            }
            jsonObject.put("assignee", user);
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private Set<String> getAssigneeByTaskId(String taskId) {
        HashSet<String> users = new HashSet<String>();
        List identityLinkList = this.taskService.getIdentityLinksForTask(taskId);
        if (identityLinkList != null && identityLinkList.size() > 0) {
            for (IdentityLink identityLink : identityLinkList) {
                users.add(identityLink.getUserId());
            }
        }
        return users;
    }

    public ApiResponse<?> queryHistoryActByTaskId(String taskId, String processInsId) {
        JSONArray json = new JSONArray();
        String newProcessInstanceId = processInsId;
        if (newProcessInstanceId == null) {
            Task task = this.getTask(taskId, "0");
            newProcessInstanceId = task.getProcessInstanceId();
        }
        try {
            List list = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(newProcessInstanceId)).orderByHistoricTaskInstanceEndTime().finished().desc()).list();
            if (list != null && list.size() > 0) {
                for (HistoricTaskInstance historyIns : list) {
                    JSONObject object = new JSONObject();
                    String tId = historyIns.getId();
                    if (tId.equals(taskId)) continue;
                    object.put("nodeId", (Object)historyIns.getTaskDefinitionKey());
                    object.put("nodeName", (Object)historyIns.getName());
                    object.put("taskId", (Object)tId);
                    object.put("endTime", historyIns.getEndTime() == null ? null : Long.valueOf(historyIns.getEndTime().getTime()));
                    json.add((Object)object);
                }
            }
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("count", list.size());
            result.put("data", (Integer)json);
            return ApiResponse.success(result);
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u5386\u53f2\u73af\u8282\u4fe1\u606f\u63a5\u53e3\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            return ApiResponse.fail((String)e.getMessage());
        }
    }

    public ApiResponse<?> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        JSONObject object = new JSONObject();
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            DefinitionModel definitionModel = this.processDefinitionsService.getMainOrNew(processKey);
            if (definitionModel != null) {
                object.put("processDefinitionId", (Object)definitionModel.getId());
            }
        } else {
            Task task = this.getTask(taskId, "0");
            object.put("processDefinitionId", (Object)task.getProcessDefinitionId());
            object.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
        }
        return ApiResponse.success((Object)object);
    }

    public BpmResponseResult queryTaskIdByBusinessId(String businessId) {
        JSONArray json = new JSONArray();
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceBusinessKey(businessId)).list();
        if (tasks != null) {
            for (Task task : tasks) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("taskId", (Object)task.getId());
                jsonObject.put("taskDefinitionKey", (Object)task.getTaskDefinitionKey());
                jsonObject.put("name", (Object)task.getName());
                jsonObject.put("processInsId", (Object)task.getProcessInstanceId());
                json.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult queryNextNode(String taskId, boolean isGetRevokeNode) {
        Map variables;
        Task task = this.getTask(taskId, isGetRevokeNode ? "1" : "0");
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        Process process = (Process)bm.getProcesses().get(0);
        if (isGetRevokeNode && ToolUtil.isNotEmpty((Object)(variables = task.getTaskLocalVariables())) && ToolUtil.isNotEmpty(variables.get("reject_from"))) {
            String nodeId = String.valueOf(variables.get("reject_from"));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("id", (Object)nodeId);
            jsonObject.put("type", (Object)"userTask");
            jsonObject.put("name", (Object)process.getFlowElement(nodeId).getName());
            jsonArray.add((Object)jsonObject);
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        UserTask userTask = (UserTask)process.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        Map<String, Object> resultMap = new HashMap<String, Object>();
        if (process.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            resultMap = CommonCodeUtil.getGodAxeResult(null, (String)userTask.getId(), (String)historicProcessInstance.getBusinessKey(), (String)task.getProcessDefinitionId());
        }
        this.getUserTaskByCondition(jsonArray, process, sequenceFlows, ToolUtil.isNotEmpty(resultMap) ? resultMap : null);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, boolean isGetRevokeNode) {
        if (ToolUtil.isNotEmpty((Object)taskId)) {
            return this.queryNextNode(taskId, isGetRevokeNode);
        }
        JSONArray jsonArray = new JSONArray();
        if (ToolUtil.isNotEmpty((Object)processKey)) {
            String procDefId = this.processDefinitionsService.getMainOrNew(processKey).getId();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(procDefId);
            Process process = bpmnModel.getMainProcess();
            Collection flowElements = process.getFlowElements();
            for (FlowElement flowElement : flowElements) {
                List startOut;
                String firstUserTask;
                if (!(flowElement instanceof StartEvent) || !(process.getFlowElement(firstUserTask = ((SequenceFlow)(startOut = ((StartEvent)flowElement).getOutgoingFlows()).get(0)).getTargetRef()) instanceof UserTask)) continue;
                UserTask userTask = (UserTask)process.getFlowElement(firstUserTask);
                List sequenceFlows = userTask.getOutgoingFlows();
                HashMap<String, Object> resultMap = new HashMap();
                if (process.getFlowElement(((SequenceFlow)sequenceFlows.get(0)).getTargetRef()) instanceof Gateway) {
                    resultMap = CommonCodeUtil.getGodAxeResult(null, (String)userTask.getId(), (String)"", (String)procDefId);
                }
                this.getUserTaskByCondition(jsonArray, process, sequenceFlows, ToolUtil.isNotEmpty(resultMap) ? resultMap : null);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), (JSONArray)jsonArray);
    }

    public BpmResponseResult queryNextNode(String processKey, String taskId, Map<String, Object> lineCondition) {
        if (ToolUtil.isEmpty((Object)taskId)) {
            return this.queryNextNode(processKey, taskId, false);
        }
        Task task = this.getTask(taskId, "0");
        JSONArray jsonArray = new JSONArray();
        BpmnModel bm = this.repositoryService.getBpmnModel(task.getProcessDefinitionId());
        if (bm == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getModelNotFound(), null);
        }
        Process process = (Process)bm.getProcesses().get(0);
        UserTask userTask = (UserTask)process.getFlowElement(task.getTaskDefinitionKey());
        if (userTask == null) {
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
        }
        List sequenceFlows = userTask.getOutgoingFlows();
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        Map visitorMap = CommonCodeUtil.getGodAxeResult(null, (String)task.getTaskDefinitionKey(), (String)hpi.getBusinessKey(), (String)task.getProcessDefinitionId());
        visitorMap.putAll(lineCondition);
        return this.getUserTaskByCondition(jsonArray, process, sequenceFlows, visitorMap);
    }

    private BpmResponseResult getUserTaskByCondition(JSONArray jsonArray, Process process, List<SequenceFlow> sfs, Map<String, Object> visitorMap) {
        if (sfs != null && sfs.size() > 0) {
            for (SequenceFlow sequenceFlow : sfs) {
                ServiceTask p;
                ArrayList<Object> seqList;
                Object valueExpression;
                SimpleContext context;
                ExpressionFactoryImpl factory;
                ArrayList<SequenceFlow> defaultList;
                List sequenceFlowsList;
                Gateway gateway;
                UserTask u;
                JSONObject jsonObject;
                String targetRef = sequenceFlow.getTargetRef();
                if (process.getFlowElement(targetRef) instanceof UserTask) {
                    jsonObject = new JSONObject();
                    u = (UserTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"userTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof EndEvent) {
                    jsonObject = new JSONObject();
                    u = (EndEvent)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"endEvent");
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                    gateway = (Gateway)process.getFlowElement(targetRef);
                    sequenceFlowsList = gateway.getOutgoingFlows();
                    boolean flag = true;
                    defaultList = new ArrayList<SequenceFlow>();
                    for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                        if (sequenceFlows.getConditionExpression() != null) {
                            factory = new ExpressionFactoryImpl();
                            context = new SimpleContext();
                            if (visitorMap != null && visitorMap.size() > 0) {
                                for (String k : visitorMap.keySet()) {
                                    if (visitorMap.get(k.toString()) != null) {
                                        context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), visitorMap.get(k.toString()).getClass()));
                                        continue;
                                    }
                                    context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), Object.class));
                                }
                            }
                            if ((valueExpression = factory.createValueExpression((ELContext)context, sequenceFlows.getConditionExpression(), Boolean.TYPE)).getExpressionString().contains("bpm_next_node")) {
                                seqList = new ArrayList<SequenceFlow>();
                                seqList.add(sequenceFlows);
                                this.getUserTaskByCondition(jsonArray, process, seqList, visitorMap);
                                continue;
                            }
                            if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                            if (!flag && process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                                jsonArray.remove(0);
                                return InstallResult.getResult((String)"0", (String)"\u6d41\u7a0b\u6761\u4ef6\u914d\u7f6e\u4e0d\u6b63\u786e!", (JSONArray)jsonArray);
                            }
                            flag = false;
                            seqList = new ArrayList();
                            seqList.add(sequenceFlows);
                            this.getUserTaskByCondition(jsonArray, process, seqList, visitorMap);
                            continue;
                        }
                        defaultList.add(sequenceFlows);
                    }
                    if (flag) {
                        this.getUserTaskByCondition(jsonArray, process, defaultList, visitorMap);
                    }
                }
                if (process.getFlowElement(targetRef) instanceof InclusiveGateway) {
                    gateway = (Gateway)process.getFlowElement(targetRef);
                    sequenceFlowsList = gateway.getOutgoingFlows();
                    boolean flag = true;
                    defaultList = new ArrayList();
                    for (SequenceFlow sequenceFlows : sequenceFlowsList) {
                        if (sequenceFlows.getConditionExpression() != null) {
                            factory = new ExpressionFactoryImpl();
                            context = new SimpleContext();
                            if (visitorMap.size() > 0) {
                                valueExpression = visitorMap.keySet().iterator();
                                while (valueExpression.hasNext()) {
                                    String k;
                                    k = valueExpression.next();
                                    if (visitorMap.get(k.toString()) != null) {
                                        context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), visitorMap.get(k.toString()).getClass()));
                                        continue;
                                    }
                                    context.setVariable(k.toString(), factory.createValueExpression(visitorMap.get(k.toString()), Object.class));
                                }
                            }
                            if ((valueExpression = factory.createValueExpression((ELContext)context, sequenceFlows.getConditionExpression(), Boolean.TYPE)).getExpressionString().contains("bpm_next_node")) {
                                seqList = new ArrayList();
                                seqList.add(sequenceFlows);
                                this.getUserTaskByCondition(jsonArray, process, seqList, visitorMap);
                                continue;
                            }
                            if (!((Boolean)valueExpression.getValue((ELContext)context)).booleanValue()) continue;
                            seqList = new ArrayList();
                            seqList.add(sequenceFlows);
                            this.getUserTaskByCondition(jsonArray, process, seqList, visitorMap);
                            continue;
                        }
                        defaultList.add(sequenceFlows);
                    }
                    this.getUserTaskByCondition(jsonArray, process, defaultList, visitorMap);
                }
                if (process.getFlowElement(targetRef) instanceof CallActivity) {
                    CallActivity callActivity = (CallActivity)process.getFlowElement(targetRef);
                    JSONObject jsonObject2 = new JSONObject();
                    jsonObject2.put("id", (Object)callActivity.getId());
                    jsonObject2.put("name", (Object)callActivity.getName());
                    jsonObject2.put("type", (Object)"callActivity");
                    jsonArray.add((Object)jsonObject2);
                }
                if (process.getFlowElement(targetRef) instanceof ParallelGateway) {
                    ParallelGateway p2 = (ParallelGateway)process.getFlowElement(targetRef);
                    this.getUserTaskByCondition(jsonArray, process, p2.getOutgoingFlows(), visitorMap);
                }
                if (process.getFlowElement(targetRef) instanceof ServiceTask) {
                    jsonObject = new JSONObject();
                    p = (ServiceTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)p.getId());
                    jsonObject.put("name", (Object)p.getName());
                    jsonObject.put("type", (Object)"serviceTask");
                    jsonArray.add((Object)jsonObject);
                }
                if (!(process.getFlowElement(targetRef) instanceof ReceiveTask)) continue;
                jsonObject = new JSONObject();
                p = (ReceiveTask)process.getFlowElement(targetRef);
                jsonObject.put("id", (Object)p.getId());
                jsonObject.put("name", (Object)p.getName());
                jsonObject.put("type", (Object)"receiveTask");
                jsonArray.add((Object)jsonObject);
            }
        }
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)jsonArray);
    }

    private static SimpleContext getVariables(Map<String, Object> map) {
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        SimpleContext context = new SimpleContext();
        if (map != null && map.size() > 0) {
            for (String k : map.keySet()) {
                if (map.get(k.toString()) == null) continue;
                context.setVariable(k.toString(), factory.createValueExpression(map.get(k.toString()), map.get(k.toString()).getClass()));
            }
        }
        return context;
    }

    private void getUserTask(JSONArray jsonArray, Process process, List<SequenceFlow> sfs) {
        if (sfs != null && sfs.size() > 0) {
            for (SequenceFlow sequenceFlow : sfs) {
                ParallelGateway p;
                List sequenceFlows;
                ExclusiveGateway exclusiveGateway;
                UserTask u;
                JSONObject jsonObject;
                String targetRef = sequenceFlow.getTargetRef();
                if (process.getFlowElement(targetRef) instanceof UserTask) {
                    jsonObject = new JSONObject();
                    u = (UserTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"UserTask");
                    String allowSetParticipantRepetition = "";
                    if (u.getExtensionElements().get("allowSetParticipant") != null) {
                        allowSetParticipantRepetition = ((ExtensionAttribute)((List)((ExtensionElement)((List)u.getExtensionElements().get("allowSetParticipant")).get(0)).getAttributes().get("allowSetParticipant")).get(0)).getValue();
                    }
                    jsonObject.put("allowSetParticipant", (Object)allowSetParticipantRepetition);
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof EndEvent) {
                    jsonObject = new JSONObject();
                    u = (EndEvent)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)u.getId());
                    jsonObject.put("name", (Object)u.getName());
                    jsonObject.put("type", (Object)"EndEvent");
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ExclusiveGateway) {
                    exclusiveGateway = (ExclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof InclusiveGateway) {
                    exclusiveGateway = (InclusiveGateway)process.getFlowElement(targetRef);
                    sequenceFlows = exclusiveGateway.getOutgoingFlows();
                    this.getUserTask(jsonArray, process, sequenceFlows);
                }
                if (process.getFlowElement(targetRef) instanceof CallActivity) {
                    CallActivity callActivity = (CallActivity)process.getFlowElement(targetRef);
                    JSONObject jsonObject2 = new JSONObject();
                    jsonObject2.put("id", (Object)callActivity.getId());
                    jsonObject2.put("name", (Object)callActivity.getName());
                    jsonObject2.put("type", (Object)"CallActivity");
                    jsonArray.add((Object)jsonObject2);
                }
                if (process.getFlowElement(targetRef) instanceof ParallelGateway) {
                    jsonObject = new JSONObject();
                    p = (ParallelGateway)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)p.getId());
                    jsonObject.put("name", (Object)p.getName());
                    jsonObject.put("type", (Object)"ParallelGateway");
                    jsonArray.add((Object)jsonObject);
                }
                if (process.getFlowElement(targetRef) instanceof ServiceTask) {
                    jsonObject = new JSONObject();
                    p = (ServiceTask)process.getFlowElement(targetRef);
                    jsonObject.put("id", (Object)p.getId());
                    jsonObject.put("name", (Object)p.getName());
                    jsonObject.put("type", (Object)"ServiceTask");
                    jsonArray.add((Object)jsonObject);
                }
                if (!(process.getFlowElement(targetRef) instanceof ReceiveTask)) continue;
                jsonObject = new JSONObject();
                p = (ReceiveTask)process.getFlowElement(targetRef);
                jsonObject.put("id", (Object)p.getId());
                jsonObject.put("name", (Object)p.getName());
                jsonObject.put("type", (Object)"ReceiveTask");
                jsonArray.add((Object)jsonObject);
            }
        }
    }

    public BpmResponseResult withdrawState(String historicTaskId) {
        ProcessInstance instance;
        if (historicTaskId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        JSONArray json = new JSONArray();
        boolean result = true;
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        if (currTask == null) {
            LOGGER.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (ToolUtil.isEmpty((Object)currTask.getEndTime())) {
            LOGGER.error(this.bpmConstantProperties.getCurrentTaskCannotRevoke());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCurrentTaskCannotRevoke(), null);
        }
        if ("skip".equals(currTask.getTaskLocalVariables().get("taskSourceFlag"))) {
            result = false;
        }
        if ((instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult()) == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessEnd());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessEnd(), null);
        }
        if (instance.isSuspended()) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskIsSuspended(), null);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        map.put("processInsId", currTask.getProcessInstanceId());
        map.put("endTime", formatter.format(currTask.getEndTime()));
        map.put("taskDefinitionKey", currTask.getTaskDefinitionKey());
        map.put("dbType", this.druidProperties.getUrl().split(":")[1]);
        map.put("isEnd", "true");
        if (!"0".equals(this.taskEngineMapper.withdrawState(map))) {
            result = false;
        }
        map.put("isEnd", "false");
        if ("0".equals(this.taskEngineMapper.withdrawState(map))) {
            result = false;
        }
        json.add((Object)result);
        return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
    }

    public BpmResponseResult revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(historicTaskId)).includeTaskLocalVariables()).singleResult();
        if (currTask == null) {
            LOGGER.error(this.bpmConstantProperties.getTaskNotFound());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (ToolUtil.isEmpty((Object)currTask.getEndTime())) {
            LOGGER.error(this.bpmConstantProperties.getCurrentTaskCannotRevoke());
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getCurrentTaskCannotRevoke(), null);
        }
        String taskSourceFlag = (String)currTask.getTaskLocalVariables().get("taskSourceFlag");
        boolean revokeReject = false;
        if ("reject".equals(taskSourceFlag)) {
            revokeReject = true;
        }
        if ("revoke".equals(taskSourceFlag) || "reject_revoke".equals(taskSourceFlag)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidRevoke(), null);
        }
        boolean isCallReject = false;
        List taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(currTask.getProcessInstanceId())).taskVariableValueLike(revokeReject ? "reject_from" : "complete_from", currTask.getTaskDefinitionKey())).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
        if (ToolUtil.isEmpty((Object)taskList)) {
            List list = this.historyService.createHistoricActivityInstanceQuery().unfinished().processInstanceId(currTask.getProcessInstanceId()).activityType("callActivity").list();
            ArrayList<String> procIds = new ArrayList<String>();
            for (HistoricActivityInstance historicActivityInstance : list) {
                procIds.add(historicActivityInstance.getCalledProcessInstanceId());
            }
            if (procIds.size() > 0) {
                isCallReject = true;
                taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(procIds)).taskVariableValueEquals(revokeReject ? "main_reject_from" : "call_complete_from", (Object)currTask.getTaskDefinitionKey())).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
                if (taskList.size() == 0 && !revokeReject) {
                    taskList = ((TaskQuery)((TaskQuery)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceIdIn(procIds)).taskVariableValueEquals("complete_from", (Object)currTask.getTaskDefinitionKey())).includeProcessVariables()).includeTaskLocalVariables()).listPage(0, 1);
                }
            }
        }
        if (taskList != null && taskList.size() > 0) {
            int backType;
            String backActivityId;
            Task task = (Task)taskList.get(0);
            task.setAssignee(userId);
            boolean isFirst = false;
            String starterUserId = "";
            if (revokeReject) {
                Map variables = task.getTaskLocalVariables() == null ? new HashMap(16) : task.getTaskLocalVariables();
                backActivityId = isCallReject ? "main_process_" + variables.get("main_reject_from").toString() : variables.get("reject_from").toString();
            } else {
                backActivityId = this.getLastActivityId(task);
            }
            if ("".equals(backActivityId)) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidRevoke(), null);
            }
            Map<String, Object> results = this.backType(task, backActivityId, false, userId, comment, revokeReject ? "reject_revoke" : "revoke");
            String processInsId = (String)results.get("processInsId");
            String processDefinitionId = (String)results.get("processDefinitionId");
            String taskDefinitionKey = (String)results.get("taskDefinitionKey");
            if (backActivityId != null) {
                String nodeId;
                BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
                String string = nodeId = backActivityId.startsWith("main_process_") ? backActivityId.substring("main_process_".length()) : backActivityId;
                if (!this.canReject(bm, taskDefinitionKey, nodeId, null, null, true) && !this.canReject(bm, taskDefinitionKey, nodeId, null, null, false)) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRevokeToTargetNode(), null);
                }
            }
            if (backActivityId != null && (backActivityId.equals(this.getFirstActivityId(processInsId, taskDefinitionKey)) || backActivityId.equals("main_process_" + this.getFirstActivityId(processInsId, taskDefinitionKey)))) {
                starterUserId = this.getTaskStarterUserId(task.getProcessInstanceId());
                isFirst = true;
            }
            if ((backType = ((Integer)results.get("num")).intValue()) == 0) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getForbidRevoke(), null);
            }
            if (backType == 4) {
                return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotRevokeToTargetNode(), null);
            }
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            if (map != null) {
                newMap.putAll(map);
            }
            if (isSubmit) {
                if (revokeReject) {
                    List lastCommitList = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(task.getProcessInstanceId())).taskDefinitionKey(backActivityId)).taskVariableValueEquals("complete_type", (Object)"complete")).includeTaskLocalVariables()).orderByHistoricTaskInstanceEndTime().desc()).listPage(0, 1);
                    newMap.put("appoint_assignee", ((HistoricTaskInstance)lastCommitList.get(0)).getTaskLocalVariables().get("old_appoint_assignee"));
                } else {
                    newMap.put("reject_appoint_assignee", this.getTaskCommitUser((String)results.get("processInstanceId"), backActivityId));
                }
            }
            if (backType == 3) {
                this.callActivitiReject((List)results.get("affectedTasks"), (Set)results.get("runningActivitiNodeIds"), processInsId, userId, null, null);
                newMap.put("affectedTasks", results.get("affectedTasks"));
            }
            if (backActivityId.startsWith("main_process_")) {
                newMap.put("executionId", results.get("executionId"));
                newMap.put("processInsId", processInsId);
                newMap.put("processDefinitionId", processDefinitionId);
                newMap.put("taskDefinitionKey", taskDefinitionKey);
            }
            this.rejectTask(userId, task, backActivityId, comment, newMap, backType, revokeReject ? "reject_revoke" : "revoke");
            BpmResponseResult result = this.installRejectReturnValue(processInsId, isFirst, starterUserId, backActivityId, userId, taskDefinitionKey, revokeReject ? "reject_revoke" : "revoke", (String)results.get("taskName"), task.getTaskDefinitionKey(), task.getName());
            this.revokeDataPush(task, comment, userId);
            return result;
        }
        return InstallResult.getResult((String)"0", (String)"error", null);
    }

    private String getTaskStarterUserId(String processInsId) {
        String starterUserId = "";
        HistoricProcessInstance hpi = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
        if (hpi != null) {
            starterUserId = hpi.getStartUserId();
        }
        return starterUserId;
    }

    private int isMulti(Task task) {
        int num = 1;
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessNotFound());
            return 0;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        return num;
    }

    private Map<String, Object> backType(Task task, String nodeId, boolean isRejectFirst, String userId, String comment, String type) {
        Map<String, Object> result = this.getBackTypeWithTasks(nodeId, task, isRejectFirst, userId, comment, type);
        int num = (Integer)result.get("num");
        if (nodeId.startsWith("main_process_")) {
            result.put("num", 3);
            return result;
        }
        if (num != 1) {
            return result;
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        if (instance == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessEnd());
            num = 0;
            result.put("num", num);
            return result;
        }
        ProcessDefinitionEntity definition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(task.getProcessDefinitionId());
        if (definition == null) {
            LOGGER.error(this.bpmConstantProperties.getProcessNotFound());
            num = 0;
            result.put("num", num);
            return result;
        }
        ActivityImpl currActivity = definition.findActivity(task.getTaskDefinitionKey());
        if (currActivity == null) {
            throw new PublicClientException(this.bpmConstantProperties.getRunningNodeNotFound(), Boolean.valueOf(false));
        }
        ActivityBehavior activityBehavior = currActivity.getActivityBehavior();
        if (nodeId == null) {
            List incomingTransitions = currActivity.getIncomingTransitions();
            for (PvmTransition pvmTransition : incomingTransitions) {
                PvmActivity pvmActivity = pvmTransition.getSource();
                ActivityBehavior inActivity = ((ActivityImpl)pvmActivity).getActivityBehavior();
                if (!(inActivity instanceof ParallelGatewayActivityBehavior) && !(inActivity instanceof InclusiveGatewayActivityBehavior) || pvmActivity.getIncomingTransitions().size() <= 1) continue;
                num = 0;
                result.put("num", num);
                return result;
            }
        }
        if (activityBehavior instanceof ParallelMultiInstanceBehavior || activityBehavior instanceof SequentialMultiInstanceBehavior) {
            num = 2;
        }
        result.put("num", num);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, Object> getBackTypeWithTasks(String nodeId, Task task, boolean isRejectFirst, String userId, String comment, String type) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<Object> affectedTasks = new ArrayList<String>();
        int newNum = 1;
        ArrayList<String> taskIds = new ArrayList<String>();
        HashSet<String> runningNodeIds = new HashSet<String>();
        ArrayList<String> finishedNodeIds = new ArrayList<String>();
        HashSet<String> runningActivitiNodeIds = new HashSet<String>();
        String processInsId = task.getProcessInstanceId();
        String processDefinitionId = task.getProcessDefinitionId();
        String taskDefinitionKey = task.getTaskDefinitionKey();
        String taskName = task.getName();
        if (nodeId.startsWith("main_process_")) {
            nodeId = nodeId.substring("main_process_".length());
            HistoricProcessInstance processInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).singleResult();
            if (processInstance.getSuperProcessInstanceId() == null) {
                throw new PublicClientException("\u8be5\u6d41\u7a0b\u6ca1\u6709\u4e3b\u6d41\u7a0b");
            }
            Iterator list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstance.getSuperProcessInstanceId()).unfinished().activityType("callActivity").list();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)iterator.next();
                runningActivitiNodeIds.add(historicActivityInstance.getActivityId());
                if (!historicActivityInstance.getCalledProcessInstanceId().equals(processInsId)) continue;
                taskDefinitionKey = historicActivityInstance.getActivityId();
                processDefinitionId = historicActivityInstance.getProcessDefinitionId();
                processInsId = processInstance.getSuperProcessInstanceId();
                taskName = historicActivityInstance.getActivityName();
                result.put("executionId", historicActivityInstance.getExecutionId());
            }
        } else {
            List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().activityType("callActivity").list();
            for (HistoricActivityInstance historicActivityInstance : list) {
                runningActivitiNodeIds.add(historicActivityInstance.getActivityId());
            }
        }
        result.put("runningActivitiNodeIds", runningActivitiNodeIds);
        result.put("processInsId", processInsId);
        result.put("processDefinitionId", processDefinitionId);
        result.put("taskDefinitionKey", taskDefinitionKey);
        result.put("taskName", taskName);
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInsId)).list();
        for (Task runningTask : tasks) {
            runningNodeIds.add(runningTask.getTaskDefinitionKey());
        }
        BpmnModel bm = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bm.getProcesses().get(0);
        List executions = this.runtimeService.createExecutionQuery().processInstanceId(processInsId).list();
        ArrayList<String> finishedExcutionIds = new ArrayList<String>();
        for (Execution execution : executions) {
            if ((((ExecutionEntity)execution).isScope() || execution.getActivityId() == null) && !(process.getFlowElement(execution.getActivityId()) instanceof CallActivity)) continue;
            if (!runningNodeIds.contains(execution.getActivityId()) && !runningActivitiNodeIds.contains(execution.getActivityId())) {
                finishedExcutionIds.add(execution.getId());
                continue;
            }
            taskIds.add(execution.getActivityId());
        }
        if (finishedExcutionIds.size() > 0) {
            void var24_28;
            List activityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(task.getProcessInstanceId()).orderByHistoricActivityInstanceStartTime().desc()).list();
            boolean bl = false;
            while (var24_28 < activityInstances.size()) {
                if (finishedExcutionIds.contains(((HistoricActivityInstance)activityInstances.get((int)var24_28)).getExecutionId()) && ("parallelGateway".equals(((HistoricActivityInstance)activityInstances.get((int)var24_28)).getActivityType()) || "inclusiveGateway".equals(((HistoricActivityInstance)activityInstances.get((int)var24_28)).getActivityType()))) {
                    Date date = ((HistoricActivityInstance)activityInstances.get((int)(var24_28 + true))).getStartTime();
                    for (void j = var24_28 + true; j < activityInstances.size(); ++j) {
                        if (((HistoricActivityInstance)activityInstances.get((int)j)).getEndTime().getTime() >= ((HistoricActivityInstance)activityInstances.get((int)var24_28)).getStartTime().getTime() || j != var24_28 + true && ((HistoricActivityInstance)activityInstances.get((int)j)).getEndTime().getTime() <= date.getTime()) continue;
                        finishedNodeIds.add(((HistoricActivityInstance)activityInstances.get((int)j)).getActivityId());
                        taskIds.add(((HistoricActivityInstance)activityInstances.get((int)j)).getActivityId());
                        finishedExcutionIds.remove(((HistoricActivityInstance)activityInstances.get((int)var24_28)).getExecutionId());
                        break;
                    }
                    if (finishedExcutionIds.size() == 0) break;
                }
                ++var24_28;
            }
        }
        if ((taskIds = new ArrayList(new HashSet(taskIds))).size() > 1) {
            if (isRejectFirst) {
                result.put("affectedTasks", taskIds);
                result.put("num", 3);
                if (finishedNodeIds.size() > 0) {
                    result.put("num", 4);
                }
                return result;
            }
            if (ToolUtil.isEmpty((Object)process.getFlowElement(nodeId))) {
                throw new PublicClientException(this.bpmConstantProperties.getNodeNotFound(), Boolean.valueOf(false));
            }
            boolean isFindTask = false;
            affectedTasks = this.findAffectedTask(process, nodeId, true, taskIds);
            if (affectedTasks.contains(taskDefinitionKey)) {
                isFindTask = true;
                affectedTasks.remove(taskDefinitionKey);
            }
            if (affectedTasks.size() > 0) {
                newNum = 3;
            }
            if (!isFindTask) {
                void var24_31;
                ArrayList arrayList = new ArrayList();
                if (affectedTasks.size() > 0) {
                    List<Object> list = affectedTasks;
                }
                if ((affectedTasks = this.findAffectedTask(process, nodeId, false, taskIds)).contains(taskDefinitionKey)) {
                    isFindTask = true;
                    affectedTasks.remove(taskDefinitionKey);
                }
                if (affectedTasks.size() > 0) {
                    newNum = 3;
                }
                if (!isFindTask && affectedTasks.size() + var24_31.size() > 0) {
                    newNum = -1;
                }
            }
        }
        affectedTasks.add(taskDefinitionKey);
        if (newNum == 3) {
            for (String string : affectedTasks) {
                if (!finishedNodeIds.contains(string)) continue;
                newNum = 4;
                break;
            }
        }
        result.put("affectedTasks", affectedTasks);
        result.put("num", newNum);
        return result;
    }

    private void callActivitiReject(List<String> nodeIds, Set<String> callActivitiNodeIds, String processInsId, String userId, String comment, String type) {
        ArrayList<String> ids = new ArrayList<String>();
        for (String nodeId : nodeIds) {
            if (!callActivitiNodeIds.remove(nodeId)) continue;
            ids.add(nodeId);
        }
        if (ids.size() == 0) {
            return;
        }
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).unfinished().activityType("callActivity").list();
        for (HistoricActivityInstance historicActivityInstance : list) {
            if (!ids.contains(historicActivityInstance.getActivityId())) continue;
            CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, comment, type);
            CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
        }
    }

    private void endCallProcess(String instanceId, String userId, String comment, String type) {
        List list = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instanceId).unfinished().list();
        if (list.size() > 0) {
            for (HistoricActivityInstance historicActivityInstance : list) {
                if (!"callActivity".equals(historicActivityInstance.getActivityType())) continue;
                CALL_REJECT_LIST.add(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
                this.endCallProcess(historicActivityInstance.getCalledProcessInstanceId(), userId, comment, type);
                CALL_REJECT_LIST.remove(historicActivityInstance.getProcessInstanceId() + historicActivityInstance.getActivityId());
            }
            HistoricActivityInstance historicActivityInstance = (HistoricActivityInstance)list.get(0);
            ActivityImpl destinationActivity = null;
            ActivityImpl currentActivity = null;
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicActivityInstance.getProcessDefinitionId());
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (pvmTransitionList.isEmpty()) {
                    destinationActivity = activityImpl;
                }
                if (!activityImpl.getId().equals(historicActivityInstance.getActivityId())) continue;
                currentActivity = activityImpl;
            }
            if (destinationActivity == null) {
                throw new PublicClientException(this.bpmConstantProperties.getEndNodeNotFound(), Boolean.valueOf(false));
            }
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, historicActivityInstance.getExecutionId(), destinationActivity, type, comment, new HashMap<String, Object>(), currentActivity));
        }
    }

    private List<String> findAffectedTask(Process process, String nodeId, boolean isGoToNext, List<String> taskIds) {
        ArrayList<FlowElement> flowElements = new ArrayList<FlowElement>();
        ArrayList<String> affectedTasks = new ArrayList<String>();
        flowElements.add(process.getFlowElement(nodeId));
        HashSet<FlowElement> list = new HashSet<FlowElement>();
        for (int i = 0; i < flowElements.size(); ++i) {
            FlowElement flowElement = (FlowElement)flowElements.get(i);
            if (!list.add(flowElement)) continue;
            if (taskIds.contains(flowElement.getId())) {
                affectedTasks.add(flowElement.getId());
                continue;
            }
            if (flowElement instanceof EndEvent || flowElement instanceof StartEvent || !(flowElement instanceof FlowNode)) continue;
            if (isGoToNext) {
                for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getOutgoingFlows()) {
                    flowElements.add(process.getFlowElement(sequenceFlow.getTargetRef()));
                }
                continue;
            }
            for (SequenceFlow sequenceFlow : ((FlowNode)flowElement).getIncomingFlows()) {
                flowElements.add(process.getFlowElement(sequenceFlow.getSourceRef()));
            }
        }
        return affectedTasks;
    }

    public BpmResponseResult editTaskComment(String taskId, String comment) {
        if (taskId == null) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (ToolUtil.isEmpty((Object)historicTaskInstance)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getTaskNotFound(), null);
        }
        if (ToolUtil.isEmpty((Object)historicTaskInstance.getEndTime())) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getUnfinishedTaskCanNotEditComment(), null);
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(TaskComment::getTaskId, (Object)taskId)).eq(TaskComment::getType, (Object)"complete")).eq(TaskComment::getAction, (Object)"AddComment");
        this.taskCommentService.saveOrUpdate((Object)new TaskComment(taskId, comment, comment.getBytes()), (Wrapper)queryWrapper);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private boolean canReject(BpmnModel bm, String startNodeId, String nodeId, List<String> nodes, List<String> freeJumpList, boolean isPre) {
        FlowElement element = ((Process)bm.getProcesses().get(0)).getFlowElement(startNodeId);
        ArrayList<String> newNodes = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(nodes)) {
            newNodes.addAll(nodes);
        }
        if (element instanceof ParallelGateway || element instanceof InclusiveGateway) {
            boolean isFreeJump = freeJumpList != null;
            boolean canFreeJump = true;
            for (SequenceFlow sequenceFlow : isPre ? ((Gateway)element).getIncomingFlows() : ((Gateway)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList == null) continue;
                    freeJumpList.add(nodeId);
                    continue;
                }
                newNodes.add(preNode);
                if (this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                if (isFreeJump) {
                    canFreeJump = false;
                    continue;
                }
                return false;
            }
            return canFreeJump;
        }
        if (!(element instanceof StartEvent) && !(element instanceof EndEvent)) {
            for (SequenceFlow sequenceFlow : isPre ? ((FlowNode)element).getIncomingFlows() : ((FlowNode)element).getOutgoingFlows()) {
                String preNode = isPre ? sequenceFlow.getSourceRef() : sequenceFlow.getTargetRef();
                if (newNodes.contains(preNode)) continue;
                if (nodeId.equals(preNode)) {
                    if (freeJumpList != null) {
                        freeJumpList.add(nodeId);
                    }
                    return true;
                }
                newNodes.add(preNode);
                if (!this.canReject(bm, preNode, nodeId, newNodes, freeJumpList, isPre)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public BpmResponseResult multiInstanceDelAssignee(String taskId, String assignees) {
        Task task = this.getTask(taskId, "0");
        if (this.isMulti(task) != 2) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotMultiCanDelAssignee(), null);
        }
        if (assignees == null) {
            assignees = "";
        }
        if ((assignees == null || "".equals(assignees)) && task.getDueDate() != null) {
            this.activityRedisTimerService.delTimeOutModel(taskId);
        }
        this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(task.getExecutionId(), taskId, Arrays.asList(assignees.split(","))));
        this.installReturnValue("", task.getProcessInstanceId(), task.getTaskDefinitionKey(), new HashMap<String, Object>());
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public Map<String, Integer> updateRejectForm(Map<String, Object> map) {
        List nodeIds = (List)map.get("nodeIds");
        String procDefId = (String)map.get("procDefId");
        List delNodeIds = (List)map.get("delNodeIds");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List list = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processDefinitionId(procDefId).unfinished().orderByActivityId().asc()).list();
        HashSet<String> instanceIds = new HashSet<String>();
        if (list.size() == 0) {
            return result;
        }
        String taskDefKey = ((HistoricActivityInstance)list.get(0)).getActivityId();
        HashSet<String> nodeInstanceId = new HashSet<String>();
        HashSet<String> allInstanceIds = new HashSet<String>();
        int processNumAll = 0;
        for (HistoricActivityInstance activityInstance : list) {
            instanceIds.add(activityInstance.getProcessInstanceId());
            if (!delNodeIds.contains(activityInstance.getActivityId())) continue;
            Object num = (Integer)result.get(activityInstance.getActivityId());
            if (num == null) {
                num = 0;
            }
            if (!taskDefKey.equals(activityInstance.getActivityId())) {
                nodeInstanceId = new HashSet();
                taskDefKey = activityInstance.getActivityId();
            }
            if (nodeInstanceId.add(activityInstance.getProcessInstanceId())) {
                Object object = num;
                Object object2 = num = Integer.valueOf((Integer)num + 1);
                result.put(activityInstance.getActivityId(), (Integer)num);
            }
            if (!allInstanceIds.add(activityInstance.getProcessInstanceId())) continue;
            ++processNumAll;
        }
        if (processNumAll > 0) {
            result.put("", processNumAll);
            return result;
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceIdIn(new ArrayList(instanceIds))).includeTaskLocalVariables()).orderByProcessInstanceId()).orderByTaskCreateTime()).asc()).list();
        HashMap<String, ArrayList<HistoricTaskInstance>> hisTaskMap = new HashMap<String, ArrayList<HistoricTaskInstance>>();
        for (HistoricTaskInstance historicTaskInstance : historicTaskInstances) {
            ArrayList<HistoricTaskInstance> hisTasks = (ArrayList<HistoricTaskInstance>)hisTaskMap.get(historicTaskInstance.getProcessInstanceId());
            if (hisTasks == null) {
                hisTasks = new ArrayList<HistoricTaskInstance>();
            }
            hisTasks.add(historicTaskInstance);
            hisTaskMap.put(historicTaskInstance.getProcessInstanceId(), hisTasks);
        }
        HashMap<String, List<String>> finishTaskId = new HashMap<String, List<String>>();
        HashMap<String, List<String>> unFinishTaskId = new HashMap<String, List<String>>();
        for (List hisTasks : hisTaskMap.values()) {
            for (int i = 0; i < hisTasks.size(); ++i) {
                ArrayList<String> taskIds;
                HistoricTaskInstance historicTaskInstance = (HistoricTaskInstance)hisTasks.get(i);
                String completeFrom = (String)historicTaskInstance.getTaskLocalVariables().get("complete_from");
                if (!ToolUtil.isNotEmpty((Object)completeFrom) || nodeIds.contains(completeFrom)) continue;
                String newCompleteFrom = completeFrom;
                boolean isDelFrom = i == 0;
                for (int j = i - 1; j > -1; --j) {
                    newCompleteFrom = (String)((HistoricTaskInstance)hisTasks.get(j)).getTaskLocalVariables().get("complete_from");
                    if (ToolUtil.isEmpty((Object)newCompleteFrom)) {
                        isDelFrom = true;
                        break;
                    }
                    if (nodeIds.contains(newCompleteFrom)) break;
                }
                if (isDelFrom) {
                    newCompleteFrom = "";
                }
                if ((taskIds = (ArrayList<String>)finishTaskId.get(newCompleteFrom)) == null) {
                    taskIds = new ArrayList<String>();
                }
                taskIds.add(historicTaskInstance.getId());
                finishTaskId.put(newCompleteFrom, taskIds);
                if (historicTaskInstance.getEndTime() != null) continue;
                ArrayList<String> unFinishTaskIds = (ArrayList<String>)unFinishTaskId.get(newCompleteFrom);
                if (unFinishTaskIds == null) {
                    unFinishTaskIds = new ArrayList<String>();
                }
                unFinishTaskIds.add(historicTaskInstance.getId());
                unFinishTaskId.put(newCompleteFrom, unFinishTaskIds);
            }
        }
        if (finishTaskId.size() > 0) {
            this.taskEngineMapper.updateCompleteFrom(finishTaskId, unFinishTaskId, this.druidProperties.getUrl().split(":")[1]);
        }
        return result;
    }

    public void reStartProcessUpdate(String processInsId, String businessId, String processDefinitionId, String parentExecutionId, String tenantId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        map.put("tenantId", tenantId);
        map.put("parentExecutionId", parentExecutionId);
        map.put("processDefinitionId", processDefinitionId);
        map.put("dbType", this.druidProperties.getUrl().split(":")[1]);
        this.taskEngineMapper.reStartProcessUpdate(map);
    }

    public BpmResponseResult reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        if (ToolUtil.isAllEmpty((Object[])new Object[]{processInsId, businessId})) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNotNullParamIsNull(), null);
        }
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInsId).processInstanceBusinessKey(businessId).singleResult();
        if (historicProcessInstance != null) {
            if (ToolUtil.isEmpty((Object)historicProcessInstance.getEndTime())) {
                throw new PublicClientException(this.bpmConstantProperties.getProcessInstanceIsNotEnd(), Boolean.valueOf(false));
            }
            ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)this.repositoryService.getProcessDefinition(historicProcessInstance.getProcessDefinitionId());
            ActivityImpl destinationActivity = null;
            if (ToolUtil.isEmpty((Object)taskDefinitionKey)) {
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!activityImpl.getIncomingTransitions().isEmpty()) continue;
                    destinationActivity = (ActivityImpl)((PvmTransition)activityImpl.getOutgoingTransitions().get(0)).getDestination();
                    break;
                }
            } else {
                for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                    if (!taskDefinitionKey.equals(activityImpl.getId())) continue;
                    destinationActivity = activityImpl;
                }
                if (destinationActivity == null) {
                    return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getNodeNotFound(), null);
                }
            }
            if (ToolUtil.isEmpty(map)) {
                map = new HashMap<String, Object>();
            }
            map.put("sendUser", userId);
            if (isSubmit && ToolUtil.isEmpty((Object)assignee)) {
                assignee = this.getTaskCommitUser(historicProcessInstance.getId(), destinationActivity.getId());
            }
            if (ToolUtil.isNotEmpty((Object)assignee)) {
                HashMap<String, String> appointAssignee = new HashMap<String, String>();
                appointAssignee.put("static_appoint_assignee", assignee);
                map.put("appoint_assignee", appointAssignee);
            }
            this.reStartProcessUpdate(historicProcessInstance.getId(), businessId, historicProcessInstance.getProcessDefinitionId(), null, historicProcessInstance.getTenantId());
            this.processEngine.getManagementService().executeCommand((Command)new ParallelJumpTaskCmd(userId, historicProcessInstance.getId(), destinationActivity, null, null, map, null));
            return this.installReturnValue(userId, historicProcessInstance.getId(), null, map);
        }
        return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getProcessNotFound(), null);
    }

    public BpmResponseResult updateUserSecurityLevel(String userId, Integer level) {
        List<Map<String, String>> multiTaskMessages = this.taskEngineMapper.getSecurityLevelMultiTask(userId, level);
        for (Map<String, String> map : multiTaskMessages) {
            if (map.get("DUEDATE") != null) {
                this.activityRedisTimerService.delTimeOutModel(String.valueOf(map.get("TASKID")));
            }
            this.processEngine.getManagementService().executeCommand((Command)new MultiInstanceDelAssigneeCmd(String.valueOf(map.get("EXECUTIONID")), String.valueOf(map.get("TASKID")), null));
            this.installReturnValue(userId, String.valueOf(map.get("processInsId")), map.get("TASKDEFKEY"), new HashMap<String, Object>());
        }
        this.taskEngineMapper.updateSecurityLevelUserTask(userId, level, this.druidProperties.getUrl().split(":")[1]);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult updateStarter(String processInsId, String businessId, String userId) {
        if (ToolUtil.isEmpty((Object)processInsId) && ToolUtil.isEmpty((Object)businessId) || ToolUtil.isEmpty((Object)userId)) {
            return InstallResult.getResult((String)"0", (String)this.bpmConstantProperties.getErrorReset(), null);
        }
        if (ToolUtil.isEmpty((Object)processInsId)) {
            processInsId = this.taskEngineMapper.getProcessInsIdByBusinessId(businessId);
        }
        this.taskEngineMapper.updateActHiProcinstStater(processInsId, userId);
        this.taskEngineMapper.updateActHiIdentitylinkStater(processInsId, userId);
        this.taskEngineMapper.updateActRuIdentitylinkStater(processInsId, userId);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    public BpmResponseResult activeTaskCandidates(String taskId) {
        BpmResponseResult result;
        LambdaQueryWrapper ew = new LambdaQueryWrapper();
        ew.eq(CandidateUser::getTaskId, (Object)taskId);
        List candidateUserList = this.candidateUserService.list((Wrapper)ew);
        String users = "";
        StringBuilder candidateUsers = new StringBuilder();
        for (CandidateUser candidateUser : candidateUserList) {
            String userId = candidateUser.getAssignee();
            if (!ToolUtil.isNotEmpty((Object)userId)) continue;
            candidateUsers.append(",").append(userId);
        }
        users = candidateUsers.toString();
        if (ToolUtil.isNotEmpty((Object)users)) {
            users = users.substring(1);
        }
        if ("1".equals((result = this.addAssignees(taskId, null, users)).getCode())) {
            this.candidateUserService.remove((Wrapper)ew);
        }
        return result;
    }

    public BpmResponseResult getExecutionByBusinessId(String businessId) {
        String processInsId = ((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceBusinessKey(businessId).singleResult()).getId();
        if (ToolUtil.isNotEmpty((Object)processInsId)) {
            List historicActivityInstances = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInsId).activityType("receiveTask").unfinished().list();
            JSONArray json = new JSONArray();
            if (ToolUtil.isEmpty((Object)historicActivityInstances)) {
                return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
            }
            for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                JSONObject object = new JSONObject();
                object.put("activitiName", (Object)historicActivityInstance.getActivityName());
                object.put("activitiType", (Object)historicActivityInstance.getActivityType());
                object.put("activitiId", (Object)historicActivityInstance.getActivityId());
                object.put("executionId", (Object)historicActivityInstance.getExecutionId());
                json.add((Object)object);
            }
            return InstallResult.getResult((String)"1", (String)"success", (JSONArray)json);
        }
        return InstallResult.getResult((String)"0", (String)"\u67e5\u8be2\u5931\u8d25", null);
    }

    public BpmResponseResult receiveTaskSignal(String executionId, Map<String, Object> variableMap) {
        Map map = (Map)this.processEngine.getManagementService().executeCommand((Command)new ReceiveTaskAddVariablesCmd(executionId, null, null, true, variableMap));
        this.runtimeService.signal(executionId);
        this.activityRedisTimerService.delTimeOutModel(executionId);
        this.installReturnValue((String)map.get("userId"), (String)map.get("processInsId"), (String)map.get("backActivityId"), null);
        return InstallResult.getResult((String)"1", (String)"success", null);
    }

    private void rejectDataPush(Task task, String comment, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId);
            this.dataPushService.rejectDataPush(dataPush);
        }
    }

    private void completeDataPush(Task task, String comment, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId);
            this.dataPushService.completeDataPush(dataPush);
        }
    }

    private void claimDataPush(String taskId, String userId) {
        if (this.dataPushService.isDataPush()) {
            Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
            DataPush dataPush = this.dataPush(task, null, userId);
            this.dataPushService.claimDataPush(dataPush);
        }
    }

    public void entrustDataPush(Task task, String userId, String consignee, String comment, Date startTime, Date endTime) {
        if (this.dataPushService.isDataPush()) {
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
            DataPush dataPush = new DataPush();
            dataPush.setTaskId(task.getId());
            dataPush.setTaskDefinitionName(task.getName());
            dataPush.setUserId(consignee);
            dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
            dataPush.setStartUserId(historicProcessInstance.getStartUserId());
            dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
            dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
            dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
            HashMap map = new HashMap();
            map.putAll(task.getProcessVariables());
            map.putAll(task.getTaskLocalVariables());
            dataPush.setStartDate(startTime);
            dataPush.setUrl(task.getFormKey());
            dataPush.setDescription((String)map.get("todoConfiguration"));
            dataPush.setSendUser((String)task.getTaskLocalVariables().get("sendUser"));
            dataPush.setProcessName(historicProcessInstance.getProcessDefinitionName());
            dataPush.setComment(comment);
            dataPush.setProcessInsId(task.getProcessInstanceId());
            if (userId != null) {
                dataPush.setConsignor(userId);
                dataPush.setEndDate(endTime);
            }
            this.dataPushService.entrustDataPush(dataPush);
        }
    }

    private void revokeDataPush(Task task, String comment, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId);
            this.dataPushService.revokeDataPush(dataPush);
        }
    }

    private void freeJumpDataPush(Task task, String comment, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId);
            this.dataPushService.freeJumpDataPush(dataPush);
        }
    }

    private void addUserDataPush(Task task, String comment, String userId) {
        if (this.dataPushService.isDataPush()) {
            DataPush dataPush = this.dataPush(task, comment, userId);
            this.dataPushService.addUserDataPush(dataPush);
        }
    }

    private DataPush dataPush(Task task, String comment, String userId) {
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).singleResult();
        DataPush dataPush = new DataPush();
        dataPush.setTaskId(task.getId());
        dataPush.setTaskDefinitionName(task.getName());
        dataPush.setUserId(userId);
        dataPush.setBusinessKey(historicProcessInstance.getBusinessKey());
        dataPush.setTaskDefinitionKey(task.getTaskDefinitionKey());
        dataPush.setProcessDefinitionId(task.getProcessDefinitionId());
        dataPush.setProcessKey(task.getProcessDefinitionId().split(":")[0]);
        HashMap map = new HashMap();
        map.putAll(task.getProcessVariables());
        map.putAll(task.getTaskLocalVariables());
        dataPush.setSendUser((String)map.get("sendUser"));
        dataPush.setStartDate(task.getCreateTime());
        dataPush.setEndDate(new Date());
        dataPush.setUrl(task.getFormKey());
        dataPush.setDescription((String)map.get("todoConfiguration"));
        dataPush.setProcessName(((HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(task.getProcessInstanceId()).list().get(0)).getProcessDefinitionName());
        if (ToolUtil.isNotEmpty((Object)comment)) {
            dataPush.setComment(comment);
        }
        dataPush.setProcessInsId(task.getProcessInstanceId());
        return dataPush;
    }
}

