/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.datasource.properties.DruidProperties;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.dao.FlowTaskMapper;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTask;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.FlowTaskQueryModel;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.model.Variables;
import com.jxdinfo.hussar.workflow.engine.bpm.flowtask.service.IFlowTaskService;
import com.jxdinfo.hussar.workflow.engine.bpm.taskmanage.vo.TaskManagerQueryVo;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.service.ITenantConfigService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowTaskServiceImpl
implements IFlowTaskService {
    @Resource
    private FlowTaskMapper flowTaskMapper;
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;
    @Autowired
    private ITenantConfigService iTenantConfigService;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private ISysActExtendPropertiesService iSysActExtendPropertiesService;

    public ApiResponse<IPage<TaskManagerQueryVo>> todoList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dbType = this.druidProperties.getUrl().split(":")[1];
        flowTaskQueryModel.setDbType(dbType);
        List<FlowTask> todoList = this.flowTaskMapper.todoList(pages, flowTaskQueryModel);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> processInsIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            taskIds.add(flowTask.getTaskId());
            processInsIds.add(flowTask.getProcessInsId());
        }
        List<Object> allVariables = new ArrayList();
        if (todoList.size() > 0) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.size() == 0) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllToDoVariables(taskIds, processInsIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = todoList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        ArrayList<TaskManagerQueryVo> resultData = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        for (FlowTask flowTask : todoList) {
            TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
            taskManagerQueryVo.setTaskId(flowTask.getTaskId());
            taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
            taskManagerQueryVo.setUserId(flowTask.getUserId());
            taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
            taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
            taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
            taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
            taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
            taskManagerQueryVo.setStartTime(flowTask.getStartTime());
            taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
            taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
            taskManagerQueryVo.setFormKey(flowTask.getFormKey());
            taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
            taskManagerQueryVo.setSendUser(flowTask.getSendUser());
            taskManagerQueryVo.setFormAddress((Map)JSON.parse((String)flowTask.getFormKey()));
            if (taskManagerQueryVo.getFormAddress() != null) {
                taskManagerQueryVo.setWeb((String)taskManagerQueryVo.getFormAddress().get("web"));
                taskManagerQueryVo.setMobile((String)taskManagerQueryVo.getFormAddress().get("mobile"));
            }
            taskManagerQueryVo.setVariables(flowTask.getProcessVariableMap());
            taskManagerQueryVo.setTaskVariables(flowTask.getTaskVariableMap());
            if (flowTask.getTaskVariableMap() != null) {
                taskManagerQueryVo.setMessage((String)flowTask.getTaskVariableMap().get("todoConfiguration"));
                taskManagerQueryVo.setTaskSourceFlag((String)flowTask.getTaskVariableMap().get("taskSourceFlag"));
            }
            userIds.add(String.valueOf(taskManagerQueryVo.getSendUser()));
            resultData.add(taskManagerQueryVo);
        }
        Map finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        Iterator<Object> iterator2 = resultData.iterator();
        while (iterator2.hasNext()) {
            TaskManagerQueryVo taskManagerQueryVo;
            taskManagerQueryVo.setSendUserName(finalUsers.get((taskManagerQueryVo = (TaskManagerQueryVo)iterator2.next()).getSendUser()) == null ? "" : (String)finalUsers.get(taskManagerQueryVo.getSendUser()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(resultData);
        return ApiResponse.success((Object)page);
    }

    public ApiResponse<IPage<TaskManagerQueryVo>> doneList(Page<FlowTask> pages, FlowTaskQueryModel flowTaskQueryModel, String tenantId) {
        if (this.lcdpBpmProperties.isUseSecurityLevel()) {
            Integer securityLevel = null;
            if (this.lcdpBpmProperties.isStartAlone()) {
                TenantConfig tenantConfig = this.iTenantConfigService.getTenantConfig(tenantId);
                securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), tenantConfig.getProjectAddress(), tenantId);
            } else {
                securityLevel = this.iAssigneeChooseService.getSecurityLevel(flowTaskQueryModel.getUserId(), null, tenantId);
            }
            flowTaskQueryModel.setSecurityLevel(securityLevel);
        }
        String dbType = this.druidProperties.getUrl().split(":")[1];
        flowTaskQueryModel.setDbType(dbType);
        List<FlowTask> doneList = this.flowTaskMapper.doneList(pages, flowTaskQueryModel);
        ArrayList<String> taskIds = new ArrayList<String>();
        ArrayList<String> processInsIds = new ArrayList<String>();
        for (FlowTask flowTask : doneList) {
            taskIds.add(flowTask.getTaskId());
            processInsIds.add(flowTask.getProcessInsId());
        }
        List<Object> allVariables = new ArrayList();
        if (doneList.size() > 0) {
            processInsIds = new ArrayList(new HashSet(processInsIds));
            processInsIds.remove(null);
            if (processInsIds.size() == 0) {
                processInsIds = null;
            }
            allVariables = this.flowTaskMapper.getAllVariables(taskIds, processInsIds);
        }
        HashMap<String, ArrayList<Variables>> taskVariablesMap = new HashMap<String, ArrayList<Variables>>();
        HashMap<String, ArrayList<Variables>> processVariablesMap = new HashMap<String, ArrayList<Variables>>();
        for (Variables variables : allVariables) {
            List<Object> list;
            if (variables.getTaskId() == null) {
                list = (ArrayList<Variables>)processVariablesMap.get(variables.getProcessInsId());
                if (list == null) {
                    list = new ArrayList<Variables>();
                }
                list.add(variables);
                processVariablesMap.put(variables.getProcessInsId(), (ArrayList<Variables>)list);
                continue;
            }
            list = (List)taskVariablesMap.get(variables.getTaskId());
            if (list == null) {
                list = new ArrayList();
            }
            list.add(variables);
            taskVariablesMap.put(variables.getTaskId(), (ArrayList<Variables>)list);
        }
        Iterator<Object> iterator = doneList.iterator();
        while (iterator.hasNext()) {
            FlowTask flowTask;
            flowTask.setTaskVariables(taskVariablesMap.get((flowTask = (FlowTask)iterator.next()).getTaskId()) == null ? new ArrayList() : (List)taskVariablesMap.get(flowTask.getTaskId()));
            flowTask.setProcessVariables(processVariablesMap.get(flowTask.getProcessInsId()) == null ? new ArrayList() : (List)processVariablesMap.get(flowTask.getProcessInsId()));
        }
        Page page = new Page(pages.getCurrent(), pages.getSize(), pages.getTotal());
        page.setRecords(this.hisTasksToVo(doneList, tenantId));
        return ApiResponse.success((Object)page);
    }

    private List<TaskManagerQueryVo> hisTasksToVo(List<FlowTask> lists, String tenantId) {
        ArrayList<TaskManagerQueryVo> list = new ArrayList<TaskManagerQueryVo>();
        ArrayList<String> userIds = new ArrayList<String>();
        Map finalUsers = new HashMap();
        Map propertiesMap = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                Map taskVariables = flowTask.getTaskVariableMap();
                if (ToolUtil.isNotEmpty(taskVariables.get("sendUser"))) {
                    userIds.add(String.valueOf(taskVariables.get("sendUser")));
                }
                userIds.add(flowTask.getUserId());
                ids.add(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
            }
            propertiesMap = this.iSysActExtendPropertiesService.queryList(ids);
            finalUsers = this.iAssigneeChooseService.getUserListByUserId(userIds, tenantId);
        }
        if (ToolUtil.isNotEmpty(lists)) {
            for (FlowTask flowTask : lists) {
                TaskManagerQueryVo taskManagerQueryVo = new TaskManagerQueryVo();
                Map variables = flowTask.getProcessVariableMap();
                Map taskVariables = flowTask.getTaskVariableMap();
                taskManagerQueryVo.setTaskId(flowTask.getTaskId());
                taskManagerQueryVo.setIsNoticeTask(flowTask.getIsNoticeTask());
                taskManagerQueryVo.setTaskDefinitionName(flowTask.getName());
                taskManagerQueryVo.setAssigneeId(flowTask.getUserId());
                taskManagerQueryVo.setAssigneeName((String)finalUsers.get(flowTask.getUserId()));
                taskManagerQueryVo.setProcessDefinitionId(flowTask.getProcessDefinitionId());
                taskManagerQueryVo.setProcessKey(flowTask.getProcessKey());
                taskManagerQueryVo.setProcessName(flowTask.getProcessDefinitionName());
                taskManagerQueryVo.setTaskDefinitionKey(flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setProcessInsId(flowTask.getProcessInsId());
                taskManagerQueryVo.setStartTime(flowTask.getStartTime());
                taskManagerQueryVo.setEndTime(flowTask.getEndTime());
                taskManagerQueryVo.setProcessStartTime(flowTask.getProcessStartTime());
                taskManagerQueryVo.setProcessEndTime(flowTask.getProcessEndTime());
                taskManagerQueryVo.setBusinessId(flowTask.getBusinessId());
                taskManagerQueryVo.setVariables(variables);
                taskManagerQueryVo.setTaskVariables(taskVariables);
                taskManagerQueryVo.setTaskSourceFlag((String)taskVariables.get("taskSourceFlag"));
                String scope = String.valueOf(taskVariables.get("taskSourceFlag"));
                scope = "reject".equals(scope) ? "\u5df2\u9a73\u56de" : (ToolUtil.isNotEmpty((Object)flowTask.getEndTime()) ? "\u5df2\u5b8c\u6210" : "\u672a\u5b8c\u6210");
                taskManagerQueryVo.setState(scope);
                taskManagerQueryVo.setSendUser((String)taskVariables.get("sendUser"));
                taskManagerQueryVo.setSendUserName((String)finalUsers.get(taskVariables.get("sendUser")));
                String message = ToolUtil.isNotEmpty((Object)flowTask.getTodoConfiguration()) ? flowTask.getTodoConfiguration() : (taskVariables.get("todoConfiguration") == null ? "" : taskVariables.get("todoConfiguration").toString());
                taskManagerQueryVo.setMessage(message);
                taskManagerQueryVo.setFormKey(flowTask.getFormKey());
                String formDetail = (String)propertiesMap.get(flowTask.getProcessDefinitionId() + flowTask.getTaskDefinitionKey());
                taskManagerQueryVo.setFormDetailKey(formDetail);
                if (ToolUtil.isNotEmpty((Object)formDetail)) {
                    JSONObject object = JSON.parseObject((String)formDetail);
                    taskManagerQueryVo.setWeb(object.getString("web"));
                    taskManagerQueryVo.setMobile(object.getString("mobile"));
                }
                list.add(taskManagerQueryVo);
            }
        }
        return list;
    }
}

