/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.engine;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.workflow.engine.response.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.util.BpmConfigReadService;
import com.jxdinfo.hussar.workflow.engine.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.util.HttpRequestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskEngineService {
    private static final String TASK = "/task/";
    private static final BpmConfigReadService bpmConfigReadService = BpmSpringContextHolder.getBean(BpmConfigReadService.class);

    public static ApiResponse<?> queryTask(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryTask");
    }

    public static ApiResponse<?> queryAllToDoTaskList(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, Integer page, Integer size) {
        HashMap<String, Object> map = new HashMap<String, Object>(15);
        map.put("processName", processName);
        map.put("processKey", processKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("timeoutState", timeoutState);
        map.put("suspensionState", suspensionState);
        map.put("todoConfiguration", todoConfiguration);
        map.put("page", page);
        map.put("size", size);
        return TaskEngineService.execute(map, "queryAllToDoTaskList");
    }

    public static ApiResponse<?> queryAllToDoTaskListByBusiness(String processName, String processKey, String startTime, String endTime, String timeoutState, String suspensionState, String todoConfiguration, List<String> businessList, Integer page, Integer size) {
        HashMap<String, Object> map = new HashMap<String, Object>(15);
        map.put("processName", processName);
        map.put("processKey", processKey);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("timeoutState", timeoutState);
        map.put("suspensionState", suspensionState);
        map.put("todoConfiguration", todoConfiguration);
        map.put("business", JSON.toJSONString(businessList));
        map.put("page", page);
        map.put("size", size);
        return TaskEngineService.execute(map, "queryAllToDoTaskListByBusiness");
    }

    public static ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("userId", userId);
        map.put("processKey", processKey);
        map.put("definitionKey", definitionKey);
        return TaskEngineService.execute(map, "queryToDoTaskList");
    }

    public static ApiResponse<?> queryToDoTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("userId", userId);
        map.put("processKey", processKey);
        map.put("definitionKey", definitionKey);
        map.put("page", page);
        map.put("rows", rows);
        return TaskEngineService.execute(map, "queryToDoTaskListByPage");
    }

    public static ApiResponse<?> queryToDoTaskList(String userId, List<String> businessIds) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("userId", userId);
        map.put("businessIds", businessIds);
        return TaskEngineService.execute(map, "queryToDoTaskListByBusinessIds");
    }

    public static ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("userId", userId);
        map.put("processKey", processKey);
        map.put("definitionKey", definitionKey);
        return TaskEngineService.execute(map, "queryFinishedTaskList");
    }

    public static ApiResponse<?> queryFinishedTaskList(String userId, String processKey, String definitionKey, Integer page, Integer rows) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("userId", userId);
        map.put("processKey", processKey);
        map.put("definitionKey", definitionKey);
        map.put("page", page);
        map.put("rows", rows);
        return TaskEngineService.execute(map, "queryFinishedTaskListByPage");
    }

    public static ApiResponse<?> queryUserTaskCount(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("userId", userId);
        return TaskEngineService.execute(map, "queryUserTaskCount");
    }

    public static ApiResponse<?> queryUserTaskCountByNode(String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("userId", userId);
        return TaskEngineService.execute(map, "queryUserTaskCountByNode");
    }

    public static ApiResponse<?> claimTask(String taskId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("taskId", taskId);
        map.put("userId", userId);
        return TaskEngineService.execute(map, "claimTask");
    }

    public static ApiResponse<?> unClaimTask(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "unClaimTask");
    }

    public static ApiResponse<?> completeTask(String taskId, String userId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(7);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask1");
    }

    public static ApiResponse<?> completeTask(String taskId, String userId, Map<String, String> assigneeMap, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask2");
    }

    public static ApiResponse<?> completeTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(10);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask3");
    }

    public static ApiResponse<?> completeTask(String taskId, String userId, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask4");
    }

    public static ApiResponse<?> completeTask(String taskId, String userId, String comment, String subProcesses, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(10);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("subProcesses", subProcesses);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask5");
    }

    public static ApiResponse<?> completeTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("users", JSON.toJSONString(users));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask6");
    }

    public static ApiResponse<?> completeTaskNoAuditAuthority(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("users", JSON.toJSONString(users));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeTask7");
    }

    public static ApiResponse<?> completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(10);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeLeapTask");
    }

    public static ApiResponse<?> completeLeapTask(String taskId, String userId, Map<String, String> assigneeMap, Set<String> users, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assigneeMap", JSON.toJSONString(assigneeMap));
        maps.put("users", JSON.toJSONString(users));
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "completeLeapTask1");
    }

    public static ApiResponse<?> rejectToLastTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("assignees", "");
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToLastTask");
    }

    public static ApiResponse<?> rejectToLastTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("assignees", assignees);
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToLastTask");
    }

    public static ApiResponse<?> rejectToFirstTask(String taskId, String userId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assignees", assignees);
        maps.put("isSubmit", isSubmit);
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToFirstTask");
    }

    public static ApiResponse<?> rejectToFirstTask(String taskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("assignees", "");
        maps.put("isSubmit", isSubmit);
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToFirstTask");
    }

    public static ApiResponse<?> rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, String assignees, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(12);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("backActivityId", backActivityId);
        maps.put("comment", comment);
        maps.put("assignees", assignees);
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToAnyTask");
    }

    public static ApiResponse<?> rejectToAnyTask(String taskId, String userId, String backActivityId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(12);
        maps.put("taskId", taskId);
        maps.put("userId", userId);
        maps.put("backActivityId", backActivityId);
        maps.put("comment", comment);
        maps.put("assignees", "");
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "rejectToAnyTask");
    }

    public static ApiResponse<?> queryRejectNode(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryRejectNode");
    }

    public static ApiResponse<?> delegateTask(String taskId, String userId) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("taskId", taskId);
        map.put("userId", userId);
        return TaskEngineService.execute(map, "delegateTask");
    }

    public static ApiResponse<?> entrustTask(String taskId, String userId, String mandatary) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("taskId", taskId);
        map.put("userId", userId);
        map.put("mandatary", mandatary);
        return TaskEngineService.execute(map, "entrustTask");
    }

    public static ApiResponse<?> entrustTask(String taskId, String mandatary) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("taskId", taskId);
        map.put("mandatary", mandatary);
        return TaskEngineService.execute(map, "entrustTaskByTaskId");
    }

    public static ApiResponse<?> freeJump(String taskId, String activitiId, String userId, String assignees, boolean isSubmit, String comment, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(12);
        maps.put("taskId", taskId);
        maps.put("activitiId", activitiId);
        maps.put("userId", userId);
        maps.put("assignees", assignees);
        maps.put("isSubmit", isSubmit);
        maps.put("comment", comment);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "freeJump");
    }

    public static ApiResponse<?> multiInstanceAddAssignee(String taskId, List<String> assigneeList) {
        HashMap<String, Object> maps = new HashMap<String, Object>(6);
        maps.put("taskId", taskId);
        maps.put("assigneeList", JSON.toJSONString(assigneeList));
        return TaskEngineService.execute(maps, "multiInstanceAddAssignee");
    }

    public static ApiResponse<?> queryAssigneeByTaskId(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryAssigneeByTaskId");
    }

    public static ApiResponse<?> addAssignees(String taskId, String businessId, String users) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("taskId", taskId);
        map.put("businessId", businessId);
        map.put("users", users);
        return TaskEngineService.execute(map, "addAssignees");
    }

    public static ApiResponse<?> queryProcessNodeByTaskId(String taskId) {
        HashMap<String, Object> maps = new HashMap<String, Object>(4);
        maps.put("taskId", taskId);
        return TaskEngineService.execute(maps, "queryProcessNodeByTaskId");
    }

    public static ApiResponse<?> queryNextAssigneeByTaskIdAndNodeId(String taskId, String nodeId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(7);
        maps.put("taskId", taskId);
        maps.put("nodeId", nodeId);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "queryNextAssigneeByTaskIdAndNodeId");
    }

    public static ApiResponse<?> queryNextAssignee(String processKey, String taskId, String nodeId, String userId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(7);
        maps.put("processKey", processKey);
        maps.put("taskId", taskId);
        maps.put("nodeId", nodeId);
        HashMap<String, String> newMap = map == null ? new HashMap<String, String>() : map;
        newMap.put("userId", userId);
        maps.put("map", JSON.toJSONString(newMap));
        return TaskEngineService.execute(maps, "queryNextAssignee");
    }

    public static ApiResponse<?> queryNextAssignee(String processKey, String taskId, String nodeId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(7);
        maps.put("processKey", processKey);
        maps.put("taskId", taskId);
        maps.put("nodeId", nodeId);
        HashMap newMap = map == null ? new HashMap() : map;
        maps.put("map", JSON.toJSONString(newMap));
        return TaskEngineService.execute(maps, "queryNextAssignee");
    }

    public static ApiResponse<?> queryHistoryActByTaskId(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryHistoryActByTaskId");
    }

    public static ApiResponse<?> getProcessDefinitionIdAndNodeId(String processKey, String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("processKey", processKey);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "getProcessDefinitionIdAndNodeId");
    }

    public static ApiResponse<?> queryTaskIdByBusinessId(String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessId", businessId);
        return TaskEngineService.execute(map, "queryTaskIdByBusinessId");
    }

    public static ApiResponse<?> queryNextNode(String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryNextNodeByTaskId");
    }

    public static ApiResponse<?> queryRejectNodeOrNextNode(String processKey, String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("processKey", processKey);
        map.put("taskId", taskId);
        map.put("isGetRevokeNode", true);
        return TaskEngineService.execute(map, "queryNextNode");
    }

    public static ApiResponse<?> queryNextNode(String processKey, String taskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(5);
        map.put("processKey", processKey);
        map.put("taskId", taskId);
        return TaskEngineService.execute(map, "queryNextNode");
    }

    public static ApiResponse<?> withdrawState(String historicTaskId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("historicTaskId", historicTaskId);
        return TaskEngineService.execute(map, "withdrawState");
    }

    public static ApiResponse<?> revokeTask(String historicTaskId, String userId, String comment, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("historicTaskId", historicTaskId);
        maps.put("userId", userId);
        maps.put("comment", comment);
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "revokeTask");
    }

    public static ApiResponse<?> editTaskComment(String taskId, String comment) {
        HashMap<String, Object> maps = new HashMap<String, Object>(6);
        maps.put("taskId", taskId);
        maps.put("comment", comment);
        return TaskEngineService.execute(maps, "editTaskComment");
    }

    public static ApiResponse<?> reStartProcess(String processInsId, String businessId, String taskDefinitionKey, String userId, String assignee, boolean isSubmit, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>(11);
        maps.put("processInsId", processInsId);
        maps.put("businessId", businessId);
        maps.put("taskDefinitionKey", taskDefinitionKey);
        maps.put("userId", userId);
        maps.put("assignee", assignee);
        maps.put("isSubmit", isSubmit);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "reStartProcess");
    }

    public static ApiResponse<?> addCustomNode(String taskId, List<Map<String, Object>> list, String parallel) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("taskId", taskId);
        maps.put("addList", JSON.toJSONString(list));
        maps.put("parallel", parallel);
        return TaskEngineService.executeFramework(maps, "add");
    }

    public static ApiResponse<?> isAddParallel(String taskId) {
        HashMap<String, Object> maps = new HashMap<String, Object>(8);
        maps.put("taskId", taskId);
        return TaskEngineService.executeFramework(maps, "isAddParallel");
    }

    public static ApiResponse<?> multiInstanceDelAssignee(String taskId) {
        HashMap<String, Object> maps = new HashMap<String, Object>(4);
        maps.put("taskId", taskId);
        return TaskEngineService.execute(maps, "multiInstanceDelAssignee");
    }

    public static ApiResponse<?> multiInstanceDelAssignee(String taskId, String assignees) {
        HashMap<String, Object> maps = new HashMap<String, Object>(4);
        maps.put("taskId", taskId);
        maps.put("assignees", assignees);
        return TaskEngineService.execute(maps, "multiInstanceDelAssignee");
    }

    public static ApiResponse<?> updateUserSecurityLevel(String userId, Integer level) {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("userId", userId);
        maps.put("level", level);
        return TaskEngineService.execute(maps, "updateUserSecurityLevel");
    }

    private static ApiResponse<?> execute(Map<String, Object> map, String url) {
        map.put("tenantId", bpmConfigReadService.getTenantId());
        map.put("tenantCipher", bpmConfigReadService.getTenantCipher());
        String finalUrl = bpmConfigReadService.getUrl() + TASK + url;
        String result = HttpRequestUtil.get(finalUrl, map);
        return (ApiResponse)JSON.parseObject((String)result, ApiResponse.class);
    }

    private static ApiResponse<?> executeFramework(Map<String, Object> map, String url) {
        map.put("tenantId", bpmConfigReadService.getTenantId());
        map.put("tenantCipher", bpmConfigReadService.getTenantCipher());
        String finalUrl = bpmConfigReadService.getUrl() + "/addCustomNode/" + url;
        String result = HttpRequestUtil.get(finalUrl, map);
        return (ApiResponse)JSON.parseObject((String)result, ApiResponse.class);
    }

    public static ApiResponse<?> updateStarter(String processInsId, String businessId, String userId) {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("processInsId", processInsId);
        maps.put("businessId", businessId);
        maps.put("userId", userId);
        return TaskEngineService.execute(maps, "updateStarter");
    }

    public static ApiResponse<?> getExecutionByBusinessId(String businessId) {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("businessId", businessId);
        return TaskEngineService.execute(maps, "getExecutionByBusinessId");
    }

    public static ApiResponse<?> receiveTaskSignal(String executionId, Map<String, Object> map) {
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("executionId", executionId);
        maps.put("map", JSON.toJSONString(map));
        return TaskEngineService.execute(maps, "receiveTaskSignal");
    }
}

