/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.response;

import com.jxdinfo.hussar.workflow.engine.response.IResultCode;
import com.jxdinfo.hussar.workflow.engine.response.ResultCode;
import java.io.Serializable;
import java.util.Optional;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

public class ApiResponse<T>
implements Serializable {
    private static final long serialVersionUID = -5104378348955818552L;
    private int code;
    private boolean success;
    private T data;
    private String msg;

    private ApiResponse(IResultCode resultCode) {
        this(resultCode, null, resultCode.getMessage());
    }

    private ApiResponse(IResultCode resultCode, String msg) {
        this(resultCode, null, msg);
    }

    private ApiResponse(IResultCode resultCode, T data, String msg) {
        this(resultCode.getCode(), data, msg);
    }

    public ApiResponse() {
    }

    private ApiResponse(int code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.success = ResultCode.SUCCESS.code == code;
    }

    public static boolean isSuccess(@Nullable ApiResponse<?> result) {
        return Optional.ofNullable(result).map(x -> ObjectUtils.nullSafeEquals((Object)ResultCode.SUCCESS.code, (Object)x.code)).orElse(Boolean.FALSE);
    }

    public static boolean isNotSuccess(@Nullable ApiResponse<?> result) {
        return !ApiResponse.isSuccess(result);
    }

    public static <T> ApiResponse<T> data(T data) {
        return ApiResponse.data(data, "\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> ApiResponse<T> data(T data, String msg) {
        return ApiResponse.data(200, data, msg);
    }

    public static <T> ApiResponse<T> data(int code, T data, String msg) {
        return new ApiResponse<T>(code, data, data == null ? "\u6682\u65e0\u627f\u8f7d\u6570\u636e" : msg);
    }

    public static <T> ApiResponse<T> success(String msg) {
        return new ApiResponse<T>(ResultCode.SUCCESS, msg);
    }

    public static <T> ApiResponse<T> success(int code, String msg) {
        return new ApiResponse<Object>(code, null, msg);
    }

    public static <T> ApiResponse<T> success(IResultCode resultCode) {
        return new ApiResponse<T>(resultCode);
    }

    public static <T> ApiResponse<T> success(IResultCode resultCode, String msg) {
        return new ApiResponse<T>(resultCode, msg);
    }

    public static <T> ApiResponse<T> fail(String msg) {
        return new ApiResponse<T>(ResultCode.FAILURE, msg);
    }

    public static <T> ApiResponse<T> fail(int code, String msg) {
        return new ApiResponse<Object>(code, null, msg);
    }

    public static <T> ApiResponse<T> fail(IResultCode resultCode) {
        return new ApiResponse<T>(resultCode);
    }

    public static <T> ApiResponse<T> fail(IResultCode resultCode, String msg) {
        return new ApiResponse<T>(resultCode, msg);
    }

    public static <T> ApiResponse<T> status(boolean flag) {
        return flag ? ApiResponse.success("\u64cd\u4f5c\u6210\u529f") : ApiResponse.fail("\u64cd\u4f5c\u5931\u8d25");
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public static long getSerialversionuid() {
        return -5104378348955818552L;
    }
}

