/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.engine;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.workflow.engine.response.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.util.BpmConfigReadService;
import com.jxdinfo.hussar.workflow.engine.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.util.HttpRequestUtil;
import java.util.HashMap;
import java.util.Map;

public class InstanceEngineService {
    private static final String INSTANCE = "/instance/";
    private static final BpmConfigReadService bpmConfigReadService = BpmSpringContextHolder.getBean(BpmConfigReadService.class);

    public static ApiResponse<?> startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processDefinitionId", processDefinitionId);
        map.put("userId", userId);
        map.put("businessId", businessId);
        map.put("variables", JSON.toJSONString(variables));
        return InstanceEngineService.execute(map, "startProcessInstanceById");
    }

    public static ApiResponse<?> startProcessInstanceByKey(String processKey, String userId, String businessId, Map<String, Object> variables) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processKey", processKey);
        map.put("userId", userId);
        map.put("businessId", businessId);
        map.put("variables", JSON.toJSONString(variables));
        return InstanceEngineService.execute(map, "startProcessInstanceByKey");
    }

    public static ApiResponse<?> checkProcessInstByBusinessId(String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessId", businessId);
        return InstanceEngineService.execute(map, "checkProcessInstByBusinessId");
    }

    public static ApiResponse<?> validateEditAuthority(String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessId", businessId);
        return InstanceEngineService.execute(map, "validateEditAuthority");
    }

    public static ApiResponse<?> validateDeleteByBusinessId(String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessId", businessId);
        return InstanceEngineService.execute(map, "validateDeleteByBusinessId");
    }

    public static ApiResponse<?> suspendProcessInstanceById(String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "suspendProcessInstanceById");
    }

    public static ApiResponse<?> activateProcessInstanceById(String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "activateProcessInstanceById");
    }

    public static ApiResponse<?> deleteProcessInstance(String processInsId, String reason) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInsId", processInsId);
        map.put("reason", reason);
        return InstanceEngineService.execute(map, "deleteProcessInstance");
    }

    public static ApiResponse<?> deleteFinishedProcessInstance(String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "deleteFinishedProcessInstance");
    }

    public static ApiResponse<?> deleteProcessInstanceByBusinessId(String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessId", businessId);
        return InstanceEngineService.execute(map, "deleteProcessInstanceByBusinessId");
    }

    public static ApiResponse<?> queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("processKey", processKey);
        map.put("businessId", businessId);
        map.put("page", page);
        map.put("rows", rows);
        return InstanceEngineService.execute(map, "queryFinishedProcessInstance");
    }

    public static ApiResponse<?> queryProcessInstanceCompleteState(String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "queryProcessInstanceCompleteState");
    }

    public static ApiResponse<?> queryProcessInstanceCompleteStateByBusinessId(String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("businessId", businessId);
        return InstanceEngineService.execute(map, "queryProcessInstanceCompleteStateByBusinessId");
    }

    public static ApiResponse<?> getProcessTrace(String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "getProcessTrace");
    }

    public static ApiResponse<?> getAllProcessTrace(String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "getAllProcessTrace");
    }

    public static ApiResponse<?> queryCallActivityTask(String businessId, String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "queryCallActivityTask");
    }

    public static ApiResponse<?> queryMainActivityTask(String businessId, String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "queryMainActivityTask");
    }

    public static ApiResponse<?> getAllProcessTraceByBusinessId(String businessId, int page, int size) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("businessId", businessId);
        map.put("page", page);
        map.put("size", size);
        return InstanceEngineService.execute(map, "getAllProcessTraceByBusinessId");
    }

    public static ApiResponse<?> queryCompletecomment(String businessId, String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(7);
        map.put("businessId", businessId);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "queryCompletecomment");
    }

    public static ApiResponse<?> queryProcessDefinitionByInstanceId(String processInsId) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("processInsId", processInsId);
        return InstanceEngineService.execute(map, "queryProcessDefinitionByInstanceId");
    }

    public static ApiResponse<?> endProcess(String taskId, String userId, String reason) {
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("taskId", taskId);
        map.put("userId", userId);
        map.put("reason", reason);
        return InstanceEngineService.execute(map, "endProcess");
    }

    private static ApiResponse<?> execute(Map<String, Object> map, String url) {
        map.put("tenantId", bpmConfigReadService.getTenantId());
        map.put("tenantCipher", bpmConfigReadService.getTenantCipher());
        String finalUrl = bpmConfigReadService.getUrl() + INSTANCE + url;
        String result = HttpRequestUtil.get(finalUrl, map);
        return (ApiResponse)JSON.parseObject((String)result, ApiResponse.class);
    }
}

