/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.assignee.controller;

import com.jxdinfo.hussar.workflow.engine.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.assignee.service.AssigneeService;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assignee"})
public class AssigneeController {
    @Autowired
    private AssigneeService assigneeService;

    @GetMapping(value={"/user"})
    public List<BpmTreeModel> userTree(@RequestParam(value="id", defaultValue="11") String id) {
        return this.assigneeService.userTree(id);
    }

    @GetMapping(value={"/dept"})
    public List<BpmTreeModel> deptTree(@RequestParam String id) {
        return this.assigneeService.deptTree(id);
    }

    @GetMapping(value={"/role"})
    public List<BpmTreeModel> roleTree() {
        return this.assigneeService.roleTree();
    }

    @GetMapping(value={"/userDetail"})
    public List<BpmTreeModel> userDetail(String userIds) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return null;
        }
        return this.assigneeService.userDetail(Arrays.asList(userIds.split(",")));
    }

    @GetMapping(value={"/userDeptDetail"})
    public List<BpmTreeModel> userDeptDetail(String userId) {
        if (StringUtils.isEmpty((Object)userId)) {
            return null;
        }
        return this.assigneeService.userDeptDetail(userId);
    }

    @GetMapping(value={"/getCandidateUser"})
    public List<String> getCandidateUser(String condition, Integer securityLevel, boolean isConditionFullSql) {
        return this.assigneeService.getCandidateUser(condition, securityLevel, isConditionFullSql);
    }

    @GetMapping(value={"/getRealCondition"})
    public String getRealCondition(String condition) {
        return this.assigneeService.getRealCondition(condition);
    }

    @GetMapping(value={"/getSecurityLevel"})
    public String getSecurityLevel(String userId) {
        return String.valueOf(this.assigneeService.getSecurityLevel(userId));
    }
}

