/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.taskmanage.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.workflow.engine.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.engine.assignee.service.AssigneeService;
import com.jxdinfo.hussar.workflow.engine.engine.DefinitionEngineService;
import com.jxdinfo.hussar.workflow.engine.response.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.taskmanage.service.IEntrustListService;
import com.jxdinfo.hussar.workflow.engine.util.BpmConfigReadService;
import com.jxdinfo.hussar.workflow.engine.util.HttpRequestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EntrustListServiceImpl
implements IEntrustListService {
    private static final String ENTRUST = "/sysActEntrust/";
    @Autowired
    private BpmConfigReadService bpmConfigReadService;
    @Autowired
    AssigneeService assigneeService;

    @Override
    public ApiResponse<?> initList(Map<String, Object> body) {
        return this.execute(body, "list");
    }

    @Override
    public ApiResponse<?> saveEntrust(Map<String, Object> body) {
        String processKey = "";
        List keys = (List)body.get("processKey");
        for (int i = 0; i < keys.size(); ++i) {
            processKey = processKey + (String)keys.get(i) + ",";
        }
        String mandator = String.valueOf(body.get("mandator"));
        String mandatary = String.valueOf(body.get("mandatary"));
        String startTime = String.valueOf(body.get("startTime")).concat(" 00:00:00");
        String endTime = String.valueOf(body.get("endTime")).concat(" 23:59:59");
        String state = "1";
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        map.put("processKey", processKey);
        map.put("mandator", mandator);
        map.put("mandatary", mandatary);
        map.put("state", state);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return this.execute(map, "addBatch");
    }

    @Override
    public ApiResponse<?> deleteEntrust(Map<String, Object> body) {
        return this.execute(body, "delete");
    }

    @Override
    public ApiResponse<?> detailEntrust(Map<String, Object> body) {
        return this.execute(body, "detail");
    }

    @Override
    public ApiResponse<?> updateEntrust(Map<String, Object> body) {
        Long id = (Long)body.get("id");
        String mandatary = String.valueOf(body.get("mandatary"));
        String startTime = String.valueOf(body.get("startTime")).length() > 10 ? String.valueOf(body.get("startTime")) : String.valueOf(body.get("startTime")).concat(" 00:00:00");
        String endTime = String.valueOf(body.get("endTime")).length() > 10 ? String.valueOf(body.get("endTime")) : String.valueOf(body.get("endTime")).concat(" 23:59:59");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("id", id);
        map.put("mandatary", mandatary);
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return this.execute(map, "update");
    }

    @Override
    public ApiResponse<?> updateStateEntrust(Map<String, Object> body) {
        Long tEntrustId = (Long)body.get("id");
        String state = "";
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        if ("1".equals(String.valueOf(body.get("state")))) {
            state = "0";
            map.put("state", state);
        } else {
            state = "1";
            map.put("state", state);
        }
        map.put("tEntrustId", tEntrustId);
        return this.execute(map, "updateState");
    }

    @Override
    public ApiResponse<List<BpmTreeModel>> userTree(String id) {
        return ApiResponse.data(this.assigneeService.userTree(id));
    }

    @Override
    public ApiResponse<?> queryProcess() {
        return DefinitionEngineService.queryProcess();
    }

    private ApiResponse<?> execute(Map<String, Object> map, String url) {
        map.put("tenantId", this.bpmConfigReadService.getTenantId());
        map.put("tenantCipher", this.bpmConfigReadService.getTenantCipher());
        String finalUrl = this.bpmConfigReadService.getUrl() + ENTRUST + url;
        String result = HttpRequestUtil.get(finalUrl, map);
        return (ApiResponse)JSON.parseObject((String)result, ApiResponse.class);
    }
}

