/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.flowchar.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.workflow.engine.flowchar.service.IFlowChartService;
import com.jxdinfo.hussar.workflow.engine.util.BpmConfigReadService;
import com.jxdinfo.hussar.workflow.engine.util.HttpRequestUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FlowChartServiceImpl
implements IFlowChartService {
    private static final String FLOW_CHART = "/flowChart/";
    @Autowired
    private BpmConfigReadService bpmConfigReadService;

    @Override
    public Map<String, Object> historyList(String processInsId, String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        String result = this.execute(map, "historyList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @Override
    public Map<String, Object> historyMicroList(String processInsId, String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        String result = this.execute(map, "historyMicroList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    @Override
    public JSONObject getProcessDetail(String processInsId, String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        String result = this.execute(map, "getProcessDetail");
        return (JSONObject)JSON.parseObject((String)result, JSONObject.class);
    }

    @Override
    public JSONArray getProcessCompleteDetail(String processInsId, String businessId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processInsId", processInsId);
        map.put("businessId", businessId);
        String result = this.execute(map, "getProcessCompleteDetail");
        return (JSONArray)JSON.parseObject((String)result, JSONArray.class);
    }

    @Override
    public JSONObject getProcessInfoByFile(String processIdentityKey, String processKey) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("processIdentityKey", processIdentityKey);
        map.put("processKey", processKey);
        String result = this.execute(map, "getProcessInfoByFile");
        return (JSONObject)JSON.parseObject((String)result, JSONObject.class);
    }

    @Override
    public Map<String, Object> subProcessList(String supProcessInsId, String businessId, String taskDefinitionKey, Integer page, Integer size) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("supProcessInsId", supProcessInsId);
        map.put("businessId", businessId);
        map.put("taskDefinitionKey", taskDefinitionKey);
        map.put("page", page);
        map.put("size", size);
        String result = this.execute(map, "subProcessList");
        return (Map)JSON.parseObject((String)result, Map.class);
    }

    private String execute(Map<String, Object> map, String url) {
        map.put("tenantId", this.bpmConfigReadService.getTenantId());
        map.put("tenantCipher", this.bpmConfigReadService.getTenantCipher());
        String finalUrl = this.bpmConfigReadService.getUrl() + FLOW_CHART + url;
        return HttpRequestUtil.get(finalUrl, map);
    }
}

