/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.httpclient;

import com.jxdinfo.hussar.support.rmi.core.RmiApi;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequest;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequestType;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpClient {
    private static IBpmConfigService bpmConfigService;

    @Autowired
    public void setBpmConfigService(IBpmConfigService bpmConfigService) {
        HttpClient.bpmConfigService = bpmConfigService;
    }

    private static int getConnectionTimeOut() {
        return (int)bpmConfigService.getLongByKeyUseCache("connection_timeout");
    }

    private static int getReadTimeOut() {
        return (int)bpmConfigService.getLongByKeyUseCache("read_timeout");
    }

    public static String doGet(String url, Map<String, String> param) {
        return HttpClient.request(url, RmiApiRequestType.GET, null, param, null);
    }

    public static String doGet(String url, Map<String, String> param, Map<String, String> headers) {
        return HttpClient.request(url, RmiApiRequestType.GET, null, param, headers);
    }

    public static String doPost(String url, String body) {
        return HttpClient.request(url, RmiApiRequestType.POST, body, null, null);
    }

    public static String doPost(String url, String body, Map<String, String> headers) {
        return HttpClient.request(url, RmiApiRequestType.POST, body, null, headers);
    }

    private static String request(String url, RmiApiRequestType type, String body, Map params, Map<String, String> headers) {
        RmiApiRequest request = RmiApi.request(String.class).url(url).type(type);
        request.connectTimeout(HttpClient.getConnectionTimeOut());
        request.readTimeout(HttpClient.getReadTimeOut());
        if (RmiApiRequestType.POST.equals((Object)type)) {
            if (body != null) {
                request.addBody(body);
            }
        } else if (params != null) {
            request.addQuery(params, true, "utf-8");
        }
        if (headers == null) {
            headers = new HashMap<String, String>();
        }
        HashSet<String> keySet = new HashSet<String>(headers.keySet());
        for (String key : keySet) {
            if (headers.get(key) != null) continue;
            headers.remove(key);
        }
        headers.put("Content-Type", "application/json");
        request.addHeader(headers);
        return (String)request.execute(String.class);
    }
}

