/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bsp.exception;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.message.model.BpmActMsgDetail;
import com.jxdinfo.hussar.workflow.engine.bpm.message.service.BpmMsgPushService;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PublicClientException
extends RuntimeException {
    private final String reason;
    private final Boolean isSaveLogger;
    private final JSONArray result;
    private static final Logger logger = LoggerFactory.getLogger(PublicClientException.class);
    private BpmMsgPushService msgPushService = (BpmMsgPushService)SpringContextHolder.getBean(BpmMsgPushService.class);

    @Override
    public void printStackTrace() {
        logger.error(this.reason);
        super.printStackTrace();
    }

    @Override
    public String getMessage() {
        if (this.reason != null) {
            return this.reason;
        }
        return super.getMessage();
    }

    public PublicClientException(String reason) {
        this.reason = reason;
        this.isSaveLogger = true;
        this.result = null;
    }

    public PublicClientException(String reason, Boolean isSaveLogger) {
        this.reason = reason;
        this.isSaveLogger = isSaveLogger;
        this.result = null;
    }

    public PublicClientException(String reason, Boolean isSaveLogger, JSONArray result) {
        this.reason = reason;
        this.isSaveLogger = isSaveLogger;
        this.result = result;
    }

    public PublicClientException(String reason, Boolean isSaveLogger, String processName) {
        this.reason = reason;
        this.isSaveLogger = isSaveLogger;
        this.result = null;
        this.pushExceptionMessage(reason, processName);
    }

    public String getReason() {
        return this.reason;
    }

    public Boolean getIsSaveLogger() {
        return this.isSaveLogger;
    }

    public JSONArray getResult() {
        return this.result;
    }

    private void pushExceptionMessage(String exceptionMsg, String processName) {
        ArrayList<BpmActMsgDetail> bpmActMsgDetailList = new ArrayList<BpmActMsgDetail>();
        HashMap<String, String> messageData = new HashMap<String, String>();
        BpmActMsgDetail bpmActMsgDetail = new BpmActMsgDetail();
        bpmActMsgDetail.setSceneCode("exception");
        messageData.put("processName", processName);
        messageData.put("exceptionMsg", exceptionMsg);
        bpmActMsgDetail.setMessageData(messageData);
        bpmActMsgDetailList.add(bpmActMsgDetail);
        this.msgPushService.pushMessage(bpmActMsgDetailList);
    }
}

