/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.model;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.ExecutionInfo;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.model.JumpInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class JumpModel {
    private final int jumpType;
    private Collection<String> affectedTasks;
    private List<String> jumpFrom;
    private List<String> jumpTo;
    private List<ExecutionInfo> jumpFromExecution;
    private List<ExecutionInfo> jumpToExecution;
    private Collection<String> runningSubProcessNodeIds;
    private Collection<String> runningActivityNodeIds;
    private Map<String, String> allPrevNode;

    public JumpModel(int jumpType) {
        this.jumpType = jumpType;
    }

    public int getJumpType() {
        return this.jumpType;
    }

    public Collection<String> getAffectedTasks() {
        return this.affectedTasks;
    }

    public JumpModel setAffectedTasks(Collection<String> affectedTasks) {
        this.affectedTasks = affectedTasks;
        return this;
    }

    public List<String> getJumpFrom() {
        return this.jumpFrom;
    }

    public JumpModel setJumpFrom(List<String> jumpFrom) {
        this.jumpFrom = jumpFrom;
        return this;
    }

    public JumpModel setJumpFrom(String jumpFrom) {
        this.jumpFrom = Collections.singletonList(jumpFrom);
        return this;
    }

    public List<ExecutionInfo> getJumpFromExecution() {
        return this.jumpFromExecution;
    }

    public JumpModel setJumpFromExecution(List<ExecutionInfo> jumpFromExecution) {
        this.jumpFromExecution = jumpFromExecution;
        return this;
    }

    public Collection<String> getRunningSubProcessNodeIds() {
        return this.runningSubProcessNodeIds;
    }

    public JumpModel setRunningSubProcessNodeIds(Collection<String> runningSubProcessNodeIds) {
        this.runningSubProcessNodeIds = runningSubProcessNodeIds;
        return this;
    }

    public Collection<String> getRunningActivityNodeIds() {
        return this.runningActivityNodeIds;
    }

    public JumpModel setRunningActivityNodeIds(Collection<String> runningActivityNodeIds) {
        this.runningActivityNodeIds = runningActivityNodeIds;
        return this;
    }

    public List<String> getJumpTo() {
        return this.jumpTo;
    }

    public JumpModel setJumpTo(List<String> jumpTo) {
        this.jumpTo = jumpTo;
        return this;
    }

    public JumpModel setJumpTo(String jumpTo) {
        this.jumpTo = Collections.singletonList(jumpTo);
        return this;
    }

    public List<ExecutionInfo> getJumpToExecution() {
        return this.jumpToExecution;
    }

    public JumpModel setJumpToExecution(List<ExecutionInfo> jumpToExecution) {
        this.jumpToExecution = jumpToExecution;
        return this;
    }

    public Map<String, String> getAllPrevNode() {
        return this.allPrevNode;
    }

    public JumpModel setAllPrevNode(Map<String, String> allPrevNode) {
        this.allPrevNode = allPrevNode;
        return this;
    }

    public JumpInfo toJumpInfo() {
        return new JumpInfo(this.getJumpFrom(), this.getJumpTo(), HussarUtils.isNotEmpty(this.getJumpFromExecution())).setJumpFromExecutionInfo(this.jumpFromExecution);
    }
}

