/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.comment.model;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.workflow.engine.constant.BpmConstant;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;

@ApiModel(value="\u610f\u89c1\u8868")
@TableName(value="BPM_ACT_HI_COMMENT")
public class TaskComment
extends Model<TaskComment>
implements BaseEntity {
    @ApiModelProperty(value="\u6587\u4ef6id")
    @TableId(value="ID_")
    private Long id;
    @ApiModelProperty(value="\u7c7b\u578b")
    @TableField(value="TYPE_")
    private String type;
    @ApiModelProperty(value="\u65f6\u95f4")
    @TableField(value="TIME_")
    private LocalDateTime time;
    @ApiModelProperty(value="\u8282\u70b9id")
    @TableField(value="TASK_ID_")
    private Long taskId;
    @ApiModelProperty(value="\u529e\u7406\u4ebaid")
    @TableField(value="USER_ID_")
    private String userId;
    @ApiModelProperty(value="\u8282\u70b9\u72b6\u6001")
    @TableField(value="ACTION_")
    private String action;
    @ApiModelProperty(value="\u4fe1\u606f")
    @TableField(value="MESSAGE_")
    private String message;
    @ApiModelProperty(value="\u5b8c\u6574\u4fe1\u606f")
    @TableField(value="FULL_MSG_")
    private byte[] fullMsg;

    public TaskComment() {
    }

    public TaskComment(Long taskId, String message, byte[] fullMsg) {
        this.type = "complete";
        this.time = LocalDateTime.now();
        this.taskId = taskId;
        this.action = "AddComment";
        this.message = message;
        this.fullMsg = fullMsg;
    }

    public TaskComment(Long taskId, byte[] fullMsg) {
        this.type = "complete";
        this.time = LocalDateTime.now();
        this.taskId = taskId;
        this.action = "AddComment";
        this.fullMsg = fullMsg;
        String fullMessage = new String(fullMsg);
        String eventMessage = fullMessage.replaceAll("\\s+", " ");
        if (eventMessage.length() > BpmConstant.MAX_COMMENT_LENGTG) {
            eventMessage = eventMessage.substring(0, BpmConstant.COMMENT_LENGTH) + "...";
        }
        this.message = eventMessage;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public LocalDateTime getTime() {
        return this.time;
    }

    public void setTime(LocalDateTime time) {
        this.time = time;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public byte[] getFullMsg() {
        return this.fullMsg;
    }

    public void setFullMsg(byte[] fullMsg) {
        this.fullMsg = fullMsg;
    }
}

