/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.unifiedtodatapush.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar.bpm")
public class UnifiedToDoDataPushProperties {
    private final IBpmConfigService bpmConfigService;
    public static final String PREFIX = "hussar.bpm";
    private String deploymentModel;
    private long systemId = 524168298611613696L;
    private String unifiedUrl;
    private String userIdType = "outOriginId";

    public UnifiedToDoDataPushProperties(IBpmConfigService bpmConfigService) {
        this.bpmConfigService = bpmConfigService;
    }

    public String getUserIdType() {
        return this.userIdType;
    }

    public void setUserIdType(String userIdType) {
        this.userIdType = userIdType;
    }

    public IBpmConfigService getBpmConfigService() {
        return this.bpmConfigService;
    }

    public String getUnifiedUrl() {
        return this.unifiedUrl;
    }

    public void setUnifiedUrl(String unifiedUrl) {
        this.unifiedUrl = unifiedUrl;
    }

    public String getDeploymentModel() {
        return this.deploymentModel;
    }

    public void setDeploymentModel(String deploymentModel) {
        this.deploymentModel = deploymentModel;
    }

    public boolean isWorkflowPlatformStandalone() {
        return "workflow-platform".equals(this.deploymentModel);
    }

    public boolean isUseDatapush() {
        return this.bpmConfigService.getBooleanByKeyUseCache("use_data_push");
    }

    public long getSystemId() {
        return this.systemId;
    }

    public void setSystemId(long systemId) {
        this.systemId = systemId;
    }

    public String getClientId() {
        return this.bpmConfigService.getStringByKeyUseCache("client_id");
    }

    public String getClientSecret() {
        return this.bpmConfigService.getStringByKeyUseCache("client_secret");
    }

    public String getClientScope() {
        return this.bpmConfigService.getStringByKeyUseCache("client_scope");
    }

    public String getTenantCallAddress() {
        String address = this.bpmConfigService.getStringByKeyUseCache("tenant_call_address");
        if (HussarUtils.isNotEmpty((Object)address) && address.endsWith("/")) {
            return address.substring(0, address.length() - 1);
        }
        return address;
    }
}

