/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.engine.model;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.activiti.engine.history.HistoricTaskInstance;

public class ProcessHistoryTaskModel {
    private final List<HistoricTaskInstance> allHistoryTask;
    private List<HistoricTaskInstance> orderedByEndTime;
    private Map<String, List<HistoricTaskInstance>> groupBySubProcessOrderedByEndTime;
    private Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeOrderedByEndTime;
    private List<HistoricTaskInstance> unfinished;
    private Map<String, List<HistoricTaskInstance>> groupBySubProcessUnfinished;
    private Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeUnfinished;

    public List<HistoricTaskInstance> getAllHistoryTask() {
        return this.allHistoryTask;
    }

    public List<HistoricTaskInstance> getOrderedByEndTime() {
        if (this.orderedByEndTime == null) {
            this.orderedByEndTime = this.getAllHistoryTask().stream().filter(task -> task.getEndTime() != null).sorted(Comparator.comparing(HistoricTaskInstance::getEndTime).reversed()).collect(Collectors.toList());
        }
        return this.orderedByEndTime;
    }

    private void buildFinishedGroup() {
        this.groupByNodeOrderedByEndTime = new HashMap<String, Map<String, List<HistoricTaskInstance>>>();
        this.groupBySubProcessOrderedByEndTime = new HashMap<String, List<HistoricTaskInstance>>();
        List<HistoricTaskInstance> orderedByEndTime = this.getOrderedByEndTime();
        for (HistoricTaskInstance historicTaskInstance : orderedByEndTime) {
            this.groupByNodeOrderedByEndTime.computeIfAbsent(historicTaskInstance.getSubProcessKey(), k -> new HashMap()).computeIfAbsent(historicTaskInstance.getTaskDefinitionKey(), k -> new ArrayList()).add(historicTaskInstance);
            this.groupBySubProcessOrderedByEndTime.computeIfAbsent(historicTaskInstance.getSubProcessKey(), k -> new ArrayList()).add(historicTaskInstance);
        }
    }

    public Map<String, Map<String, List<HistoricTaskInstance>>> getGroupByNodeOrderedByEndTime() {
        if (this.groupByNodeOrderedByEndTime == null) {
            this.buildFinishedGroup();
        }
        return this.groupByNodeOrderedByEndTime;
    }

    public List<HistoricTaskInstance> getUnfinished() {
        if (this.unfinished == null) {
            this.unfinished = this.getAllHistoryTask().stream().filter(task -> task.getEndTime() == null).collect(Collectors.toList());
        }
        return this.unfinished;
    }

    private void buildUnfinishedGroup() {
        this.groupByNodeUnfinished = new HashMap<String, Map<String, List<HistoricTaskInstance>>>();
        this.groupBySubProcessUnfinished = new HashMap<String, List<HistoricTaskInstance>>();
        List<HistoricTaskInstance> unfinished = this.getUnfinished();
        for (HistoricTaskInstance historicTaskInstance : unfinished) {
            this.groupByNodeUnfinished.computeIfAbsent(historicTaskInstance.getSubProcessKey(), k -> new HashMap()).computeIfAbsent(historicTaskInstance.getTaskDefinitionKey(), k -> new ArrayList()).add(historicTaskInstance);
            this.groupBySubProcessUnfinished.computeIfAbsent(historicTaskInstance.getSubProcessKey(), k -> new ArrayList()).add(historicTaskInstance);
        }
    }

    public Map<String, List<HistoricTaskInstance>> getGroupBySubProcessUnfinished() {
        if (this.groupBySubProcessUnfinished == null) {
            this.buildUnfinishedGroup();
        }
        return this.groupBySubProcessUnfinished;
    }

    public Map<String, Map<String, List<HistoricTaskInstance>>> getGroupByNodeUnfinished() {
        if (this.groupByNodeUnfinished == null) {
            this.buildUnfinishedGroup();
        }
        return this.groupByNodeUnfinished;
    }

    public static HistoricTaskInstance findFirstTask(List<HistoricTaskInstance> historicTaskInstanceList, Predicate<HistoricTaskInstance> predicate) {
        if (historicTaskInstanceList == null) {
            return null;
        }
        Optional<HistoricTaskInstance> first = historicTaskInstanceList.stream().filter(predicate).findFirst();
        return first.orElse(null);
    }

    public HistoricTaskInstance findFirstEndTask(String subProcessKey, String taskDefKey, Predicate<HistoricTaskInstance> predicate) {
        Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeOrderedByEndTime = this.getGroupByNodeOrderedByEndTime();
        Map<String, List<HistoricTaskInstance>> subProcessTask = groupByNodeOrderedByEndTime.get(subProcessKey);
        if (subProcessTask != null) {
            List<HistoricTaskInstance> nodeTask = subProcessTask.get(taskDefKey);
            if (nodeTask == null && subProcessKey != null) {
                return this.findFirstEndTask(null, taskDefKey, predicate);
            }
            return ProcessHistoryTaskModel.findFirstTask(nodeTask, predicate);
        }
        if (subProcessKey != null) {
            return this.findFirstEndTask(null, taskDefKey, predicate);
        }
        return null;
    }

    public List<HistoricTaskInstance> findAllEndTask(String subProcessKey, String taskDefKey) {
        Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeOrderedByEndTime = this.getGroupByNodeOrderedByEndTime();
        Map<String, List<HistoricTaskInstance>> subProcessTask = groupByNodeOrderedByEndTime.get(subProcessKey);
        if (subProcessTask != null) {
            List<HistoricTaskInstance> nodeTask = subProcessTask.get(taskDefKey);
            if (nodeTask == null && subProcessKey != null) {
                return this.findAllEndTask(null, taskDefKey);
            }
            return nodeTask;
        }
        if (subProcessKey != null) {
            return this.findAllEndTask(null, taskDefKey);
        }
        return null;
    }

    public HistoricTaskInstance findFirstRunningTask(String subProcessKey, String taskDefKey, Predicate<HistoricTaskInstance> predicate) {
        List<HistoricTaskInstance> runningTasks = this.getRunningTasks(subProcessKey, taskDefKey);
        return ProcessHistoryTaskModel.findFirstTask(runningTasks, predicate);
    }

    public static List<HistoricTaskInstance> findAllTask(List<HistoricTaskInstance> historicTaskInstanceList, Predicate<HistoricTaskInstance> predicate) {
        if (historicTaskInstanceList == null) {
            return null;
        }
        return historicTaskInstanceList.stream().filter(predicate).collect(Collectors.toList());
    }

    public List<HistoricTaskInstance> getRunningTasks(String subProcessKey, String taskDefKey) {
        Map<String, Map<String, List<HistoricTaskInstance>>> groupByNodeUnfinished = this.getGroupByNodeUnfinished();
        Map<String, List<HistoricTaskInstance>> subProcessTask = groupByNodeUnfinished.get(subProcessKey);
        if (subProcessTask != null) {
            List<HistoricTaskInstance> historicTaskInstanceList = subProcessTask.get(taskDefKey);
            if (historicTaskInstanceList == null && subProcessTask != null) {
                return this.getRunningTasks(null, taskDefKey);
            }
            return historicTaskInstanceList;
        }
        if (subProcessKey != null) {
            return this.getRunningTasks(null, taskDefKey);
        }
        return null;
    }

    public ProcessHistoryTaskModel(List<HistoricTaskInstance> allHistoryTask) {
        if (allHistoryTask == null) {
            throw new UnsupportedOperationException();
        }
        this.allHistoryTask = allHistoryTask;
    }
}

