/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.flowlog.factory;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.model.SysActExtendProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.extendproperties.service.ISysActExtendPropertiesService;
import com.jxdinfo.hussar.workflow.engine.bpm.flowlog.model.BpmOperationLog;
import com.jxdinfo.hussar.workflow.engine.bpm.flowlog.model.UserLog;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.model.ProcessInst;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.service.ProcessInstService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;

public class LogFactory {
    public static final String ADJUST_APPROVER = "0";
    public static final String INITIATE_PROCESS = "1";
    public static final String APPEND_NODES = "2";
    public static final String PROCESS_APPROVAL = "3";
    public static final String PROCESS_CC = "4";
    private static IAssigneeChooseService iAssigneeChooseService = (IAssigneeChooseService)SpringContextHolder.getBean(IAssigneeChooseService.class);
    private static ISysActExtendPropertiesService iSysActExtendPropertiesService = (ISysActExtendPropertiesService)SpringContextHolder.getBean(ISysActExtendPropertiesService.class);
    private static RepositoryService repositoryService = (RepositoryService)BpmSpringContextHolder.getBean(RepositoryService.class);
    private static ProcessInstService processInstService = (ProcessInstService)BpmSpringContextHolder.getBean(ProcessInstService.class);
    private static HistoryService historyService = (HistoryService)BpmSpringContextHolder.getBean(HistoryService.class);

    public static BpmOperationLog createBpmOperationLog(SecurityUser user, String businessId, String procInstId, String procName, String version, String type, List<UserLog> users, List<UserLog> userList, Map<String, String> info) {
        BpmOperationLog bpmOperationLog = new BpmOperationLog();
        ArrayList<String> userInfo = new ArrayList<String>();
        ArrayList<String> postIds = new ArrayList<String>();
        Map<Object, Object> userInfoMap = new HashMap();
        Map<Object, Object> postMap = new HashMap();
        if (user != null) {
            userInfo.add(user.getExtendUserMap().get("corporationId").toString());
            userInfo.add(user.getId().toString());
            userInfo.add(user.getDeptId().toString());
            postIds.add(user.getExtendUserMap().get("postCurrent").toString());
        }
        if (users != null && !users.isEmpty()) {
            for (UserLog userLog : users) {
                userInfo.add(userLog.getUserId());
                userInfo.add(userLog.getDeptId());
                userInfo.add(userLog.getUnitId());
                postIds.add(userLog.getPostId());
            }
        }
        if (userList != null && !userList.isEmpty()) {
            for (UserLog userLog : userList) {
                userInfo.add(userLog.getUserId());
                userInfo.add(userLog.getDeptId());
                userInfo.add(userLog.getUnitId());
                postIds.add(userLog.getPostId());
            }
        }
        userInfoMap = iAssigneeChooseService.getDepartmentNameBydepartmentIds(userInfo);
        postMap = iAssigneeChooseService.getPostNameBypostIds(postIds);
        if (user != null) {
            bpmOperationLog.setUserId(user.getId().toString());
            bpmOperationLog.setUserName(user.getUserName());
            bpmOperationLog.setDeptId(user.getDeptId().toString());
            bpmOperationLog.setDeptName(user.getDeptName());
            bpmOperationLog.setUnitId(user.getExtendUserMap().get("corporationId").toString());
            bpmOperationLog.setUnitName((String)userInfoMap.get(user.getExtendUserMap().get("corporationId").toString()));
            bpmOperationLog.setPostId(user.getExtendUserMap().get("postCurrent").toString());
            bpmOperationLog.setPostName((String)postMap.get(user.getExtendUserMap().get("postCurrent").toString()));
            bpmOperationLog.setUserAccount(user.getAccount());
        }
        bpmOperationLog.setLogTime(LocalDateTime.now());
        bpmOperationLog.setRemoteAddr(info.get("ip"));
        bpmOperationLog.setRemoteHost(info.get("host"));
        bpmOperationLog.setRemotePort(info.get("port"));
        bpmOperationLog.setLocalAddr(info.get("localIp"));
        bpmOperationLog.setLocalPort(info.get("localPort"));
        bpmOperationLog.setLocalHost(info.get("localHost"));
        bpmOperationLog.setBusinessId(businessId);
        bpmOperationLog.setProcInstId(procInstId);
        bpmOperationLog.setProcName(procName);
        bpmOperationLog.setVersion(version);
        StringBuffer sb = new StringBuffer();
        switch (type) {
            case "0": {
                sb.append(LogFactory.getDetail(LogFactory.getUserLogs(user), userInfoMap, postMap, INITIATE_PROCESS));
                if (userList.isEmpty()) {
                    sb.append("\u5728\u8282\u70b9");
                    sb.append(info.get("taskName"));
                    sb.append("\u6dfb\u52a0\u4e86\u5ba1\u6279\u4eba");
                    sb.append(LogFactory.getDetail(users, userInfoMap, postMap, type));
                } else {
                    sb.append("\u5728\u8282\u70b9");
                    sb.append(info.get("taskName"));
                    sb.append("\u628a\u5ba1\u6279\u4eba\u4ece");
                    sb.append(LogFactory.getDetail(userList, userInfoMap, postMap, type));
                    sb.append("\u8c03\u6574\u6210");
                    sb.append(LogFactory.getDetail(users, userInfoMap, postMap, type));
                }
                if (businessId == null) {
                    ProcessInst inst = (ProcessInst)processInstService.getById((Serializable)((Object)procInstId));
                    bpmOperationLog.setBusinessId(inst.getBusinessId());
                }
                ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)repositoryService.getProcessDefinition(info.get("procDefId"));
                bpmOperationLog.setProcName(processDefinition.getName());
                bpmOperationLog.setVersion(processDefinition.getVersion() + "");
                bpmOperationLog.setProcDefId(info.get("procDefId"));
                bpmOperationLog.setLogContent(sb.toString());
                bpmOperationLog.setTaskName(info.get("taskName"));
                bpmOperationLog.setTaskKey(info.get("taskKey"));
                bpmOperationLog.setLogType(ADJUST_APPROVER);
                bpmOperationLog.setLogTypeName("\u8c03\u6574\u5ba1\u6279\u4eba");
                break;
            }
            case "1": {
                sb.append(LogFactory.getDetail(LogFactory.getUserLogs(user), userInfoMap, postMap, type));
                sb.append("\u53d1\u8d77\u4e86");
                ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)repositoryService.getProcessDefinition(info.get("procDefId"));
                sb.append(processDefinition.getName());
                sb.append("\u6d41\u7a0b");
                bpmOperationLog.setProcName(processDefinition.getName());
                bpmOperationLog.setVersion(processDefinition.getVersion() + "");
                bpmOperationLog.setLogContent(sb.toString());
                bpmOperationLog.setLogType(INITIATE_PROCESS);
                bpmOperationLog.setProcDefId(info.get("procDefId"));
                bpmOperationLog.setLogTypeName("\u53d1\u8d77\u6d41\u7a0b");
                break;
            }
            case "2": {
                sb.append(LogFactory.getDetail(LogFactory.getUserLogs(user), userInfoMap, postMap, type));
                sb.append(info.get("detail"));
                sb.append("\u6dfb\u52a0\u5230\u5ba1\u6279\u8282\u70b9");
                SysActExtendProperties sysActExtendProperties = (SysActExtendProperties)iSysActExtendPropertiesService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysActExtendProperties::getProcDefId, (Object)info.get("procDefId"))).eq(SysActExtendProperties::getTaskDefKey, (Object)info.get("taskKey")));
                sb.append(sysActExtendProperties.getTaskDefName());
                if (users != null && !users.isEmpty()) {
                    sb.append("\u524d,\u5e76\u6dfb\u52a0\u5ba1\u6279\u4eba");
                    sb.append(LogFactory.getDetail(users, userInfoMap, postMap, ADJUST_APPROVER));
                } else {
                    sb.append("\u540e");
                }
                bpmOperationLog.setLogContent(sb.toString());
                bpmOperationLog.setTaskKey(info.get("taskKey"));
                bpmOperationLog.setTaskName(sysActExtendProperties.getTaskDefName());
                bpmOperationLog.setProcDefId(info.get("procDefId"));
                bpmOperationLog.setLogType(APPEND_NODES);
                bpmOperationLog.setLogTypeName("\u6dfb\u52a0\u5ba1\u6279\u8282\u70b9");
                break;
            }
            case "3": {
                if (info.get("taskId") != null && !info.get("taskId").equals("")) {
                    HistoricTaskInstance taskInstance = (HistoricTaskInstance)((HistoricTaskInstanceQuery)historyService.createHistoricTaskInstanceQuery().taskId(info.get("taskId"))).singleResult();
                    info.put("procDefId", taskInstance.getProcessDefinitionId());
                    info.put("taskName", taskInstance.getName());
                    info.put("taskKey", taskInstance.getTaskDefinitionKey());
                    procInstId = taskInstance.getProcessInstanceId();
                }
                ProcessInst inst = (ProcessInst)processInstService.getById((Serializable)((Object)procInstId));
                ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)repositoryService.getProcessDefinition(info.get("procDefId"));
                bpmOperationLog.setBusinessId(inst.getBusinessId());
                bpmOperationLog.setProcName(processDefinition.getName());
                bpmOperationLog.setVersion(processDefinition.getVersion() + "");
                sb.append(LogFactory.getDetail(LogFactory.getUserLogs(user), userInfoMap, postMap, type));
                sb.append("\u5728\u6d41\u7a0b\u8282\u70b9");
                sb.append(info.get("taskName"));
                sb.append("\u5ba1\u6279\u4e86");
                sb.append(processDefinition.getName());
                sb.append("\u6d41\u7a0b,\u5ba1\u6279\u7ed3\u8bba\u662f:");
                if (info.get("approvalType").equals("agree")) {
                    sb.append("\u540c\u610f");
                } else if (info.get("approvalType").equals("suspend")) {
                    sb.append("\u7ec8\u6b62");
                } else if (info.get("approvalType").equals("rectification")) {
                    sb.append("\u8fd4\u56de\u6574\u6539");
                } else if (info.get("approvalType").equals("disagree")) {
                    sb.append("\u4e0d\u540c\u610f");
                } else if (info.get("approvalType").equals("accept")) {
                    sb.append("\u63a5\u53d7");
                } else if (info.get("approvalType").equals("reject")) {
                    sb.append("\u8fd4\u56de\u81f3\u6307\u5b9a\u4eba");
                }
                sb.append(",\u5ba1\u6279\u610f\u89c1\u662f:");
                if (info.get("comment") != null && !info.get("comment").equals("")) {
                    sb.append(info.get("comment"));
                }
                bpmOperationLog.setLogContent(sb.toString());
                bpmOperationLog.setTaskName(info.get("taskName"));
                bpmOperationLog.setTaskKey(info.get("taskKey"));
                bpmOperationLog.setProcDefId(info.get("procDefId"));
                bpmOperationLog.setLogType(PROCESS_APPROVAL);
                bpmOperationLog.setLogTypeName("\u6d41\u7a0b\u5ba1\u6279");
                break;
            }
            case "4": {
                ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)repositoryService.getProcessDefinition(info.get("procDefId"));
                bpmOperationLog.setProcName(processDefinition.getName());
                bpmOperationLog.setVersion(processDefinition.getVersion() + "");
                sb.append(LogFactory.getDetail(LogFactory.getUserLogs(user), userInfoMap, postMap, type));
                sb.append("\u628a\u6d41\u7a0b");
                sb.append(processDefinition.getName());
                sb.append("\u6284\u9001\u7ed9\u4e86");
                sb.append(LogFactory.getDetail(userList, userInfoMap, postMap, type));
                bpmOperationLog.setLogContent(sb.toString());
                bpmOperationLog.setProcDefId(info.get("procDefId"));
                bpmOperationLog.setLogType(PROCESS_CC);
                bpmOperationLog.setLogTypeName("\u6284\u9001");
                break;
            }
            default: {
                throw new PublicClientException("\u6d41\u7a0b\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25");
            }
        }
        return bpmOperationLog;
    }

    private static List<UserLog> getUserLogs(SecurityUser user) {
        if (user == null) {
            return null;
        }
        ArrayList<UserLog> userLogs = new ArrayList<UserLog>();
        UserLog userLog = new UserLog();
        userLog.setUserId(user.getId().toString());
        userLog.setDeptId(user.getDeptId().toString());
        userLog.setPostId(user.getExtendUserMap().get("postCurrent").toString());
        userLog.setUnitId(user.getExtendUserMap().get("corporationId").toString());
        userLogs.add(userLog);
        return userLogs;
    }

    private static String getDetail(List<UserLog> userLogs, Map<String, String> userInfoMap, Map<String, String> postMap, String type) {
        StringBuffer sb = new StringBuffer();
        if (userLogs == null) {
            return sb.toString();
        }
        for (int i = 0; i < userLogs.size(); ++i) {
            sb.append(userInfoMap.get(userLogs.get(i).getUserId()));
            sb.append("(");
            sb.append(userInfoMap.get(userLogs.get(i).getUserId()));
            sb.append(":");
            sb.append(userLogs.get(i).getUserId());
            sb.append(",");
            sb.append(userInfoMap.get(userLogs.get(i).getDeptId()));
            sb.append(":");
            sb.append(userLogs.get(i).getDeptId());
            sb.append(",");
            sb.append(userInfoMap.get(userLogs.get(i).getUnitId()));
            sb.append(":");
            sb.append(userLogs.get(i).getUnitId());
            sb.append(",");
            sb.append(postMap.get(userLogs.get(i).getPostId()));
            sb.append(":");
            sb.append(userLogs.get(i).getPostId());
            if (type.equals(ADJUST_APPROVER)) {
                sb.append(",");
                sb.append("\u662f\u5426\u662f\u4e3b\u5ba1\u6279\u4eba");
                sb.append(":");
                if (userLogs.get(i).getIsMain().equals(INITIATE_PROCESS)) {
                    sb.append("\u662f");
                } else {
                    sb.append("\u5426");
                }
            }
            sb.append(")");
            if (i == userLogs.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

