/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.httpclient;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.bpm.bpmconfig.service.IBpmConfigService;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HttpClient {
    private static final Logger logger = LogManager.getLogger(HttpClient.class);
    private static IBpmConfigService bpmConfigService;

    @Autowired
    public void setBpmConfigService(IBpmConfigService bpmConfigService) {
        HttpClient.bpmConfigService = bpmConfigService;
    }

    private static int getConnectionTimeOut() {
        return (int)bpmConfigService.getLongByKeyUseCache("connection_timeout");
    }

    private static int getReadTimeOut() {
        return (int)bpmConfigService.getLongByKeyUseCache("read_timeout");
    }

    public static String doGet(String url, Map<String, String> param) {
        return HttpClient.baseHttp("get", url, param, null, null);
    }

    public static String doGet(String url, Map<String, String> param, Map<String, String> headers) {
        return HttpClient.baseHttp("get", url, param, null, headers);
    }

    public static String doPost(String url, String body) {
        return HttpClient.baseHttp("post", url, null, body, null);
    }

    public static String doPost(String url, String body, Map<String, String> headers) {
        return HttpClient.baseHttp("post", url, null, body, headers);
    }

    public static String baseHttp(String type, String url, Map<String, String> params, String body, Map<String, String> headers) {
        String result = null;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse response = null;
        try {
            int statusCode;
            HttpPost httpRequest;
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(HttpClient.getConnectionTimeOut()).setConnectTimeout(HttpClient.getConnectionTimeOut()).setSocketTimeout(HttpClient.getReadTimeOut()).setRedirectsEnabled(true).build();
            URIBuilder builder = new URIBuilder(url);
            if (HussarUtils.isNotEmpty(params)) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    builder.addParameter(entry.getKey(), entry.getValue());
                }
            }
            URI uri = builder.build();
            if ("post".equalsIgnoreCase(type)) {
                httpRequest = new HttpPost(uri);
                HttpPost httpPost = httpRequest;
                StringEntity stringEntity = new StringEntity(body, "UTF-8");
                httpPost.setEntity((HttpEntity)stringEntity);
            } else {
                httpRequest = new HttpGet(uri);
            }
            httpRequest.setConfig(requestConfig);
            httpRequest.setHeader("Content-Type", "application/json");
            if (HussarUtils.isNotEmpty(headers)) {
                for (Map.Entry entry : headers.entrySet()) {
                    httpRequest.setHeader((String)entry.getKey(), (String)entry.getValue());
                }
            }
            if ((statusCode = (response = httpClient.execute((HttpUriRequest)httpRequest)).getStatusLine().getStatusCode()) != 200) {
                httpRequest.abort();
                throw new BpmException("HttpClient,error status code :" + statusCode);
            }
            HttpEntity httpEntity = response.getEntity();
            if (null != httpEntity) {
                result = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            EntityUtils.consume((HttpEntity)httpEntity);
        }
        catch (Exception e) {
            logger.error("{}\u8bf7\u6c42\u5931\u8d25\uff01", (Object)url, (Object)e);
            throw new BpmException(e.getMessage());
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
            if (null != httpClient) {
                try {
                    httpClient.close();
                }
                catch (IOException e) {
                    logger.error((Object)e);
                }
            }
        }
        logger.info("{}\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\uff1a{}", (Object)url, (Object)result);
        return result;
    }
}

