/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.customform.util;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class TreeUtil {
    public static <T, T_ID> List<T> flatToTree(Collection<T> flatTree, Function<T, T_ID> getParentId, Function<T, T_ID> getId, BiConsumer<T, List<T>> setChild, Comparator<T> childComparator, T_ID root) {
        if (flatTree.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<Object, List> collect = new HashMap<Object, List>();
        for (Object object : flatTree) {
            collect.computeIfAbsent(getParentId.apply(object), k -> new ArrayList()).add(object);
        }
        if (childComparator != null) {
            collect.values().forEach(list -> list.sort(childComparator));
        }
        flatTree.forEach(node -> {
            Object id = getId.apply(node);
            setChild.accept((Object)node, (List)collect.get(id));
            collect.remove(id);
        });
        if (root != null) {
            return (List)collect.get(root);
        }
        if (collect.size() == 1) {
            return (List)collect.values().iterator().next();
        }
        ArrayList<T> rootNodes = new ArrayList<T>();
        for (List value : collect.values()) {
            if (!HussarUtils.isNotEmpty((Object)value)) continue;
            rootNodes.addAll(value);
        }
        if (childComparator != null) {
            rootNodes.sort(childComparator);
        }
        return rootNodes;
    }

    public static <T, T_ID> List<T> flatToTree(Collection<T> flatTree, Function<T, T_ID> getParentId, Function<T, T_ID> getId, Function<T, List<T>> getChild, BiConsumer<T, List<T>> setChild, Comparator<T> childComparator) {
        if (flatTree.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> root = new ArrayList<T>();
        ArrayList<List<T>> allChild = new ArrayList<List<T>>();
        Map idToNodeMap = flatTree.stream().collect(Collectors.toMap(getId, Function.identity()));
        for (T node : flatTree) {
            List<T> childrenList;
            Object parent = idToNodeMap.get(getParentId.apply(node));
            if (parent == null) {
                root.add(node);
            }
            if ((childrenList = getChild.apply(parent)) == null) {
                childrenList = new ArrayList<T>();
                setChild.accept(parent, childrenList);
                if (childComparator != null) {
                    allChild.add(childrenList);
                }
            }
            childrenList.add(node);
        }
        if (childComparator != null) {
            allChild.add(root);
            allChild.forEach(childList -> childList.sort(childComparator));
        }
        return root;
    }

    public static <T, T_ID> List<T> nodeToTree(Collection<T_ID> nodes, Collection<T> flatTree, Function<T, T_ID> getParentId, Function<T, T_ID> getId, Function<T, List<T>> getChild, BiConsumer<T, List<T>> setChild, Comparator<T> childComparator) {
        ArrayList root = new ArrayList();
        HashSet builtNode = new HashSet();
        ArrayList childListNode = new ArrayList();
        Map idToNodeMap = flatTree.stream().collect(Collectors.toMap(getId, Function.identity()));
        nodes.forEach(node -> {
            Object now = idToNodeMap.get(node);
            while (now != null && !builtNode.contains(getId.apply(now))) {
                builtNode.add(getId.apply(now));
                Object parent = idToNodeMap.get(getParentId.apply(now));
                if (parent == null) {
                    root.add(now);
                    continue;
                }
                ArrayList childrenList = (ArrayList)getChild.apply(parent);
                if (childrenList == null) {
                    childrenList = new ArrayList();
                    setChild.accept(parent, childrenList);
                    if (childComparator != null) {
                        childListNode.add(childrenList);
                    }
                }
                childrenList.add(now);
                now = parent;
            }
        });
        if (childComparator != null) {
            childListNode.add(root);
            childListNode.forEach(childList -> childList.sort(childComparator));
        }
        return root;
    }

    public static <T, T_ID> List<T> nodeToFlatTree(Collection<T_ID> nodes, Collection<T> flatTree, Function<T, T_ID> getParentId, Function<T, T_ID> getId) {
        ArrayList res = new ArrayList();
        HashSet set = new HashSet();
        Map idToNodeMap = flatTree.stream().collect(Collectors.toMap(getId, Function.identity()));
        nodes.forEach(node -> {
            Object now = idToNodeMap.get(node);
            while (now != null && !set.contains(getId.apply(now))) {
                set.add(getId.apply(now));
                res.add(now);
                now = idToNodeMap.get(getParentId.apply(now));
            }
        });
        return res;
    }

    public static <T> void ergodicTree(Collection<T> tree, Function<T, List<T>> getChildren, Consumer<T> function) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        for (T t : tree) {
            function.accept(t);
            TreeUtil.ergodicTree((Collection)getChildren.apply(t), getChildren, function);
        }
    }

    private TreeUtil() {
    }
}

