/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.core.util;

import com.jxdinfo.hussar.common.datasource.service.IDynamicDataSourceService;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class BpmTenantInfoUtils {
    private final LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);
    private static boolean startAlone = false;
    private static boolean multiTenant = true;
    private static IDynamicDataSourceService dynamicDataSourceService = (IDynamicDataSourceService)SpringContextHolder.getBean(IDynamicDataSourceService.class);

    @PostConstruct
    public void init() {
        startAlone = this.lcdpBpmProperties.isStartAlone();
        Environment env = (Environment)SpringContextHolder.getBean(Environment.class);
        if (!startAlone && !"true".equals(env.getProperty("global.tenant-open"))) {
            multiTenant = false;
        }
    }

    public static String getCurrDataBaseType() {
        String url = BpmTenantInfoUtils.getCurrUrl();
        if (ToolUtil.isEmpty((Object)url)) {
            return null;
        }
        return url.split(":")[1];
    }

    public static String getCurrUrl() {
        String url = null;
        Connection connection = null;
        try {
            connection = dynamicDataSourceService.getConnection();
            url = connection.getMetaData().getURL();
        }
        catch (SQLException throwables) {
            throwables.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException throwables) {
                throwables.printStackTrace();
            }
        }
        return url;
    }

    public static boolean isStartAlone() {
        return startAlone;
    }

    public static boolean isMultiTenant() {
        return multiTenant;
    }
}

