/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.utils;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.speedcode.speedcode.visitor.AssemblyVariablesVisitor;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.HttpRequestUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.model.service.ModelService;
import com.jxdinfo.hussar.workflow.engine.bpm.timeouthandle.service.ActivityRedisTimerService;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.GodAxeRequestException;
import com.jxdinfo.hussar.workflow.engine.bsp.exception.PublicClientException;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.model.TenantConfig;
import com.jxdinfo.hussar.workflow.engine.bsp.tenantconfig.service.ITenantConfigService;
import com.jxdinfo.hussar.workflow.engine.core.util.HussarBpmSM4Util;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowNode;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.SequenceFlow;
import org.activiti.engine.RepositoryService;

public class CommonCodeUtil {
    private static boolean isStartAlone;
    private static ModelService modelService;
    private static RepositoryService repositoryService;
    private static ITenantConfigService iTenantConfigService;
    private static BpmConstantProperties bpmConstantProperties;
    private static ActivityRedisTimerService activityRedisTimerService;
    private static final String GodAxePath = "/GodAxeVariables";
    private LcdpBpmProperties lcdpBpmProperties = (LcdpBpmProperties)SpringContextHolder.getBean(LcdpBpmProperties.class);

    @PostConstruct
    private void init() {
        isStartAlone = this.lcdpBpmProperties.isStartAlone();
    }

    public static Map<String, Object> getGodAxeResult(String tenantId, String nodeId, String businessId, String procDefId) {
        String procDefKey = procDefId.split(":")[0];
        String realVersion = String.valueOf(modelService.getRealVersion(procDefId));
        BpmnModel bm = repositoryService.getBpmnModel(procDefId);
        String beanId = procDefKey + ":" + realVersion + CommonCodeUtil.getVisitorNodeId(nodeId, bm);
        Map<Object, Object> variable = new HashMap();
        if (!isStartAlone) {
            AssemblyVariablesVisitor assemblyVariablesVisitor;
            try {
                assemblyVariablesVisitor = (AssemblyVariablesVisitor)SpringContextHolder.getBean(AssemblyVariablesVisitor.class);
            }
            catch (Exception e) {
                return new HashMap<String, Object>();
            }
            try {
                variable = assemblyVariablesVisitor.assemblyVariables(beanId, businessId);
            }
            catch (Exception e) {
                return new HashMap<String, Object>();
            }
        }
        TenantConfig tenantConfig = iTenantConfigService.getTenantConfig(tenantId);
        if (tenantConfig == null) {
            throw new PublicClientException(bpmConstantProperties.getTenantConfigNotExist(), false);
        }
        if ("0".equals(tenantConfig.getIsGodAxe())) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("tenantId", HussarBpmSM4Util.encrypt(tenantId, "admin#$%^kopoiuy"));
        requestMap.put("beanId", beanId);
        requestMap.put("businessId", businessId);
        String result = HttpRequestUtil.getRequestResult(tenantConfig.getProjectAddress() + GodAxePath, requestMap);
        if (ToolUtil.isNotEmpty((Object)result)) {
            try {
                variable = (Map)JSON.parseObject((String)result, HashMap.class);
            }
            catch (Exception e) {
                throw new GodAxeRequestException(1);
            }
        }
        for (Map.Entry<Object, Object> k : variable.entrySet()) {
            Object date;
            if (k.getValue() == null) continue;
            String className = k.getValue().getClass().getName();
            if ("java.lang.String".equals(className) && ToolUtil.isNotEmpty((Object)(date = CommonCodeUtil.isValidDate(k.getValue().toString())))) {
                variable.put(k.getKey(), date);
            }
            if (!"java.math.BigDecimal".equals(className)) continue;
            variable.put(k.getKey(), ((BigDecimal)k.getValue()).doubleValue());
        }
        return variable;
    }

    private static Object isValidDate(String str) {
        SimpleDateFormat format;
        String yMdhmsRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0[1-9]|1[0-2])([-/]?)(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\\s+([01][0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9]$";
        String yMdRegex = "^(?:(?!0000)[0-9]{4}([-/]?)(?:(?:0?[1-9]|1[0-2])\\1(?:0?[1-9]|1[0-9]|2[0-8])|(?:0?[13-9]|1[0-2])\\1(?:29|30)|(?:0?[13578]|1[02])\\1(?:31))|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)([-/]?)0?2\\2(?:29))$";
        String yMRegex = "^\\d{4}([-/]?)(0[1-9]|1[0-2])$";
        String hmsRegex = "([0-1]?[0-9]|2[0-3]):([0-5][0-9]):([0-5][0-9])$";
        if (str.length() == 7) {
            if (!str.matches(yMRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM");
        } else if (str.length() == 10) {
            if (!str.matches(yMdRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd");
        } else if (str.length() == 8) {
            if (!str.matches(hmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("HH:mm:ss");
        } else {
            if (!str.matches(yMdhmsRegex)) {
                return null;
            }
            format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        try {
            format.setLenient(false);
            return format.parse(str);
        }
        catch (ParseException e) {
            return null;
        }
    }

    private static String getVisitorNodeId(String id, BpmnModel bm) {
        Process process = (Process)bm.getProcesses().get(0);
        int num = process.getFlowElements().size();
        while (id.startsWith("jxd_bpm_custom_node")) {
            id = id.contains("parallel_node") ? id.split("parallel_node")[1] : ((SequenceFlow)((FlowNode)process.getFlowElement(id)).getIncomingFlows().get(0)).getSourceRef();
            if (--num >= 0) continue;
            throw new PublicClientException("\u6d41\u7a0b\u56fe\u5f02\u5e38");
        }
        return id;
    }

    public static void triggerEventHandleClass(Map<String, Object> map) {
        BpmnModel bm = repositoryService.getBpmnModel((String)map.get("processDefinitionId"));
        String type = "";
        Object tType = map.get("type");
        if (ToolUtil.isNotEmpty((Object)tType)) {
            type = tType.toString();
        }
        if ("processCreateEnd".equals(type)) {
            activityRedisTimerService.addGlobalTimeOutModel(bm, map);
        } else if ("processCompleteEnd".equals(type)) {
            activityRedisTimerService.delGlobalTimeOutModel(map);
        }
    }

    public static ApiResponse<?> getApiResponse(BpmResponseResult bpmResponseResult) {
        if ("1".equals(bpmResponseResult.getCode())) {
            return ApiResponse.success((Object)bpmResponseResult.getResult(), (String)bpmResponseResult.getMsg());
        }
        return ApiResponse.fail((String)bpmResponseResult.getMsg());
    }

    static {
        modelService = (ModelService)SpringContextHolder.getBean(ModelService.class);
        repositoryService = (RepositoryService)SpringContextHolder.getBean(RepositoryService.class);
        iTenantConfigService = (ITenantConfigService)SpringContextHolder.getBean(ITenantConfigService.class);
        bpmConstantProperties = (BpmConstantProperties)SpringContextHolder.getBean(BpmConstantProperties.class);
        activityRedisTimerService = (ActivityRedisTimerService)SpringContextHolder.getBean(ActivityRedisTimerService.class);
    }
}

