/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.common.properties;

import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="hussar")
public class LcdpBpmProperties {
    public static final String PREFIX = "hussar";
    @Value(value="${hussar.cache.cacheType:ehcache}")
    private String cacheType;
    private String defaultPass = "123456";
    private String fileUploadPathWindows;
    private String fileUploadPathLinux;
    private String fileUploadPathMac;
    private Boolean fileDateSplit = true;
    private Boolean haveCreatePath = false;
    private String modulePath = "modulePath";
    private String versionPath = "versionPath";
    private boolean useRedis;
    private String version = "";
    private boolean startAlone = false;
    private boolean modifyConfigurationOnline = false;
    private boolean useSecurityLevel = false;
    private boolean editableOnline = false;
    private boolean orderByTime;
    private int readTimeOut = 60000;
    private int connectionTimeOut = 60000;

    public int getReadTimeOut() {
        return this.readTimeOut;
    }

    public void setReadTimeOut(int readTimeOut) {
        this.readTimeOut = readTimeOut;
    }

    public int getConnectionTimeOut() {
        return this.connectionTimeOut;
    }

    public void setConnectionTimeOut(int connectionTimeOut) {
        this.connectionTimeOut = connectionTimeOut;
    }

    public boolean isOrderByTime() {
        return this.orderByTime;
    }

    public void setOrderByTime(boolean orderByTime) {
        this.orderByTime = orderByTime;
    }

    public String getFileUploadPath() {
        String fileUploadPath = "";
        boolean fileDateSplit = this.getFileDateSplit();
        Properties prop = System.getProperties();
        String os = prop.getProperty("os.name");
        if (os != null) {
            fileUploadPath = os.toLowerCase().indexOf("windows") > -1 ? this.fileUploadPathWindows : (os.toLowerCase().indexOf("linux") > -1 ? this.fileUploadPathLinux : this.fileUploadPathMac);
        }
        if (fileDateSplit) {
            fileUploadPath = fileUploadPath + "/" + new SimpleDateFormat("yyyy/MM/dd").format(new Date());
        }
        if (ToolUtil.isEmpty((Object)fileUploadPath)) {
            return ToolUtil.getTempPath();
        }
        if (!fileUploadPath.endsWith(File.separator)) {
            fileUploadPath = fileUploadPath + File.separator;
        }
        if (!this.haveCreatePath.booleanValue()) {
            File file = new File(fileUploadPath);
            file.mkdirs();
            this.haveCreatePath = true;
        }
        return fileUploadPath;
    }

    public boolean isStartAlone() {
        return this.startAlone;
    }

    public void setStartAlone(boolean startAlone) {
        this.startAlone = startAlone;
    }

    public void setFileUploadPathWindows(String fileUploadPathWindows) {
        this.fileUploadPathWindows = fileUploadPathWindows;
    }

    public void setFileUploadPathLinux(String fileUploadPathLinux) {
        this.fileUploadPathLinux = fileUploadPathLinux;
    }

    public Boolean getFileDateSplit() {
        return this.fileDateSplit;
    }

    public void setFileDateSplit(Boolean fileDateSplit) {
        this.fileDateSplit = fileDateSplit;
    }

    public String getFileUploadPathWindows() {
        return this.fileUploadPathWindows;
    }

    public String getFileUploadPathLinux() {
        return this.fileUploadPathLinux;
    }

    public Boolean getHaveCreatePath() {
        return this.haveCreatePath;
    }

    public void setHaveCreatePath(Boolean haveCreatePath) {
        this.haveCreatePath = haveCreatePath;
    }

    public String getDefaultPass() {
        return this.defaultPass;
    }

    public void setDefaultPass(String defaultPass) {
        this.defaultPass = defaultPass;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public String getBpmListenerPath() {
        return null;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public String getVersionPath() {
        return this.versionPath;
    }

    public void setVersionPath(String versionPath) {
        this.versionPath = versionPath;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isUseRedis() {
        boolean flag = false;
        if ("redis".equals(this.cacheType)) {
            flag = true;
        }
        return flag;
    }

    public void setUseRedis(boolean useRedis) {
        this.useRedis = useRedis;
    }

    public boolean isModifyConfigurationOnline() {
        return this.modifyConfigurationOnline;
    }

    public void setModifyConfigurationOnline(boolean modifyConfigurationOnline) {
        this.modifyConfigurationOnline = modifyConfigurationOnline;
    }

    public boolean isUseSecurityLevel() {
        return this.useSecurityLevel;
    }

    public void setUseSecurityLevel(boolean useSecurityLevel) {
        this.useSecurityLevel = useSecurityLevel;
    }

    public boolean isEditableOnline() {
        return this.editableOnline;
    }

    public void setEditableOnline(boolean editableOnline) {
        this.editableOnline = editableOnline;
    }
}

