/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.callback.business.taskmodel.service.impl;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.task.model.dto.CompleteTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.DeletedTaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.ProcessNodeInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.TaskInfoDto;
import com.jxdinfo.hussar.workflow.task.model.dto.UpdateTaskUserDto;
import com.jxdinfo.hussar.workflow.task.model.service.TaskModelService;
import com.jxdinfo.hussar.workflow.task.model.util.TaskModelServiceBeanUtil;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.stereotype.Service;

@Service
public class WorkflowCallbackTaskModelInnerServiceImpl {
    private static Logger logger = LogManager.getLogger(WorkflowCallbackTaskModelInnerServiceImpl.class);

    public void addTaskInfoPush(TaskInfoDto taskInfoDto) {
        TaskModelService taskModelService = null;
        try {
            taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)taskInfoDto.getProcessKey());
            if (HussarUtils.isEmpty((Object)taskModelService)) {
                return;
            }
            Integer num = taskModelService.addTaskInfo(taskInfoDto);
            if (num <= 0) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
        }
        catch (BpmException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
        }
    }

    public void completeTaskPush(List<CompleteTaskInfoDto> completeTaskInfoDtos) {
        CompleteTaskInfoDto completeTaskInfoDto = completeTaskInfoDtos.get(0);
        String processKey = null;
        if (HussarUtils.isNotEmpty((Object)completeTaskInfoDto)) {
            processKey = completeTaskInfoDto.getProcessKey();
        }
        TaskModelService taskModelService = null;
        try {
            taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processKey);
            if (HussarUtils.isEmpty((Object)taskModelService)) {
                return;
            }
            boolean flag = taskModelService.completeTask(completeTaskInfoDtos);
            if (!flag) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
        }
        catch (BpmException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
        }
    }

    public void updateTaskUserPush(List<UpdateTaskUserDto> updateTaskUserDtos) {
        UpdateTaskUserDto updateTaskUserDto = updateTaskUserDtos.get(0);
        TaskModelService taskModelService = null;
        try {
            taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)updateTaskUserDto.getProcessKey());
            if (HussarUtils.isEmpty((Object)taskModelService)) {
                return;
            }
            Integer num = taskModelService.updateTaskUser(updateTaskUserDtos);
            if (num <= 0) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
        }
        catch (BpmException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
        }
    }

    public void deleteTaskInfoPush(List<DeletedTaskInfoDto> deletedTaskInfoDtos) {
        DeletedTaskInfoDto deletedTaskInfoDto = deletedTaskInfoDtos.get(0);
        String processKey = null;
        if (HussarUtils.isNotEmpty((Object)deletedTaskInfoDto)) {
            processKey = deletedTaskInfoDto.getProcessKey();
        }
        TaskModelService taskModelService = null;
        try {
            taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processKey);
            if (HussarUtils.isEmpty((Object)taskModelService)) {
                return;
            }
            boolean flag = taskModelService.deleteTaskInfo(deletedTaskInfoDtos);
            if (!flag) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
        }
        catch (BpmException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
        }
    }

    public void deleteProcessPush(List<DeletedProcessInfoDto> deletedProcessInfoDtos) {
        DeletedProcessInfoDto deletedProcessInfoDto = deletedProcessInfoDtos.get(0);
        String processKey = null;
        if (HussarUtils.isNotEmpty((Object)deletedProcessInfoDto)) {
            processKey = deletedProcessInfoDto.getProcessKey();
        }
        TaskModelService taskModelService = null;
        try {
            taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processKey);
            if (HussarUtils.isEmpty((Object)taskModelService)) {
                return;
            }
            boolean flag = taskModelService.deleteProcess(deletedProcessInfoDtos);
            if (!flag) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
        }
        catch (BpmException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
        }
    }

    public void changeProcessInfoPush(ProcessInfoDto processInfoDto) {
        TaskModelService taskModelService = null;
        try {
            taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processInfoDto.getProcessKey());
            if (HussarUtils.isEmpty((Object)taskModelService)) {
                return;
            }
            boolean flag = taskModelService.changeProcessInfo(processInfoDto);
            if (!flag) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
        }
        catch (BpmException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
        }
    }

    public void changeProcessNodePush(ProcessNodeInfoDto processNodeInfoDto) {
        TaskModelService taskModelService = null;
        try {
            taskModelService = TaskModelServiceBeanUtil.getVisitorBean((String)processNodeInfoDto.getProcessKey());
            if (HussarUtils.isEmpty((Object)taskModelService)) {
                return;
            }
            boolean flag = taskModelService.changeProcessNode(processNodeInfoDto);
            if (!flag) {
                throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
            }
        }
        catch (BpmException e) {
            throw e;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL_WITH_BEAN_ERROR.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new BpmException(BpmExceptionCodeEnum.TASK_MODEL_BACK_FILL_FAIL.getMessage());
        }
    }
}

