/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.callback.business.listener.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.config.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.CallActivityInfo;
import com.jxdinfo.hussar.workflow.manage.bpm.constant.SubProcessInfo;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowCallbackListenerHttpServiceImpl {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    public void executionListener(String requestMethod, String beanId, Map<String, Object> map) {
        String result;
        if (!beanId.startsWith("/")) {
            beanId = "/" + beanId;
        }
        String url = this.lcdpBpmProperties.getTenantCallAddress() + beanId;
        if (HussarUtils.isEmpty((Object)requestMethod)) {
            requestMethod = "POST";
        }
        switch (requestMethod) {
            case "GET": {
                result = HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                break;
            }
            case "POST": {
                result = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                break;
            }
            default: {
                throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
            }
        }
        if (HussarUtils.isNotEmpty((Object)result)) {
            Object success = null;
            try {
                JSONObject object = JSONObject.parseObject((String)result);
                success = object.get((Object)"success");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (Boolean.FALSE.equals(success)) {
                throw new BpmException(BpmExceptionCodeEnum.LISTENER_EXECUTION_ERROR);
            }
        }
    }

    public List<CallActivityInfo> executionCallActivityListener(String requestMethod, String beanId, Map<String, Object> map) {
        if (!beanId.startsWith("/")) {
            beanId = "/" + beanId;
        }
        String url = this.lcdpBpmProperties.getTenantCallAddress() + beanId;
        switch (requestMethod) {
            case "GET": {
                String result = HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                return JSONArray.parseArray((String)result, CallActivityInfo.class);
            }
            case "POST": {
                String postResult = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                return JSONArray.parseArray((String)postResult, CallActivityInfo.class);
            }
        }
        throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
    }

    public List<SubProcessInfo> executeSubProcessListener(String requestMethod, String beanId, Map<String, Object> map) {
        if (!beanId.startsWith("/")) {
            beanId = "/" + beanId;
        }
        String url = this.lcdpBpmProperties.getTenantCallAddress() + beanId;
        switch (requestMethod) {
            case "GET": {
                String result = HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                return JSONArray.parseArray((String)result, SubProcessInfo.class);
            }
            case "POST": {
                String postResult = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                return JSONArray.parseArray((String)postResult, SubProcessInfo.class);
            }
        }
        throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
    }

    public Map<String, Object> executeProcessVariableListener(String requestMethod, String beanId, Map<String, Object> map) {
        if (!beanId.startsWith("/")) {
            beanId = "/" + beanId;
        }
        String url = this.lcdpBpmProperties.getTenantCallAddress() + beanId;
        switch (requestMethod) {
            case "GET": {
                String result = HttpClient.doGet((String)url, (Map)((Map)JSON.parseObject((String)JSON.toJSONString(map), Map.class)));
                return (Map)JSONObject.parseObject((String)result, Map.class);
            }
            case "POST": {
                String postResult = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                return (Map)JSONObject.parseObject((String)postResult, Map.class);
            }
        }
        throw new BpmException(BpmExceptionCodeEnum.LISTENER_REQUEST_METHOD_ERROR);
    }
}

