/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.callback.business.function.service.impl;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.workflow.config.properties.LcdpBpmProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.function.model.SysActFunction;
import com.jxdinfo.hussar.workflow.engine.bpm.httpclient.HttpClient;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmException;
import com.jxdinfo.hussar.workflow.engine.common.exception.BpmExceptionCodeEnum;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkflowCallbackFunctionHttpServiceImpl {
    @Autowired
    private LcdpBpmProperties lcdpBpmProperties;

    public List<String> getFunctionResult(SysActFunction function, Map<String, String> map) {
        String url = this.lcdpBpmProperties.getTenantCallAddress() + function.getFunctionBean();
        try {
            switch (function.getRequestMethod()) {
                case "GET": {
                    String response = HttpClient.doGet((String)url, map);
                    return JSON.parseArray((String)response, String.class);
                }
                case "POST": {
                    String response = HttpClient.doPost((String)url, (String)JSON.toJSONString(map));
                    return JSON.parseArray((String)response, String.class);
                }
            }
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCTION_REQUEST_METHOD);
        }
        catch (Exception e) {
            String errorMsg = "\u8c03\u7528\u51fd\u6570" + function.getFunctionName() + "\u5931\u8d25";
            throw new BpmException(BpmExceptionCodeEnum.ERROR_FUNCATION_REQUEST.getCode(), errorMsg);
        }
    }
}

