/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.bpa.processcount.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.bpa.processcount.dao.ProcessCountMapper;
import com.jxdinfo.hussar.workflow.bpa.processcount.dto.QueryProcessInstanceDto;
import com.jxdinfo.hussar.workflow.bpa.processcount.dto.QueryProcessStatusDto;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.AllProcessCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.NodeTimeModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.ParticipateInstanceModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.ProcessDayCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.ProcessInstanceCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.ProcessInstanceDrillModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.ProcessTimeModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.RejectCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.ResponseCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.TaskCountModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.model.TaskSourceFlagModel;
import com.jxdinfo.hussar.workflow.bpa.processcount.service.IProcessCountService;
import com.jxdinfo.hussar.workflow.bpa.processcount.utils.BpaQuarter;
import com.jxdinfo.hussar.workflow.engine.bpm.assignee.service.IAssigneeChooseService;
import com.jxdinfo.hussar.workflow.engine.bpm.common.properties.BpmConstantProperties;
import com.jxdinfo.hussar.workflow.engine.bpm.common.utils.BpmWorkflowTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.bpm.translate.util.BpmTranslateUtil;
import com.jxdinfo.hussar.workflow.engine.constant.TaskSourceFlag;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcessCountServiceImpl
implements IProcessCountService {
    @Resource
    private ProcessCountMapper processCountMapper;
    @Autowired
    private IAssigneeChooseService iAssigneeChooseService;
    @Autowired
    private BpmConstantProperties bpmConstantProperties;
    public static final int EIGHT = 8;
    public static final String START_TIME = "startTime";
    public static final String END_TIME = "endTime";
    public static final String START_OF_THE_YEAR = "-01-01";
    public static final String USERID = "USERID";

    public ResponseCountModel queryProcessCountModel() {
        ResponseCountModel result = new ResponseCountModel();
        result.setModel(Integer.valueOf(this.processCountMapper.queryAllModelCount()));
        result.setCompleteInstance(this.processCountMapper.getCompleteInstanceCount());
        result.setRunningInstance(this.processCountMapper.getRunningInstanceCount());
        result.setCompleteTask(this.processCountMapper.getCompleteTaskCount());
        result.setRunningTask(this.processCountMapper.getRunningTaskCount());
        List<TaskSourceFlagModel> taskSourceFlagCount = this.processCountMapper.getTaskSourceFlagCount();
        int revoke = 0;
        int reject = 0;
        for (TaskSourceFlagModel taskSourceFlagModel : taskSourceFlagCount) {
            if (TaskSourceFlag.isRevoke((String)taskSourceFlagModel.getTaskSourceFlag())) {
                revoke += taskSourceFlagModel.getNum().intValue();
                continue;
            }
            if (!TaskSourceFlag.isReject((String)taskSourceFlagModel.getTaskSourceFlag())) continue;
            reject += taskSourceFlagModel.getNum().intValue();
        }
        result.setRejectTask(Integer.valueOf(reject));
        result.setRevokeTask(Integer.valueOf(revoke));
        result.setAllDuration(this.processCountMapper.getProcessAllDuration() == null ? "0.00" : String.valueOf(this.processCountMapper.getProcessAllDuration()));
        if (result.getCompleteInstance() + result.getRunningInstance() == 0) {
            result.setProcessCompleteRate("0.00%");
        } else {
            result.setProcessCompleteRate(String.format("%.2f", (double)(result.getCompleteInstance() * 100) / (double)(result.getCompleteInstance() + result.getRunningInstance())) + "%");
        }
        if (result.getCompleteTask() + result.getRunningTask() == 0) {
            result.setTaskCompleteRate("0.00%");
        } else {
            result.setTaskCompleteRate(String.format("%.2f", (double)(result.getCompleteTask() * 100) / (double)(result.getCompleteTask() + result.getRunningTask())) + "%");
        }
        return result;
    }

    public IPage<ResponseCountModel> queryProcessInstanceList(Page page) {
        IPage<ResponseCountModel> processlist = this.processCountMapper.getProcessInstanceRanking(page);
        List<ResponseCountModel> tasklist = this.processCountMapper.getTaskInstanceRanking();
        block0: for (ResponseCountModel process : processlist.getRecords()) {
            for (ResponseCountModel task : tasklist) {
                if (!process.getProcessKey().equals(task.getProcessKey())) continue;
                process.setProcessCompleteRate(String.format("%.2f", (double)(process.getCompleteInstance() * 100) / (double)(process.getCompleteInstance() + process.getRunningInstance())) + "%");
                process.setRunningTask(task.getRunningTask());
                process.setCompleteTask(task.getCompleteTask());
                process.setTaskCompleteRate(String.format("%.2f", (double)(process.getCompleteTask() * 100) / (double)(process.getCompleteTask() + process.getRunningTask())) + "%");
                continue block0;
            }
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)processlist.getRecords(), ResponseCountModel.class).translate(ResponseCountModel::getNameTranslateKey, ResponseCountModel::setProcessName).execute();
        return processlist;
    }

    public IPage<ProcessTimeModel> queryInstanceTodoTaskCount(Page page, QueryProcessInstanceDto queryProcessInstanceDto) {
        IPage<ProcessTimeModel> pages = this.processCountMapper.queryTodoTaskCount(page, queryProcessInstanceDto);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)pages.getRecords(), ProcessTimeModel.class).translate(ProcessTimeModel::getNameTranslateKey, ProcessTimeModel::setProcessName).execute();
        return pages;
    }

    public IPage<NodeTimeModel> queryInstanceTodoTaskCountByProcessKey(Page page, QueryProcessStatusDto queryProcessStatusDto) {
        page.addOrder(new OrderItem[]{OrderItem.desc((String)"nodeTaskCount")});
        IPage<NodeTimeModel> pages = this.processCountMapper.queryInstanceTodoTaskCount(page, queryProcessStatusDto);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)pages.getRecords(), NodeTimeModel.class).translate(NodeTimeModel::getNameTranslateKey, NodeTimeModel::setTaskDefinitionName).execute();
        return pages;
    }

    public AllProcessCountModel queryAllProcessCountMsg() {
        return this.processCountMapper.queryAllProcessCountMsg();
    }

    public Map<String, List<ProcessDayCountModel>> getDayChangeCountModel() {
        HashMap<String, List<ProcessDayCountModel>> result = new HashMap<String, List<ProcessDayCountModel>>(8);
        ArrayList<ProcessDayCountModel> processCompleteDayCountModelList = new ArrayList<ProcessDayCountModel>();
        ArrayList<ProcessDayCountModel> processAddDayCountModelList = new ArrayList<ProcessDayCountModel>();
        ArrayList<ProcessDayCountModel> taskCompleteDayCountModelList = new ArrayList<ProcessDayCountModel>();
        ArrayList<ProcessDayCountModel> taskAddDayCountModelList = new ArrayList<ProcessDayCountModel>();
        Date endTime = new Date();
        LocalDateTime start = LocalDateTime.of(LocalDate.now(), LocalTime.MIN);
        Date todayStartTime = Date.from(start.atZone(ZoneId.systemDefault()).toInstant());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(todayStartTime);
        calendar.add(5, -7);
        Date startTime = calendar.getTime();
        for (int i = 1; i < 8; ++i) {
            ProcessDayCountModel processCompleteDayCountModel = new ProcessDayCountModel();
            ProcessDayCountModel processAddDayCountModel = new ProcessDayCountModel();
            ProcessDayCountModel taskCompleteDayCountModel = new ProcessDayCountModel();
            ProcessDayCountModel taskAddDayCountModel = new ProcessDayCountModel();
            Date date = DateUtils.addDays((Date)startTime, (int)i);
            processCompleteDayCountModel.setMouthDay(date);
            processAddDayCountModel.setMouthDay(date);
            taskCompleteDayCountModel.setMouthDay(date);
            taskAddDayCountModel.setMouthDay(date);
            processCompleteDayCountModelList.add(processCompleteDayCountModel);
            processAddDayCountModelList.add(processAddDayCountModel);
            taskCompleteDayCountModelList.add(taskCompleteDayCountModel);
            taskAddDayCountModelList.add(taskAddDayCountModel);
        }
        result.put("processComplete", this.setDayCountModel("process", "complete", startTime, endTime, processCompleteDayCountModelList));
        result.put("processAdd", this.setDayCountModel("process", "add", startTime, endTime, processAddDayCountModelList));
        result.put("taskComplete", this.setDayCountModel("task", "complete", startTime, endTime, taskCompleteDayCountModelList));
        result.put("taskAdd", this.setDayCountModel("task", "add", startTime, endTime, taskAddDayCountModelList));
        return result;
    }

    private List<ProcessDayCountModel> setDayCountModel(String ptType, String type, Date startTime, Date endTime, List<ProcessDayCountModel> model) {
        List<ProcessDayCountModel> newModel = this.processCountMapper.getDayChangeCountModel(ptType, type, startTime, endTime);
        for (ProcessDayCountModel newModelList : model) {
            int countnum = 0;
            for (ProcessDayCountModel taskAddModel : newModel) {
                if (!DateUtil.format((Date)newModelList.getMouthDay(), (String)"yyyy-MM-dd").equals(DateUtil.format((Date)taskAddModel.getMouthDay(), (String)"yyyy-MM-dd"))) continue;
                ++countnum;
            }
            newModelList.setCountNum(Integer.valueOf(countnum));
        }
        return model;
    }

    public IPage<ProcessTimeModel> queryProcessConsumeTime(Page page, QueryProcessInstanceDto queryProcessInstanceDto) {
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        IPage<ProcessTimeModel> pages = this.processCountMapper.queryProcessAvgTime(startTime, endTime, page);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)pages.getRecords(), ProcessTimeModel.class).translate(ProcessTimeModel::getNameTranslateKey, ProcessTimeModel::setProcessName).execute();
        return pages;
    }

    public IPage<NodeTimeModel> queryNodeConsumeTimeByProcessKey(Page page, QueryProcessInstanceDto queryProcessInstanceDto) {
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        page.addOrder(new OrderItem[]{OrderItem.desc((String)"nodeTime")});
        IPage<NodeTimeModel> pages = this.processCountMapper.queryNodeConsumeTimeByProcessKey(queryProcessInstanceDto.getProcessKey(), startTime, endTime, page);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)pages.getRecords(), NodeTimeModel.class).translate(NodeTimeModel::getNameTranslateKey, NodeTimeModel::setTaskDefinitionName).execute();
        return pages;
    }

    public List<ProcessInstanceCountModel> queryProcessModelTree() {
        List<ProcessInstanceCountModel> list = this.processCountMapper.queryProcessModelTree();
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(list, ProcessInstanceCountModel.class).translate(ProcessInstanceCountModel::getNameTranslateKey, ProcessInstanceCountModel::setProcessName).execute();
        return list;
    }

    public ApiResponse<List<ProcessInstanceCountModel>> queryProcessStatusForChart() {
        List<AllProcessCountModel> allProcessCountModel = this.processCountMapper.queryProcessStatus(null, null);
        List processStatusList = ProcessInstanceCountModel.getProcessStatusList((AllProcessCountModel)allProcessCountModel.get(0));
        return ApiResponse.success((Object)processStatusList);
    }

    public ApiResponse<Page<ProcessInstanceCountModel>> queryProcessStatusForList() {
        List<AllProcessCountModel> allProcessCountModel = this.processCountMapper.queryProcessStatus(null, null);
        List processStatusList = ProcessInstanceCountModel.getProcessStatusList((AllProcessCountModel)allProcessCountModel.get(0));
        Page resultPage = new Page();
        resultPage.setRecords(processStatusList);
        resultPage.setTotal((long)processStatusList.size());
        return ApiResponse.success((Object)resultPage);
    }

    public ApiResponse<Page<TaskCountModel>> queryProcessTaskStatusList(Page<TaskCountModel> page, QueryProcessStatusDto queryProcessStatusDto) {
        List<Long> processInstIdList;
        List<Object> taskList = new ArrayList();
        String statusName = null;
        if ("normal".equals(queryProcessStatusDto.getStatus())) {
            processInstIdList = this.processCountMapper.queryProcessTaskNormalStatusProcessInstIdList(page, queryProcessStatusDto.getKeyword(), queryProcessStatusDto.getProcessKey());
            if (HussarUtils.isNotEmpty(processInstIdList)) {
                taskList = this.processCountMapper.queryProcessTaskNormalStatusList(processInstIdList);
                statusName = "\u8fdb\u884c\u4e2d";
            }
        } else if ("end".equals(queryProcessStatusDto.getStatus())) {
            taskList = this.processCountMapper.queryProcessTaskEndStatusList(page, queryProcessStatusDto.getKeyword(), queryProcessStatusDto.getProcessKey());
            statusName = "\u7ed3\u675f";
        } else if ("pause".equals(queryProcessStatusDto.getStatus())) {
            processInstIdList = this.processCountMapper.queryProcessTaskPauseStatusProcessInstIdList(page, queryProcessStatusDto.getKeyword(), queryProcessStatusDto.getProcessKey());
            if (HussarUtils.isNotEmpty(processInstIdList)) {
                taskList = this.processCountMapper.queryProcessTaskPauseStatusList(processInstIdList);
                statusName = "\u6302\u8d77";
            }
        } else if ("terminated".equals(queryProcessStatusDto.getStatus())) {
            taskList = this.processCountMapper.queryProcessTaskTerminatedStatusList(page, queryProcessStatusDto.getKeyword(), queryProcessStatusDto.getProcessKey());
            statusName = "\u7ec8\u6b62";
        }
        if (HussarUtils.isNotEmpty(taskList)) {
            HashMap<String, TaskCountModel> map = new HashMap<String, TaskCountModel>();
            HashSet<String> procInsIdList = new HashSet<String>();
            for (TaskCountModel taskCountModel : taskList) {
                taskCountModel.setStatus(queryProcessStatusDto.getStatus());
                taskCountModel.setStatusName(statusName);
                if (Integer.parseInt(taskCountModel.getVer()) <= 0) {
                    taskCountModel.setVer(this.bpmConstantProperties.getTempVersion());
                }
                if (procInsIdList.add(taskCountModel.getProcessInsId())) {
                    map.put(taskCountModel.getProcessInsId(), taskCountModel);
                    continue;
                }
                TaskCountModel taskCountModel2 = (TaskCountModel)map.get(taskCountModel.getProcessInsId());
                taskCountModel2.setTaskDefinitionName(taskCountModel2.getTaskDefinitionName() + "," + taskCountModel.getTaskDefinitionName());
            }
            page.setRecords(new ArrayList(map.values()));
        }
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel((Object)page.getRecords(), TaskCountModel.class).translate(TaskCountModel::getProcNameTranslateKey, TaskCountModel::setProcessName).translate(TaskCountModel::getTaskNameTranslateKey, TaskCountModel::setTaskDefinitionName).execute();
        return ApiResponse.success(page);
    }

    public ApiResponse<List<ParticipateInstanceModel>> queryParticipateProcessForChart(QueryProcessInstanceDto queryProcessInstanceDto) {
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<ParticipateInstanceModel> result = this.processCountMapper.queryParticipateProcessList(null, queryProcessInstanceDto.getUserId(), null, startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, ParticipateInstanceModel.class).translate(ParticipateInstanceModel::getNameTranslateKey, ParticipateInstanceModel::setProcessName).execute();
        return ApiResponse.success(result);
    }

    public ApiResponse<Page<ParticipateInstanceModel>> queryParticipateProcessForList(Page<ParticipateInstanceModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<ParticipateInstanceModel> result = this.processCountMapper.queryParticipateProcessList(page, queryProcessInstanceDto.getUserId(), null, startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, ParticipateInstanceModel.class).translate(ParticipateInstanceModel::getNameTranslateKey, ParticipateInstanceModel::setProcessName).execute();
        page.setRecords(result);
        return ApiResponse.success(page);
    }

    private HashMap<String, Date> computeStartAndEndTime(QueryProcessInstanceDto queryProcessInstanceDto) {
        Date startTime = null;
        Date endTime = null;
        if ("day".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)queryProcessInstanceDto.getDayTime(), (String)"yyyy-MM-dd");
            endTime = DateUtil.addDay((Date)startTime, (int)1);
        } else if ("month".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)(queryProcessInstanceDto.getMonthMonth() + "-01"), (String)"yyyy-MM-dd");
            endTime = DateUtil.addMonth((Date)startTime, (int)1);
        } else if ("year".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)(queryProcessInstanceDto.getYearYear() + START_OF_THE_YEAR), (String)"yyyy-MM-dd");
            endTime = DateUtil.addYear((Date)startTime, (int)1);
        } else if ("quarter".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)(queryProcessInstanceDto.getQuarterYear() + START_OF_THE_YEAR), (String)"yyyy-MM-dd");
            startTime = DateUtil.addMonth((Date)startTime, (int)(queryProcessInstanceDto.getQuarterQuarter() * 3));
            endTime = DateUtil.addMonth((Date)startTime, (int)3);
        } else if ("auto".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)queryProcessInstanceDto.getAutoStartTime(), (String)"yyyy-MM-dd");
            endTime = DateUtil.addDay((Date)DateUtil.parse((String)queryProcessInstanceDto.getAutoEndTime(), (String)"yyyy-MM-dd"), (int)1);
        }
        HashMap<String, Date> map = new HashMap<String, Date>(8);
        map.put(START_TIME, startTime);
        map.put(END_TIME, endTime);
        return map;
    }

    public ApiResponse<Page<ProcessInstanceDrillModel>> queryParticipateProcessNumberDrill(Page<ProcessInstanceDrillModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success(page);
        }
        queryProcessInstanceDto.setStartTime(map.get(START_TIME));
        queryProcessInstanceDto.setEndTime(map.get(END_TIME));
        List<ProcessInstanceDrillModel> result = this.processCountMapper.queryParticipateProcessNumberDrill(page, queryProcessInstanceDto);
        page.setRecords(result);
        return ApiResponse.success(page);
    }

    public ApiResponse<Page<TaskCountModel>> queryParticipateTaskNumberDrill(Page<TaskCountModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success(page);
        }
        queryProcessInstanceDto.setStartTime(map.get(START_TIME));
        queryProcessInstanceDto.setEndTime(map.get(END_TIME));
        List<TaskCountModel> result = this.processCountMapper.queryParticipateTaskNumberDrill(page, queryProcessInstanceDto);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, TaskCountModel.class).translate(TaskCountModel::getTaskNameTranslateKey, TaskCountModel::setTaskDefinitionName).execute();
        page.setRecords(result);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<ProcessInstanceCountModel>> queryHotProcess(Page<ProcessInstanceCountModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        page.setSize((long)queryProcessInstanceDto.getSize().intValue());
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<ProcessInstanceCountModel> result = this.processCountMapper.queryHotProcess(page, startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, ProcessInstanceCountModel.class).translate(ProcessInstanceCountModel::getNameTranslateKey, ProcessInstanceCountModel::setProcessName).execute();
        return ApiResponse.success(result);
    }

    public ApiResponse<Page<ProcessInstanceCountModel>> queryHotProcessForList(Page<ProcessInstanceCountModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        page.setSize((long)queryProcessInstanceDto.getSize().intValue());
        Page newPage = new Page();
        newPage.setSize((long)queryProcessInstanceDto.getSize().intValue());
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success(page);
        }
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<ProcessInstanceCountModel> result = this.processCountMapper.queryHotProcess((Page<ProcessInstanceCountModel>)newPage, startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, ProcessInstanceCountModel.class).translate(ProcessInstanceCountModel::getNameTranslateKey, ProcessInstanceCountModel::setProcessName).execute();
        page.setTotal((long)result.size());
        List<ProcessInstanceCountModel> newList = null;
        newList = (long)result.size() >= page.getCurrent() * page.getSize() ? result.subList((int)((page.getCurrent() - 1L) * page.getSize()), (int)(page.getCurrent() * page.getSize())) : result.subList((int)((page.getCurrent() - 1L) * page.getSize()), result.size());
        page.setRecords(newList);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<ProcessInstanceCountModel>> queryProcessNumberList(QueryProcessInstanceDto queryProcessInstanceDto) {
        List<String> processKeys = null;
        if (HussarUtils.isNotEmpty((Object)queryProcessInstanceDto.getProcessKeys())) {
            processKeys = Arrays.asList(queryProcessInstanceDto.getProcessKeys().split(","));
        }
        Date startTime = null;
        Date endTime = null;
        List<ProcessInstanceCountModel> result = null;
        if ("day".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)queryProcessInstanceDto.getDayTime(), (String)"yyyy-MM-dd");
            endTime = DateUtil.addDay((Date)startTime, (int)1);
            result = this.processCountMapper.queryProcessNumberList(processKeys, startTime, endTime);
            result.get(0).setStatisTime(queryProcessInstanceDto.getDayTime());
        } else if ("month".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)(queryProcessInstanceDto.getYearYear() + START_OF_THE_YEAR), (String)"yyyy-MM-dd");
            endTime = DateUtil.addYear((Date)startTime, (int)1);
            List<Date> startTimeList = this.processCountMapper.queryProcessNumberListStartCount(processKeys, startTime, endTime);
            List<Date> endTimeList = this.processCountMapper.queryProcessNumberListFinishCount(processKeys, startTime, endTime);
            int[] startTimeFlag = new int[12];
            int[] endTimeFlag = new int[12];
            startTimeList.forEach(e -> {
                int n = e.getMonth();
                startTimeFlag[n] = startTimeFlag[n] + 1;
            });
            endTimeList.forEach(e -> {
                int n = e.getMonth();
                endTimeFlag[n] = endTimeFlag[n] + 1;
            });
            result = new ArrayList<ProcessInstanceCountModel>();
            for (int i = 0; i < 12; ++i) {
                ProcessInstanceCountModel oneMonthResult = new ProcessInstanceCountModel();
                switch (i) {
                    case 0: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getJanuary());
                        break;
                    }
                    case 1: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getFebruary());
                        break;
                    }
                    case 2: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getMarch());
                        break;
                    }
                    case 3: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getApril());
                        break;
                    }
                    case 4: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getMay());
                        break;
                    }
                    case 5: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getJune());
                        break;
                    }
                    case 6: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getJuly());
                        break;
                    }
                    case 7: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getAugust());
                        break;
                    }
                    case 8: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getSeptember());
                        break;
                    }
                    case 9: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getOctober());
                        break;
                    }
                    case 10: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getNovember());
                        break;
                    }
                    case 11: {
                        oneMonthResult.setStatisTime(this.bpmConstantProperties.getDecember());
                    }
                }
                oneMonthResult.setCreateCount(startTimeFlag[i]);
                oneMonthResult.setFinishCount(endTimeFlag[i]);
                result.add(oneMonthResult);
            }
        } else if ("year".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)(queryProcessInstanceDto.getYearYear() + START_OF_THE_YEAR), (String)"yyyy-MM-dd");
            endTime = DateUtil.addYear((Date)startTime, (int)1);
            result = this.processCountMapper.queryProcessNumberList(processKeys, startTime, endTime);
            result.get(0).setStatisTime(queryProcessInstanceDto.getYearYear());
        } else if ("quarter".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)(queryProcessInstanceDto.getYearYear() + START_OF_THE_YEAR), (String)"yyyy-MM-dd");
            endTime = DateUtil.addYear((Date)startTime, (int)1);
            List<Date> startTimeList = this.processCountMapper.queryProcessNumberListStartCount(processKeys, startTime, endTime);
            List<Date> endTimeList = this.processCountMapper.queryProcessNumberListFinishCount(processKeys, startTime, endTime);
            int[] startTimeFlag = new int[4];
            int[] endTimeFlag = new int[4];
            startTimeList.forEach(e -> {
                int n = e.getMonth() / 3;
                startTimeFlag[n] = startTimeFlag[n] + 1;
            });
            endTimeList.forEach(e -> {
                int n = e.getMonth() / 3;
                endTimeFlag[n] = endTimeFlag[n] + 1;
            });
            result = new ArrayList<ProcessInstanceCountModel>();
            for (int i = 0; i < 4; ++i) {
                ProcessInstanceCountModel oneMonthResult = new ProcessInstanceCountModel();
                oneMonthResult.setStatisTime(BpaQuarter.of((int)(i + 1)).getValue());
                oneMonthResult.setCreateCount(startTimeFlag[i]);
                oneMonthResult.setFinishCount(endTimeFlag[i]);
                result.add(oneMonthResult);
            }
        } else if ("auto".equals(queryProcessInstanceDto.getStatisType())) {
            startTime = DateUtil.parse((String)queryProcessInstanceDto.getAutoStartTime(), (String)"yyyy-MM-dd");
            endTime = DateUtil.addDay((Date)DateUtil.parse((String)queryProcessInstanceDto.getAutoEndTime(), (String)"yyyy-MM-dd"), (int)1);
            result = this.processCountMapper.queryProcessNumberList(processKeys, startTime, endTime);
            result.get(0).setStatisTime(queryProcessInstanceDto.getAutoStartTime() + "-" + queryProcessInstanceDto.getAutoEndTime());
        }
        return ApiResponse.success(result);
    }

    public ApiResponse<List<ProcessInstanceCountModel>> queryMultiPersonProcessList(QueryProcessInstanceDto queryProcessInstanceDto) {
        HashMap<String, Date> map;
        ArrayList<String> userIds = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)queryProcessInstanceDto.getUserIds())) {
            userIds = Arrays.asList(queryProcessInstanceDto.getUserIds().split(","));
        }
        if (HussarUtils.isEmpty((Object)(map = this.computeStartAndEndTime(queryProcessInstanceDto)).get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<ProcessInstanceCountModel> createCountList = this.processCountMapper.queryMultiPersonProcessListCreateCount(userIds, startTime, endTime);
        List<ProcessInstanceCountModel> approveCountList = this.processCountMapper.queryMultiPersonProcessListApproveCount(userIds, startTime, endTime);
        Map<String, ProcessInstanceCountModel> createCountMap = createCountList.stream().collect(Collectors.toMap(ProcessInstanceCountModel::getUserId, e -> e));
        Map<String, ProcessInstanceCountModel> approveCountMap = approveCountList.stream().collect(Collectors.toMap(ProcessInstanceCountModel::getUserId, e -> e));
        List userList = this.iAssigneeChooseService.getUserAndAccountListByUserId(userIds);
        ArrayList<ProcessInstanceCountModel> result = new ArrayList<ProcessInstanceCountModel>();
        for (AssigneeChooseDto userInfo : userList) {
            ProcessInstanceCountModel approveModel;
            ProcessInstanceCountModel oneModel = new ProcessInstanceCountModel();
            String userId = userInfo.getUserId();
            String userName = userInfo.getUserName();
            String account = userInfo.getUserAccount();
            oneModel.setUserId(userId);
            oneModel.setUserName(userName + "(" + account + ")");
            ProcessInstanceCountModel createModel = createCountMap.get(userId);
            if (HussarUtils.isNotEmpty((Object)createModel)) {
                oneModel.setCreateCount(createModel.getCreateCount().intValue());
            }
            if (HussarUtils.isNotEmpty((Object)(approveModel = approveCountMap.get(userId)))) {
                oneModel.setApproveCount(approveModel.getApproveCount());
            }
            result.add(oneModel);
        }
        return ApiResponse.success(result);
    }

    public ApiResponse<Page<ProcessInstanceCountModel>> querySinglePersonProcessList(Page<ProcessInstanceCountModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        if (HussarUtils.isEmpty((Object)queryProcessInstanceDto.getUserId())) {
            return ApiResponse.success(page);
        }
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success(page);
        }
        queryProcessInstanceDto.setStartTime(map.get(START_TIME));
        queryProcessInstanceDto.setEndTime(map.get(END_TIME));
        List<ProcessInstanceCountModel> result = this.processCountMapper.querySinglePersonProcessList(page, queryProcessInstanceDto);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, ProcessInstanceCountModel.class).translate(ProcessInstanceCountModel::getNameTranslateKey, ProcessInstanceCountModel::setProcessName).execute();
        page.setRecords(result);
        return ApiResponse.success(page);
    }

    public ApiResponse<Page<TaskCountModel>> querySinglePersonProcessTaskList(Page<TaskCountModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        if (HussarUtils.isEmpty((Object)queryProcessInstanceDto.getUserId()) && HussarUtils.isEmpty((Object)queryProcessInstanceDto.getProcessKey())) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success(page);
        }
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<TaskCountModel> result = this.processCountMapper.querySinglePersonProcessTaskList(page, queryProcessInstanceDto, startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, TaskCountModel.class).translate(TaskCountModel::getTaskNameTranslateKey, TaskCountModel::setTaskDefinitionName).execute();
        page.setRecords(result);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<RejectCountModel>> queryHotRejectProcessList(QueryProcessInstanceDto queryProcessInstanceDto) {
        Page page = new Page();
        page.setSize((long)queryProcessInstanceDto.getSize().intValue());
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<RejectCountModel> result = this.processCountMapper.queryHotRejectProcessList((Page<RejectCountModel>)page, startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, RejectCountModel.class).translate(RejectCountModel::getProcNameTranslateKey, RejectCountModel::setProcessName).execute();
        return ApiResponse.success(result);
    }

    public ApiResponse<Page<RejectCountModel>> queryNodeRejectCount(Page<RejectCountModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success(page);
        }
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        page.addOrder(new OrderItem[]{OrderItem.desc((String)"rejectCount")});
        List<RejectCountModel> result = this.processCountMapper.queryNodeRejectCount(page, queryProcessInstanceDto.getProcessKey(), startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, RejectCountModel.class).translate(RejectCountModel::getTaskNameTranslateKey, RejectCountModel::setTaskDefinitionName).execute();
        page.setRecords(result);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<AllProcessCountModel>> queryProcessStatusByKeysForChart(String processKeys) {
        if (HussarUtils.isEmpty((Object)processKeys)) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        List<String> processKeyList = Arrays.asList(processKeys.split(","));
        List<AllProcessCountModel> result = this.processCountMapper.queryProcessStatus(null, processKeyList);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, AllProcessCountModel.class).translate(AllProcessCountModel::getNameTranslateKey, AllProcessCountModel::setProcessName).execute();
        return ApiResponse.success(result);
    }

    public ApiResponse<Page<AllProcessCountModel>> queryProcessStatusByKeysForList(Page<AllProcessCountModel> page, String processKeys) {
        if (HussarUtils.isEmpty((Object)processKeys)) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        List<String> processKeyList = Arrays.asList(processKeys.split(","));
        List<AllProcessCountModel> resultList = this.processCountMapper.queryProcessStatus(page, processKeyList);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(resultList, AllProcessCountModel.class).translate(AllProcessCountModel::getNameTranslateKey, AllProcessCountModel::setProcessName).execute();
        page.setRecords(resultList);
        return ApiResponse.success(page);
    }

    public ApiResponse<List<ParticipateInstanceModel>> queryProcessStatisticForChart(QueryProcessInstanceDto queryProcessInstanceDto) {
        if (HussarUtils.isEmpty((Object)queryProcessInstanceDto.getProcessKeys())) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        List<String> keys = Arrays.asList(queryProcessInstanceDto.getProcessKeys().split(","));
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success((String)BpmTranslateUtil.getResponseSuccess());
        }
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<ParticipateInstanceModel> result = this.processCountMapper.queryParticipateProcessList(null, null, keys, startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, ParticipateInstanceModel.class).translate(ParticipateInstanceModel::getNameTranslateKey, ParticipateInstanceModel::setProcessName).execute();
        return ApiResponse.success(result);
    }

    public ApiResponse<Page<ParticipateInstanceModel>> queryProcessStatisticForList(Page<ParticipateInstanceModel> page, QueryProcessInstanceDto queryProcessInstanceDto) {
        if (HussarUtils.isEmpty((Object)queryProcessInstanceDto.getProcessKeys())) {
            return ApiResponse.success(page);
        }
        List<String> keys = Arrays.asList(queryProcessInstanceDto.getProcessKeys().split(","));
        HashMap<String, Date> map = this.computeStartAndEndTime(queryProcessInstanceDto);
        if (HussarUtils.isEmpty((Object)map.get(START_TIME)) || HussarUtils.isEmpty((Object)map.get(END_TIME))) {
            return ApiResponse.success(page);
        }
        Date startTime = map.get(START_TIME);
        Date endTime = map.get(END_TIME);
        List<ParticipateInstanceModel> result = this.processCountMapper.queryParticipateProcessList(page, null, keys, startTime, endTime);
        BpmWorkflowTranslateUtil.createBpmWorkflowTranslateModel(result, ParticipateInstanceModel.class).translate(ParticipateInstanceModel::getNameTranslateKey, ParticipateInstanceModel::setProcessName).execute();
        page.setRecords(result);
        return ApiResponse.success(page);
    }
}

