/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.bpa.platform.config;

import com.jxdinfo.hussar.support.job.execution.core.processor.ProcessResult;
import com.jxdinfo.hussar.support.job.execution.core.processor.TaskContext;
import com.jxdinfo.hussar.support.job.execution.core.processor.sdk.BasicProcessor;
import com.jxdinfo.hussar.tenant.common.dto.SysTenantDatasourceDto;
import com.jxdinfo.hussar.workflow.bpa.platform.model.BpmActPlatformBpa;
import com.jxdinfo.hussar.workflow.bpa.platform.model.PlatformProcessCountModel;
import com.jxdinfo.hussar.workflow.bpa.platform.service.BpmActPlatformBpaService;
import java.util.ArrayList;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public class BpaPlatformCountJobProcessors
implements BasicProcessor {
    private final Logger logger = LogManager.getLogger(BpaPlatformCountJobProcessors.class);
    private final BpmActPlatformBpaService bpmActPlatformBpaService;

    public BpaPlatformCountJobProcessors(BpmActPlatformBpaService bpmActPlatformBpaService) {
        this.bpmActPlatformBpaService = bpmActPlatformBpaService;
    }

    public ProcessResult process(TaskContext taskContext) throws Exception {
        this.logger.info("\u8c03\u5ea6\u4efb\u52a1\u6267\u884c\uff1a\u4efb\u52a1id\uff1a{}\uff0c\u4efb\u52a1\u53c2\u6570\uff1a{}", (Object)taskContext.getJobId(), (Object)taskContext);
        ArrayList sysTenantDtos = new ArrayList();
        PlatformProcessCountModel platformProcessCountModel = new PlatformProcessCountModel();
        for (SysTenantDatasourceDto sysTenantInfo : sysTenantDtos) {
            this.bpmActPlatformBpaService.queryPlatformProcessCount(platformProcessCountModel, sysTenantInfo.getDataBaseName(), "sysTenantInfo.getConnName()");
        }
        BpmActPlatformBpa bpmActPlatformBpa = this.bpmActPlatformBpaService.countPlatformProcess(platformProcessCountModel);
        bpmActPlatformBpa.setCountTime(new Date());
        this.bpmActPlatformBpaService.save((Object)bpmActPlatformBpa);
        return new ProcessResult(true, "success");
    }
}

