/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.result;

import com.alibaba.fastjson.JSONArray;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;

public class InstallResult {
    public static final String SUCCESS_CODE = "1";
    public static final String SUCCESS_MSG = "success";
    public static final String ERROR_CODE = "0";

    public static BpmResponseResult getResult(String code, String msg, JSONArray result) {
        BpmResponseResult r = new BpmResponseResult();
        r.setCode(code);
        r.setMsg(msg);
        if (result == null) {
            r.setResult(new JSONArray());
        } else {
            r.setResult(result);
        }
        return r;
    }

    public static BpmResponseResult success(String msg, JSONArray result) {
        return InstallResult.getResult(SUCCESS_CODE, msg, result);
    }

    public static BpmResponseResult success(Object result) {
        JSONArray jsonArray = new JSONArray();
        if (result != null) {
            jsonArray.add(result);
        }
        return InstallResult.getResult(SUCCESS_CODE, SUCCESS_MSG, jsonArray);
    }

    public static BpmResponseResult success(String msg) {
        return InstallResult.getResult(SUCCESS_CODE, msg, null);
    }

    public static BpmResponseResult success(JSONArray result) {
        return InstallResult.getResult(SUCCESS_CODE, SUCCESS_MSG, result);
    }

    public static BpmResponseResult success() {
        return InstallResult.getResult(SUCCESS_CODE, SUCCESS_MSG, null);
    }

    public static BpmResponseResult fail(String msg, JSONArray result) {
        return InstallResult.getResult(ERROR_CODE, msg, result);
    }

    public static BpmResponseResult fail(String msg) {
        return InstallResult.getResult(ERROR_CODE, msg, null);
    }

    private InstallResult() {
    }
}

