/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.assignee.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.authorization.organ.model.SysStru;
import com.jxdinfo.hussar.authorization.organ.service.ISysStruFilterUnitService;
import com.jxdinfo.hussar.authorization.organ.vo.StruFilteredVo;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.dao.WorkflowAssigneeChooseMapper;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.dto.QueryAssigneeDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganUserTree;
import com.jxdinfo.hussar.workflow.assignee.model.UserSecurityVo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class WorkflowAssigneeChooseServiceImpl
implements IWorkflowAssigneeChooseService {
    private final WorkflowAssigneeChooseMapper workflowAssigneeChooseMapper;
    private final ISysStruFilterUnitService sysStruFilterUnitService;
    private static final String DEFAULT_PARENTID = "10000";
    private static final String DEFAULT_ORGAN_PARENTID = "1";
    public static final String ORGAN = "organ";
    public static final String USER = "user";
    public static final String GROUP = "GROUP";
    public static final String LEFT_JOIN_PART = " LEFT JOIN ";
    private static final Pattern ORGAN_CONTAINS_CHILD_REGEX = Pattern.compile("O.PARENT_ID( NOT)? CONTAINSCHILD \\('([^)])*\\)");
    private static final Pattern ALL_LETTER = Pattern.compile("^[A-Za-z0-9]+$");
    public static final BpmTreeModel USER_NODE = new BpmTreeModel("999", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u7528\u6237", "organ", false, false, "9999", null, null);
    public static final BpmTreeModel LEAF_USER_NODE = new BpmTreeModel("999", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u7528\u6237", "organ", true, false, "9999", null, null);
    public static final BpmTreeModel POST_NODE = new BpmTreeModel("1000", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u5c97\u4f4d", "organ", false, false, "10000", null, null);
    public static final BpmTreeModel LEAF_POST_NODE = new BpmTreeModel("1000", "10000", "\u672a\u5173\u8054\u7ec4\u7ec7\u5c97\u4f4d", "organ", true, false, "10000", null, null);

    public WorkflowAssigneeChooseServiceImpl(WorkflowAssigneeChooseMapper workflowAssigneeChooseMapper, ISysStruFilterUnitService sysStruFilterUnitService) {
        this.workflowAssigneeChooseMapper = workflowAssigneeChooseMapper;
        this.sysStruFilterUnitService = sysStruFilterUnitService;
    }

    public List<BpmTreeModel> userTree(String id, boolean isMainPost, boolean longIdType, boolean useSecurityLevel, Integer securityLevel, String tablePrefix) {
        List<BpmTreeModel> result;
        block6: {
            String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
            result = this.workflowAssigneeChooseMapper.userTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, isMainPost, null, longIdType ? null : newId, null, tablePrefix, securityLevel, useSecurityLevel);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block6;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), isMainPost ? "userWithMainPost" : USER, tablePrefix);
            if (longIdType) {
                List parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return result;
    }

    public List<BpmTreeModel> currentDeptUserTree(String id, boolean isMainPost, boolean longIdType, boolean useSecurityLevel, Integer securityLevel, String tablePrefix, Long deptId) {
        List<Object> result;
        block14: {
            String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
            Set<Long> filteredStruIds = new HashSet();
            Long rootId = null;
            SysStru closestUnitStru = new SysStru();
            if (HussarUtils.isNotEmpty((Object)deptId)) {
                StruFilteredVo struFilteredVo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
                closestUnitStru = struFilteredVo.getClosestUnitStru();
                filteredStruIds = struFilteredVo.getFilteredStruIds();
                rootId = struFilteredVo.getRootId();
                if (newId.equals(rootId.toString())) {
                    newId = closestUnitStru.getParentId().toString();
                }
            }
            result = this.workflowAssigneeChooseMapper.userTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, isMainPost, null, longIdType ? null : newId, null, tablePrefix, securityLevel, useSecurityLevel);
            if (HussarUtils.isNotEmpty((Object)deptId)) {
                Set<Long> filteredStruIdsWithRoot = filteredStruIds;
                HashSet filteredStruIdsWithoutRoot = new HashSet(filteredStruIds);
                filteredStruIdsWithRoot.add(rootId);
                result = result.stream().filter(bpmTreeModel -> {
                    if (ORGAN.equals(bpmTreeModel.getType())) {
                        return filteredStruIdsWithRoot.contains(Long.valueOf(bpmTreeModel.getId()));
                    }
                    return filteredStruIdsWithoutRoot.contains(Long.valueOf(bpmTreeModel.getParentId()));
                }).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel2 : result) {
                    if (!bpmTreeModel2.getId().equals(closestUnitStru.getId().toString())) continue;
                    bpmTreeModel2.setParentId(String.valueOf(rootId));
                }
            }
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel3 : result) {
                if (!ORGAN.equals(bpmTreeModel3.getType())) continue;
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel3.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel3.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block14;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), isMainPost ? "userWithMainPost" : USER, tablePrefix);
            if (longIdType) {
                List list = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty((Object)deptId) && list.contains(closestUnitStru.getParentId())) {
                    list.remove(closestUnitStru.getParentId());
                    list.add(rootId);
                }
                for (BpmTreeModel bpmTreeModel4 : result) {
                    if (ORGAN.equals(bpmTreeModel4.getType()) && list.contains(Long.valueOf(bpmTreeModel4.getId()))) {
                        bpmTreeModel4.setIsLeaf("false");
                    }
                    if (!HussarUtils.isNotEmpty((Object)deptId) || !String.valueOf(rootId).equals(bpmTreeModel4.getId())) continue;
                    bpmTreeModel4.setIsLeaf("false");
                }
            } else {
                if (parentIdList.contains(String.valueOf(closestUnitStru.getParentId()))) {
                    parentIdList.remove(String.valueOf(closestUnitStru.getParentId()));
                    parentIdList.add(String.valueOf(rootId));
                }
                for (BpmTreeModel bpmTreeModel5 : result) {
                    if (ORGAN.equals(bpmTreeModel5.getType()) && parentIdList.contains(bpmTreeModel5.getId())) {
                        bpmTreeModel5.setIsLeaf("false");
                    }
                    if (!HussarUtils.isNotEmpty((Object)deptId) || !String.valueOf(rootId).equals(bpmTreeModel5.getId())) continue;
                    bpmTreeModel5.setIsLeaf("false");
                }
            }
        }
        return result;
    }

    public List<OrganUserTree> userTreeForUserChoose(String id, Integer securityLevel, boolean useSecurityLevel, String tablePrefix) {
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        List<OrganUserTree> result = this.workflowAssigneeChooseMapper.userTreeForUserChoose(Long.parseLong(newId), tablePrefix, securityLevel, useSecurityLevel);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (OrganUserTree organUserTree : result) {
            if (!ORGAN.equals(organUserTree.getTypes())) continue;
            parentIds.add(Long.valueOf(organUserTree.getId()));
        }
        if (!parentIds.isEmpty()) {
            HashSet<String> parentIdList = new HashSet<String>(this.workflowAssigneeChooseMapper.getNotLeafParentIds(this.getInListSqlCondition(parentIds), null, USER, tablePrefix));
            for (OrganUserTree organUserTree : result) {
                if (!ORGAN.equals(organUserTree.getTypes()) || !parentIdList.contains(organUserTree.getId())) continue;
                organUserTree.setHasChildren(true);
            }
        }
        return result;
    }

    public Page<BpmTreeModel> queryUserTreeForUserChoose(QueryAssigneeDto queryAssigneeDto, String tablePrefix) {
        String organName = queryAssigneeDto.getOrganName();
        Page page = queryAssigneeDto.getPage();
        if (organName.isEmpty()) {
            return this.getPageResult(page, new ArrayList());
        }
        String type = queryAssigneeDto.getType();
        if (HussarUtils.isEmpty((Object)type)) {
            type = USER;
        }
        boolean useSecurityLevel = queryAssigneeDto.isUseSecurityLevel();
        if (!USER.equals(type)) {
            useSecurityLevel = false;
        }
        List userIds = queryAssigneeDto.getUserIds();
        ArrayList<Long> userIdList = new ArrayList();
        if (HussarUtils.isNotEmpty((Object)userIds)) {
            userIdList = userIds.stream().map(id -> Long.valueOf(id)).collect(Collectors.toList());
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        boolean isAllLetter = ALL_LETTER.matcher(organName).matches();
        String lowerCaseOrganName = null;
        if (isAllLetter) {
            lowerCaseOrganName = organName.toLowerCase();
        }
        List<BpmTreeModel> organUserTrees = this.workflowAssigneeChooseMapper.queryUserTreeForUserChoose(organName, type, userIdList, tablePrefix, queryAssigneeDto.getSecurityLevel(), useSecurityLevel, lowerCaseOrganName);
        HashMap<String, BpmTreeModel> userMap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel bpmTreeModel : organUserTrees) {
            if (userMap.containsKey(bpmTreeModel.getId())) {
                BpmTreeModel treeModel = (BpmTreeModel)userMap.get(bpmTreeModel.getId());
                String parentName = treeModel.getParentName() + "," + bpmTreeModel.getParentName();
                treeModel.setParentName(parentName);
                userMap.put(bpmTreeModel.getId(), treeModel);
                continue;
            }
            userMap.put(bpmTreeModel.getId(), bpmTreeModel);
        }
        ArrayList<Object> assigneeList = new ArrayList<Object>();
        for (Map.Entry entry : userMap.entrySet()) {
            assigneeList.add(entry.getValue());
        }
        assigneeList.sort(Comparator.comparing(BpmTreeModel::getParentId).thenComparing(BpmTreeModel::getSort).thenComparing(BpmTreeModel::getId));
        return this.getPageResult(page, assigneeList);
    }

    public List<BpmTreeModel> queryDeptUserForUserChoose(List<String> organIds, List<String> userIds, boolean longIdType, String tablePrefix) {
        List<Object> result = new ArrayList<BpmTreeModel>();
        List<Long> userIdL = new ArrayList<Long>();
        List<Long> organIdL = new ArrayList<Long>();
        if (userIds != null && !StringUtils.isEmpty(userIds) && !userIds.isEmpty()) {
            userIds = userIds.stream().distinct().collect(Collectors.toList());
            if (longIdType) {
                userIdL = userIds.stream().map(Long::parseLong).collect(Collectors.toList());
            }
            result = this.workflowAssigneeChooseMapper.userDetail(longIdType ? this.getInListSqlCondition(userIdL) : null, longIdType ? null : this.getStringListSqlCondition(userIds), tablePrefix);
        }
        if (organIds != null && !StringUtils.isEmpty(organIds) && !organIds.isEmpty()) {
            List<BpmTreeModel> userList;
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            if (longIdType) {
                organIdL = organIds.stream().map(Long::parseLong).collect(Collectors.toList());
            }
            List<BpmTreeModel> bpmTreeList = this.workflowAssigneeChooseMapper.getOrganUserByOrganIds(longIdType ? this.getInListSqlCondition(organIdL) : null, longIdType ? null : this.getStringListSqlCondition(organIds), ORGAN, tablePrefix);
            List<String> fidList = bpmTreeList.stream().distinct().map(BpmTreeModel::getOrganFid).collect(Collectors.toList());
            List<String> deptIds = this.workflowAssigneeChooseMapper.getDeptIdByFid(fidList, tablePrefix);
            List<Long> deptIdL = new ArrayList<Long>();
            if (deptIds != null && !StringUtils.isEmpty(deptIds) && !deptIds.isEmpty() && longIdType) {
                deptIdL = deptIds.stream().map(Long::parseLong).collect(Collectors.toList());
            }
            if (HussarUtils.isEmpty(deptIds)) {
                deptIds = new ArrayList<String>();
            }
            if (!(userList = this.workflowAssigneeChooseMapper.getOrganUserByOrganIds(longIdType ? this.getInListSqlCondition(deptIdL) : null, longIdType ? null : this.getStringListSqlCondition(deptIds), USER, tablePrefix)).isEmpty()) {
                result.addAll(userList);
            }
        }
        if (HussarUtils.isNotEmpty(result)) {
            result = result.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BpmTreeModel>(Comparator.comparing(BpmTreeModel::getId))), ArrayList::new));
        }
        return result;
    }

    public List<BpmTreeModel> queryDeptUser(List<String> organIds, boolean longIdType, String tablePrefix) {
        List<Object> result = new ArrayList<BpmTreeModel>();
        List<Object> organIdL = new ArrayList();
        if (organIds != null && !StringUtils.isEmpty(organIds) && !organIds.isEmpty()) {
            List<BpmTreeModel> userList;
            organIds = organIds.stream().distinct().collect(Collectors.toList());
            if (longIdType) {
                organIdL = organIds.stream().map(Long::parseLong).collect(Collectors.toList());
            }
            if (organIds != null && !StringUtils.isEmpty(organIds) && !organIds.isEmpty() && longIdType) {
                organIdL = organIds.stream().map(Long::parseLong).collect(Collectors.toList());
            }
            if (HussarUtils.isEmpty(organIds)) {
                organIds = new ArrayList();
            }
            if (!(userList = this.workflowAssigneeChooseMapper.getOrganUserByOrganIds(longIdType ? this.getInListSqlCondition(organIdL) : null, longIdType ? null : this.getStringListSqlCondition(organIds), USER, tablePrefix)).isEmpty()) {
                result.addAll(userList);
            }
        } else {
            List<BpmTreeModel> userList = this.workflowAssigneeChooseMapper.getOrganUserByOrganIds(null, null, USER, tablePrefix);
            if (!userList.isEmpty()) {
                result.addAll(userList);
            }
        }
        if (HussarUtils.isNotEmpty(result)) {
            result = result.stream().filter(bpmTreeModel -> HussarUtils.isNotEmpty((Object)bpmTreeModel.getId())).collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<BpmTreeModel>(Comparator.comparing(BpmTreeModel::getId))), ArrayList::new));
        }
        return result;
    }

    public List<BpmTreeModel> postTree(String id, String postId, boolean isMainPost, boolean longIdType, String tablePrefix) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        List<BpmTreeModel> result = !StringUtils.isEmpty((Object)postId) ? this.workflowAssigneeChooseMapper.userTreeWithType(null, isMainPost, longIdType ? Long.valueOf(Long.parseLong(postId)) : null, null, postId, "post", tablePrefix) : this.workflowAssigneeChooseMapper.userTreeWithType(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, isMainPost, null, longIdType ? null : newId, null, "post", tablePrefix);
        if (DEFAULT_PARENTID.equals(id)) {
            result.add(LEAF_POST_NODE);
        }
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<String> stringParentIds = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!ORGAN.equals(bpmTreeModel.getType())) continue;
            if (longIdType) {
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                continue;
            }
            stringParentIds.add(bpmTreeModel.getId());
        }
        if (!parentIds.isEmpty() || !stringParentIds.isEmpty()) {
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), "post", tablePrefix);
            if (longIdType) {
                List parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            }
        }
        if (!StringUtils.isEmpty((Object)postId)) {
            List<BpmTreeModel> allDept = this.workflowAssigneeChooseMapper.getAllDept(tablePrefix);
            List<BpmTreeModel> backTree = this.queryAllTreeByChildrenNode(result, 3, tablePrefix);
            for (BpmTreeModel bpmTreeModel : allDept) {
                if (result.size() <= 0 || backTree.get(0).getId().equals(bpmTreeModel.getId()) || !bpmTreeModel.getParentId().equals(DEFAULT_PARENTID)) continue;
                backTree.add(bpmTreeModel);
            }
            return backTree;
        }
        return result;
    }

    public List<BpmTreeModel> deptTree(String id, boolean longIdType, String tablePrefix) {
        List<BpmTreeModel> result;
        block6: {
            String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
            result = this.workflowAssigneeChooseMapper.deptTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null, tablePrefix);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block6;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), ORGAN, tablePrefix);
            if (longIdType) {
                List parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return result;
    }

    public List<BpmTreeModel> deptTree(String id, String organId, boolean longIdType, String tablePrefix) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        List<BpmTreeModel> result = !StringUtils.isEmpty((Object)organId) ? this.workflowAssigneeChooseMapper.deptTree(null, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, null, longIdType ? null : organId, tablePrefix) : this.workflowAssigneeChooseMapper.deptTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null, tablePrefix);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<String> stringParentIds = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!ORGAN.equals(bpmTreeModel.getType())) continue;
            if (longIdType) {
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                continue;
            }
            stringParentIds.add(bpmTreeModel.getId());
        }
        if (!parentIds.isEmpty() || !stringParentIds.isEmpty()) {
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), ORGAN, tablePrefix);
            if (longIdType) {
                List parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            }
        }
        if (!StringUtils.isEmpty((Object)organId)) {
            List<BpmTreeModel> allDept = this.workflowAssigneeChooseMapper.getAllDept(tablePrefix);
            List<BpmTreeModel> backTree = this.queryAllTreeByChildrenNode(result, 2, tablePrefix);
            for (BpmTreeModel bpmTreeModel : allDept) {
                if (result.size() <= 0 || backTree.get(0).getId().equals(bpmTreeModel.getId()) || !bpmTreeModel.getParentId().equals(DEFAULT_PARENTID)) continue;
                backTree.add(bpmTreeModel);
            }
            return backTree;
        }
        return result;
    }

    public List<BpmTreeModel> currentUserDept(String id, String organId, boolean longIdType, String tablePrefix, Long deptId) {
        String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_PARENTID : id;
        Set<Long> filteredStruIds = new HashSet();
        Long rootId = null;
        SysStru closestUnitStru = new SysStru();
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            StruFilteredVo struFilteredVo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
            closestUnitStru = struFilteredVo.getClosestUnitStru();
            filteredStruIds = struFilteredVo.getFilteredStruIds();
            rootId = struFilteredVo.getRootId();
            if (newId.equals(rootId.toString())) {
                newId = closestUnitStru.getParentId().toString();
            }
        }
        List<Object> result = !StringUtils.isEmpty((Object)organId) ? this.workflowAssigneeChooseMapper.deptTree(null, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, null, longIdType ? null : organId, tablePrefix) : this.workflowAssigneeChooseMapper.deptTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null, tablePrefix);
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            Set<Long> filteredStruIdsWithRoot = filteredStruIds;
            filteredStruIdsWithRoot.add(rootId);
            result = result.stream().filter(bpmTreeModel -> {
                if (ORGAN.equals(bpmTreeModel.getType())) {
                    return filteredStruIdsWithRoot.contains(Long.valueOf(bpmTreeModel.getId()));
                }
                return filteredStruIdsWithRoot.contains(Long.valueOf(bpmTreeModel.getParentId()));
            }).collect(Collectors.toList());
            for (BpmTreeModel bpmTreeModel2 : result) {
                if (!bpmTreeModel2.getId().equals(closestUnitStru.getId().toString())) continue;
                bpmTreeModel2.setParentId(String.valueOf(rootId));
            }
        }
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<String> stringParentIds = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel3 : result) {
            if (!ORGAN.equals(bpmTreeModel3.getType())) continue;
            if (longIdType) {
                parentIds.add(Long.valueOf(bpmTreeModel3.getId()));
                continue;
            }
            stringParentIds.add(bpmTreeModel3.getId());
        }
        if (!parentIds.isEmpty() || !stringParentIds.isEmpty()) {
            List<String> list = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), ORGAN, tablePrefix);
            if (longIdType) {
                List list2 = list.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                if (HussarUtils.isNotEmpty((Object)deptId) && list2.contains(closestUnitStru.getParentId())) {
                    list2.remove(closestUnitStru.getParentId());
                    list2.add(rootId);
                }
                for (BpmTreeModel bpmTreeModel4 : result) {
                    if (ORGAN.equals(bpmTreeModel4.getType()) && list2.contains(Long.valueOf(bpmTreeModel4.getId()))) {
                        bpmTreeModel4.setIsLeaf("false");
                        bpmTreeModel4.setHasChildren("true");
                    }
                    if (!HussarUtils.isNotEmpty((Object)deptId) || !String.valueOf(rootId).equals(bpmTreeModel4.getId())) continue;
                    bpmTreeModel4.setIsLeaf("false");
                    bpmTreeModel4.setHasChildren("true");
                }
            } else {
                for (BpmTreeModel bpmTreeModel5 : result) {
                    if (ORGAN.equals(bpmTreeModel5.getType()) && list.contains(bpmTreeModel5.getId())) {
                        bpmTreeModel5.setIsLeaf("false");
                        bpmTreeModel5.setHasChildren("true");
                    }
                    if (!HussarUtils.isNotEmpty((Object)deptId) || !String.valueOf(rootId).equals(bpmTreeModel5.getId())) continue;
                    bpmTreeModel5.setIsLeaf("false");
                    bpmTreeModel5.setHasChildren("true");
                }
            }
        }
        if (!StringUtils.isEmpty((Object)organId)) {
            List<BpmTreeModel> list = this.workflowAssigneeChooseMapper.getAllDept(tablePrefix);
            List<BpmTreeModel> list3 = this.queryAllTreeByChildrenNode(result, 2, tablePrefix);
            for (BpmTreeModel bpmTreeModel6 : list) {
                if (result.size() <= 0 || list3.get(0).getId().equals(bpmTreeModel6.getId()) || !bpmTreeModel6.getParentId().equals(DEFAULT_PARENTID)) continue;
                list3.add(bpmTreeModel6);
            }
            return list3;
        }
        return result;
    }

    public List<BpmTreeModel> roleTree(String tablePrefix) {
        List<BpmTreeModel> result = this.workflowAssigneeChooseMapper.roleTree(null, null, null, null, tablePrefix);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        for (BpmTreeModel bpmTreeModel : result) {
            parentIds.add(Long.valueOf(bpmTreeModel.getId()));
        }
        if (!parentIds.isEmpty()) {
            for (BpmTreeModel bpmTreeModel : result) {
                if (!parentIds.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                bpmTreeModel.setIsLeaf("false");
            }
        }
        return result;
    }

    public List<BpmTreeModel> roleTree(String id, boolean longIdType, String tablePrefix) {
        List<BpmTreeModel> result;
        block6: {
            String newId = StringUtils.isEmpty((Object)id) ? DEFAULT_ORGAN_PARENTID : id;
            result = this.workflowAssigneeChooseMapper.roleTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null, tablePrefix);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block6;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafRoleParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), tablePrefix);
            if (longIdType) {
                List parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return result;
    }

    public List<BpmTreeModel> roleTree(String id, String roleId, boolean longIdType, String tablePrefix) {
        String newId;
        String string = newId = StringUtils.isEmpty((Object)id) ? DEFAULT_ORGAN_PARENTID : id;
        List<BpmTreeModel> result = !StringUtils.isEmpty((Object)roleId) ? this.workflowAssigneeChooseMapper.roleTree(null, longIdType ? Long.valueOf(Long.parseLong(roleId)) : null, null, longIdType ? null : roleId, tablePrefix) : this.workflowAssigneeChooseMapper.roleTree(longIdType ? Long.valueOf(Long.parseLong(newId)) : null, null, longIdType ? null : newId, null, tablePrefix);
        ArrayList<Long> parentIds = new ArrayList<Long>();
        ArrayList<String> stringParentIds = new ArrayList<String>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (longIdType) {
                if (!GROUP.equals(bpmTreeModel.getType())) continue;
                parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                continue;
            }
            if (!GROUP.equals(bpmTreeModel.getType())) continue;
            stringParentIds.add(bpmTreeModel.getId());
        }
        if (!parentIds.isEmpty() || !stringParentIds.isEmpty()) {
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafRoleParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), tablePrefix);
            if (longIdType) {
                List parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                    bpmTreeModel.setHasChildren("true");
                }
            }
        }
        if (!StringUtils.isEmpty((Object)roleId)) {
            List<BpmTreeModel> allDept = this.workflowAssigneeChooseMapper.getAllRole(tablePrefix);
            List<BpmTreeModel> backTree = this.queryAllTreeByChildrenNode(result, 1, tablePrefix);
            for (BpmTreeModel bpmTreeModel : allDept) {
                if (result.size() <= 0 || backTree.get(0).getId().equals(bpmTreeModel.getId()) || !bpmTreeModel.getParentId().equals(DEFAULT_ORGAN_PARENTID) || !GROUP.equals(bpmTreeModel.getType())) continue;
                backTree.add(bpmTreeModel);
            }
            return backTree;
        }
        return result;
    }

    public List<BpmTreeModel> userDetail(List<String> userIds, boolean longIdType, String tablePrefix) {
        if ((userIds = new ArrayList<String>(new HashSet<String>(userIds))) != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            removeList.add(null);
            removeList.add("null");
            userIds.removeAll(removeList);
        }
        if (StringUtils.isEmpty(userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        ArrayList<Long> userIdL = new ArrayList<Long>();
        ArrayList<String> userIdStr = new ArrayList<String>();
        for (String str : userIds) {
            if (StringUtils.isEmpty((Object)str)) continue;
            if (longIdType) {
                userIdL.add(Long.parseLong(str));
                continue;
            }
            userIdStr.add(str);
        }
        return this.workflowAssigneeChooseMapper.userDetail(longIdType ? this.getInListSqlCondition(userIdL) : null, longIdType ? null : this.getStringListSqlCondition(userIdStr), tablePrefix);
    }

    public List<BpmTreeModel> organDetail(List<String> organIds, boolean longIdType, String tablePrefix) {
        if ((organIds = new ArrayList<String>(new HashSet<String>(organIds))) != null) {
            ArrayList<String> removeList = new ArrayList<String>();
            removeList.add(null);
            removeList.add("");
            removeList.add("null");
            organIds.removeAll(removeList);
        }
        if (StringUtils.isEmpty(organIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        ArrayList<Long> organIdL = new ArrayList<Long>();
        ArrayList<String> userIdStr = new ArrayList<String>();
        for (String str : organIds) {
            if (StringUtils.isEmpty((Object)str)) continue;
            if (longIdType) {
                organIdL.add(Long.parseLong(str));
                continue;
            }
            userIdStr.add(str);
        }
        return this.workflowAssigneeChooseMapper.getOrganUserByOrganIds(longIdType ? this.getInListSqlCondition(organIdL) : null, longIdType ? null : this.getStringListSqlCondition(organIds), ORGAN, tablePrefix);
    }

    public List<BpmTreeModel> userDeptDetail(String userId, boolean longIdType, String tablePrefix) {
        List<BpmTreeModel> result = this.workflowAssigneeChooseMapper.userDeptDetail(longIdType ? Long.valueOf(Long.parseLong(userId)) : null, longIdType ? null : userId, tablePrefix);
        for (BpmTreeModel bpmTreeModel : result) {
            if (!DEFAULT_PARENTID.equals(bpmTreeModel.getParentId())) continue;
            bpmTreeModel.setParentId(null);
        }
        return result;
    }

    public List<String> getCandidateUser(String condition, boolean useSecurityLevel, Integer securityLevel, String tablePrefix) {
        condition = this.getRealCondition(condition, tablePrefix);
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT O.ORGAN_ID AS userId ").append(" FROM ");
        if (!StringUtils.isEmpty((Object)tablePrefix)) {
            sb.append(tablePrefix);
        }
        sb.append("HUSSAR_BPM_ORGAN_VIEW O ");
        if (condition.contains("GRANTED_ROLE")) {
            sb.append("  LEFT JOIN ");
            if (!StringUtils.isEmpty((Object)tablePrefix)) {
                sb.append(tablePrefix);
            }
            sb.append("HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ");
        }
        if (condition.contains("POST_ID")) {
            sb.append(LEFT_JOIN_PART);
            if (!StringUtils.isEmpty((Object)tablePrefix)) {
                sb.append(tablePrefix);
            }
            sb.append("HUSSAR_BPM_USER_POST_VIEW S ON S.USER_ID = O.ORGAN_ID");
        }
        sb.append("  WHERE O.ORGAN_TYPE = 'user'  ");
        sb.append(condition);
        String sql = sb.toString().replace("''", "'0'");
        return new ArrayList<String>(new HashSet<String>(this.workflowAssigneeChooseMapper.getCandidateUsers(sql, useSecurityLevel, securityLevel, tablePrefix)));
    }

    public List<BpmTreeModel> getCandidateUserWithParent(String condition, boolean useSecurityLevel, Integer securityLevel, String tablePrefix) {
        condition = this.getRealCondition(condition, tablePrefix);
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT O.ORGAN_ID AS id, ").append(" O.ORGAN_NAME AS label, ").append(" O.PARENT_ID AS parentid, ").append(" P.ORGAN_NAME AS parentName, ").append(" O.SORT AS sort, ").append(" O.ORGAN_FID AS organFid ").append(" FROM ");
        if (!StringUtils.isEmpty((Object)tablePrefix)) {
            sb.append(tablePrefix);
        }
        sb.append("HUSSAR_BPM_ORGAN_VIEW O ").append(LEFT_JOIN_PART);
        if (!StringUtils.isEmpty((Object)tablePrefix)) {
            sb.append(tablePrefix);
        }
        sb.append("HUSSAR_BPM_ORGAN_VIEW P ON P.ORGAN_ID = O.PARENT_ID ");
        if (condition.contains("GRANTED_ROLE")) {
            sb.append(LEFT_JOIN_PART);
            if (!StringUtils.isEmpty((Object)tablePrefix)) {
                sb.append(tablePrefix);
            }
            sb.append("HUSSAR_BPM_USER_ROLE_VIEW R ON R.USER_ID = O.ORGAN_ID ");
        }
        if (condition.contains("POST_ID")) {
            sb.append(LEFT_JOIN_PART);
            if (!StringUtils.isEmpty((Object)tablePrefix)) {
                sb.append(tablePrefix);
            }
            sb.append("HUSSAR_BPM_USER_POST_VIEW S ON S.USER_ID = O.ORGAN_ID");
        }
        sb.append("  WHERE O.ORGAN_TYPE = 'user' ");
        sb.append(condition);
        String sql = sb.toString().replace("''", "'0'");
        List<BpmTreeModel> result = this.workflowAssigneeChooseMapper.getCandidateUsersWithParent(sql, useSecurityLevel, securityLevel, tablePrefix);
        ArrayList<BpmTreeModel> finalResult = new ArrayList<BpmTreeModel>();
        HashMap<String, Set> map = new HashMap<String, Set>();
        for (BpmTreeModel bpmTreeModel : result) {
            if (!map.computeIfAbsent(bpmTreeModel.getId(), k -> new HashSet()).add(bpmTreeModel.getParentId())) continue;
            finalResult.add(bpmTreeModel);
        }
        return finalResult;
    }

    public String getRealCondition(String realCondition, String tablePrefix) {
        if (realCondition.contains("CONTAINSCHILD")) {
            List<AssigneeChooseDto> allOrgans = this.workflowAssigneeChooseMapper.getAllOrgans(tablePrefix);
            HashMap<String, ArrayList<String>> maps = new HashMap<String, ArrayList<String>>();
            for (AssigneeChooseDto assigneeChooseDto : allOrgans) {
                String organId = assigneeChooseDto.getUserId();
                String parentId = assigneeChooseDto.getParentId();
                ArrayList<String> list = (ArrayList<String>)maps.get(parentId);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(organId);
                maps.put(parentId, list);
            }
            Matcher organMatcher = ORGAN_CONTAINS_CHILD_REGEX.matcher(realCondition);
            while (organMatcher.find()) {
                int i;
                String organCondition = organMatcher.group();
                String[] organConditions = organCondition.split("'");
                ArrayList<String> organIds = new ArrayList<String>();
                for (i = 1; i < organConditions.length; i += 2) {
                    organIds.add(organConditions[i]);
                }
                for (i = 0; i < organIds.size(); ++i) {
                    List addOrgans = (List)maps.get(organIds.get(i));
                    if (addOrgans == null) continue;
                    organIds.addAll(addOrgans);
                }
                organIds = new ArrayList(new HashSet(organIds));
                StringBuilder stringBuilder = new StringBuilder();
                boolean isConditionNotIn = organCondition.contains("NOT CONTAINSCHILD");
                if (isConditionNotIn) {
                    stringBuilder.append("O.PARENT_ID NOT IN (");
                } else {
                    stringBuilder.append("O.PARENT_ID IN (");
                }
                for (String s : organIds) {
                    stringBuilder.append("'").append(s).append("',");
                }
                stringBuilder.append("'')");
                String replactCondition = stringBuilder.toString();
                while (replactCondition.contains(",''")) {
                    replactCondition = replactCondition.replace(",''", "");
                }
                while (replactCondition.contains("'',")) {
                    replactCondition = replactCondition.replace("'',", "");
                }
                if (replactCondition.contains("('')")) {
                    replactCondition = isConditionNotIn ? "1=1" : "1!=1";
                }
                realCondition = realCondition.replace(organCondition, replactCondition);
            }
        }
        return realCondition;
    }

    public Integer getSecurityLevel(String userId, boolean longIdType, String tablePrefix) {
        List<String> securityLevelList = this.workflowAssigneeChooseMapper.getSecurityLevel(longIdType ? Long.valueOf(Long.parseLong(userId)) : null, longIdType ? null : userId, tablePrefix);
        if (HussarUtils.isEmpty(securityLevelList) || HussarUtils.isEmpty((Object)securityLevelList.get(0))) {
            return 0;
        }
        try {
            return Integer.valueOf(securityLevelList.get(0));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getSameLevelDeptIdByUserId(String userId, boolean longIdType, String tablePrefix) {
        List<String> deptId = this.workflowAssigneeChooseMapper.getSameLevelDeptIdByUserId(longIdType ? Long.valueOf(Long.parseLong(userId)) : null, longIdType ? null : userId, tablePrefix);
        return String.join((CharSequence)",", deptId);
    }

    public String getSameLevelDeptIdByOrganId(String organId, boolean longIdType, String tablePrefix) {
        List<String> deptId = this.workflowAssigneeChooseMapper.getSameLevelDeptIdByOrganId(longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId, tablePrefix);
        return String.join((CharSequence)",", deptId);
    }

    public String getParentDeptIdByUserId(String userId, boolean longIdType, String tablePrefix) {
        List<String> deptId = this.workflowAssigneeChooseMapper.getParentDeptIdByUserId(longIdType ? Long.valueOf(Long.parseLong(userId)) : null, longIdType ? null : userId, tablePrefix);
        return String.join((CharSequence)",", deptId);
    }

    public String getDeptIdByUserIds(String userId, boolean longIdType, String tablePrefix) {
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
        ArrayList<Long> longUserIds = new ArrayList();
        ArrayList<String> stringUserIds = new ArrayList();
        if (longIdType) {
            longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            stringUserIds = users.stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        List<String> deptId = this.workflowAssigneeChooseMapper.getDeptIdByUserIds(longIdType ? this.getInListSqlCondition(longUserIds) : null, longIdType ? null : this.getStringListSqlCondition(stringUserIds), tablePrefix);
        return String.join((CharSequence)",", new HashSet<String>(deptId));
    }

    public String getSameLevelDeptIdByUserIds(String userId, boolean longIdType, String tablePrefix) {
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
        ArrayList<Long> longUserIds = new ArrayList();
        ArrayList<String> stringUserIds = new ArrayList();
        if (longIdType) {
            longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            stringUserIds = users.stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        List<String> deptId = this.workflowAssigneeChooseMapper.getSameLevelDeptIdByUserIds(longIdType ? this.getInListSqlCondition(longUserIds) : null, longIdType ? null : this.getStringListSqlCondition(stringUserIds), tablePrefix);
        return String.join((CharSequence)",", new HashSet<String>(deptId));
    }

    public String getParentDeptIdByUserIds(String userId, boolean longIdType, String tablePrefix) {
        ArrayList<String> users = new ArrayList<String>(Arrays.asList(userId.split(",")));
        ArrayList<Long> longUserIds = new ArrayList();
        ArrayList<String> stringUserIds = new ArrayList();
        if (longIdType) {
            longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            stringUserIds = users.stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        List<String> deptId = this.workflowAssigneeChooseMapper.getParentDeptIdByUserIds(longIdType ? this.getInListSqlCondition(longUserIds) : null, longIdType ? null : this.getStringListSqlCondition(stringUserIds), tablePrefix);
        return String.join((CharSequence)",", new HashSet<String>(deptId));
    }

    public List<BpmTreeModel> queryUserTree(QueryAssigneeDto queryAssigneeDto, String tablePrefix) {
        boolean isAllLetter = false;
        String lowerCaseOrganName = null;
        if (HussarUtils.isNotEmpty((Object)queryAssigneeDto.getOrganName()) && (isAllLetter = ALL_LETTER.matcher(queryAssigneeDto.getOrganName()).matches())) {
            lowerCaseOrganName = queryAssigneeDto.getOrganName().toLowerCase();
        }
        return this.workflowAssigneeChooseMapper.queryUserTree(queryAssigneeDto.getOrganName(), queryAssigneeDto.isUseSecurityLevel(), queryAssigneeDto.getSecurityLevel(), tablePrefix, lowerCaseOrganName);
    }

    public List<BpmTreeModel> queryCurrentUserTreeSecurityLevel(QueryAssigneeDto queryAssigneeDto, String tablePrefix) {
        boolean isAllLetter = false;
        String lowerCaseOrganName = null;
        if (HussarUtils.isNotEmpty((Object)queryAssigneeDto.getOrganName()) && (isAllLetter = ALL_LETTER.matcher(queryAssigneeDto.getOrganName()).matches())) {
            lowerCaseOrganName = queryAssigneeDto.getOrganName().toLowerCase();
        }
        List<Object> result = this.workflowAssigneeChooseMapper.queryUserTree(queryAssigneeDto.getOrganName(), queryAssigneeDto.isUseSecurityLevel(), queryAssigneeDto.getSecurityLevel(), tablePrefix, lowerCaseOrganName);
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long deptId = securityUser.getDeptId();
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            StruFilteredVo struFilteredVo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
            Set filteredStruIds = struFilteredVo.getFilteredStruIds();
            result = result.stream().filter(bpmTreeModel -> {
                if (bpmTreeModel.getType().equals(USER)) {
                    return filteredStruIds.contains(Long.valueOf(bpmTreeModel.getParentId()));
                }
                if (bpmTreeModel.getType().equals(ORGAN)) {
                    return filteredStruIds.contains(Long.valueOf(bpmTreeModel.getId()));
                }
                return false;
            }).collect(Collectors.toList());
        }
        return result;
    }

    public Page<BpmTreeModel> queryUserTreeByPage(Page<BpmTreeModel> pages, String organName, String tablePrefix) {
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        return pages.setRecords(this.workflowAssigneeChooseMapper.queryUserTreeByPage(pages, organName, tablePrefix));
    }

    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> page, String organId, String type, boolean longIdType, String tablePrefix, boolean useSecurityLevel, Integer securityLevel) {
        if (StringUtils.isEmpty((Object)organId) || StringUtils.isEmpty((Object)type)) {
            return page.setRecords(this.workflowAssigneeChooseMapper.getUserListByParentIdAndSecurityLevel((IPage<BpmTreeModel>)page, null, null, tablePrefix, useSecurityLevel, securityLevel));
        }
        if (ORGAN.equals(type)) {
            return page.setRecords(this.workflowAssigneeChooseMapper.getUserListByParentIdAndSecurityLevel((IPage<BpmTreeModel>)page, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId, tablePrefix, useSecurityLevel, securityLevel));
        }
        if (USER.equals(type)) {
            return page.setRecords(this.workflowAssigneeChooseMapper.getUserListByUserId((IPage<BpmTreeModel>)page, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId, tablePrefix, securityLevel));
        }
        return new Page();
    }

    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel, String tablePrefix) {
        if (StringUtils.isEmpty((Object)bpmTreeModel.getId()) || StringUtils.isEmpty((Object)bpmTreeModel.getParentId())) {
            return new ArrayList<BpmTreeModel>();
        }
        List<BpmTreeModel> allDept = this.workflowAssigneeChooseMapper.getAllDept(tablePrefix);
        HashMap<String, BpmTreeModel> deptmap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptmap.put(dept.getId(), dept);
        }
        if (USER.equals(bpmTreeModel.getType())) {
            if (StringUtils.isEmpty((Object)(bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())))) {
                return new ArrayList<BpmTreeModel>();
            }
        } else if (ORGAN.equals(bpmTreeModel.getType())) {
            bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getId());
        }
        while (deptmap.containsKey(bpmTreeModel.getParentId())) {
            ArrayList<BpmTreeModel> children = new ArrayList<BpmTreeModel>();
            children.add(bpmTreeModel);
            bpmTreeModel = ((BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())).setChildrenList(children);
        }
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        result.add(bpmTreeModel);
        return result;
    }

    public List<BpmTreeModel> queryCurrentUserDeptTreeByChildren(BpmTreeModel bpmTreeModel, String tablePrefix) {
        SecurityUser securityUser = BaseSecurityUtil.getUser();
        Long deptId = securityUser.getDeptId();
        SysStru closestUnitStru = new SysStru();
        Long rootId = null;
        if (HussarUtils.isNotEmpty((Object)deptId)) {
            StruFilteredVo struFilteredVo = this.sysStruFilterUnitService.getFilteredStruInfo(deptId);
            closestUnitStru = struFilteredVo.getClosestUnitStru();
            rootId = struFilteredVo.getRootId();
        }
        if (StringUtils.isEmpty((Object)bpmTreeModel.getId()) || StringUtils.isEmpty((Object)bpmTreeModel.getParentId())) {
            return new ArrayList<BpmTreeModel>();
        }
        List<BpmTreeModel> allDept = this.workflowAssigneeChooseMapper.getAllDept(tablePrefix);
        HashMap<String, BpmTreeModel> deptmap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptmap.put(dept.getId(), dept);
        }
        if (USER.equals(bpmTreeModel.getType())) {
            if (StringUtils.isEmpty((Object)(bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())))) {
                return new ArrayList<BpmTreeModel>();
            }
        } else if (ORGAN.equals(bpmTreeModel.getType())) {
            bpmTreeModel = (BpmTreeModel)deptmap.get(bpmTreeModel.getId());
        }
        while (deptmap.containsKey(bpmTreeModel.getParentId())) {
            if (HussarUtils.isNotEmpty((Object)deptId) && bpmTreeModel.getId().equals(String.valueOf(closestUnitStru.getId()))) {
                bpmTreeModel.setParentId(String.valueOf(rootId));
            }
            ArrayList<BpmTreeModel> children = new ArrayList<BpmTreeModel>();
            children.add(bpmTreeModel);
            bpmTreeModel = ((BpmTreeModel)deptmap.get(bpmTreeModel.getParentId())).setChildrenList(children);
        }
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        result.add(bpmTreeModel);
        return result;
    }

    public List<BpmTreeModel> queryAssigneeAndDept(List<String> users, String organName, boolean longIdType, String tablePrefix) {
        if (users == null || users.size() == 0 || StringUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        ArrayList<Long> longUserIds = new ArrayList();
        ArrayList<String> stringUserIds = new ArrayList();
        if (longIdType) {
            longUserIds = users.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
        } else {
            stringUserIds = users.stream().map(s -> s.trim()).collect(Collectors.toList());
        }
        boolean isAllLetter = ALL_LETTER.matcher(organName).matches();
        String lowerCaseOrganName = null;
        if (isAllLetter) {
            lowerCaseOrganName = organName.toLowerCase();
        }
        return this.workflowAssigneeChooseMapper.queryAssigneeAndDept(longIdType ? this.getInListSqlCondition(longUserIds) : null, longIdType ? null : this.getStringListSqlCondition(stringUserIds), organName, tablePrefix, lowerCaseOrganName);
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, List<BpmTreeModel> users, String organId, String type, boolean longIdType, String organName, String tablePrefix, boolean useSecurityLevel, Integer securityLevel) {
        if (StringUtils.isEmpty((Object)organId) || StringUtils.isEmpty((Object)type)) {
            long current = pages.getCurrent();
            long size = pages.getSize();
            int start = (int)((current - 1L) * size);
            int end = start + (int)size;
            if (start > users.size()) {
                return pages.setRecords(new ArrayList());
            }
            if (end > users.size()) {
                end = users.size();
            }
            if (HussarUtils.isNotEmpty(users)) {
                pages.setTotal((long)users.size());
                users = users.subList(start, end);
            } else {
                pages.setTotal(0L);
            }
            return pages.setRecords(users);
        }
        ArrayList longUsers = new ArrayList();
        ArrayList stringUsers = new ArrayList();
        HashMap<String, List> usersMap = new HashMap<String, List>();
        List<Object> list = new ArrayList();
        for (BpmTreeModel bpmTreeModel : users) {
            HashMap<String, Object> map;
            List parentIds = usersMap.computeIfAbsent(bpmTreeModel.getId(), k -> new ArrayList());
            if (bpmTreeModel.getParentId() != null) {
                parentIds.add(bpmTreeModel.getParentId());
            }
            if (longIdType) {
                map = new HashMap<String, Object>();
                map.put("id", Long.parseLong(bpmTreeModel.getId()));
                if (bpmTreeModel.getParentId() != null) {
                    map.put("parentId", Long.parseLong(bpmTreeModel.getParentId()));
                }
                longUsers.add(map);
                continue;
            }
            map = new HashMap();
            map.put("id", bpmTreeModel.getId());
            map.put("parentId", bpmTreeModel.getParentId());
            stringUsers.add(map);
        }
        if (ORGAN.equals(type)) {
            list = this.workflowAssigneeChooseMapper.getUserListByParentId(null, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId, tablePrefix, securityLevel, useSecurityLevel).stream().filter(a -> usersMap.containsKey(a.getId()) && (((List)usersMap.get(a.getId())).isEmpty() || ((List)usersMap.get(a.getId())).contains(a.getParentId()))).collect(Collectors.toList());
        } else if (USER.equals(type)) {
            list = this.workflowAssigneeChooseMapper.getNodeAssigneeListByUserIdWithParent(null, longIdType ? Long.valueOf(Long.parseLong(organId)) : null, longIdType ? null : organId, useSecurityLevel, securityLevel, tablePrefix).stream().filter(a -> usersMap.containsKey(a.getId()) && (((List)usersMap.get(a.getId())).isEmpty() || ((List)usersMap.get(a.getId())).contains(a.getParentId()))).collect(Collectors.toList());
        }
        return this.getPageResult(pages, list);
    }

    public Page<BpmTreeModel> queryNodeAssigneeListWithPage(Page<BpmTreeModel> pages, List<String> users, String organId, String organName, String type, boolean longType, String tablePrefix, Integer securityLevel, boolean useSecurityLevel) {
        ArrayList<Long> longUsers = new ArrayList<Long>();
        for (String user : users) {
            longUsers.add(Long.parseLong(user));
        }
        if (!StringUtils.isEmpty((Object)organName)) {
            organName = organName.replace("%", "\\%").replace("_", "\\_");
        }
        if (StringUtils.isEmpty((Object)organId) || StringUtils.isEmpty((Object)type)) {
            boolean isAllLetter = false;
            String lowerCaseOrganName = null;
            if (HussarUtils.isNotEmpty((Object)organName) && (isAllLetter = ALL_LETTER.matcher(organName).matches())) {
                lowerCaseOrganName = organName.toLowerCase();
            }
            List<BpmTreeModel> userList = this.workflowAssigneeChooseMapper.getNodeAssigneeList(longType ? null : users, longType ? longUsers : null, organName, tablePrefix, securityLevel, useSecurityLevel, lowerCaseOrganName);
            HashMap<String, BpmTreeModel> userMap = new HashMap<String, BpmTreeModel>();
            for (BpmTreeModel bpmTreeModel : userList) {
                if (userMap.containsKey(bpmTreeModel.getId())) {
                    BpmTreeModel treeModel = (BpmTreeModel)userMap.get(bpmTreeModel.getId());
                    String parentName = treeModel.getParentName() + "," + bpmTreeModel.getParentName();
                    treeModel.setParentName(parentName);
                    userMap.put(bpmTreeModel.getId(), treeModel);
                    continue;
                }
                userMap.put(bpmTreeModel.getId(), bpmTreeModel);
            }
            ArrayList assigneeList = new ArrayList();
            for (Map.Entry entry : userMap.entrySet()) {
                assigneeList.add(entry.getValue());
            }
            return this.getPageResult(pages, assigneeList);
        }
        if (ORGAN.equals(type)) {
            List<Object> list = this.workflowAssigneeChooseMapper.getUserListByParentId(null, longType ? Long.valueOf(Long.parseLong(organId)) : null, longType ? null : organId, tablePrefix, securityLevel, useSecurityLevel);
            list = list.stream().filter(item -> users.contains(item.getId())).collect(Collectors.toList());
            return this.getPageResult(pages, list);
        }
        if (USER.equals(type)) {
            return pages.setRecords(this.workflowAssigneeChooseMapper.getNodeAssigneeListByUserId((IPage<BpmTreeModel>)pages, longType ? Long.valueOf(Long.parseLong(organId)) : null, longType ? null : organId, tablePrefix));
        }
        return pages.setRecords(new ArrayList());
    }

    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName, boolean longIdType, String tablePrefix) {
        List<BpmTreeModel> result;
        block6: {
            organName = organName.replace("%", "\\%").replace("_", "\\_");
            result = this.workflowAssigneeChooseMapper.queryDeptTreeByDeptName(organName, tablePrefix);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (!ORGAN.equals(bpmTreeModel.getType())) continue;
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block6;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), ORGAN, tablePrefix);
            List<Object> parentIdsLong = new ArrayList();
            if (longIdType) {
                parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!ORGAN.equals(bpmTreeModel.getType()) || !parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return this.queryAllTreeByChildrenNode(result, 2, tablePrefix);
    }

    private List<BpmTreeModel> queryAllTreeByChildrenNode(List<BpmTreeModel> childrenNode, Integer type, String tablePrefix) {
        List<BpmTreeModel> allDept;
        ArrayList<BpmTreeModel> result = new ArrayList<BpmTreeModel>();
        if (type == 1) {
            allDept = this.workflowAssigneeChooseMapper.getAllRole(tablePrefix);
        } else {
            allDept = this.workflowAssigneeChooseMapper.getAllDept(tablePrefix);
            BpmTreeModel userNode = new BpmTreeModel();
            BpmTreeModel postNode = new BpmTreeModel();
            if (type == 1) {
                BeanUtils.copyProperties((Object)USER_NODE, (Object)userNode);
                allDept.add(userNode);
            } else if (type == 3) {
                BeanUtils.copyProperties((Object)POST_NODE, (Object)postNode);
                allDept.add(postNode);
            } else if (type == 4) {
                BeanUtils.copyProperties((Object)USER_NODE, (Object)userNode);
                BeanUtils.copyProperties((Object)POST_NODE, (Object)postNode);
                allDept.add(postNode);
                allDept.add(userNode);
            }
        }
        HashMap<String, BpmTreeModel> deptMap = new HashMap<String, BpmTreeModel>();
        for (BpmTreeModel dept : allDept) {
            deptMap.put(dept.getId(), dept);
        }
        block1: for (BpmTreeModel bpmTreeModel : childrenNode) {
            BpmTreeModel children = bpmTreeModel;
            if (deptMap.containsKey(children.getId())) {
                children = (BpmTreeModel)deptMap.get(children.getId());
            }
            while (true) {
                if (!deptMap.containsKey(children.getParentId())) {
                    int i;
                    for (BpmTreeModel rootNode : result) {
                        if (!rootNode.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < result.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)result.get(i)).getType())) {
                                result.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < result.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)result.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)result.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            result.add(i, children);
                            continue block1;
                        }
                    }
                    result.add(children);
                    continue block1;
                }
                BpmTreeModel parent = (BpmTreeModel)deptMap.get(children.getParentId());
                ArrayList<BpmTreeModel> childrenList = parent.getChildrenList();
                if (childrenList != null && childrenList.size() != 0) {
                    int i;
                    for (BpmTreeModel parentChildrenList : childrenList) {
                        if (!parentChildrenList.getId().equals(children.getId())) continue;
                        continue block1;
                    }
                    if (ORGAN.equals(children.getType())) {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (USER.equals(((BpmTreeModel)childrenList.get(i)).getType())) {
                                childrenList.add(i, children);
                                continue block1;
                            }
                            if (Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    } else {
                        for (i = 0; i < childrenList.size(); ++i) {
                            if (!USER.equals(((BpmTreeModel)childrenList.get(i)).getType()) || Integer.parseInt(((BpmTreeModel)childrenList.get(i)).getSort()) < Integer.parseInt(children.getSort())) continue;
                            childrenList.add(i, children);
                            continue block1;
                        }
                    }
                    childrenList.add(children);
                    continue block1;
                }
                childrenList = new ArrayList<BpmTreeModel>();
                childrenList.add(children);
                parent.setChildrenList(childrenList);
                children = parent;
            }
        }
        return result;
    }

    public List<BpmTreeModel> queryUserTreeByUserName(String organName, String tablePrefix) {
        if (StringUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        List<BpmTreeModel> childrenNode = this.workflowAssigneeChooseMapper.queryUserTreeByUserName(organName, null, tablePrefix, null);
        return this.queryAllTreeByChildrenNode(childrenNode, 0, tablePrefix);
    }

    public List<BpmTreeModel> queryPostTreeByPostName(String postName, String tablePrefix) {
        if (StringUtils.isEmpty((Object)postName)) {
            return new ArrayList<BpmTreeModel>();
        }
        postName = postName.replace("%", "\\%").replace("_", "\\_");
        List<BpmTreeModel> childrenNode = this.workflowAssigneeChooseMapper.queryPostTreeByPostName(postName, tablePrefix);
        return this.queryAllTreeByChildrenNode(childrenNode, 3, tablePrefix);
    }

    public List<BpmTreeModel> queryUserListByUserName(String organName, Integer securityLevel, String tablePrefix) {
        if (StringUtils.isEmpty((Object)organName)) {
            return new ArrayList<BpmTreeModel>();
        }
        organName = organName.replace("%", "\\%").replace("_", "\\_");
        boolean isAllLetter = ALL_LETTER.matcher(organName).matches();
        String lowerCaseOrganName = null;
        if (isAllLetter) {
            lowerCaseOrganName = organName.toLowerCase();
        }
        return this.workflowAssigneeChooseMapper.queryUserTreeByUserName(organName, securityLevel, tablePrefix, lowerCaseOrganName);
    }

    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName, boolean longIdType, String tablePrefix) {
        List<BpmTreeModel> result;
        block7: {
            if (StringUtils.isEmpty((Object)roleName)) {
                return new ArrayList<BpmTreeModel>();
            }
            roleName = roleName.replace("%", "\\%").replace("_", "\\_");
            result = this.workflowAssigneeChooseMapper.queryRoleTreeByRoleName(roleName, tablePrefix);
            ArrayList<Long> parentIds = new ArrayList<Long>();
            ArrayList<String> stringParentIds = new ArrayList<String>();
            for (BpmTreeModel bpmTreeModel : result) {
                if (longIdType) {
                    parentIds.add(Long.valueOf(bpmTreeModel.getId()));
                    continue;
                }
                stringParentIds.add(bpmTreeModel.getId());
            }
            if (parentIds.isEmpty() && stringParentIds.isEmpty()) break block7;
            List<String> parentIdList = this.workflowAssigneeChooseMapper.getNotLeafRoleParentIds(longIdType ? this.getInListSqlCondition(parentIds) : null, longIdType ? null : this.getStringListSqlCondition(stringParentIds), tablePrefix);
            if (longIdType) {
                List parentIdsLong = parentIdList.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdsLong.contains(Long.valueOf(bpmTreeModel.getId()))) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            } else {
                for (BpmTreeModel bpmTreeModel : result) {
                    if (!parentIdList.contains(bpmTreeModel.getId())) continue;
                    bpmTreeModel.setIsLeaf("false");
                }
            }
        }
        return this.queryAllTreeByChildrenNode(result, 1, tablePrefix);
    }

    public List<AssigneeChooseDto> getUserAndAccountListByUserId(List<String> userIds, boolean longIdType, String tablePrefix) {
        ArrayList<Long> longUsers = new ArrayList<Long>();
        ArrayList<String> stringUsers = new ArrayList<String>();
        for (String user : userIds) {
            if (longIdType) {
                longUsers.add(Long.parseLong(user));
                continue;
            }
            stringUsers.add(user);
        }
        return this.workflowAssigneeChooseMapper.getUserAndAccountListByUserId(longIdType ? this.getInListSqlCondition(longUsers) : null, longIdType ? null : this.getStringListSqlCondition(stringUsers), tablePrefix);
    }

    public List<BpmUserInfoVo> getUserMsgByUserIds(List<String> userIds, boolean longIdType, String tablePrefix) {
        if (userIds == null || userIds.size() == 0) {
            return new ArrayList<BpmUserInfoVo>();
        }
        ArrayList<Long> ids = new ArrayList();
        ArrayList<String> stringIds = new ArrayList();
        if (longIdType && !StringUtils.isEmpty((Object)userIds.get(0))) {
            ids = userIds.stream().map(Long::parseLong).collect(Collectors.toList());
        } else {
            stringIds = userIds.stream().map(String::valueOf).collect(Collectors.toList());
        }
        return this.workflowAssigneeChooseMapper.getUserMsgByUserIds(longIdType ? this.getInListSqlCondition(ids) : null, longIdType ? null : this.getStringListSqlCondition(stringIds), tablePrefix);
    }

    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListDto, boolean longIdType, String tablePrefix) {
        if (DEFAULT_PARENTID.equals(getListDto.getDeptId())) {
            getListDto.setDeptId("");
        }
        if (longIdType) {
            if (!StringUtils.isEmpty((Object)getListDto.getDeptId())) {
                getListDto.setLongDeptId(Long.valueOf(Long.parseLong(getListDto.getDeptId())));
            }
            if (!StringUtils.isEmpty((Object)getListDto.getRoleId())) {
                getListDto.setLongRoleId(Long.valueOf(Long.parseLong(getListDto.getRoleId())));
            }
            if (!StringUtils.isEmpty((Object)getListDto.getPostId())) {
                getListDto.setLongPostId(Long.valueOf(Long.parseLong(getListDto.getPostId())));
            }
        }
        return page.setRecords(this.workflowAssigneeChooseMapper.queryList((IPage<BpmUserInfoVo>)page, getListDto, tablePrefix));
    }

    private List<List<Long>> getInListSqlCondition(List<Long> longList) {
        ArrayList<List<Long>> result = new ArrayList<List<Long>>();
        int size = longList.size();
        for (int i = 0; i < size; i += 1000) {
            List<Long> list = longList.subList(i, Math.min(i + 1000, size));
            result.add(list);
        }
        return result;
    }

    private List<List<String>> getStringListSqlCondition(List<String> stringList) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        if (HussarUtils.isNotEmpty(stringList)) {
            int size = stringList.size();
            for (int i = 0; i < size; i += 1000) {
                List<String> list = stringList.subList(i, Math.min(i + 1000, size));
                result.add(list);
            }
        }
        return result;
    }

    public List<AssigneeManageInfoVo> queryDept(String name, String tablePrefix) {
        return this.workflowAssigneeChooseMapper.queryOrganization(name, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryRole(String name, String tablePrefix) {
        return this.workflowAssigneeChooseMapper.queryRole(name, tablePrefix);
    }

    public List<AssigneeManageInfoVo> queryPost(String name, String tablePrefix) {
        return this.workflowAssigneeChooseMapper.queryPost(name, tablePrefix);
    }

    public List<BpmTreeModel> queryNodeAssigneeListByPageIncludeFuzzyQueryByName(Page<BpmTreeModel> pages, Long organId, List<List<Long>> users, String userName, String tablePrefix) {
        return this.workflowAssigneeChooseMapper.getNodeAssigneeListByParentIdIncludeFuzzyQueryByName(pages, organId, users, userName, tablePrefix);
    }

    public List<String> getAllParentOrganId(String userId, String organId, Boolean longIdType, String tablePrefix) {
        List<BpmTreeModel> organModels;
        if (organId == null || "".equals(organId)) {
            if (userId != null && !"".equals(userId)) {
                List<BpmTreeModel> bpmTreeModels = this.workflowAssigneeChooseMapper.userDeptDetail(longIdType != false ? Long.valueOf(Long.parseLong(userId)) : null, longIdType != false ? null : userId, tablePrefix);
                if (bpmTreeModels.isEmpty()) {
                    return null;
                }
                organId = bpmTreeModels.get(0).getParentId();
            } else {
                return null;
            }
        }
        ArrayList<String> organIds = new ArrayList<String>();
        while (!StringUtils.isEmpty((Object)organId) && !(organModels = this.workflowAssigneeChooseMapper.deptTree(null, longIdType != false ? Long.valueOf(Long.parseLong(organId)) : null, null, longIdType != false ? null : organId, tablePrefix)).isEmpty()) {
            BpmTreeModel organModel = organModels.get(0);
            if (organModel.getOrganFid() != null && !"".equals(organModel.getOrganFid())) {
                List<String> organIdList = Arrays.asList(organModel.getOrganFid().replaceFirst("/", "").split("/"));
                Collections.reverse(organIdList);
                organIds.addAll(organIdList);
                break;
            }
            organIds.add(organId);
            organId = organModel.getParentId();
        }
        return organIds;
    }

    public List<UserSecurityVo> getUserSecurity(List<String> userIds, Integer securityLevel, String tablePrefix) {
        if (HussarUtils.isNotEmpty(userIds)) {
            List<Long> userIdLong = userIds.stream().map(Long::parseLong).collect(Collectors.toList());
            return this.workflowAssigneeChooseMapper.getUserSecurity(userIdLong, securityLevel, tablePrefix);
        }
        return null;
    }

    private <T> Page<T> getPageResult(Page<T> pages, List<T> list) {
        pages.setTotal((long)list.size());
        int start = (int)((pages.getCurrent() - 1L) * pages.getSize());
        int end = (int)Math.min((long)list.size(), pages.getCurrent() * pages.getSize());
        if (list.size() <= start) {
            end = (int)Math.min((long)list.size(), pages.getSize());
            pages.setCurrent(1L);
            pages.setRecords(list.subList(0, end));
            return pages;
        }
        return pages.setRecords(list.subList(start, end));
    }
}

