/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.assignee.open;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.dto.QueryAssigneeDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.OrganUserTree;
import com.jxdinfo.hussar.workflow.assignee.model.QueryWithUsersModel;
import com.jxdinfo.hussar.workflow.assignee.model.UserSecurityVo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarBpm/assignee/obtain"})
public class AssigneeObtainController {
    @Autowired
    private IWorkflowAssigneeChooseService workflowAssigneeChooseService;

    @GetMapping(value={"/userTree"})
    public List<BpmTreeModel> userTree(String id, boolean isMainPost, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, Integer securityLevel, String tablePrefix) {
        return this.workflowAssigneeChooseService.userTree(id, isMainPost, longIdType, securityLevel, tablePrefix);
    }

    @GetMapping(value={"/userTreeForUserChoose"})
    public List<OrganUserTree> userTreeForUserChoose(String id, String tablePrefix) {
        return this.workflowAssigneeChooseService.userTreeForUserChoose(id, tablePrefix);
    }

    @GetMapping(value={"/queryUserTreeForUserChoose"})
    public Page<BpmTreeModel> queryUserTreeForUserChoose(QueryWithUsersModel queryWithUsersModel) {
        QueryAssigneeDto queryAssigneeDto = new QueryAssigneeDto();
        queryAssigneeDto.setPage(queryWithUsersModel.getPage());
        queryAssigneeDto.setOrganName(queryWithUsersModel.getOrganName());
        queryAssigneeDto.setType(queryWithUsersModel.getType());
        queryAssigneeDto.setUserIds(queryWithUsersModel.getUserIds());
        String tablePrefix = queryWithUsersModel.getTablePrefix();
        return this.workflowAssigneeChooseService.queryUserTreeForUserChoose(queryAssigneeDto, tablePrefix);
    }

    @GetMapping(value={"/queryDeptUserForUserChoose"})
    public List<BpmTreeModel> queryDeptUserForUserChoose(List<String> organIds, List<String> userIds, boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryDeptUserForUserChoose(organIds, userIds, longIdType, tablePrefix);
    }

    @GetMapping(value={"/postTree"})
    public List<BpmTreeModel> postTree(String id, String postId, boolean isMainPost, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.postTree(id, postId, isMainPost, longIdType, tablePrefix);
    }

    @GetMapping(value={"/deptTree"})
    public List<BpmTreeModel> deptTree(String id, String organId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.deptTree(id, organId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/roleTreeWithOutId"})
    public List<BpmTreeModel> roleTreeWithOutId(String tablePrefix) {
        return this.workflowAssigneeChooseService.roleTree(tablePrefix);
    }

    @GetMapping(value={"/roleTree"})
    public List<BpmTreeModel> roleTree(String id, String roleId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.roleTree(id, roleId, longIdType, tablePrefix);
    }

    @PostMapping(value={"/userDetail"})
    public List<BpmTreeModel> userDetail(@RequestBody QueryWithUsersModel queryWithUsersModel) {
        if (StringUtils.isEmpty((Object)queryWithUsersModel.getUserIds())) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.workflowAssigneeChooseService.userDetail(queryWithUsersModel.getUserIds(), queryWithUsersModel.getLongIdType(), queryWithUsersModel.getTablePrefix());
    }

    @GetMapping(value={"/userDeptDetail"})
    public List<BpmTreeModel> userDeptDetail(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.userDeptDetail(userId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/getSameLevelDeptIdByUserId"})
    public String getSameLevelDeptIdByUserId(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserId(userId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/getSameLevelDeptIdByOrganId"})
    public String getSameLevelDeptIdByOrganId(String organId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.getSameLevelDeptIdByOrganId(organId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/queryNodeAssigneeListByPageIncludeFuzzyQueryByName"})
    public List<BpmTreeModel> queryNodeAssigneeListByPageIncludeFuzzyQueryByName(@RequestBody Page<BpmTreeModel> pages, @RequestParam(value="organId") String organId, @RequestParam List<List<Long>> users, @RequestParam(value="userName", required=false) String userName, @RequestParam String tablePrefix) {
        return this.workflowAssigneeChooseService.queryNodeAssigneeListByPageIncludeFuzzyQueryByName(pages, Long.valueOf(organId), users, userName, tablePrefix);
    }

    @GetMapping(value={"/getParentDeptIdByUserId"})
    public String getParentDeptIdByUserId(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.getParentDeptIdByUserId(userId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/getDeptIdByUserIds"})
    public String getDeptIdByUserIds(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.getDeptIdByUserIds(userId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/getSameLevelDeptIdByUserIds"})
    public String getSameLevelDeptIdByUserIds(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserIds(userId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/getParentDeptIdByUserIds"})
    public String getParentDeptIdByUserIds(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.getParentDeptIdByUserIds(userId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/getSecurityLevel"})
    public Integer getSecurityLevel(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.getSecurityLevel(userId, longIdType, tablePrefix);
    }

    @GetMapping(value={"/queryDeptTreeByDeptName"})
    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryDeptTreeByDeptName(organName, longIdType, tablePrefix);
    }

    @GetMapping(value={"/queryUserTreeByUserName"})
    public List<BpmTreeModel> queryUserTreeByUserName(String organName, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryUserTreeByUserName(organName, tablePrefix);
    }

    @GetMapping(value={"/queryPostTreeByPostName"})
    public List<BpmTreeModel> queryPostTreeByPostName(String postName, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryPostTreeByPostName(postName, tablePrefix);
    }

    @GetMapping(value={"/queryUserListByUserName"})
    public List<BpmTreeModel> queryUserListByUserName(String organName, String securityLevel, String tablePrefix) {
        Integer securityLevelInt = null;
        if (!"".equals(securityLevel)) {
            securityLevelInt = Integer.parseInt(securityLevel);
        }
        return this.workflowAssigneeChooseService.queryUserListByUserName(organName, securityLevelInt, tablePrefix);
    }

    @GetMapping(value={"/queryRoleTreeByRoleName"})
    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryRoleTreeByRoleName(roleName, longIdType, tablePrefix);
    }

    @GetMapping(value={"/queryUserTree"})
    public List<BpmTreeModel> queryUserTree(String organName, String securityLevel, String tablePrefix) {
        QueryAssigneeDto queryAssigneeDto = new QueryAssigneeDto();
        queryAssigneeDto.setOrganName(organName);
        if (HussarUtils.isNotEmpty((Object)securityLevel)) {
            queryAssigneeDto.setSecurityLevel(Integer.valueOf(securityLevel));
        }
        return this.workflowAssigneeChooseService.queryUserTree(queryAssigneeDto, tablePrefix);
    }

    @GetMapping(value={"/queryUserTreeByPage"})
    public Page<BpmTreeModel> queryUserTreeByPage(Page<BpmTreeModel> pages, String organName, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryUserTreeByPage(pages, organName, tablePrefix);
    }

    @GetMapping(value={"/queryUserListByPage"})
    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, String organId, String type, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix, Integer securityLevel) {
        return this.workflowAssigneeChooseService.queryUserListByPage(pages, organId, type, longIdType, tablePrefix, securityLevel);
    }

    @GetMapping(value={"/getCandidateUser"})
    public List<String> getCandidateUser(String condition, Integer securityLevel, String tablePrefix) {
        return this.workflowAssigneeChooseService.getCandidateUser(condition, securityLevel, tablePrefix);
    }

    @GetMapping(value={"/getCandidateUserWithParent"})
    public List<BpmTreeModel> getCandidateUserWithParent(String condition, Integer securityLevel, String tablePrefix) {
        return this.workflowAssigneeChooseService.getCandidateUserWithParent(condition, securityLevel, tablePrefix);
    }

    @PostMapping(value={"/getUserMsgByUserIds"})
    public List<BpmUserInfoVo> getUserMsgByUserIds(@RequestBody QueryWithUsersModel queryWithUsersModel) {
        if (StringUtils.isEmpty((Object)queryWithUsersModel.getUserIds())) {
            return new ArrayList<BpmUserInfoVo>();
        }
        return this.workflowAssigneeChooseService.getUserMsgByUserIds(queryWithUsersModel.getUserIds(), queryWithUsersModel.getLongIdType(), queryWithUsersModel.getTablePrefix());
    }

    @PostMapping(value={"/getUserAndAccountListByUserId"})
    public List<AssigneeChooseDto> getUserAndAccountListByUserId(@RequestBody QueryWithUsersModel queryWithUsersModel) {
        return this.workflowAssigneeChooseService.getUserAndAccountListByUserId(queryWithUsersModel.getUserIds(), queryWithUsersModel.getLongIdType(), queryWithUsersModel.getTablePrefix());
    }

    @PostMapping(value={"/queryNodeAssigneeListByPage"})
    public Page<BpmTreeModel> queryNodeAssigneeListByPage(@RequestBody QueryWithUsersModel queryWithUsersModel) {
        if (StringUtils.isEmpty((Object)queryWithUsersModel.getUserIds())) {
            return queryWithUsersModel.getPage();
        }
        return this.workflowAssigneeChooseService.queryNodeAssigneeListWithPage(queryWithUsersModel.getPage(), queryWithUsersModel.getUserIds(), queryWithUsersModel.getOrganId(), queryWithUsersModel.getOrganName(), queryWithUsersModel.getType(), queryWithUsersModel.getLongIdType(), queryWithUsersModel.getTablePrefix(), queryWithUsersModel.getSecurityLevel());
    }

    @PostMapping(value={"/queryNodeAssigneeListWithParentByPage"})
    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(@RequestBody QueryWithUsersModel queryWithUsersModel) {
        if (StringUtils.isEmpty((Object)queryWithUsersModel.getUsers())) {
            return queryWithUsersModel.getPage();
        }
        return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(queryWithUsersModel.getPage(), queryWithUsersModel.getUsers(), queryWithUsersModel.getOrganId(), queryWithUsersModel.getType(), queryWithUsersModel.getLongIdType(), queryWithUsersModel.getOrganName(), queryWithUsersModel.getTablePrefix(), queryWithUsersModel.getSecurityLevel());
    }

    @PostMapping(value={"/queryNodeAssigneeListWithPage"})
    public IPage<BpmTreeModel> queryNodeAssigneeListWithPage(@RequestBody QueryWithUsersModel queryWithUsersModel) {
        if (StringUtils.isEmpty((Object)queryWithUsersModel.getUserIds())) {
            return queryWithUsersModel.getPage();
        }
        return this.workflowAssigneeChooseService.queryNodeAssigneeListWithPage(queryWithUsersModel.getPage(), queryWithUsersModel.getUserIds(), queryWithUsersModel.getOrganId(), queryWithUsersModel.getOrganName(), queryWithUsersModel.getType(), queryWithUsersModel.getLongIdType(), queryWithUsersModel.getTablePrefix(), queryWithUsersModel.getSecurityLevel());
    }

    @PostMapping(value={"/queryAssigneeAndDept"})
    public List<BpmTreeModel> queryAssigneeAndDept(@RequestBody QueryWithUsersModel queryWithUsersModel) {
        return this.workflowAssigneeChooseService.queryAssigneeAndDept(queryWithUsersModel.getUserIds(), queryWithUsersModel.getOrganName(), queryWithUsersModel.getLongIdType(), queryWithUsersModel.getTablePrefix());
    }

    @GetMapping(value={"/queryDeptTreeByChildren"})
    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryDeptTreeByChildren(bpmTreeModel, tablePrefix);
    }

    @GetMapping(value={"/list"})
    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListInfoVo, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryList(page, getListInfoVo, longIdType, tablePrefix);
    }

    @GetMapping(value={"/queryDept"})
    public List<AssigneeManageInfoVo> queryDept(String name, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryDept(name, tablePrefix);
    }

    @GetMapping(value={"/queryRole"})
    public List<AssigneeManageInfoVo> queryRole(String name, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryRole(name, tablePrefix);
    }

    @GetMapping(value={"/queryPost"})
    public List<AssigneeManageInfoVo> queryPost(String name, String tablePrefix) {
        return this.workflowAssigneeChooseService.queryPost(name, tablePrefix);
    }

    @GetMapping(value={"/getAllParentOrganId"})
    public List<String> getAllParentOrganId(String userId, String organId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType, String tablePrefix) {
        return this.workflowAssigneeChooseService.getAllParentOrganId(userId, organId, Boolean.valueOf(longIdType), tablePrefix);
    }

    @GetMapping(value={"/getUserSecurity"})
    public List<UserSecurityVo> getUserSecurity(@RequestBody QueryWithUsersModel queryWithUsersModel) {
        return this.workflowAssigneeChooseService.getUserSecurity(queryWithUsersModel.getUserIds(), queryWithUsersModel.getSecurityLevel(), queryWithUsersModel.getTablePrefix());
    }
}

