/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.assignee.open;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.workflow.assignee.dto.AssigneeChooseDto;
import com.jxdinfo.hussar.workflow.assignee.model.AssigneeManageInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserAccountModel;
import com.jxdinfo.hussar.workflow.assignee.model.BpmUserInfoVo;
import com.jxdinfo.hussar.workflow.assignee.model.GetListInfoVo;
import com.jxdinfo.hussar.workflow.assignee.service.IWorkflowAssigneeChooseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hussarBpm/assignee/obtain"})
public class AssigneeObtainController {
    @Autowired
    private IWorkflowAssigneeChooseService workflowAssigneeChooseService;

    @GetMapping(value={"/userTree"})
    public List<BpmTreeModel> userTree(String id, boolean isMainPost, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.userTree(id, isMainPost, longIdType);
    }

    @GetMapping(value={"/deptTree"})
    public List<BpmTreeModel> deptTree(String id, String organId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.deptTree(id, organId, longIdType);
    }

    @GetMapping(value={"/roleTreeWithOutId"})
    public List<BpmTreeModel> roleTreeWithOutId() {
        return this.workflowAssigneeChooseService.roleTree();
    }

    @GetMapping(value={"/roleTree"})
    public List<BpmTreeModel> roleTree(String id, String roleId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.roleTree(id, roleId, longIdType);
    }

    @GetMapping(value={"/userDetail"})
    public List<BpmTreeModel> userDetail(String userIds, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.workflowAssigneeChooseService.userDetail(Arrays.asList(userIds.split(",")), longIdType);
    }

    @GetMapping(value={"/userDeptDetail"})
    public List<BpmTreeModel> userDeptDetail(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.userDeptDetail(userId, longIdType);
    }

    @GetMapping(value={"/getSameLevelDeptIdByUserId"})
    public String getSameLevelDeptIdByUserId(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserId(userId, longIdType);
    }

    @GetMapping(value={"/getParentDeptIdByUserId"})
    public String getParentDeptIdByUserId(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.getParentDeptIdByUserId(userId, longIdType);
    }

    @GetMapping(value={"/getDeptIdByUserIds"})
    public String getDeptIdByUserIds(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.getDeptIdByUserIds(userId, longIdType);
    }

    @GetMapping(value={"/getSameLevelDeptIdByUserIds"})
    public String getSameLevelDeptIdByUserIds(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.getSameLevelDeptIdByUserIds(userId, longIdType);
    }

    @GetMapping(value={"/getParentDeptIdByUserIds"})
    public String getParentDeptIdByUserIds(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.getParentDeptIdByUserIds(userId, longIdType);
    }

    @GetMapping(value={"/getSecurityLevel"})
    public Integer getSecurityLevel(String userId, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.getSecurityLevel(userId, longIdType);
    }

    @GetMapping(value={"/queryDeptTreeByDeptName"})
    public List<BpmTreeModel> queryDeptTreeByDeptName(String organName, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.queryDeptTreeByDeptName(organName, longIdType);
    }

    @GetMapping(value={"/queryUserTreeByUserName"})
    public List<BpmTreeModel> queryUserTreeByUserName(String organName) {
        return this.workflowAssigneeChooseService.queryUserTreeByUserName(organName);
    }

    @GetMapping(value={"/queryUserListByUserName"})
    public List<BpmTreeModel> queryUserListByUserName(String organName) {
        return this.workflowAssigneeChooseService.queryUserListByUserName(organName);
    }

    @GetMapping(value={"/queryRoleTreeByRoleName"})
    public List<BpmTreeModel> queryRoleTreeByRoleName(String roleName, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.queryRoleTreeByRoleName(roleName, longIdType);
    }

    @GetMapping(value={"/queryUserTree"})
    public List<BpmTreeModel> queryUserTree(String organName) {
        return this.workflowAssigneeChooseService.queryUserTree(organName);
    }

    @GetMapping(value={"/queryUserListByPage"})
    public Page<BpmTreeModel> queryUserListByPage(Page<BpmTreeModel> pages, String organId, String type, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.queryUserListByPage(pages, organId, type, longIdType);
    }

    @GetMapping(value={"/getCandidateUser"})
    public List<String> getCandidateUser(String condition, Integer securityLevel) {
        return this.workflowAssigneeChooseService.getCandidateUser(condition, securityLevel);
    }

    @GetMapping(value={"/getCandidateUserWithParent"})
    public List<BpmTreeModel> getCandidateUserWithParent(String condition, Integer securityLevel) {
        return this.workflowAssigneeChooseService.getCandidateUserWithParent(condition, securityLevel);
    }

    @GetMapping(value={"/getUserMsgByUserIds"})
    public List<BpmUserInfoVo> getUserMsgByUserIds(String userIds, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return new ArrayList<BpmUserInfoVo>();
        }
        return this.workflowAssigneeChooseService.getUserMsgByUserIds(Arrays.asList(userIds.split(",")), longIdType);
    }

    @GetMapping(value={"/getUserAndAccountListByUserId"})
    public List<AssigneeChooseDto> getUserAndAccountListByUserId(String userIds, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return new ArrayList<AssigneeChooseDto>();
        }
        return this.workflowAssigneeChooseService.getUserAndAccountListByUserId(Arrays.asList(userIds.split(",")), longIdType);
    }

    @GetMapping(value={"/queryNodeAssigneeListByPage"})
    public Page<BpmTreeModel> queryNodeAssigneeListByPage(Page<BpmTreeModel> pages, String userIds, String organId, String type, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return pages;
        }
        return this.workflowAssigneeChooseService.queryNodeAssigneeListByPage(pages, Arrays.asList(userIds.split(",")), organId, type, longIdType);
    }

    @GetMapping(value={"/queryNodeAssigneeListWithParentByPage"})
    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPage(Page<BpmTreeModel> pages, String userIds, String organId, String type, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return pages;
        }
        return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, JSONArray.parseArray((String)userIds, BpmTreeModel.class), organId, type, longIdType);
    }

    @PostMapping(value={"/queryNodeAssigneeListWithParentByPageByPost"})
    public Page<BpmTreeModel> queryNodeAssigneeListWithParentByPageByPost(@RequestBody Map<String, Object> map) {
        Page pages = new Page();
        if (!StringUtils.isEmpty((Object)map.get("size"))) {
            pages.setSize((long)Integer.valueOf(map.get("size").toString()).intValue());
        }
        if (!StringUtils.isEmpty((Object)map.get("current"))) {
            pages.setCurrent((long)Integer.valueOf(map.get("current").toString()).intValue());
        }
        if (StringUtils.isEmpty((Object)map.get("userIds"))) {
            return pages;
        }
        return this.workflowAssigneeChooseService.queryNodeAssigneeListWithParentByPage(pages, JSONArray.parseArray((String)map.get("userIds").toString(), BpmTreeModel.class), StringUtils.isEmpty((Object)map.get("organId")) ? null : map.get("organId").toString(), StringUtils.isEmpty((Object)map.get("type")) ? null : map.get("type").toString(), StringUtils.isEmpty((Object)map.get("longIdType")) ? false : Boolean.valueOf(map.get("longIdType").toString()));
    }

    @GetMapping(value={"/queryAssigneeAndDept"})
    public List<BpmTreeModel> queryAssigneeAndDept(@RequestParam String users, @RequestParam String organName, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        if (StringUtils.isEmpty((Object)users)) {
            return new ArrayList<BpmTreeModel>();
        }
        return this.workflowAssigneeChooseService.queryAssigneeAndDept(Arrays.asList(users.split(",")), organName, longIdType);
    }

    @GetMapping(value={"/queryDeptTreeByChildren"})
    public List<BpmTreeModel> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        return this.workflowAssigneeChooseService.queryDeptTreeByChildren(bpmTreeModel);
    }

    @GetMapping(value={"/list"})
    public Page<BpmUserInfoVo> queryList(Page<BpmUserInfoVo> page, GetListInfoVo getListInfoVo, @RequestParam(value="longIdType", defaultValue="false") boolean longIdType) {
        return this.workflowAssigneeChooseService.queryList(page, getListInfoVo, longIdType);
    }

    @GetMapping(value={"/queryDept"})
    public List<AssigneeManageInfoVo> queryDept(String name) {
        return this.workflowAssigneeChooseService.queryDept(name);
    }

    @GetMapping(value={"/queryRole"})
    public List<AssigneeManageInfoVo> queryRole(String name) {
        return this.workflowAssigneeChooseService.queryRole(name);
    }

    @GetMapping(value={"/getUserAccount"})
    public List<BpmUserAccountModel> getUserAccount(String userIds) {
        if (StringUtils.isEmpty((Object)userIds)) {
            return new ArrayList<BpmUserAccountModel>();
        }
        return this.workflowAssigneeChooseService.getUserAccount(Arrays.asList(userIds.split(",")));
    }
}

