/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.security.BaseSecurityUtil;
import com.jxdinfo.hussar.common.security.SecurityUser;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.workflow.assignee.dto.QueryAssigneeDto;
import com.jxdinfo.hussar.workflow.assignee.model.BpmTreeModel;
import com.jxdinfo.hussar.workflow.assignee.model.OrganUserTree;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.NodeAssigneeQueryDto;
import com.jxdinfo.hussar.workflow.manage.engine.service.AssigneeApiService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import java.util.List;

public class AssigneeService {
    private static final AssigneeApiService assigneeApiService = BpmSpringContextHolder.getBean(AssigneeApiService.class);

    public static ApiResponse<List<BpmTreeModel>> queryUserTree(String organName) {
        QueryAssigneeDto queryAssigneeDto = new QueryAssigneeDto();
        queryAssigneeDto.setOrganName(organName);
        return assigneeApiService.queryUserTree(queryAssigneeDto);
    }

    public static ApiResponse<List<BpmTreeModel>> queryUserTreeSecurityLevel(QueryAssigneeDto queryAssigneeDto) {
        return assigneeApiService.queryUserTree(queryAssigneeDto);
    }

    public static ApiResponse<List<BpmTreeModel>> queryCurrentUserTreeSecurityLevel(QueryAssigneeDto queryAssigneeDto) {
        return assigneeApiService.queryCurrentUserTreeSecurityLevel(queryAssigneeDto);
    }

    public static ApiResponse<Page<BpmTreeModel>> queryUserListByPage(Page<BpmTreeModel> pages, BpmTreeModel bpmTreeModel) {
        NodeAssigneeQueryDto nodeAssigneeQueryDto = new NodeAssigneeQueryDto(bpmTreeModel);
        return assigneeApiService.queryUserListByPage(pages, nodeAssigneeQueryDto);
    }

    public static ApiResponse<Page<BpmTreeModel>> queryUserListByPage(NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        SecurityUser securityUser;
        Page pages = new Page(nodeAssigneeQueryDto.getCurrent(), nodeAssigneeQueryDto.getSize());
        if (HussarUtils.isNotEmpty((Object)nodeAssigneeQueryDto.getTransferProcessKey()) && HussarUtils.isNotEmpty((Object)(securityUser = BaseSecurityUtil.getUser()))) {
            nodeAssigneeQueryDto.setUserId(String.valueOf(securityUser.getId()));
        }
        return assigneeApiService.queryUserListByPage((Page<BpmTreeModel>)pages, nodeAssigneeQueryDto);
    }

    public static ApiResponse<Page<BpmTreeModel>> queryUserListByPageForAct(Page<BpmTreeModel> pages, NodeAssigneeQueryDto nodeAssigneeQueryDto) {
        return assigneeApiService.queryUserListByPage(pages, nodeAssigneeQueryDto);
    }

    public static ApiResponse<List<BpmTreeModel>> deptTree(String id) {
        return assigneeApiService.deptTree(id);
    }

    public static ApiResponse<List<BpmTreeModel>> currentUserDept(String id) {
        return assigneeApiService.currentUserDept(id);
    }

    public static ApiResponse<List<BpmTreeModel>> queryDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        return assigneeApiService.queryDeptTreeByChildren(bpmTreeModel);
    }

    public static ApiResponse<List<BpmTreeModel>> queryCurrentUserDeptTreeByChildren(BpmTreeModel bpmTreeModel) {
        return assigneeApiService.queryCurrentUserDeptTreeByChildren(bpmTreeModel);
    }

    public static ApiResponse<List<BpmTreeModel>> userTree(String id, boolean isMainPost) {
        return assigneeApiService.userTree(id, isMainPost);
    }

    public static ApiResponse<List<BpmTreeModel>> postTree(String id, boolean isMainPost) {
        return assigneeApiService.postTree(id, isMainPost);
    }

    public static ApiResponse<List<BpmTreeModel>> queryUserListByUserName(String userNam) {
        QueryAssigneeDto queryAssigneeDto = new QueryAssigneeDto();
        queryAssigneeDto.setUserName(userNam);
        return assigneeApiService.queryUserListByUserName(queryAssigneeDto);
    }

    public static ApiResponse<List<BpmTreeModel>> queryUserTreeByUserNameSecurityLevel(QueryAssigneeDto queryAssigneeDto) {
        return assigneeApiService.queryUserListByUserName(queryAssigneeDto);
    }

    public static ApiResponse<List<OrganUserTree>> userTreeForUserChoose(String id, String taskId) {
        return assigneeApiService.userTreeForUserChoose(id, taskId);
    }

    public static ApiResponse<Page<BpmTreeModel>> queryUserTreeForUserChoose(QueryAssigneeDto queryAssigneeDto) {
        return assigneeApiService.queryUserTreeForUserChoose(queryAssigneeDto);
    }

    public static ApiResponse<List<BpmTreeModel>> queryDeptUserForUserChoose(List<String> organIds, List<String> userIds) {
        return assigneeApiService.queryDeptUserForUserChoose(organIds, userIds);
    }

    public static ApiResponse<List<BpmTreeModel>> userTreeBySecurity(String id, boolean isMainPost, Integer security) {
        return assigneeApiService.userTreeBySecurity(id, isMainPost, security);
    }

    public static ApiResponse<List<BpmTreeModel>> currentDeptUserTreeBySecurity(String id, boolean isMainPost, Integer security) {
        return assigneeApiService.currentDeptUserTreeBySecurity(id, isMainPost, security);
    }
}

