/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.engine.bpm.customform.vo;

import com.jxdinfo.hussar.workflow.engine.bpm.customform.constant.CustomFormConstant;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomCategory;
import com.jxdinfo.hussar.workflow.engine.bpm.customform.model.CustomForm;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategoryAndFormTreeVo {
    public static final String FORM = "form";
    public static final String CATEGORY = "category";
    public static final String ROOT = "root";
    private static final Map<String, Integer> TYPE_SORT = new HashMap<String, Integer>();
    private Long id;
    private String name;
    private String type;
    private String formType;
    private boolean hasChildren = true;
    private Integer sort;
    private Long parentId;
    private List<CategoryAndFormTreeVo> children;

    public static CategoryAndFormTreeVo buildRoot() {
        return new CategoryAndFormTreeVo().setId(CustomFormConstant.CATEGORY_ROOT).setName("\u5206\u7c7b\u7ba1\u7406").setType(ROOT).setSort(1);
    }

    public static int getTypeSort(CategoryAndFormTreeVo categoryAndFormTreeVo) {
        String formType = categoryAndFormTreeVo.getFormType();
        Integer integer = TYPE_SORT.get(formType);
        return integer == null ? Integer.MIN_VALUE : integer;
    }

    public Long getId() {
        return this.id;
    }

    public CategoryAndFormTreeVo setId(Long id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CategoryAndFormTreeVo setName(String name) {
        this.name = name;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public CategoryAndFormTreeVo setType(String type) {
        this.type = type;
        return this;
    }

    public boolean isHasChildren() {
        return this.hasChildren;
    }

    public CategoryAndFormTreeVo setHasChildren(boolean hasChildren) {
        this.hasChildren = hasChildren;
        return this;
    }

    public Long getParentId() {
        return this.parentId;
    }

    public CategoryAndFormTreeVo setParentId(Long parentId) {
        this.parentId = parentId;
        return this;
    }

    public List<CategoryAndFormTreeVo> getChildren() {
        return this.children;
    }

    public CategoryAndFormTreeVo setChildren(List<CategoryAndFormTreeVo> children) {
        this.children = children;
        return this;
    }

    public Integer getSort() {
        return this.sort;
    }

    public CategoryAndFormTreeVo setSort(Integer sort) {
        this.sort = sort;
        return this;
    }

    public String getFormType() {
        return this.formType;
    }

    public CategoryAndFormTreeVo setFormType(String formType) {
        this.formType = formType;
        return this;
    }

    public static CategoryAndFormTreeVo buildVo(CustomCategory customCategory) {
        return new CategoryAndFormTreeVo().setId(customCategory.getCategoryId()).setName(customCategory.getCategoryName()).setParentId(customCategory.getParentId()).setSort(customCategory.getCategoryOrder()).setHasChildren(!customCategory.getIsLeaf()).setType(CATEGORY);
    }

    public static CategoryAndFormTreeVo buildVo(CustomForm customForm) {
        return new CategoryAndFormTreeVo().setId(customForm.getFormId()).setName(customForm.getFormName()).setParentId(customForm.getCategoryId()).setSort(customForm.getFormOrder()).setHasChildren(false).setFormType(customForm.getFormType()).setType(FORM);
    }

    private CategoryAndFormTreeVo() {
    }

    static {
        TYPE_SORT.put(ROOT, 0);
        TYPE_SORT.put(CATEGORY, 1);
        TYPE_SORT.put(FORM, 2);
    }
}

