/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.workflow.manage.engine;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.platform.core.base.apiresult.ApiResponse;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.EditPrcessTileDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessInstAllQueryDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessQueryByStarterDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessRevokeDto;
import com.jxdinfo.hussar.workflow.engine.bpm.engine.dto.ProcessSecurityLevelDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.BusinessInfoDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.ProcessStartDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteBatchDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartAndCompleteDto;
import com.jxdinfo.hussar.workflow.engine.bpm.processinst.dto.StartProcessDto;
import com.jxdinfo.hussar.workflow.engine.response.BpmResponseResult;
import com.jxdinfo.hussar.workflow.manage.engine.service.InstanceEngineApiService;
import com.jxdinfo.hussar.workflow.manage.util.BpmSpringContextHolder;
import com.jxdinfo.hussar.workflow.manage.util.TypeConvertUtils;
import com.jxdinfo.hussar.workflow.upgrade.StandardInstanceEngineApiService;
import java.util.Map;

public class InstanceEngineService {
    private static final InstanceEngineApiService instanceEngineApiService = BpmSpringContextHolder.getBean(InstanceEngineApiService.class);
    private static final StandardInstanceEngineApiService standardInstanceEngineApiService = BpmSpringContextHolder.getBean(StandardInstanceEngineApiService.class);

    private static BpmResponseResult changeReturnType(ApiResponse<?> apiResponse) {
        return TypeConvertUtils.changeReturnToBpmResult(apiResponse);
    }

    public static BpmResponseResult startProcessInstanceById(String processDefinitionId, String userId, String businessId, Map<String, Object> variables) {
        return instanceEngineApiService.startProcessInstanceById(processDefinitionId, userId, businessId, variables);
    }

    public static BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String businessId, Map<String, Object> variables) {
        return instanceEngineApiService.startProcessInstanceByKey(processKey, userId, businessId, variables);
    }

    public static BpmResponseResult startProcessInstanceByKey(String processKey, String userId, String processTag, String businessId, Map<String, Object> variables) {
        ProcessStartDto processStartDto = new ProcessStartDto();
        processStartDto.setProcessKey(processKey);
        processStartDto.setUserId(userId);
        processStartDto.setProcessTag(processTag);
        processStartDto.setBusinessId(businessId);
        processStartDto.setVariables(variables);
        return standardInstanceEngineApiService.startProcessInstance(processStartDto);
    }

    public static BpmResponseResult startProcessInstanceByKey(StartProcessDto startProcessDto) {
        return instanceEngineApiService.startProcessInstanceByKey(startProcessDto);
    }

    public static BpmResponseResult startAndComplete(StartAndCompleteDto startAndCompleteDto) {
        return instanceEngineApiService.startAndComplete(startAndCompleteDto);
    }

    public static BpmResponseResult startAndCompleteBatch(StartAndCompleteBatchDto startAndCompleteBatchDto) {
        return instanceEngineApiService.startAndCompleteBatch(startAndCompleteBatchDto);
    }

    public static BpmResponseResult updateBusinessInfo(BusinessInfoDto businessInfoDto) {
        return instanceEngineApiService.updateBusinessInfo(businessInfoDto);
    }

    public static BpmResponseResult checkProcessInstByBusinessKey(String businessId) {
        return instanceEngineApiService.checkProcessInstByBusinessKey(businessId);
    }

    public static ApiResponse<JSONObject> validateEditAuthority(String businessId) {
        return instanceEngineApiService.validateEditAuthority(businessId);
    }

    public static BpmResponseResult editAuthority(String businessId) {
        return InstanceEngineService.changeReturnType(instanceEngineApiService.validateEditAuthority(businessId));
    }

    public static BpmResponseResult validateDeleteByBusinessKey(String businessId) {
        return instanceEngineApiService.validateDeleteByBusinessKey(businessId);
    }

    public static BpmResponseResult suspendProcessInstanceById(String processInsId) {
        return instanceEngineApiService.suspendProcessInstanceById(processInsId);
    }

    public static BpmResponseResult suspendProcessInstanceByBusinessId(String businessId) {
        return instanceEngineApiService.suspendProcessInstanceByBusinessId(businessId);
    }

    public static BpmResponseResult activateProcessInstanceById(String processInsId) {
        return instanceEngineApiService.activateProcessInstanceById(processInsId);
    }

    public static BpmResponseResult activateProcessInstanceByBusinessId(String businessId) {
        return instanceEngineApiService.activateProcessInstanceByBusinessId(businessId);
    }

    public static BpmResponseResult deleteProcessInstance(String processInsId, String reason) {
        return instanceEngineApiService.deleteProcessInstance(processInsId, reason);
    }

    public static BpmResponseResult deleteFinishedProcessInstance(String processInsId) {
        return instanceEngineApiService.deleteFinishedProcessInstance(processInsId);
    }

    public static BpmResponseResult deleteFinishProcessInstanceByBusinessId(String businessId) {
        return instanceEngineApiService.deleteFinishProcessInstanceByBusinessId(businessId);
    }

    public static BpmResponseResult deleteProcessInstanceByBusinessKey(String businessId) {
        return instanceEngineApiService.deleteProcessInstanceByBusinessKey(businessId);
    }

    public static BpmResponseResult deleteProcessInstanceByBusinessKeyList(String businessId, boolean isValidate) {
        return instanceEngineApiService.deleteProcessInstanceByBusinessKeyList(businessId, isValidate);
    }

    public static BpmResponseResult queryFinishedProcessInstance(String processKey, String businessId, int page, int rows) {
        return instanceEngineApiService.queryFinishedProcessInstance(processKey, businessId, page, rows);
    }

    public static BpmResponseResult queryAllProcessInstance(ProcessInstAllQueryDto processInstAllQueryDto) {
        return instanceEngineApiService.queryAllProcessInstance(processInstAllQueryDto);
    }

    public static BpmResponseResult queryProcessInstanceCompleteState(String processInsId) {
        return instanceEngineApiService.queryProcessInstanceCompleteState(processInsId);
    }

    public static BpmResponseResult queryProcessInstanceCompleteStateByBusinessKey(String businessId) {
        return instanceEngineApiService.queryProcessInstanceCompleteStateByBusinessKey(businessId);
    }

    public static BpmResponseResult getProcessTrace(String processInsId) {
        return instanceEngineApiService.getProcessTrace(processInsId);
    }

    public static BpmResponseResult getAllProcessTrace(String processInsId) {
        return instanceEngineApiService.getAllProcessTrace(processInsId, null, null);
    }

    public static BpmResponseResult getAllProcessTrace(String processInsId, String subProcessKey, Integer cycleCount) {
        return instanceEngineApiService.getAllProcessTrace(processInsId, subProcessKey, cycleCount);
    }

    public static BpmResponseResult queryCallActivityTask(String businessId, String processInsId) {
        return instanceEngineApiService.queryCallActivityTask(businessId, processInsId);
    }

    public static BpmResponseResult queryMainActivityTask(String businessId, String processInsId) {
        return instanceEngineApiService.queryMainActivityTask(businessId, processInsId);
    }

    public static BpmResponseResult getAllProcessTraceByBusinessKey(String businessId, int page, int size) {
        return instanceEngineApiService.getAllProcessTraceByBusinessKey(businessId, page, size);
    }

    public static BpmResponseResult queryCompleteComment(String businessId, String processInsId) {
        return instanceEngineApiService.queryCompletecomment(businessId, processInsId);
    }

    @Deprecated
    public static BpmResponseResult queryCompletecomment(String businessId, String processInsId, String tenantId) {
        return instanceEngineApiService.queryCompletecomment(businessId, processInsId);
    }

    public static BpmResponseResult queryProcessDefinitionByInstanceId(String processInsId) {
        return instanceEngineApiService.queryProcessDefinitionByInstanceId(processInsId);
    }

    public static BpmResponseResult endProcess(String taskId, String userId, String reason) {
        return instanceEngineApiService.endProcess(taskId, userId, reason);
    }

    public static BpmResponseResult endProcessByBusinessIdOrProcessInsId(String businessId, String processInsId, String userId, String comment) {
        return instanceEngineApiService.endProcessByBusinessIdOrProcessInsId(businessId, processInsId, userId, comment);
    }

    public static BpmResponseResult queryProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        return instanceEngineApiService.queryProcessByStarter(page, processQueryByStarterDto);
    }

    public static BpmResponseResult queryRevokeProcessByStarter(Page page, ProcessQueryByStarterDto processQueryByStarterDto) {
        processQueryByStarterDto.setIsRevoke(true);
        return instanceEngineApiService.queryProcessByStarter(page, processQueryByStarterDto);
    }

    public static BpmResponseResult revokeProcess(ProcessRevokeDto processRevokeDto) {
        return instanceEngineApiService.revokeProcess(processRevokeDto);
    }

    public static BpmResponseResult queryProcessInstance(String processInsId, String businessId) {
        ProcessDto processDto = new ProcessDto();
        processDto.setProcessInsId(processInsId);
        processDto.setBusinessId(businessId);
        return instanceEngineApiService.queryProcessInstance(processDto);
    }

    public static BpmResponseResult queryAllComment(String businessId) {
        return instanceEngineApiService.queryAllComment(businessId);
    }

    public static BpmResponseResult queryAllCountersignNodes(String taskId, String processInsId, String businessId, String processKey, String version) {
        return instanceEngineApiService.queryAllCountersignNodes(taskId, processInsId, businessId, processKey, version);
    }

    public static BpmResponseResult queryCurrentNodes(String processInstanceId, String businessId) {
        return instanceEngineApiService.queryCurrentNodes(processInstanceId, businessId);
    }

    public static BpmResponseResult queryFlowHistoryInfo(String businessId, String processInstId) {
        return instanceEngineApiService.queryFlowHistoryInfo(businessId, processInstId);
    }

    public static BpmResponseResult editProcessTitle(EditPrcessTileDto editPrcessTileDto) {
        return instanceEngineApiService.editProcessTitle(editPrcessTileDto);
    }

    public static BpmResponseResult updateProcessSecurityLevel(ProcessSecurityLevelDto securityLevelDto) {
        return instanceEngineApiService.updateProcessSecurityLevel(securityLevelDto);
    }

    private InstanceEngineService() {
    }

    public static BpmResponseResult getInterfaceList() {
        return instanceEngineApiService.getInterfaceList();
    }
}

