/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;

public class WeChatUtil {
    private static final String KEY_ALGORITHM = "AES";
    private static final String ALGORITHM_STR = "AES/CBC/PKCS7Padding";
    private static Key key;
    private static Cipher cipher;

    public static String decryptData(String encryptDataB64, String sessionKeyB64, String ivB64) {
        return new String(WeChatUtil.decryptOfDiyIV(Base64.decode((String)encryptDataB64), Base64.decode((String)sessionKeyB64), Base64.decode((String)ivB64)));
    }

    private static void init(byte[] keyBytesSrc) {
        int base = 16;
        byte[] keyBytes = new byte[keyBytesSrc.length];
        System.arraycopy(keyBytesSrc, 0, keyBytes, 0, keyBytesSrc.length);
        if (keyBytes.length % base != 0) {
            int groups = keyBytes.length / base + (keyBytes.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill((byte[])temp, (byte)0);
            System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
            keyBytes = temp;
        }
        Security.addProvider((Provider)new BouncyCastleProvider());
        key = new SecretKeySpec(keyBytes, KEY_ALGORITHM);
        try {
            cipher = Cipher.getInstance(ALGORITHM_STR, "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    private static byte[] decryptOfDiyIV(byte[] encryptedData, byte[] keyBytes, byte[] ivs) {
        byte[] encryptedText = null;
        WeChatUtil.init(keyBytes);
        try {
            cipher.init(2, key, new IvParameterSpec(ivs));
            encryptedText = cipher.doFinal(encryptedData);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        return encryptedText;
    }
}

