/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.UUID;

public class StringUtil {
    private static Random random;

    public static String getUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static String getString(Object obj) {
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public static Integer getInteger(Object obj) {
        if (obj != null) {
            return Integer.valueOf(obj.toString());
        }
        return 0;
    }

    public static Double getDouble(Object obj) {
        if (obj != null) {
            return Double.valueOf(obj.toString());
        }
        return 0.0;
    }

    public static Boolean getBoolean(Object obj) {
        if (obj != null) {
            return Boolean.valueOf(obj.toString());
        }
        return false;
    }

    public static boolean checkIsEmpty(String str) {
        return str == null || "".equals(str) || "null".equals(str);
    }

    public static String transferSqlParam(String paramStr) {
        if (paramStr == null) {
            return null;
        }
        return paramStr.replaceAll("\\%", "\\\\%").replaceAll("\\_", "\\\\_");
    }

    public static String transferSpecialChar(String str) {
        if (str == null) {
            return str;
        }
        if ("".equals(str)) {
            return str;
        }
        return str.replaceAll("\\+", "%20").replace("%28", "\\(").replace("%29", "\\)").replace("%3B", ";").replace("%40", "@").replace("%23", "\\#").replace("%26", "\\&").replace("%2C", "\\,").replace("%2B", "\\+").replace("%7D", "\\}").replace("%7B", "\\{").replace("%24", "\\$").replace("%5E", "\\^").replace("%25", "\\%").replace("%7E", "\\~").replace("%3D", "\\=").replace("%60", "\\`");
    }

    public static String applySha256(String input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte aHash : hash) {
                String hex = Integer.toHexString(0xFF & aHash);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getRandomCode(int n) {
        String val = "";
        for (int i = 0; i < n; ++i) {
            String str;
            String string = str = random.nextInt(2) % 2 == 0 ? "num" : "char";
            if ("char".equalsIgnoreCase(str)) {
                int nextInt = random.nextInt(2) % 2 == 0 ? 65 : 97;
                val = val + (char)(nextInt + random.nextInt(26));
                continue;
            }
            val = val + String.valueOf(random.nextInt(10));
        }
        return val;
    }

    public static Date stringToDate(String dateString) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            Date date = sdf.parse(dateString);
            return date;
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            return null;
        }
    }

    public static String captureName(String name) {
        String newName = name.substring(0, 1).toUpperCase() + name.substring(1);
        return newName;
    }

    public static String getSHA1(String str) {
        StringBuffer hexstr = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(str.getBytes());
            byte[] digest = md.digest();
            String shaHex = "";
            for (int i = 0; i < digest.length; ++i) {
                shaHex = Integer.toHexString(digest[i] & 0xFF);
                if (shaHex.length() < 2) {
                    hexstr.append(0);
                }
                hexstr.append(shaHex);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return hexstr.toString();
    }

    public static String getTimestamp() {
        return String.valueOf(System.currentTimeMillis() / 1000L);
    }

    public static String getURLEncoderString(String str) {
        String result = "";
        if (null == str) {
            return "";
        }
        try {
            result = URLEncoder.encode(str, "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int getRandomInteger(int length) {
        return (int)((Math.random() * 9.0 + 1.0) * Math.pow(10.0, length - 1));
    }

    public static String getRandomStringCode(int length) {
        char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'L', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < length; ++i) {
            int at = (int)(Math.random() * 56.0);
            sb.append(chars[at]);
        }
        return sb.toString();
    }

    static {
        try {
            random = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

