/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.wechat.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import net.sf.json.JSONObject;

public class HttpUtils {
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CONNECTION = "Connection";
    private static final String CHARSET = "Charset";
    private static final String KEEP_ALIVE = "Keep-Alive";
    private static final String UTF_8 = "UTF-8";
    private static final String POST_METHOD = "POST";
    private static final String APPLICATION_JSON = "application/json";
    private static final String APPLICATION_FORMURLENCODED = "application/x-www-form-urlencoded";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHttps(StringBuilder urlPath) {
        BufferedReader responseReader = null;
        try {
            URL url = new URL(urlPath.toString());
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            httpConn.setUseCaches(false);
            httpConn.setRequestMethod(POST_METHOD);
            httpConn.setRequestProperty(CONTENT_TYPE, APPLICATION_FORMURLENCODED);
            httpConn.setRequestProperty(CONNECTION, KEEP_ALIVE);
            httpConn.setRequestProperty(CHARSET, UTF_8);
            httpConn.connect();
            int resultCode = httpConn.getResponseCode();
            if (200 == resultCode) {
                String readLine;
                StringBuilder sb = new StringBuilder();
                responseReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), UTF_8));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine).append('\n');
                }
                String string = sb.toString();
                return string;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (responseReader != null) {
                    responseReader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getHttps(String urlPath) {
        try {
            URL url = new URL(urlPath);
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            httpConn.setUseCaches(false);
            httpConn.setRequestMethod(POST_METHOD);
            httpConn.setRequestProperty(CONTENT_TYPE, APPLICATION_FORMURLENCODED);
            httpConn.setRequestProperty(CONNECTION, KEEP_ALIVE);
            httpConn.setRequestProperty(CHARSET, UTF_8);
            httpConn.connect();
            int resultCode = httpConn.getResponseCode();
            if (200 == resultCode) {
                String readLine;
                StringBuilder sb = new StringBuilder();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), UTF_8));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine).append('\n');
                }
                responseReader.close();
                return sb.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String postJson(StringBuilder urlPath, Object json) {
        try {
            String data = JSONObject.fromObject((Object)json).toString();
            URL url = new URL(urlPath.toString());
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            httpConn.setUseCaches(false);
            httpConn.setRequestMethod(POST_METHOD);
            httpConn.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
            httpConn.setRequestProperty(CONNECTION, KEEP_ALIVE);
            httpConn.setRequestProperty(CHARSET, UTF_8);
            httpConn.connect();
            OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream());
            writer.write(data);
            writer.flush();
            writer.close();
            int resultCode = httpConn.getResponseCode();
            if (200 == resultCode) {
                String readLine;
                StringBuilder sb = new StringBuilder();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), UTF_8));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine).append('\n');
                }
                responseReader.close();
                return sb.toString();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void postJsonNoResult(StringBuilder urlPath, Object json) {
        try {
            String data = JSONObject.fromObject((Object)json).toString();
            URL url = new URL(urlPath.toString());
            HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
            httpConn.setDoOutput(true);
            httpConn.setDoInput(true);
            httpConn.setUseCaches(false);
            httpConn.setRequestMethod(POST_METHOD);
            httpConn.setRequestProperty(CONTENT_TYPE, APPLICATION_JSON);
            httpConn.setRequestProperty(CONNECTION, KEEP_ALIVE);
            httpConn.setRequestProperty(CHARSET, UTF_8);
            httpConn.connect();
            OutputStreamWriter writer = new OutputStreamWriter(httpConn.getOutputStream());
            writer.write(data);
            writer.flush();
            writer.close();
            httpConn.getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

